/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;

public abstract class AbstractBearing
implements Bearing {
    private static final long serialVersionUID = 1968420344627864784L;

    @Override
    public int compareTo(Bearing o) {
        return this == o ? 0 : (this.getDegrees() > o.getDegrees() ? 1 : (this.getDegrees() == o.getDegrees() ? 0 : -1));
    }

    @Override
    public Bearing reverse() {
        if (this.getDegrees() >= 180.0) {
            return new DegreeBearingImpl(this.getDegrees() - 180.0);
        }
        return new DegreeBearingImpl(this.getDegrees() + 180.0);
    }

    @Override
    public Bearing add(Bearing diff) {
        double newDeg = this.getDegrees() + diff.getDegrees();
        if (newDeg > 360.0) {
            newDeg -= 360.0;
        } else if (newDeg < 0.0) {
            newDeg += 360.0;
        }
        return new DegreeBearingImpl(newDeg);
    }

    @Override
    public Bearing getDifferenceTo(Bearing b) {
        double diff = b.getDegrees() - this.getDegrees();
        if (diff < -180.0) {
            diff += 360.0;
        } else if (diff > 180.0) {
            diff -= 360.0;
        }
        return new DegreeBearingImpl(diff);
    }

    @Override
    public Bearing getDifferenceTo(Bearing b, Bearing lastDifference) {
        double courseChangeAngleInDegrees = this.getDifferenceTo(b).getDegrees();
        double lastCourseChangeAngleInDegrees = lastDifference.getDegrees();
        if (Math.abs(Math.signum(courseChangeAngleInDegrees) - Math.signum(lastCourseChangeAngleInDegrees)) == 2.0 && Math.abs(courseChangeAngleInDegrees - lastCourseChangeAngleInDegrees) >= 180.0) {
            courseChangeAngleInDegrees += (double)(courseChangeAngleInDegrees < 0.0 ? 360 : -360);
        }
        return new DegreeBearingImpl(courseChangeAngleInDegrees);
    }

    @Override
    public Bearing middle(Bearing other) {
        Bearing result = new DegreeBearingImpl((this.getDegrees() + other.getDegrees()) / 2.0);
        if (Math.abs(this.getDegrees() - other.getDegrees()) > 180.0) {
            result = result.reverse();
        }
        return result;
    }

    public String toString() {
        return this.getDegrees() + "\u00b0";
    }

    public int hashCode() {
        return 0x3FF ^ (int)this.getDegrees();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object != null && object instanceof Bearing && this.getDegrees() == ((Bearing)object).getDegrees();
    }

    @Override
    public double getRadians() {
        return this.getDegrees() / 180.0 * Math.PI;
    }

    @Override
    public Bearing abs() {
        return this.getDegrees() >= 0.0 ? this : new DegreeBearingImpl(-this.getDegrees());
    }
}

