/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.racemap;

import com.sap.sailing.gwt.ui.simulator.racemap.TwoDPoint;

public class TwoDVector {
    private final double re;
    private final double im;
    private final double norm;

    public TwoDVector(TwoDPoint startPoint, TwoDPoint endPoint) {
        this(endPoint.getX() - startPoint.getX(), endPoint.getY() - startPoint.getY());
    }

    public TwoDVector(double re, double im) {
        this.re = re;
        this.im = im;
        this.norm = Math.sqrt(this.re * this.re + this.im * this.im);
    }

    private TwoDVector normalize() {
        return new TwoDVector(this.re / this.norm, this.im / this.norm);
    }

    private TwoDVector add(TwoDVector vector) {
        return new TwoDVector(this.re + vector.getRe(), this.im + vector.getIm());
    }

    private TwoDVector substract(TwoDVector vector) {
        return new TwoDVector(this.re - vector.getRe(), this.im - vector.getIm());
    }

    public double dotProduct(TwoDVector vector) {
        return this.re * vector.getRe() + this.im * vector.getIm();
    }

    private static double getCos(TwoDVector v1, TwoDVector v2) {
        return v1.dotProduct(v2) / (v1.getNorm() * v2.getNorm());
    }

    private TwoDVector multiplyScalar(double scalar) {
        return new TwoDVector(this.re * scalar, this.im * scalar);
    }

    private TwoDVector rotate(double degrees) {
        double temp = degrees * Math.PI / 180.0;
        double sin = Math.sin(temp);
        double cos = Math.cos(temp);
        return new TwoDVector(cos * this.re + -1.0 * sin * this.im, sin * this.re + cos * this.im);
    }

    private static TwoDPoint getRotatedPoint(TwoDPoint origin, TwoDPoint head, double degrees) {
        TwoDVector v = new TwoDVector(origin, head);
        v = v.rotate(degrees);
        return new TwoDPoint(v.getRe() + origin.getX(), v.getIm() + origin.getY());
    }

    public double getNorm() {
        return this.norm;
    }

    public double getRe() {
        return this.re;
    }

    public double getIm() {
        return this.im;
    }
}

