/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldDTO;
import com.sap.sailing.gwt.ui.simulator.TimeListenerWithStoppingCriteria;
import com.sap.sailing.gwt.ui.simulator.WindFieldCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.WindGridCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.util.WindGridColorPalette;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class WindGridCanvasOverlay
extends FullCanvasOverlay
implements TimeListenerWithStoppingCriteria {
    private WindFieldDTO windFieldDTO;
    private SortedMap<Long, List<SimulatorWindDTO>> timePointWindDTOMap;
    private final Timer timer;
    private int xRes;
    private int yRes;
    private SimulatorWindDTO[][] windMatrix;
    private Map<Util.Pair<Integer, Integer>, GridCell> gridCellMap;
    private WindGridColorPalette colorPalette;
    private static Logger logger = Logger.getLogger(WindFieldCanvasOverlay.class.getName());

    public WindGridCanvasOverlay(MapWidget map, int zIndex, Timer timer, int xRes, int yRes, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.timer = timer;
        this.xRes = xRes;
        this.yRes = yRes;
        this.windFieldDTO = null;
        this.timePointWindDTOMap = new TreeMap();
        this.colorPalette = null;
    }

    public WindGridCanvasOverlay(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        this(map, zIndex, null, 0, 0, coordinateSystem);
    }

    public void setWindField(WindFieldDTO wl) {
        this.windFieldDTO = wl;
        this.timePointWindDTOMap.clear();
        if (wl != null) {
            for (SimulatorWindDTO w : wl.getMatrix()) {
                if (!this.timePointWindDTOMap.containsKey(w.timepoint.asMillis())) {
                    this.timePointWindDTOMap.put(w.timepoint.asMillis(), new LinkedList());
                }
                ((List)this.timePointWindDTOMap.get(w.timepoint.asMillis())).add(w);
            }
            SortByWindSpeed windSpeedSorter = new SortByWindSpeed(this, null);
            double maxSpeed = ((SimulatorWindDTO)Collections.max(wl.getMatrix(), windSpeedSorter)).trueWindSpeedInKnots;
            double minSpeed = ((SimulatorWindDTO)Collections.min(wl.getMatrix(), windSpeedSorter)).trueWindSpeedInKnots;
            logger.fine("minSpeed: " + minSpeed + " maxSpeed: " + maxSpeed);
            this.colorPalette = new WindGridColorPalette(minSpeed, maxSpeed);
            logger.fine("Color minSpeed: " + this.colorPalette.getColor(minSpeed));
            logger.fine("Color maxSpeed: " + this.colorPalette.getColor(maxSpeed));
            Long firstTimePoint = (Long)this.timePointWindDTOMap.firstKey();
            SortedMap headMap = this.timePointWindDTOMap.headMap(firstTimePoint + 1L);
            if (!headMap.isEmpty()) {
                List windDTOToDraw = (List)headMap.get(headMap.lastKey());
                this.createPositionGrid(windDTOToDraw);
            }
        }
    }

    public void addToMap() {
        super.addToMap();
        if (this.timer != null) {
            this.timer.addTimeListener((TimeListener)this);
        }
    }

    public void removeFromMap() {
        super.removeFromMap();
        if (this.timer != null) {
            this.timer.removeTimeListener((TimeListener)this);
        }
    }

    public void timeChanged(Date newTime, Date oldTime) {
        List windDTOToDraw = new ArrayList();
        SortedMap headMap = this.timePointWindDTOMap.headMap(newTime.getTime() + 1L);
        if (!headMap.isEmpty()) {
            windDTOToDraw = (List)headMap.get(headMap.lastKey());
        }
        logger.info("In WindGridCanvasOverlay.timeChanged drawing " + windDTOToDraw.size() + " points" + " @ " + newTime);
        this.drawWindGrid(windDTOToDraw);
    }

    public boolean shallStop() {
        if (!this.isVisible() || this.timePointWindDTOMap == null || this.timer == null || this.timePointWindDTOMap.isEmpty()) {
            return true;
        }
        return (Long)this.timePointWindDTOMap.lastKey() < this.timer.getTime().getTime();
    }

    protected void draw() {
        super.draw();
        if (this.getMapProjection() != null && this.windFieldDTO != null) {
            this.clear();
            this.drawWindGrid();
        }
    }

    private void clear() {
        this.canvas.getContext2d().clearRect(0.0, 0.0, (double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
    }

    protected void drawWindGrid() {
        if (this.timer != null) {
            this.timeChanged(this.timer.getTime(), null);
        } else {
            this.drawWindGrid(this.windFieldDTO.getMatrix());
        }
    }

    protected void drawWindGrid(List<SimulatorWindDTO> windDTOList) {
        this.clear();
        if (windDTOList != null && windDTOList.size() > 1) {
            if (windDTOList.size() != this.xRes * this.yRes) {
                logger.warning("Error in WindGridCanvasOverlay wind field is not rectangular.");
                return;
            }
            this.updatePositionGrid(windDTOList);
            this.drawGridCell();
            String title = "Wind Grid at " + windDTOList.size() + " points.";
            this.getCanvas().setTitle(title);
        }
    }

    private double getGridWidth(List<SimulatorWindDTO> windDTOList) {
        if (windDTOList.size() > 1) {
            SortByLatitude sortLatitude = new SortByLatitude(this, null);
            Collections.sort(windDTOList, sortLatitude);
            SimulatorWindDTO windDTO1 = windDTOList.get(0);
            SimulatorWindDTO windDTO2 = windDTOList.get(1);
            LatLng positionLatLng1 = LatLng.newInstance((double)windDTO1.position.getLatDeg(), (double)windDTO1.position.getLngDeg());
            Point canvasPositionInPx1 = this.getMapProjection().fromLatLngToDivPixel(positionLatLng1);
            LatLng positionLatLng2 = LatLng.newInstance((double)windDTO2.position.getLatDeg(), (double)windDTO2.position.getLngDeg());
            Point canvasPositionInPx2 = this.getMapProjection().fromLatLngToDivPixel(positionLatLng2);
            return canvasPositionInPx2.getX() - canvasPositionInPx1.getX();
        }
        return 0.0;
    }

    private double getGridHeight(List<SimulatorWindDTO> windDTOList) {
        if (windDTOList.size() > 1) {
            SortByLongitude sortLongitude = new SortByLongitude(this, null);
            Collections.sort(windDTOList, sortLongitude);
            SimulatorWindDTO windDTO1 = windDTOList.get(0);
            SimulatorWindDTO windDTO2 = windDTOList.get(1);
            LatLng positionLatLng1 = LatLng.newInstance((double)windDTO1.position.getLatDeg(), (double)windDTO1.position.getLngDeg());
            Point canvasPositionInPx1 = this.getMapProjection().fromLatLngToDivPixel(positionLatLng1);
            LatLng positionLatLng2 = LatLng.newInstance((double)windDTO2.position.getLatDeg(), (double)windDTO2.position.getLngDeg());
            Point canvasPositionInPx2 = this.getMapProjection().fromLatLngToDivPixel(positionLatLng2);
            return canvasPositionInPx2.getY() - canvasPositionInPx1.getY();
        }
        return 0.0;
    }

    private void createPositionGrid(List<SimulatorWindDTO> windDTOList) {
        if (windDTOList.size() != this.xRes * this.yRes) {
            logger.warning("Error in WindGridCanvasOverlay wind field is not rectangular.");
            this.windMatrix = null;
            return;
        }
        this.windMatrix = new SimulatorWindDTO[this.yRes + 2][this.xRes];
        Iterator<SimulatorWindDTO> windDTOIter = windDTOList.iterator();
        int i = 1;
        while (i < this.yRes + 1) {
            int j = 0;
            while (j < this.xRes) {
                this.windMatrix[i][j] = windDTOIter.next();
                ++j;
            }
            ++i;
        }
        this.extendPositionGrid();
        this.createGridCell();
    }

    private void updatePositionGrid(List<SimulatorWindDTO> windDTOList) {
        if (windDTOList.size() != this.xRes * this.yRes) {
            logger.warning("Error in WindGridCanvasOverlay wind field is not rectangular.");
            return;
        }
        Iterator<SimulatorWindDTO> windDTOIter = windDTOList.iterator();
        int i = 0;
        while (i < this.yRes) {
            int j = 0;
            while (j < this.xRes) {
                this.windMatrix[i][j] = windDTOIter.next();
                ++j;
            }
            ++i;
        }
        this.updateGridCell();
    }

    private void extendPositionGrid() {
        SimulatorWindDTO windDTO;
        DegreePosition position;
        Position p2;
        Position p1;
        int numRow = this.windMatrix.length;
        if (numRow < 4) {
            return;
        }
        int j = 0;
        while (j < this.xRes) {
            p1 = this.windMatrix[1][j].position;
            p2 = this.windMatrix[2][j].position;
            position = new DegreePosition(2.0 * p1.getLatDeg() - p2.getLatDeg(), 2.0 * p1.getLngDeg() - p2.getLngDeg());
            windDTO = new SimulatorWindDTO();
            windDTO.position = position;
            windDTO.trueWindSpeedInKnots = 0.0;
            this.windMatrix[0][j] = windDTO;
            ++j;
        }
        j = 0;
        while (j < this.xRes) {
            p1 = this.windMatrix[numRow - 2][j].position;
            p2 = this.windMatrix[numRow - 3][j].position;
            position = new DegreePosition(2.0 * p1.getLatDeg() - p2.getLatDeg(), 2.0 * p1.getLngDeg() - p2.getLngDeg());
            windDTO = new SimulatorWindDTO();
            windDTO.position = position;
            this.windMatrix[numRow - 1][j] = windDTO;
            ++j;
        }
    }

    private void createGridCell() {
        int numCol;
        int numRow;
        if (this.windMatrix != null && (numRow = this.windMatrix.length) >= 4 && (numCol = this.windMatrix[0].length) >= 2) {
            this.gridCellMap = new HashMap();
            int i = 1;
            while (i < numRow - 1) {
                int j = 1;
                while (j < numCol - 1) {
                    Position bl = this.getCenter(this.windMatrix[i - 1][j - 1].position, this.windMatrix[i - 1][j].position, this.windMatrix[i][j].position, this.windMatrix[i][j - 1].position);
                    Position tl = this.getCenter(this.windMatrix[i][j - 1].position, this.windMatrix[i][j].position, this.windMatrix[i + 1][j - 1].position, this.windMatrix[i + 1][j].position);
                    Position br = this.getCenter(this.windMatrix[i - 1][j].position, this.windMatrix[i - 1][j + 1].position, this.windMatrix[i][j].position, this.windMatrix[i][j + 1].position);
                    Position tr = this.getCenter(this.windMatrix[i][j].position, this.windMatrix[i][j + 1].position, this.windMatrix[i + 1][j].position, this.windMatrix[i + 1][j + 1].position);
                    GridCell cell = new GridCell(this, bl, br, tl, tr, this.windMatrix[i - 1][j].trueWindSpeedInKnots);
                    Util.Pair cellPair = new Util.Pair((Object)i, (Object)j);
                    this.gridCellMap.put(cellPair, cell);
                    ++j;
                }
                ++i;
            }
        }
    }

    private void updateGridCell() {
        int numCol;
        int numRow;
        if (this.windMatrix != null && (numRow = this.windMatrix.length) >= 4 && (numCol = this.windMatrix[0].length) >= 2) {
            int i = 1;
            while (i < numRow - 1) {
                int j = 1;
                while (j < numCol - 1) {
                    Util.Pair cellPair = new Util.Pair((Object)i, (Object)j);
                    GridCell cell = (GridCell)this.gridCellMap.get(cellPair);
                    cell.windSpeedInKnots = this.windMatrix[i - 1][j].trueWindSpeedInKnots;
                    ++j;
                }
                ++i;
            }
        }
    }

    private void drawGridCell() {
        if (this.gridCellMap != null & !this.gridCellMap.isEmpty()) {
            for (Map.Entry cell : this.gridCellMap.entrySet()) {
                this.drawGridCell((GridCell)cell.getValue());
            }
        }
    }

    private void drawGridCell(GridCell cell) {
        LatLng positionLatLng = this.coordinateSystem.toLatLng(cell.bottomLeft);
        Point blPoint = this.getMapProjection().fromLatLngToDivPixel(positionLatLng);
        positionLatLng = this.coordinateSystem.toLatLng(cell.bottomRight);
        Point brPoint = this.getMapProjection().fromLatLngToDivPixel(positionLatLng);
        positionLatLng = this.coordinateSystem.toLatLng(cell.topLeft);
        Point tlPoint = this.getMapProjection().fromLatLngToDivPixel(positionLatLng);
        positionLatLng = this.coordinateSystem.toLatLng(cell.topRight);
        Point trPoint = this.getMapProjection().fromLatLngToDivPixel(positionLatLng);
        Context2d context2d = this.canvas.getContext2d();
        context2d.setLineWidth(1.0);
        context2d.setStrokeStyle("Black");
        context2d.setGlobalAlpha(0.5);
        context2d.setFillStyle(this.colorPalette.getColor(cell.windSpeedInKnots));
        context2d.beginPath();
        context2d.moveTo(blPoint.getX() - this.getWidgetPosLeft(), blPoint.getY() - this.getWidgetPosTop());
        context2d.lineTo(brPoint.getX() - this.getWidgetPosLeft(), brPoint.getY() - this.getWidgetPosTop());
        context2d.lineTo(trPoint.getX() - this.getWidgetPosLeft(), trPoint.getY() - this.getWidgetPosTop());
        context2d.lineTo(tlPoint.getX() - this.getWidgetPosLeft(), tlPoint.getY() - this.getWidgetPosTop());
        context2d.lineTo(blPoint.getX() - this.getWidgetPosLeft(), blPoint.getY() - this.getWidgetPosTop());
        context2d.closePath();
        context2d.fill();
    }

    private Position getCenter(Position a, Position b, Position c, Position d) {
        double aLng = (a.getLngDeg() + 180.0) % 360.0 - 180.0;
        double bLng = (b.getLngDeg() - aLng + 180.0) % 360.0 - 180.0;
        double cLng = (c.getLngDeg() - aLng + 180.0) % 360.0 - 180.0;
        double dLng = (d.getLngDeg() - aLng + 180.0) % 360.0 - 180.0;
        DegreePosition center = new DegreePosition((a.getLatDeg() + b.getLatDeg() + c.getLatDeg() + d.getLatDeg()) / 4.0, aLng + (bLng + cLng + dLng) / 4.0);
        return center;
    }

    public Position[] getGridCorners() {
        if (this.gridCellMap != null && !this.gridCellMap.isEmpty()) {
            Position[] corners = new Position[4];
            int numRow = this.windMatrix.length;
            int numCol = this.windMatrix[0].length;
            Util.Pair cellPair1 = new Util.Pair((Object)1, (Object)1);
            corners[0] = ((GridCell)this.gridCellMap.get((Object)cellPair1)).bottomLeft;
            Util.Pair cellPair2 = new Util.Pair((Object)1, (Object)(numCol - 2));
            corners[1] = ((GridCell)this.gridCellMap.get((Object)cellPair2)).bottomRight;
            Util.Pair cellPair3 = new Util.Pair((Object)(numRow - 2), (Object)(numCol - 2));
            corners[2] = ((GridCell)this.gridCellMap.get((Object)cellPair3)).topRight;
            Util.Pair cellPair4 = new Util.Pair((Object)(numRow - 2), (Object)1);
            corners[3] = ((GridCell)this.gridCellMap.get((Object)cellPair4)).topLeft;
            return corners;
        }
        return null;
    }
}

