/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.maps.client.MapWidget;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldGenParamsDTO;
import com.sap.sailing.gwt.ui.simulator.PathCanvasOverlay;
import com.sap.sse.common.TimePoint;
import com.sap.sse.gwt.client.player.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class ReplayPathCanvasOverlay
extends PathCanvasOverlay {
    private static final long serialVersionUID = -6284996043723173190L;
    private static Logger logger = Logger.getLogger(ReplayPathCanvasOverlay.class.getName());
    private List<SimulatorWindDTO> windDTOToDraw;

    public ReplayPathCanvasOverlay(MapWidget map, int zIndex, String name, Timer timer, WindFieldGenParamsDTO windParams, boolean algorithmTimedOut, boolean mixedLeg, CoordinateSystem coordinateSystem) {
        super(map, zIndex, name, timer, windParams, algorithmTimedOut, mixedLeg, coordinateSystem);
        this.displayWindAlongPath = false;
        this.windDTOToDraw = null;
        this.canvas.setStyleName("replayPanel");
    }

    public void timeChanged(Date newTime, Date oldTime) {
        if (this.windFieldDTO == null) {
            return;
        }
        this.canvas.getContext2d().clearRect(0.0, 0.0, (double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
        this.windDTOToDraw = new ArrayList();
        for (SimulatorWindDTO windDTO : this.windFieldDTO.getMatrix()) {
            if (windDTO.timepoint.after(TimePoint.of((Date)newTime))) continue;
            this.windDTOToDraw.add(windDTO);
        }
        logger.info("In ReplayPathCanvasOverlay.drawWindField drawing " + this.windDTOToDraw.size() + " points");
        this.drawWindField(this.windDTOToDraw);
    }

    public boolean shallStop() {
        if (this.windDTOToDraw == null || this.windFieldDTO == null) {
            return false;
        }
        if (!this.isVisible()) {
            return true;
        }
        return this.windDTOToDraw.size() >= this.windFieldDTO.getMatrix().size() - 1;
    }
}

