/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.events.click.ClickMapHandler;
import com.google.gwt.maps.client.mvc.MVCArray;
import com.google.gwt.maps.client.overlays.MapCanvasProjection;
import com.google.gwt.maps.client.overlays.Marker;
import com.google.gwt.maps.client.overlays.MarkerOptions;
import com.google.gwt.maps.client.overlays.OverlayView;
import com.google.gwt.maps.client.overlays.Polyline;
import com.google.gwt.maps.client.overlays.PolylineOptions;
import com.google.gwt.maps.client.overlays.overlayhandlers.OverlayViewOnDrawHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.RadianPosition;
import com.sap.sailing.gwt.ui.client.SimulatorServiceAsync;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.RequestTotalTimeDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorUISelectionDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.simulator.PathPolyline;
import com.sap.sailing.gwt.ui.simulator.SimulatorMainPanel;
import com.sap.sailing.gwt.ui.simulator.SimulatorMap;
import com.sap.sailing.gwt.ui.simulator.racemap.TwoDPoint;
import com.sap.sailing.gwt.ui.simulator.racemap.TwoDSegment;
import com.sap.sailing.gwt.ui.simulator.racemap.TwoDVector;
import com.sap.sse.common.Bearing;
import com.sap.sse.gwt.client.ErrorReporter;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class PathPolyline {
    public static final String DEFAULT_COLOR = "#8B0000";
    public static final String END_USER_NAME = "What-If Course";
    private static final int DEFAULT_WEIGHT = 3;
    private static final double DEFAULT_OPACITY = 1.0;
    private static final double SMOOTHNESS_MAX_DEG = 20.0;
    private static final double EPSILON = 1.0E-10;
    private static final int STEP_DURATION_MILLISECONDS = 2000;
    private static final boolean USE_REAL_AVERAGE_WIND = true;
    private Polyline polyline = null;
    private LatLng[] turnPoints = null;
    private String color = "";
    private int weight = 0;
    private double opacity = 0.0;
    private int selectedBoatClassIndex = 0;
    private int selectedRaceIndex = 0;
    private int selectedCompetitorIndex = 0;
    private int selectedLegIndex = 0;
    private List<SimulatorWindDTO> allPoints = null;
    private SimulatorServiceAsync simulatorService = null;
    private MapWidget map = null;
    protected OverlayView mapView;
    protected MapCanvasProjection mapProjection;
    private ErrorReporter errorReporter = null;
    private boolean warningAlreadyShown = false;
    private SimulatorMap simulatorMap = null;
    private SimulatorMainPanel simulatorMainPanel = null;
    private boolean getTotalTimeFactor = false;
    private double totalTimeFactor = 0.0;

    public static PathPolyline createPathPolyline(List<SimulatorWindDTO> pathPoints, String color, int weight, double opacity, ErrorReporter errorReporter, SimulatorServiceAsync simulatorService, MapWidget map, SimulatorMap simulatorMap, SimulatorMainPanel simulatorMainPanel, SimulatorUISelectionDTO selection, CoordinateSystem coordinateSystem) {
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        for (SimulatorWindDTO pathPoint : pathPoints) {
            if (!pathPoint.isTurn.booleanValue()) continue;
            points.add(coordinateSystem.toLatLng(pathPoint.position));
        }
        return new PathPolyline(points.toArray(new LatLng[0]), color, weight, opacity, selection, errorReporter, pathPoints, simulatorService, map, simulatorMap, simulatorMainPanel);
    }

    public static PathPolyline createPathPolyline(List<SimulatorWindDTO> pathPoints, ErrorReporter errorReporter, SimulatorServiceAsync simulatorService, MapWidget map, SimulatorMap simulatorMap, SimulatorMainPanel simulatorMainPanel, SimulatorUISelectionDTO selection, CoordinateSystem coordinateSystem) {
        return PathPolyline.createPathPolyline(pathPoints, (String)"#8B0000", (int)3, (double)1.0, (ErrorReporter)errorReporter, (SimulatorServiceAsync)simulatorService, (MapWidget)map, (SimulatorMap)simulatorMap, (SimulatorMainPanel)simulatorMainPanel, (SimulatorUISelectionDTO)selection, (CoordinateSystem)coordinateSystem);
    }

    private PathPolyline(LatLng[] points, String color, int weight, double opacity, SimulatorUISelectionDTO selection, ErrorReporter errorReporter, List<SimulatorWindDTO> pathPoints, SimulatorServiceAsync simulatorService, MapWidget map, SimulatorMap simulatorMap, SimulatorMainPanel simulatorMainPanel) {
        this.turnPoints = points;
        this.color = color;
        this.weight = weight;
        this.opacity = opacity;
        this.allPoints = pathPoints;
        this.simulatorService = simulatorService;
        this.map = map;
        this.mapView = OverlayView.newInstance((MapWidget)map, (OverlayViewOnDrawHandler)new /* Unavailable Anonymous Inner Class!! */, null, null);
        this.selectedBoatClassIndex = selection.boatClassIndex;
        this.selectedRaceIndex = selection.raceIndex;
        this.selectedCompetitorIndex = selection.competitorIndex;
        this.selectedLegIndex = selection.legIndex;
        this.errorReporter = errorReporter;
        this.simulatorMap = simulatorMap;
        this.simulatorMainPanel = simulatorMainPanel;
        this.drawPolylineOnMap();
    }

    private void drawPolylineOnMap() {
        this.getTotalTimeFactor = this.polyline == null;
        if (this.polyline != null) {
            this.polyline.setMap(null);
        }
        PolylineOptions polylineOptions = PolylineOptions.newInstance();
        polylineOptions.setStrokeColor(this.color);
        polylineOptions.setStrokeOpacity(this.opacity);
        polylineOptions.setStrokeWeight(this.weight);
        this.polyline = Polyline.newInstance((PolylineOptions)polylineOptions);
        MVCArray pointsAsArray = MVCArray.newInstance((JavaScriptObject[])this.turnPoints);
        this.polyline.setPath(pointsAsArray);
        this.polyline.addClickHandler((ClickMapHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.polyline.setMap(this.map);
        this.simulatorMap.setPolyline(this.polyline);
        this.polyline.setEditable(true);
        this.getTotalTime();
    }

    private void addMarker(LatLng point, String title) {
        MarkerOptions options = MarkerOptions.newInstance();
        options.setDraggable(false);
        options.setTitle(title);
        Marker marker = Marker.newInstance((MarkerOptions)options);
        marker.setPosition(point);
        marker.setMap(this.map);
    }

    private LatLng[] checkIfPreviousMustGo(LatLng[] turnPoints, int indexOfMovedPoint, TwoDPoint secondBefore, TwoDPoint firstBefore, TwoDPoint neww, TwoDPoint firstAfter, TwoDSegment firstAfterEdge) {
        ArrayList<LatLng> newTurnPoints = new ArrayList<LatLng>();
        boolean newList = false;
        TwoDVector vector = new TwoDVector(neww, firstBefore);
        TwoDPoint projection = secondBefore.getProjectionByVector(firstAfterEdge, vector);
        TwoDSegment segment = new TwoDSegment(firstAfter, projection);
        if (!segment.contains(neww, true)) {
            newList = true;
            int index = 0;
            while (index < turnPoints.length) {
                if (index == indexOfMovedPoint) {
                    newTurnPoints.add(this.toLatLng(projection));
                } else if (index != indexOfMovedPoint - 1) {
                    newTurnPoints.add(turnPoints[index]);
                }
                ++index;
            }
        }
        if (newList) {
            return newTurnPoints.toArray(new LatLng[0]);
        }
        return turnPoints;
    }

    private LatLng[] checkIfPreviousTwoMustGo(LatLng[] turnPoints, int indexOfMovedPoint, TwoDPoint secondBefore, TwoDPoint oldFirstBefore, TwoDPoint newFirstBefore, TwoDPoint old, TwoDPoint neww, TwoDPoint firstAfter, TwoDSegment firstAfterEdge) {
        ArrayList<LatLng> newTurnPoints = new ArrayList<LatLng>();
        boolean newList = false;
        TwoDPoint thirdBefore = this.toTwoDPoint(turnPoints[indexOfMovedPoint - 3]);
        TwoDSegment thirdBeforeEdge = new TwoDSegment(secondBefore, thirdBefore);
        TwoDPoint intersection = thirdBeforeEdge.getIntersection(firstAfterEdge);
        TwoDSegment segment = new TwoDSegment(firstAfter, intersection);
        TwoDSegment firstBeforeEdge = new TwoDSegment(neww, newFirstBefore);
        TwoDPoint intersection2 = thirdBeforeEdge.getIntersection(firstBeforeEdge);
        TwoDSegment segment2 = new TwoDSegment(secondBefore, intersection);
        double distanceToNewFirstAfter = neww.getDistanceTo(firstAfter);
        double distanceToOld = neww.getDistanceTo(old);
        TwoDSegment oldFirstAfterEdge = new TwoDSegment(old, firstAfter);
        if (distanceToNewFirstAfter < distanceToOld && !oldFirstAfterEdge.contains(neww, true)) {
            if (indexOfMovedPoint + 2 < turnPoints.length) {
                TwoDPoint secondAfter = this.toTwoDPoint(turnPoints[indexOfMovedPoint + 2]);
                TwoDSegment secondAfterEdge = new TwoDSegment(firstAfter, secondAfter);
                TwoDSegment secondBeforeEdge = new TwoDSegment(newFirstBefore, secondBefore);
                TwoDPoint intersection3 = secondBeforeEdge.getIntersection(secondAfterEdge);
                newList = true;
                int index = 0;
                while (index < turnPoints.length) {
                    if (index == indexOfMovedPoint - 1) {
                        newTurnPoints.add(this.toLatLng(intersection3));
                    } else if (index != indexOfMovedPoint && index != indexOfMovedPoint + 1) {
                        newTurnPoints.add(turnPoints[index]);
                    }
                    ++index;
                }
            } else {
                TwoDVector vector = new TwoDVector(old, oldFirstBefore);
                TwoDSegment secondBeforeEdge = new TwoDSegment(newFirstBefore, secondBefore);
                TwoDPoint intersection3 = firstAfter.getProjectionByVector(secondBeforeEdge, vector);
                newList = true;
                int index = 0;
                while (index < turnPoints.length) {
                    if (index == indexOfMovedPoint - 1) {
                        newTurnPoints.add(this.toLatLng(intersection3));
                    } else if (index != indexOfMovedPoint) {
                        newTurnPoints.add(turnPoints[index]);
                    }
                    ++index;
                }
            }
        } else if (!segment.contains(neww, true) || segment2.contains(intersection2, true)) {
            newList = true;
            int index = 0;
            while (index < turnPoints.length) {
                if (index == indexOfMovedPoint) {
                    newTurnPoints.add(this.toLatLng(intersection));
                } else if (index != indexOfMovedPoint - 1 && index != indexOfMovedPoint - 2) {
                    newTurnPoints.add(turnPoints[index]);
                }
                ++index;
            }
        }
        if (newList) {
            return newTurnPoints.toArray(new LatLng[0]);
        }
        return turnPoints;
    }

    private LatLng[] checkIfNextTwoMustGo(LatLng[] turnPoints, int indexOfMovedPoint, TwoDPoint firstBefore, TwoDPoint old, TwoDPoint neww, TwoDPoint oldFirstAfter, TwoDPoint newFirstAfter, TwoDPoint secondAfter, TwoDSegment firstBeforeEdge) {
        ArrayList<LatLng> newTurnPoints = new ArrayList<LatLng>();
        boolean newList = false;
        TwoDPoint thirdAfter = this.toTwoDPoint(turnPoints[indexOfMovedPoint + 3]);
        TwoDSegment thirdAfterEdge = new TwoDSegment(secondAfter, thirdAfter);
        TwoDPoint intersection = thirdAfterEdge.getIntersection(firstBeforeEdge);
        TwoDSegment segment = new TwoDSegment(firstBefore, intersection);
        TwoDSegment firstAfterEdge = new TwoDSegment(neww, newFirstAfter);
        TwoDPoint intersection2 = thirdAfterEdge.getIntersection(firstAfterEdge);
        TwoDSegment segment2 = new TwoDSegment(secondAfter, intersection);
        double distanceToNewFirstBefore = neww.getDistanceTo(firstBefore);
        double distanceToOld = neww.getDistanceTo(old);
        TwoDSegment oldFirstBeforeEdge = new TwoDSegment(old, firstBefore);
        if (distanceToNewFirstBefore < distanceToOld && !oldFirstBeforeEdge.contains(neww, true)) {
            if (indexOfMovedPoint - 2 >= 0) {
                TwoDPoint secondBefore = this.toTwoDPoint(turnPoints[indexOfMovedPoint - 2]);
                TwoDSegment secondBeforeEdge = new TwoDSegment(secondBefore, firstBefore);
                TwoDSegment secondAfterEdge = new TwoDSegment(newFirstAfter, secondAfter);
                TwoDPoint intersection3 = secondAfterEdge.getIntersection(secondBeforeEdge);
                newList = true;
                int index = 0;
                while (index < turnPoints.length) {
                    if (index == indexOfMovedPoint + 1) {
                        newTurnPoints.add(this.toLatLng(intersection3));
                    } else if (index != indexOfMovedPoint && index != indexOfMovedPoint - 1) {
                        newTurnPoints.add(turnPoints[index]);
                    }
                    ++index;
                }
            } else {
                TwoDVector vector = new TwoDVector(old, oldFirstAfter);
                TwoDSegment secondAfterEdge = new TwoDSegment(newFirstAfter, secondAfter);
                TwoDPoint intersection3 = firstBefore.getProjectionByVector(secondAfterEdge, vector);
                newList = true;
                int index = 0;
                while (index < turnPoints.length) {
                    if (index == indexOfMovedPoint + 1) {
                        newTurnPoints.add(this.toLatLng(intersection3));
                    } else if (index != indexOfMovedPoint) {
                        newTurnPoints.add(turnPoints[index]);
                    }
                    ++index;
                }
            }
        } else if (!segment.contains(neww, true) || segment2.contains(intersection2, true)) {
            newList = true;
            int index = 0;
            while (index < turnPoints.length) {
                if (index == indexOfMovedPoint) {
                    newTurnPoints.add(this.toLatLng(intersection));
                } else if (index != indexOfMovedPoint + 1 && index != indexOfMovedPoint + 2) {
                    newTurnPoints.add(turnPoints[index]);
                }
                ++index;
            }
        }
        if (newList) {
            return newTurnPoints.toArray(new LatLng[0]);
        }
        return turnPoints;
    }

    private LatLng[] checkIfNextMustGo(LatLng[] turnPoints, int indexOfMovedPoint, TwoDPoint firstBefore, TwoDPoint neww, TwoDPoint firstAfter, TwoDPoint secondAfter, TwoDSegment firstBeforeEdge) {
        ArrayList<LatLng> newTurnPoints = new ArrayList<LatLng>();
        boolean newList = false;
        TwoDVector vector = new TwoDVector(neww, firstAfter);
        TwoDPoint projection = secondAfter.getProjectionByVector(firstBeforeEdge, vector);
        TwoDSegment segment = new TwoDSegment(firstBefore, projection);
        if (!segment.contains(neww, true)) {
            newList = true;
            int index = 0;
            while (index < turnPoints.length) {
                if (index == indexOfMovedPoint) {
                    newTurnPoints.add(this.toLatLng(projection));
                } else if (index != indexOfMovedPoint + 1) {
                    newTurnPoints.add(turnPoints[index]);
                }
                ++index;
            }
        }
        if (newList) {
            return newTurnPoints.toArray(new LatLng[0]);
        }
        return turnPoints;
    }

    private LatLng[] checkIfAnyTurnsMustGo(LatLng[] turnPoints, int indexOfMovedPoint, boolean secondPart, LatLng oldPositionOfFirstBeforeMovedPoint, LatLng oldPositionOfMovedPoint, LatLng oldPositionOfAfterBeforeMovedPoint) {
        LatLng[] result = null;
        TwoDPoint oldFirstBefore = this.toTwoDPoint(oldPositionOfFirstBeforeMovedPoint);
        TwoDPoint old = this.toTwoDPoint(oldPositionOfMovedPoint);
        TwoDPoint oldFirstAfter = this.toTwoDPoint(oldPositionOfAfterBeforeMovedPoint);
        TwoDPoint neww = this.toTwoDPoint(turnPoints[indexOfMovedPoint]);
        TwoDPoint newFirstBefore = this.toTwoDPoint(turnPoints[indexOfMovedPoint - 1]);
        TwoDPoint newFirstAfter = this.toTwoDPoint(turnPoints[indexOfMovedPoint + 1]);
        if (secondPart) {
            TwoDPoint secondAfter = this.toTwoDPoint(turnPoints[indexOfMovedPoint + 2]);
            TwoDSegment firstBeforeEdge = new TwoDSegment(newFirstBefore, neww);
            result = indexOfMovedPoint == turnPoints.length - 3 ? this.checkIfNextMustGo(turnPoints, indexOfMovedPoint, newFirstBefore, neww, newFirstAfter, secondAfter, firstBeforeEdge) : this.checkIfNextTwoMustGo(turnPoints, indexOfMovedPoint, newFirstBefore, old, neww, oldFirstAfter, newFirstAfter, secondAfter, firstBeforeEdge);
        } else {
            TwoDPoint secondBefore = this.toTwoDPoint(turnPoints[indexOfMovedPoint - 2]);
            TwoDSegment firstAfterEdge = new TwoDSegment(neww, newFirstAfter);
            result = indexOfMovedPoint == 2 ? this.checkIfPreviousMustGo(turnPoints, indexOfMovedPoint, secondBefore, newFirstBefore, neww, newFirstAfter, firstAfterEdge) : this.checkIfPreviousTwoMustGo(turnPoints, indexOfMovedPoint, secondBefore, oldFirstBefore, newFirstBefore, old, neww, newFirstAfter, firstAfterEdge);
        }
        return result;
    }

    private double getAngleDegreesBetween(LatLng head1, LatLng origin, LatLng head2) {
        double length2;
        TwoDVector first = new TwoDVector(this.toTwoDPoint(origin), this.toTwoDPoint(head1));
        TwoDVector second = new TwoDVector(this.toTwoDPoint(origin), this.toTwoDPoint(head2));
        double dotProduct = first.dotProduct(second);
        double length1 = first.getNorm();
        double denominator = length1 * (length2 = second.getNorm());
        double product = denominator != 0.0 ? dotProduct / denominator : 0.0;
        double angle = Math.toDegrees(Math.acos(product));
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    private LatLng[] eliminateSpikes(LatLng[] turnPoints) {
        if (turnPoints.length < 4) {
            return turnPoints;
        }
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        TwoDSegment beforeEdge = null;
        TwoDSegment afterEdge = null;
        int newIndex = -1;
        TwoDPoint newAtIndex = null;
        int index = 2;
        while (index < turnPoints.length - 1) {
            if (this.getAngleDegreesBetween(turnPoints[index - 1], turnPoints[index], turnPoints[index + 1]) < 20.0) {
                beforeEdge = new TwoDSegment(this.toTwoDPoint(turnPoints[index - 2]), this.toTwoDPoint(turnPoints[index - 1]));
                afterEdge = new TwoDSegment(this.toTwoDPoint(turnPoints[index]), this.toTwoDPoint(turnPoints[index + 1]));
                newAtIndex = afterEdge.getIntersection(beforeEdge);
                newIndex = index;
            }
            ++index;
        }
        index = 0;
        while (index < turnPoints.length) {
            if (index != newIndex - 1) {
                if (index == newIndex) {
                    points.add(this.toLatLng(newAtIndex));
                } else {
                    points.add(turnPoints[index]);
                }
            }
            ++index;
        }
        return points.toArray(new LatLng[0]);
    }

    private LatLng[] eliminateTriangles(LatLng[] turnPoints) {
        int noOfPoints = turnPoints.length;
        if (noOfPoints < 4) {
            return turnPoints;
        }
        LatLng first = null;
        LatLng second = null;
        LatLng third = null;
        LatLng fourth = null;
        int index = 0;
        while (index + 3 < noOfPoints) {
            first = turnPoints[index];
            second = turnPoints[index + 1];
            third = turnPoints[index + 2];
            fourth = turnPoints[index + 3];
            if (TwoDPoint.areIntersecting((TwoDPoint)this.toTwoDPoint(first), (TwoDPoint)this.toTwoDPoint(second), (TwoDPoint)this.toTwoDPoint(third), (TwoDPoint)this.toTwoDPoint(fourth))) {
                TwoDSegment firstSegment = new TwoDSegment(this.toTwoDPoint(first), this.toTwoDPoint(second));
                TwoDSegment secondSegment = new TwoDSegment(this.toTwoDPoint(third), this.toTwoDPoint(fourth));
                ArrayList<LatLng> newTurnPoints = new ArrayList<LatLng>();
                int index2 = 0;
                while (index2 < noOfPoints) {
                    if (index2 != index + 1) {
                        if (index2 == index + 2) {
                            newTurnPoints.add(this.toLatLng(firstSegment.getIntersection(secondSegment)));
                        } else {
                            newTurnPoints.add(turnPoints[index2]);
                        }
                    }
                    ++index2;
                }
                return newTurnPoints.toArray(new LatLng[0]);
            }
            ++index;
        }
        return turnPoints;
    }

    private Position intersectCurved(Position pos1, Bearing bear1, Position pos2, Bearing bear2) {
        Double lon3;
        Double lat3;
        double crs21;
        double crs12;
        double lat1 = pos1.getLatRad();
        double lon1 = pos1.getLngRad();
        double lat2 = pos2.getLatRad();
        double lon2 = pos2.getLngRad();
        double crs13 = bear1.getRadians();
        double crs23 = bear2.getRadians();
        double dst12 = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        if (Math.sin(lon2 - lon1) > 0.0) {
            crs12 = Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(dst12)) / (Math.sin(dst12) * Math.cos(lat1)));
            crs21 = Math.PI * 2 - Math.acos((Math.sin(lat1) - Math.sin(lat2) * Math.cos(dst12)) / (Math.sin(dst12) * Math.cos(lat2)));
        } else {
            crs12 = Math.PI * 2 - Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(dst12)) / (Math.sin(dst12) * Math.cos(lat1)));
            crs21 = Math.acos((Math.sin(lat1) - Math.sin(lat2) * Math.cos(dst12)) / (Math.sin(dst12) * Math.cos(lat2)));
        }
        double ang1 = (crs13 - crs12 + Math.PI) % (Math.PI * 2) - Math.PI;
        double ang2 = (crs21 - crs23 + Math.PI) % (Math.PI * 2) - Math.PI;
        if (Math.sin(ang1) == 0.0 && Math.sin(ang2) == 0.0) {
            lat3 = null;
            lon3 = null;
        } else {
            Double ang3 = Math.acos(-Math.cos(ang1) * Math.cos(ang2) + Math.sin(ang1) * Math.sin(ang2) * Math.cos(dst12));
            double dst13 = Math.atan2(Math.sin(dst12) * Math.sin(ang1) * Math.sin(ang2), Math.cos(ang2) + Math.cos(ang1) * Math.cos(ang3));
            lat3 = Math.asin(Math.sin(lat1) * Math.cos(dst13) + Math.cos(lat1) * Math.sin(dst13) * Math.cos(crs13));
            double dlon = Math.atan2(Math.sin(crs13) * Math.sin(dst13) * Math.cos(lat1), Math.cos(dst13) - Math.sin(lat1) * Math.sin(lat3));
            lon3 = (lon1 + dlon + Math.PI) % (Math.PI * 2) - Math.PI;
        }
        if (Math.abs(lon3 - (lon1 + lon2) / 2.0) > 1.5707963267948966) {
            lat3 = -lat3.doubleValue();
            lon3 = lon3 + Math.PI;
        }
        RadianPosition intersectPoint = new RadianPosition(lat3.doubleValue(), lon3.doubleValue());
        return intersectPoint;
    }

    private LatLng getNewPositionOfMovedPoint(int indexOfMovedPoint) {
        TwoDPoint firstBefore = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint - 1]);
        TwoDPoint oldPositionMovedPoint = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint]);
        TwoDPoint firstAfter = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint + 1]);
        TwoDPoint newPositionMovedPointBeforeFix = this.toTwoDPoint((LatLng)this.polyline.getPath().get(indexOfMovedPoint));
        TwoDSegment beforeEdge = new TwoDSegment(oldPositionMovedPoint, firstBefore);
        double distanceToBeforeEdge = newPositionMovedPointBeforeFix.getDistanceTo(beforeEdge);
        TwoDSegment afterEdge = new TwoDSegment(oldPositionMovedPoint, firstAfter);
        double distanceToAfterEdge = newPositionMovedPointBeforeFix.getDistanceTo(afterEdge);
        LatLng projectionOnBeforeEdge = this.toLatLng(newPositionMovedPointBeforeFix.getProjection(beforeEdge));
        LatLng projectionOfAfterEdge = this.toLatLng(newPositionMovedPointBeforeFix.getProjection(afterEdge));
        if (indexOfMovedPoint == 1) {
            return projectionOnBeforeEdge;
        }
        if (indexOfMovedPoint == this.turnPoints.length - 2) {
            return projectionOfAfterEdge;
        }
        return distanceToBeforeEdge < distanceToAfterEdge ? projectionOnBeforeEdge : projectionOfAfterEdge;
    }

    private Pair getNewPositionOfMovedPointCurved(int indexOfMovedPoint) {
        Position firstBefore = this.toPosition(this.turnPoints[indexOfMovedPoint - 1]);
        Position oldPositionMovedPoint = this.toPosition(this.turnPoints[indexOfMovedPoint]);
        Position firstAfter = this.toPosition(this.turnPoints[indexOfMovedPoint + 1]);
        Position newPositionMovedPointBeforeFix = this.toPosition((LatLng)this.polyline.getPath().get(indexOfMovedPoint));
        Bearing bearBefore = firstBefore.getBearingGreatCircle(oldPositionMovedPoint);
        Bearing bearAfter = firstAfter.getBearingGreatCircle(oldPositionMovedPoint);
        System.out.println("bearBefore: " + bearBefore.getDegrees());
        System.out.println("bearAfter : " + bearAfter.getDegrees());
        Position projectionOnBeforeEdge = newPositionMovedPointBeforeFix.projectToLineThrough(firstBefore, bearBefore);
        Position projectionOnAfterEdge = newPositionMovedPointBeforeFix.projectToLineThrough(firstAfter, bearAfter);
        double distanceToBeforeEdge = newPositionMovedPointBeforeFix.getDistance(projectionOnBeforeEdge).getMeters();
        double distanceToAfterEdge = newPositionMovedPointBeforeFix.getDistance(projectionOnAfterEdge).getMeters();
        LatLng projLatLngOnBeforeEdge = LatLng.newInstance((double)projectionOnBeforeEdge.getLatDeg(), (double)projectionOnBeforeEdge.getLngDeg());
        LatLng projLatLngOnAfterEdge = LatLng.newInstance((double)projectionOnAfterEdge.getLatDeg(), (double)projectionOnAfterEdge.getLngDeg());
        if (indexOfMovedPoint == 1) {
            return new Pair(this, projLatLngOnBeforeEdge, false);
        }
        if (indexOfMovedPoint == this.turnPoints.length - 2) {
            return new Pair(this, projLatLngOnAfterEdge, true);
        }
        return distanceToBeforeEdge < distanceToAfterEdge ? new Pair(this, projLatLngOnBeforeEdge, false) : new Pair(this, projLatLngOnAfterEdge, true);
    }

    private LatLng getNewPositionOfPointAfterMoved(int indexOfMovedPoint, LatLng newPositionOfMovedPoint) {
        TwoDPoint oldPositionOfMovedPoint = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint]);
        TwoDPoint firstAfter = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint + 1]);
        TwoDPoint secondAfter = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint + 2]);
        TwoDSegment firstAfterEdge = new TwoDSegment(firstAfter, secondAfter);
        TwoDVector afterVector = new TwoDVector(oldPositionOfMovedPoint, firstAfter);
        return this.toLatLng(this.toTwoDPoint(newPositionOfMovedPoint).getProjectionByVector(firstAfterEdge, afterVector));
    }

    private LatLng getNewPositionOfPointAfterMovedCurved(int indexOfMovedPoint, LatLng newLatLngOfMovedPoint) {
        Position newPositionOfMovedPoint = this.toPosition(newLatLngOfMovedPoint);
        Position oldPositionOfMovedPoint = this.toPosition(this.turnPoints[indexOfMovedPoint]);
        Position firstAfter = this.toPosition(this.turnPoints[indexOfMovedPoint + 1]);
        Position secondAfter = this.toPosition(this.turnPoints[indexOfMovedPoint + 2]);
        Bearing bearFirstAfter = oldPositionOfMovedPoint.getBearingGreatCircle(firstAfter);
        Bearing bearSecondAfter = secondAfter.getBearingGreatCircle(firstAfter);
        Position intersectPoint = this.intersectCurved(newPositionOfMovedPoint, bearFirstAfter, secondAfter, bearSecondAfter);
        return LatLng.newInstance((double)intersectPoint.getLatDeg(), (double)intersectPoint.getLngDeg());
    }

    private LatLng getNewPositionOfPointBeforeMoved(int indexOfMovedPoint, LatLng newPositionOfMovedPoint) {
        TwoDPoint firstBefore = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint - 1]);
        TwoDPoint secondBefore = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint - 2]);
        TwoDPoint oldPositionOfMovedPoint = this.toTwoDPoint(this.turnPoints[indexOfMovedPoint]);
        TwoDSegment firstBeforeEdge = new TwoDSegment(secondBefore, firstBefore);
        TwoDVector beforeVector = new TwoDVector(oldPositionOfMovedPoint, firstBefore);
        return this.toLatLng(this.toTwoDPoint(newPositionOfMovedPoint).getProjectionByVector(firstBeforeEdge, beforeVector));
    }

    private LatLng getNewPositionOfPointBeforeMovedCurved(int indexOfMovedPoint, LatLng newLatLngOfMovedPoint) {
        Position newPositionOfMovedPoint = this.toPosition(newLatLngOfMovedPoint);
        Position firstBefore = this.toPosition(this.turnPoints[indexOfMovedPoint - 1]);
        Position secondBefore = this.toPosition(this.turnPoints[indexOfMovedPoint - 2]);
        Position oldPositionOfMovedPoint = this.toPosition(this.turnPoints[indexOfMovedPoint]);
        Bearing bearSecondBefore = secondBefore.getBearingGreatCircle(firstBefore);
        Bearing bearFirstBefore = oldPositionOfMovedPoint.getBearingGreatCircle(firstBefore);
        System.out.println("bear2Before: " + bearSecondBefore.getDegrees());
        System.out.println("bear1Before: " + bearFirstBefore.getDegrees());
        Position intersectPoint = this.intersectCurved(newPositionOfMovedPoint, bearFirstBefore, secondBefore, bearSecondBefore);
        System.out.println("interSect: " + intersectPoint.getLatDeg() + ", " + intersectPoint.getLngDeg());
        return LatLng.newInstance((double)intersectPoint.getLatDeg(), (double)intersectPoint.getLngDeg());
    }

    private int getIndexOfMovedPoint() {
        int index = 0;
        while (index < this.turnPoints.length) {
            if (!PathPolyline.equals((LatLng)this.turnPoints[index], (LatLng)((LatLng)this.polyline.getPath().get(index)), (double)1.0E-10)) break;
            ++index;
        }
        return index;
    }

    private TwoDPoint toTwoDPoint(LatLng latLng) {
        Point point = this.mapProjection.fromLatLngToContainerPixel(latLng);
        return new TwoDPoint(point.getX(), point.getY());
    }

    private Position toPosition(LatLng latLng) {
        DegreePosition pos = new DegreePosition(latLng.getLatitude(), latLng.getLongitude());
        return pos;
    }

    private LatLng toLatLng(TwoDPoint point) {
        return this.mapProjection.fromContainerPixelToLatLng(Point.newInstance((double)((int)point.getX()), (double)((int)point.getY())));
    }

    private static Position toPositionDTO(LatLng position) {
        return new DegreePosition(position.getLatitude(), position.getLongitude());
    }

    private static boolean equals(LatLng first, LatLng second, double epsilon) {
        double latDiff = Math.abs(first.getLatitude() - second.getLatitude());
        double lngDiff = Math.abs(first.getLongitude() - second.getLongitude());
        return latDiff <= epsilon && lngDiff <= epsilon;
    }

    private void getTotalTime() {
        ArrayList<Position> turnPointsAsPositionDTO = new ArrayList<Position>();
        LatLng[] latLngArray = this.turnPoints;
        int n = this.turnPoints.length;
        int n2 = 0;
        while (n2 < n) {
            LatLng point = latLngArray[n2];
            turnPointsAsPositionDTO.add(PathPolyline.toPositionDTO((LatLng)point));
            ++n2;
        }
        RequestTotalTimeDTO requestData = new RequestTotalTimeDTO(new SimulatorUISelectionDTO(this.selectedBoatClassIndex, this.selectedRaceIndex, this.selectedCompetitorIndex, this.selectedLegIndex), 2000, this.allPoints, turnPointsAsPositionDTO, true);
        this.simulatorService.getTotalTime(requestData, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setBoatClassID(int boatClassIndex) {
        this.selectedBoatClassIndex = boatClassIndex;
    }

    public static double knotsToMetersPerSecond(double knots) {
        return knots * 0.5144444444444445;
    }

    static /* synthetic */ SimulatorMainPanel access$0(PathPolyline pathPolyline) {
        return pathPolyline.simulatorMainPanel;
    }

    static /* synthetic */ Polyline access$1(PathPolyline pathPolyline) {
        return pathPolyline.polyline;
    }

    static /* synthetic */ void access$2(PathPolyline pathPolyline, LatLng[] latLngArray) {
        pathPolyline.turnPoints = latLngArray;
    }

    static /* synthetic */ void access$3(PathPolyline pathPolyline) {
        pathPolyline.drawPolylineOnMap();
    }

    static /* synthetic */ int access$4(PathPolyline pathPolyline) {
        return pathPolyline.getIndexOfMovedPoint();
    }

    static /* synthetic */ LatLng[] access$5(PathPolyline pathPolyline) {
        return pathPolyline.turnPoints;
    }

    static /* synthetic */ Pair access$6(PathPolyline pathPolyline, int n) {
        return pathPolyline.getNewPositionOfMovedPointCurved(n);
    }

    static /* synthetic */ LatLng access$7(PathPolyline pathPolyline, int n, LatLng latLng) {
        return pathPolyline.getNewPositionOfPointAfterMovedCurved(n, latLng);
    }

    static /* synthetic */ LatLng access$8(PathPolyline pathPolyline, int n, LatLng latLng) {
        return pathPolyline.getNewPositionOfPointBeforeMovedCurved(n, latLng);
    }

    static /* synthetic */ boolean access$9(LatLng latLng, LatLng latLng2, double d) {
        return PathPolyline.equals((LatLng)latLng, (LatLng)latLng2, (double)d);
    }

    static /* synthetic */ LatLng[] access$10(PathPolyline pathPolyline, LatLng[] latLngArray, int n, boolean bl, LatLng latLng, LatLng latLng2, LatLng latLng3) {
        return pathPolyline.checkIfAnyTurnsMustGo(latLngArray, n, bl, latLng, latLng2, latLng3);
    }

    static /* synthetic */ LatLng[] access$11(PathPolyline pathPolyline, LatLng[] latLngArray) {
        return pathPolyline.eliminateSpikes(latLngArray);
    }

    static /* synthetic */ LatLng[] access$12(PathPolyline pathPolyline, LatLng[] latLngArray) {
        return pathPolyline.eliminateTriangles(latLngArray);
    }

    static /* synthetic */ ErrorReporter access$13(PathPolyline pathPolyline) {
        return pathPolyline.errorReporter;
    }

    static /* synthetic */ boolean access$14(PathPolyline pathPolyline) {
        return pathPolyline.warningAlreadyShown;
    }

    static /* synthetic */ void access$15(PathPolyline pathPolyline, boolean bl) {
        pathPolyline.warningAlreadyShown = bl;
    }

    static /* synthetic */ boolean access$16(PathPolyline pathPolyline) {
        return pathPolyline.getTotalTimeFactor;
    }

    static /* synthetic */ void access$17(PathPolyline pathPolyline, double d) {
        pathPolyline.totalTimeFactor = d;
    }

    static /* synthetic */ double access$18(PathPolyline pathPolyline) {
        return pathPolyline.totalTimeFactor;
    }

    static /* synthetic */ SimulatorMap access$19(PathPolyline pathPolyline) {
        return pathPolyline.simulatorMap;
    }
}

