/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.TextMetrics;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.maps.client.MapWidget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.simulator.PathCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.PathPolyline;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PathLegendCanvasOverlay
extends FullCanvasOverlay {
    private final StringMessages stringMessages;
    private List<PathCanvasOverlay> pathOverlays;
    private double curSpeed;
    private double curBearing;
    private char mode;
    private int xOffset = 10;
    private int yOffset = 20;
    private double rectWidth = 20.0;
    private double rectHeight = 20.0;
    private String textColor = "Black";
    private String textFont = "10pt 'Open Sans'";
    private String algorithmTimedOutText = "out-of-bounds";
    private String mixedLegText = "ambiguous wind";

    public PathLegendCanvasOverlay(MapWidget map, int zIndex, char mode, CoordinateSystem coordinateSystem, StringMessages stringMessages) {
        super(map, zIndex, coordinateSystem);
        this.stringMessages = stringMessages;
        this.mode = mode;
        if (this.mode == 'e') {
            this.yOffset = 170;
        }
        this.setPathOverlays(null);
        this.algorithmTimedOutText = stringMessages.simulationLegendAlgorithmTimedOutText();
        this.mixedLegText = stringMessages.simulationLegendMixedLegText();
    }

    protected void draw() {
        if (this.getMapProjection() != null && this.pathOverlays != null && this.pathOverlays.size() > 0) {
            boolean containsPolyline = false;
            for (PathCanvasOverlay overlay : this.pathOverlays) {
                if (!overlay.getName().equals("What-If Course")) continue;
                containsPolyline = true;
                break;
            }
            if (containsPolyline) {
                ArrayList<PathCanvasOverlay> result = new ArrayList<PathCanvasOverlay>();
                int indexOfPolyline = 0;
                int index = 0;
                while (index < this.pathOverlays.size()) {
                    if (((PathCanvasOverlay)this.pathOverlays.get(index)).getName().equals("What-If Course")) {
                        indexOfPolyline = index;
                    } else {
                        result.add((PathCanvasOverlay)this.pathOverlays.get(index));
                    }
                    ++index;
                }
                result.add(0, (PathCanvasOverlay)this.pathOverlays.get(indexOfPolyline));
                this.pathOverlays = result;
            }
            this.setCanvasSettings();
            int index = 0;
            Context2d context2d = this.canvas.getContext2d();
            context2d.setFont(this.textFont);
            TextMetrics txtmet = context2d.measureText("00:00:00");
            double timewidth = txtmet.getWidth();
            double txtmaxwidth = 0.0;
            boolean containsTimeOut = false;
            boolean containsMixedLeg = false;
            for (PathCanvasOverlay path : this.pathOverlays) {
                if (path.getAlgorithmTimedOut()) {
                    containsTimeOut = true;
                }
                if (path.getMixedLeg()) {
                    containsMixedLeg = true;
                }
                txtmet = context2d.measureText(path.getName());
                txtmaxwidth = Math.max(txtmaxwidth, txtmet.getWidth());
            }
            double newwidth = 0.0;
            double deltaTime = 0.0;
            double deltaMixedLeg = 0.0;
            double deltaTimeOut = 0.0;
            double mixedLegWidth = 0.0;
            if (containsMixedLeg) {
                txtmet = context2d.measureText(this.mixedLegText);
                mixedLegWidth = txtmet.getWidth();
                newwidth = Math.max(timewidth, mixedLegWidth);
            }
            double timeOutWidth = 0.0;
            if (containsTimeOut) {
                txtmet = context2d.measureText(this.algorithmTimedOutText);
                timeOutWidth = txtmet.getWidth();
                newwidth = Math.max(newwidth, timeOutWidth);
            }
            if (containsMixedLeg || containsTimeOut) {
                deltaTime = newwidth - timewidth;
                deltaMixedLeg = newwidth - mixedLegWidth;
                deltaTimeOut = newwidth - timeOutWidth;
                timewidth = newwidth;
            }
            for (PathCanvasOverlay path : this.pathOverlays) {
                String timeText = path.getMixedLeg() ? this.mixedLegText : (path.getAlgorithmTimedOut() ? this.algorithmTimedOutText : this.getFormattedTime(path.getPathDurationMillis()));
                this.drawRectangleWithText((double)this.xOffset, (double)this.yOffset + (double)(this.pathOverlays.size() - 1 - index) * this.rectHeight, path.getPathColor(), path.getName(), timeText, txtmaxwidth, timewidth, path.getMixedLeg() ? deltaMixedLeg : (path.getAlgorithmTimedOut() ? deltaTimeOut : deltaTime));
                ++index;
            }
            DegreeBearingImpl curBear = new DegreeBearingImpl(this.curBearing);
            if (this.curSpeed >= 0.0) {
                double cFactor = 12.0;
                double cWidth = Math.max(1.0, 1.0 + cFactor * PathPolyline.knotsToMetersPerSecond((double)this.curSpeed) / 3.0);
                double cLength = Math.max(10.0, 10.0 + cFactor * 2.0 * PathPolyline.knotsToMetersPerSecond((double)this.curSpeed));
                double cX = (double)this.xOffset + (this.rectWidth + 15.0 + txtmaxwidth + timewidth) / 2.0;
                double cY = (double)this.yOffset + (double)(this.pathOverlays.size() - 1) * this.rectHeight + 75.0;
                context2d.setGlobalAlpha(0.8);
                context2d.setFillStyle("white");
                double bgWidth = 120.0;
                double bgHeight = 70.0;
                if (this.curSpeed == 0.0) {
                    bgHeight = 20.0;
                }
                context2d.fillRect(cX - bgWidth / 2.0, cY - 25.0 - 15.0, bgWidth, bgHeight);
                context2d.setGlobalAlpha(1.0);
                context2d.setFont(this.textFont);
                context2d.setFillStyle(this.textColor);
                String cText = String.valueOf(this.stringMessages.current()) + ": " + this.stringMessages.knotsValue(this.curSpeed);
                txtmet = context2d.measureText(cText);
                double txtwidth = txtmet.getWidth();
                context2d.fillText(cText, cX - txtwidth / 2.0, cY - 25.0);
                if (this.curSpeed > 0.0) {
                    this.drawArrowPx(cX, cY, curBear.getRadians(), cLength, cWidth, true, "Green");
                }
            }
        }
    }

    public void setCanvasSettings() {
        super.setCanvasSettings();
        this.canvas.getElement().getStyle().setZIndex(100000);
    }

    public List<PathCanvasOverlay> getPathOverlays() {
        return this.pathOverlays;
    }

    public void setPathOverlays(List<PathCanvasOverlay> pathOverlays) {
        this.pathOverlays = pathOverlays;
    }

    public void addPathOverlay(PathCanvasOverlay pathOverlay) {
        if (this.pathOverlays == null) {
            this.pathOverlays = new ArrayList();
        }
        boolean found = false;
        if (pathOverlay.getName().equals("What-If Course")) {
            for (PathCanvasOverlay overlay : this.pathOverlays) {
                if (!overlay.getName().equals("What-If Course")) continue;
                overlay.setTotalTimeMilliseconds(pathOverlay.getTotalTimeMilliseconds());
                found = true;
                break;
            }
        }
        if (!found) {
            this.pathOverlays.add(pathOverlay);
        }
    }

    protected void drawRectangle(double x, double y, String color) {
        Context2d context2d = this.canvas.getContext2d();
        context2d.setFillStyle(color);
        context2d.setLineWidth(3.0);
        context2d.fillRect(x, y, this.rectWidth, this.rectHeight);
    }

    protected void drawRectangleWithText(double x, double y, String color, String text, String time, double textmaxwidth, double timewidth, double xdelta) {
        double offset = 3.0;
        Context2d context2d = this.canvas.getContext2d();
        context2d.setFont(this.textFont);
        this.drawRectangle(x, y, color);
        context2d.setGlobalAlpha(0.8);
        context2d.setFillStyle("white");
        context2d.fillRect(x + this.rectWidth, y, 20.0 + textmaxwidth + timewidth, this.rectHeight);
        context2d.setGlobalAlpha(1.0);
        context2d.setFillStyle(this.textColor);
        context2d.fillText(text, x + this.rectWidth + 5.0, y + 12.0 + offset);
        context2d.fillText(time, x + this.rectWidth + textmaxwidth + xdelta + 15.0, y + 12.0 + offset);
    }

    protected String getFormattedTime(long pathTime) {
        com.google.gwt.i18n.client.TimeZone gmt = com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0);
        Date timeDiffDate = new Date(pathTime);
        String pathTimeStr = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.HOUR24_MINUTE_SECOND).format(timeDiffDate, (TimeZone)gmt);
        return pathTimeStr;
    }

    public void setCurrent(double curSpeed, double curBearing) {
        this.curSpeed = curSpeed;
        this.curBearing = curBearing;
    }
}

