/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.maps.client.base.LatLng;

public class CourseAreaDescriptor {
    private String name;
    private double radius;
    private LatLng centerPos;
    private LatLng edgePos;
    private String color;
    private String colorText;

    public CourseAreaDescriptor(String name, LatLng centerPos, double radius, String color) {
        this(name, centerPos, radius, color, color);
    }

    public CourseAreaDescriptor(String name, LatLng centerPos, double radius, String color, String colorText) {
        this.name = name;
        this.radius = radius;
        this.centerPos = centerPos;
        this.edgePos = this.getEdgePoint(centerPos, radius);
        this.color = color;
        this.colorText = colorText;
    }

    private LatLng getEdgePoint(LatLng pos, double dist) {
        double lat1 = pos.getLatitude() / 180.0 * Math.PI;
        double lon1 = pos.getLongitude() / 180.0 * Math.PI;
        double brng = 0.0;
        double R = 6371.0;
        double d = 1.852 * dist;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(d / R) + Math.cos(lat1) * Math.sin(d / R) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(d / R) * Math.cos(lat1), Math.cos(d / R) - Math.sin(lat1) * Math.sin(lat2));
        lon2 = (lon2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        double lat2deg = lat2 / Math.PI * 180.0;
        double lon2deg = lon2 / Math.PI * 180.0;
        LatLng result = LatLng.newInstance((double)lat2deg, (double)lon2deg);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getRadiusInMeters() {
        return this.radius * 1852.0;
    }

    public LatLng getCenterPos() {
        return this.centerPos;
    }

    public LatLng getEdgePos() {
        return this.edgePos;
    }

    public String getColor() {
        return this.color;
    }

    public String getColorText() {
        return this.colorText;
    }
}

