/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.base.Size;
import com.google.gwt.maps.client.events.MapEventFormatter;
import com.google.gwt.maps.client.events.MapHandler;
import com.google.gwt.maps.client.events.MapHandlerRegistration;
import com.google.gwt.maps.client.events.click.ClickEventFormatter;
import com.google.gwt.maps.client.events.click.ClickMapHandler;
import com.google.gwt.maps.client.events.dblclick.DblClickEventFormatter;
import com.google.gwt.maps.client.events.dblclick.DblClickMapHandler;
import com.google.gwt.maps.client.events.mousedown.MouseDownEventFormatter;
import com.google.gwt.maps.client.events.mousedown.MouseDownMapHandler;
import com.google.gwt.maps.client.events.mousemove.MouseMoveEventFormatter;
import com.google.gwt.maps.client.events.mousemove.MouseMoveMapHandler;
import com.google.gwt.maps.client.events.mouseout.MouseOutEventFormatter;
import com.google.gwt.maps.client.events.mouseout.MouseOutMapHandler;
import com.google.gwt.maps.client.events.mouseover.MouseOverEventFormatter;
import com.google.gwt.maps.client.events.mouseover.MouseOverMapHandler;
import com.google.gwt.maps.client.events.mouseup.MouseUpEventFormatter;
import com.google.gwt.maps.client.events.mouseup.MouseUpMapHandler;
import com.google.gwt.maps.client.events.rightclick.RightClickEventFormatter;
import com.google.gwt.maps.client.events.rightclick.RightClickMapHandler;
import com.google.gwt.maps.client.overlays.MapCanvasProjection;
import com.google.gwt.maps.client.overlays.OverlayView;
import com.google.gwt.maps.client.overlays.overlayhandlers.OverlayViewOnAddHandler;
import com.google.gwt.maps.client.overlays.overlayhandlers.OverlayViewOnDrawHandler;
import com.google.gwt.maps.client.overlays.overlayhandlers.OverlayViewOnRemoveHandler;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;

public abstract class CanvasOverlayV3 {
    private OverlayView customOverlayView;
    protected Canvas canvas;
    protected boolean isSelected;
    protected MapWidget map;
    protected LatLng latLngPosition;
    protected final int zIndex;
    protected final CoordinateSystem coordinateSystem;
    private long transitionTimeInMilliseconds = -1L;
    private Double drawingAngle;

    public CanvasOverlayV3(MapWidget map, int zIndex, String canvasId, CoordinateSystem coordinateSystem) {
        this.map = map;
        this.zIndex = zIndex;
        this.coordinateSystem = coordinateSystem;
        this.canvas = Canvas.createIfSupported();
        this.canvas.getElement().getStyle().setZIndex(zIndex);
        this.canvas.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.canvas.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
        if (canvasId != null) {
            this.canvas.getElement().setId(canvasId);
        }
        this.customOverlayView = OverlayView.newInstance((MapWidget)map, (OverlayViewOnDrawHandler)this.getOnDrawHandler(), (OverlayViewOnAddHandler)this.getOnAddHandler(), (OverlayViewOnRemoveHandler)this.getOnRemoveHandler());
    }

    public CanvasOverlayV3(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        this(map, zIndex, null, coordinateSystem);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public boolean isVisible() {
        return this.getCanvas() != null && this.getCanvas().isVisible();
    }

    public void setVisible(boolean isVisible) {
        if (this.getCanvas() != null) {
            this.getCanvas().setVisible(isVisible);
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public LatLng getLatLngPosition() {
        return this.latLngPosition;
    }

    public void addToMap() {
        this.customOverlayView.setMap(this.map);
    }

    public void removeFromMap() {
        this.customOverlayView.setMap(null);
    }

    public final HandlerRegistration addClickHandler(ClickMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)ClickEvent.getType(), (MapHandler)handler, (MapEventFormatter)new ClickEventFormatter(), (boolean)true);
    }

    public final HandlerRegistration addDblClickHandler(DblClickMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)DoubleClickEvent.getType(), (MapHandler)handler, (MapEventFormatter)new DblClickEventFormatter(), (boolean)true);
    }

    public final HandlerRegistration addMouseDownHandler(MouseDownMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)MouseDownEvent.getType(), (MapHandler)handler, (MapEventFormatter)new MouseDownEventFormatter(), (boolean)true);
    }

    public final HandlerRegistration addMouseMoveHandler(MouseMoveMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)MouseMoveEvent.getType(), (MapHandler)handler, (MapEventFormatter)new MouseMoveEventFormatter(), (boolean)true);
    }

    public final HandlerRegistration addMouseOutMoveHandler(MouseOutMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)MouseOutEvent.getType(), (MapHandler)handler, (MapEventFormatter)new MouseOutEventFormatter(), (boolean)true);
    }

    public final HandlerRegistration addMouseOverHandler(MouseOverMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)MouseOverEvent.getType(), (MapHandler)handler, (MapEventFormatter)new MouseOverEventFormatter(), (boolean)true);
    }

    public final HandlerRegistration addMouseUpHandler(MouseUpMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)MouseUpEvent.getType(), (MapHandler)handler, (MapEventFormatter)new MouseUpEventFormatter(), (boolean)true);
    }

    public final HandlerRegistration addRightClickHandler(RightClickMapHandler handler) {
        return MapHandlerRegistration.addEventListener((JavaScriptObject)this.getCanvas().getCanvasElement(), (DomEvent.Type)ContextMenuEvent.getType(), (MapHandler)handler, (MapEventFormatter)new RightClickEventFormatter(), (boolean)true);
    }

    protected void setLatLngPosition(LatLng latLngPosition) {
        this.latLngPosition = latLngPosition;
    }

    public MapWidget getMap() {
        return this.map;
    }

    protected abstract void draw();

    protected void onAttach() {
    }

    protected OverlayViewOnAddHandler getOnAddHandler() {
        1 result = new /* Unavailable Anonymous Inner Class!! */;
        return result;
    }

    protected OverlayViewOnDrawHandler getOnDrawHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected OverlayViewOnRemoveHandler getOnRemoveHandler() {
        3 result = new /* Unavailable Anonymous Inner Class!! */;
        return result;
    }

    public void setCanvasPositionAndRotationTransition(long durationInMilliseconds) {
        if (durationInMilliseconds != this.transitionTimeInMilliseconds) {
            String[] stringArray = this.getBrowserTypePrefixes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String browserTypePrefix = stringArray[n2];
                StringBuilder transformPropertyList = new StringBuilder();
                transformPropertyList.append("left ");
                transformPropertyList.append(durationInMilliseconds);
                transformPropertyList.append("ms linear, top ");
                transformPropertyList.append(durationInMilliseconds);
                transformPropertyList.append("ms linear, ");
                transformPropertyList.append(this.getBrowserSpecificDashedPropertyName(browserTypePrefix, "transform"));
                transformPropertyList.append(' ');
                transformPropertyList.append(durationInMilliseconds);
                transformPropertyList.append("ms linear");
                this.canvas.getElement().getStyle().setProperty(this.getBrowserSpecificPropertyName(browserTypePrefix, "transition"), transformPropertyList.toString());
                ++n2;
            }
            this.transitionTimeInMilliseconds = durationInMilliseconds;
        }
    }

    public void removeCanvasPositionAndRotationTransition() {
        if (this.transitionTimeInMilliseconds != -1L) {
            this.setProperty(this.canvas.getElement().getStyle(), "transition", "none");
            this.transitionTimeInMilliseconds = -1L;
        }
    }

    private void setProperty(Style style, String baseCamelCasePropertyName, String value) {
        String[] stringArray = this.getBrowserTypePrefixes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String browserTypePrefix = stringArray[n2];
            style.setProperty(this.getBrowserSpecificPropertyName(browserTypePrefix, baseCamelCasePropertyName), value);
            ++n2;
        }
    }

    private String[] getBrowserTypePrefixes() {
        return new String[]{"", "moz", "ms", "o", "webkit"};
    }

    private String getBrowserSpecificDashedPropertyName(String browserType, String camelCaseString) {
        StringBuilder result = new StringBuilder();
        if (browserType != null && !browserType.isEmpty()) {
            result.append('-');
            result.append(browserType);
            result.append('-');
        }
        int i = 0;
        while (i < camelCaseString.length()) {
            char c = camelCaseString.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('-');
            }
            result.append(Character.toLowerCase(c));
            ++i;
        }
        return result.toString();
    }

    private String getBrowserSpecificPropertyName(String browserType, String basePropertyName) {
        String result = browserType == null || browserType.isEmpty() ? basePropertyName : String.valueOf(browserType) + basePropertyName.substring(0, 1).toUpperCase() + basePropertyName.substring(1);
        return result;
    }

    protected void setCanvasPosition(double x, double y) {
        this.canvas.getElement().getStyle().setLeft(x, Style.Unit.PX);
        this.canvas.getElement().getStyle().setTop(y, Style.Unit.PX);
    }

    protected void updateDrawingAngleAndSetCanvasRotation(double newBoatDrawingAngle) {
        this.drawingAngle = this.drawingAngle == null ? Double.valueOf(newBoatDrawingAngle) : Double.valueOf(this.getNewRotationWithMinimalDiff(newBoatDrawingAngle));
        this.setCanvasRotation();
    }

    private void setCanvasRotation() {
        this.setProperty(this.canvas.getElement().getStyle(), "transformOrigin", "50% 50%");
        this.setProperty(this.canvas.getElement().getStyle(), "transform", "translateZ(0) rotate(" + this.drawingAngle + "deg)");
    }

    protected double getNewRotationWithMinimalDiff(double desiredAngle) {
        double desiredMinusCurrent;
        double result = desiredAngle;
        while (Math.abs(desiredMinusCurrent = result - this.drawingAngle) > 180.0) {
            result -= Math.signum(desiredMinusCurrent) * 360.0;
        }
        return this.drawingAngle + desiredMinusCurrent;
    }

    protected double calculateRadiusOfBoundingBoxInPixels(MapCanvasProjection projection, Position centerPosition, Distance length) {
        Position translateRhumbX = centerPosition.translateRhumb((Bearing)new DegreeBearingImpl(90.0), length);
        Position translateRhumbY = centerPosition.translateRhumb((Bearing)new DegreeBearingImpl(0.0), length);
        LatLng posWithDistanceX = this.coordinateSystem.toLatLng(translateRhumbX);
        LatLng posWithDistanceY = this.coordinateSystem.toLatLng(translateRhumbY);
        Point pointCenter = projection.fromLatLngToDivPixel(this.coordinateSystem.toLatLng(centerPosition));
        Point pointX = projection.fromLatLngToDivPixel(posWithDistanceX);
        Point pointY = projection.fromLatLngToDivPixel(posWithDistanceY);
        double diffX = this.getPointDistance(pointX, pointCenter);
        double diffY = this.getPointDistance(pointY, pointCenter);
        return Math.min(diffX, diffY);
    }

    private double getPointDistance(Point a, Point b) {
        return Math.sqrt((b.getX() - a.getX()) * (b.getX() - a.getX()) + (b.getY() - a.getY()) * (b.getY() - a.getY()));
    }

    protected double calculateDistanceAlongX(MapCanvasProjection projection, Position pos, Distance distanceX) {
        Position translateRhumbX = pos.translateRhumb((Bearing)new DegreeBearingImpl(90.0), distanceX);
        LatLng posWithDistanceX = this.coordinateSystem.toLatLng(translateRhumbX);
        Point point = projection.fromLatLngToDivPixel(this.coordinateSystem.toLatLng(pos));
        Point pointX = projection.fromLatLngToDivPixel(posWithDistanceX);
        return Math.abs(pointX.getX() - point.getX());
    }

    protected Size calculateBoundingBox(MapCanvasProjection projection, Position pos, Distance distanceX, Distance distanceY) {
        Position translateRhumbX = pos.translateRhumb((Bearing)new DegreeBearingImpl(90.0), distanceX);
        Position translateRhumbY = pos.translateRhumb((Bearing)new DegreeBearingImpl(0.0), distanceY);
        LatLng posWithDistanceX = this.coordinateSystem.toLatLng(translateRhumbX);
        LatLng posWithDistanceY = this.coordinateSystem.toLatLng(translateRhumbY);
        Point pointCenter = projection.fromLatLngToDivPixel(this.coordinateSystem.toLatLng(pos));
        Point pointX = projection.fromLatLngToDivPixel(posWithDistanceX);
        Point pointY = projection.fromLatLngToDivPixel(posWithDistanceY);
        return Size.newInstance((double)Math.abs(pointX.getX() - pointCenter.getX()), (double)Math.abs(pointY.getY() - pointCenter.getY()));
    }

    protected void setCanvasSize(int newWidthInPx, int newHeightInPx) {
        if (this.getCanvas() != null) {
            this.getCanvas().setWidth(String.valueOf(newWidthInPx) + "px");
            this.getCanvas().setHeight(String.valueOf(newHeightInPx) + "px");
            this.getCanvas().setCoordinateSpaceWidth(newWidthInPx);
            this.getCanvas().setCoordinateSpaceHeight(newHeightInPx);
        }
    }

    protected void updateTransition(long timeForPositionTransitionMillis) {
        if (timeForPositionTransitionMillis == -1L) {
            this.removeCanvasPositionAndRotationTransition();
        } else {
            this.setCanvasPositionAndRotationTransition(timeForPositionTransitionMillis);
        }
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public MapCanvasProjection getMapProjection() {
        return this.customOverlayView.getProjection();
    }
}

