/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.windfinder.SpotDTO;
import com.sap.sailing.gwt.ui.shared.EventBaseDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class EventDTO
extends EventBaseDTO
implements SecuredDTO {
    private static final long serialVersionUID = -7100030301376959817L;
    private SecurityInformationDTO securityInformation = new SecurityInformationDTO();
    private Date currentServerTime;
    private List<LeaderboardGroupDTO> leaderboardGroups;
    private List<String> windFinderReviewedSpotsCollectionIds;
    private List<SpotDTO> allWindFinderSpotIdsUsedByEvent;

    @Deprecated
    EventDTO() {
    }

    public EventDTO(String name) {
        this(name, new ArrayList());
    }

    public EventDTO(String name, List<LeaderboardGroupDTO> leaderboardGroups) {
        super(name, leaderboardGroups);
        this.leaderboardGroups = leaderboardGroups;
        this.initCurrentServerTime();
    }

    public boolean isFakeSeries() {
        return this.leaderboardGroups.size() == 1 && ((LeaderboardGroupDTO)this.leaderboardGroups.get(0)).hasOverallLeaderboard();
    }

    public boolean isRunning() {
        return this.getCurrentServerTime().after(this.startDate) && this.getCurrentServerTime().before(this.endDate);
    }

    public boolean isFinished() {
        return this.getCurrentServerTime().after(this.endDate);
    }

    private void initCurrentServerTime() {
        this.currentServerTime = new Date();
    }

    public Date getCurrentServerTime() {
        return this.currentServerTime;
    }

    public void addLeaderboardGroup(LeaderboardGroupDTO leaderboardGroup) {
        this.leaderboardGroups.add(leaderboardGroup);
    }

    public List<LeaderboardGroupDTO> getLeaderboardGroups() {
        return this.leaderboardGroups;
    }

    public List<UUID> getLeaderboardGroupIds() {
        ArrayList<UUID> updatedEventLeaderboardGroupIds = new ArrayList<UUID>();
        for (LeaderboardGroupDTO leaderboardGroup : this.getLeaderboardGroups()) {
            updatedEventLeaderboardGroupIds.add(leaderboardGroup.getId());
        }
        return updatedEventLeaderboardGroupIds;
    }

    public AbstractLeaderboardDTO getLeaderboardByName(String leaderboardName) {
        for (LeaderboardGroupDTO leaderboardGroup : this.getLeaderboardGroups()) {
            for (StrippedLeaderboardDTO leaderboardDTO : leaderboardGroup.getLeaderboards()) {
                if (!leaderboardName.equals(leaderboardDTO.getName())) continue;
                return leaderboardDTO;
            }
        }
        return null;
    }

    public List<String> getWindFinderReviewedSpotsCollectionIds() {
        List result = this.windFinderReviewedSpotsCollectionIds == null ? Collections.emptyList() : this.windFinderReviewedSpotsCollectionIds;
        return result;
    }

    public void setWindFinderReviewedSpotsCollection(Iterable<String> reviewedSpotsCollectionId) {
        this.windFinderReviewedSpotsCollectionIds = new ArrayList();
        if (reviewedSpotsCollectionId != null) {
            Util.addAll(reviewedSpotsCollectionId, (Collection)this.windFinderReviewedSpotsCollectionIds);
        }
    }

    public Iterable<SpotDTO> getAllWindFinderSpotIdsUsedByEvent() {
        Collection<Object> result = this.allWindFinderSpotIdsUsedByEvent == null ? Collections.emptySet() : this.allWindFinderSpotIdsUsedByEvent;
        return result;
    }

    public void setAllWindFinderSpotsUsedByEvent(Iterable<SpotDTO> windFinderSpots) {
        this.allWindFinderSpotIdsUsedByEvent = new ArrayList();
        if (windFinderSpots != null) {
            Util.addAll(windFinderSpots, (Collection)this.allWindFinderSpotIdsUsedByEvent);
        }
    }

    public final AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    public final OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    public final void setAccessControlList(AccessControlListDTO accessControlList) {
        this.securityInformation.setAccessControlList(accessControlList);
    }

    public final void setOwnership(OwnershipDTO ownership) {
        this.securityInformation.setOwnership(ownership);
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.EVENT;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return new TypeRelativeObjectIdentifier(new String[]{this.getId().toString()});
    }
}

