/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.RadianPosition;
import com.sap.sailing.gwt.ui.shared.SimulatorUISelectionDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.SimulatorUISelection;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.SimulatorUISelectionImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimulatorServiceUtils {
    public static double EARTH_RADIUS_METERS = 6378137.0;
    public static double FACTOR_DEG2RAD = 0.0174532925;
    public static double FACTOR_RAD2DEG = 57.2957795;
    public static double FACTOR_KN2MPS = 0.514444;
    public static double FACTOR_MPS2KN = 1.94384;
    public static SpeedWithBearing DEFAULT_AVERAGE_WIND = new KnotSpeedWithBearingImpl(4.5, (Bearing)new DegreeBearingImpl(350.0));

    public static double degreesToRadians(double degrees) {
        return degrees * FACTOR_DEG2RAD;
    }

    public static double radiansToDegrees(double radians) {
        return radians * FACTOR_RAD2DEG;
    }

    public static double knotsToMetersPerSecond(double knots) {
        return knots * FACTOR_KN2MPS;
    }

    public static double metersPerSecondToKnots(double metersPerSecond) {
        return metersPerSecond * FACTOR_MPS2KN;
    }

    public static SpeedWithBearing getAverage(SimulatorWindDTO windDTO1, SimulatorWindDTO windDTO2) {
        ArrayList<SimulatorWindDTO> windDTOs = new ArrayList<SimulatorWindDTO>();
        windDTOs.add(windDTO1);
        windDTOs.add(windDTO2);
        return SimulatorServiceUtils.getAverage(windDTOs);
    }

    public static SpeedWithBearing getAverage(List<SimulatorWindDTO> windDTOs) {
        double sumOfProductOfSpeedAndCosBearing = 0.0;
        double sumOfProductOfSpeedAndSinBearing = 0.0;
        double windBearingRadians = 0.0;
        for (SimulatorWindDTO windDTO : windDTOs) {
            windBearingRadians = SimulatorServiceUtils.degreesToRadians((double)windDTO.trueWindBearingDeg);
            sumOfProductOfSpeedAndSinBearing += windDTO.trueWindSpeedInKnots * Math.sin(windBearingRadians);
            sumOfProductOfSpeedAndCosBearing += windDTO.trueWindSpeedInKnots * Math.cos(windBearingRadians);
        }
        int count = windDTOs.size();
        double a = sumOfProductOfSpeedAndSinBearing / (double)count;
        double b = sumOfProductOfSpeedAndCosBearing / (double)count;
        double c = SimulatorServiceUtils.radiansToDegrees((double)Math.atan(a / b));
        double averageBearingDegrees = 0.0;
        if (a > 0.0 && b >= 0.0) {
            averageBearingDegrees = c;
        } else if (a < 0.0 && b >= 0.0) {
            averageBearingDegrees = 360.0 + c;
        } else if (a < 0.0 && b < 0.0) {
            averageBearingDegrees = 180.0 + c;
        } else if (a > 0.0 && b < 0.0) {
            averageBearingDegrees = 180.0 - c;
        }
        double averageSpeedKnots = Math.sqrt(a * a + b * b);
        return new KnotSpeedWithBearingImpl(averageSpeedKnots, (Bearing)new DegreeBearingImpl(averageBearingDegrees));
    }

    public static List<Position> getIntermediatePoints(Position startPoint, Position endPoint, double stepSizeMeters) {
        ArrayList<Position> result = new ArrayList<Position>();
        double distance = startPoint.getDistance(endPoint).getMeters();
        int noOfSteps = (int)(distance / stepSizeMeters) + 1;
        double bearing = SimulatorServiceUtils.getInitialBearing((Position)startPoint, (Position)endPoint);
        Position temp = null;
        result.add(startPoint);
        int stepIndex = 1;
        while (stepIndex < noOfSteps) {
            temp = SimulatorServiceUtils.getDestinationPoint((Position)startPoint, (double)bearing, (double)(stepSizeMeters * (double)stepIndex));
            result.add(temp);
            bearing = SimulatorServiceUtils.getInitialBearing((Position)startPoint, (Position)temp);
            ++stepIndex;
        }
        return result;
    }

    public static List<Position> getIntermediatePoints2(List<Position> points, double stepSizeMeters) {
        ArrayList<Position> newPoints = new ArrayList<Position>();
        for (Position point : points) {
            newPoints.add(point);
        }
        return SimulatorServiceUtils.getIntermediatePoints(newPoints, (double)stepSizeMeters);
    }

    public static List<Position> getIntermediatePoints(List<Position> points, double stepSizeMeters) {
        int noOfPoints = points.size();
        int noOfPointsMinus1 = noOfPoints - 1;
        if (noOfPoints == 0) {
            return new ArrayList<Position>();
        }
        if (noOfPoints == 1) {
            return points;
        }
        if (noOfPoints == 2) {
            Position endPoint;
            Position startPoint = points.get(0);
            double distance = startPoint.getDistance(endPoint = points.get(1)).getMeters();
            if (distance <= stepSizeMeters) {
                return points;
            }
            List newPoints = SimulatorServiceUtils.getIntermediatePoints((Position)startPoint, (Position)endPoint, (double)stepSizeMeters);
            newPoints.add(endPoint);
            return newPoints;
        }
        ArrayList<Position> result = new ArrayList<Position>();
        int index = 0;
        while (index < noOfPointsMinus1) {
            result.addAll(SimulatorServiceUtils.getIntermediatePoints((Position)points.get(index), (Position)points.get(index + 1), (double)stepSizeMeters));
            ++index;
        }
        result.add(points.get(noOfPoints - 1));
        return result;
    }

    public static double getTimeSeconds(Position startPoint, Position endPoint, double endSpeedMetersPerSecond) {
        double distance = startPoint.getDistance(endPoint).getMeters();
        if (distance == 0.0) {
            return 0.0;
        }
        return distance / endSpeedMetersPerSecond;
    }

    public static double getTotalDistanceMeters(Position[] points) {
        int noOfPositions = points.length;
        if (noOfPositions == 0 || noOfPositions == 1) {
            return 0.0;
        }
        double result = 0.0;
        int index = 0;
        while (index < noOfPositions) {
            if (index == noOfPositions - 1) break;
            result += points[index].getDistance(points[index + 1]).getMeters();
            ++index;
        }
        return result;
    }

    public static double getInitialBearing(Position startPoint, Position endPoint) {
        double lat1 = startPoint.getLatRad();
        double lat2 = endPoint.getLatRad();
        double dLon = endPoint.getLngRad() - startPoint.getLngRad();
        double y = Math.sin(dLon) * Math.cos(lat2);
        double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon);
        double bearing = Math.atan2(y, x);
        return (SimulatorServiceUtils.radiansToDegrees((double)bearing) + 360.0) % 360.0;
    }

    public static double getFinalBearing(Position startPoint, Position endPoint) {
        double lat1 = startPoint.getLatRad();
        double lat2 = endPoint.getLatRad();
        double dLon = endPoint.getLngRad() - startPoint.getLngRad();
        double y = Math.sin(dLon) * Math.cos(lat2);
        double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon);
        double bearing = Math.atan2(y, x);
        return (SimulatorServiceUtils.radiansToDegrees((double)bearing) + 180.0) % 360.0;
    }

    public static Position getMidpointBetween(Position startPoint, Position endPoint) {
        double lat1 = startPoint.getLatRad();
        double lon1 = startPoint.getLngRad();
        double lat2 = endPoint.getLatRad();
        double dLon = endPoint.getLngRad() - lon1;
        double Bx = Math.cos(lat2) * Math.cos(dLon);
        double By = Math.cos(lat2) * Math.sin(dLon);
        double lat3 = Math.atan2(Math.sin(lat1) + Math.sin(lat2), Math.sqrt((Math.cos(lat1) + Bx) * (Math.cos(lat1) + Bx) + By * By));
        double lon3 = lon1 + Math.atan2(By, Math.cos(lat1) + Bx);
        lon3 = (lon3 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new RadianPosition(lat3, lon3);
    }

    public static Position getDestinationPoint(Position startPoint, double bearingDegrees, double distanceMeters) {
        double distance = distanceMeters / EARTH_RADIUS_METERS;
        double bearing = SimulatorServiceUtils.degreesToRadians((double)bearingDegrees);
        double lat1 = startPoint.getLatRad();
        double lon1 = startPoint.getLngRad();
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(distance) + Math.cos(lat1) * Math.sin(distance) * Math.cos(bearing));
        double lon2 = lon1 + Math.atan2(Math.sin(bearing) * Math.sin(distance) * Math.cos(lat1), Math.cos(distance) - Math.sin(lat1) * Math.sin(lat2));
        lon2 = (lon2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new RadianPosition(lat2, lon2);
    }

    public static double getSign(Position p1, Position p2, Position p3) {
        return (p1.getLatDeg() - p3.getLatDeg()) * (p2.getLngDeg() - p3.getLngDeg()) - (p2.getLatDeg() - p3.getLatDeg()) * (p1.getLngDeg() - p3.getLngDeg());
    }

    public static boolean isPointInsideTriangle(Position point, Position corner1, Position corner2, Position corner3) {
        boolean b3;
        boolean b1 = SimulatorServiceUtils.getSign((Position)point, (Position)corner1, (Position)corner2) < 0.0;
        boolean b2 = SimulatorServiceUtils.getSign((Position)point, (Position)corner2, (Position)corner3) < 0.0;
        boolean bl = b3 = SimulatorServiceUtils.getSign((Position)point, (Position)corner3, (Position)corner1) < 0.0;
        return b1 == b2 && b2 == b3;
    }

    public static boolean areTowardsSameDirection(Bearing b1, Bearing b2) {
        boolean isB1TowardsNorth = b1.getDegrees() < 90.0 || b1.getDegrees() > 270.0;
        boolean isB2TowardsNorth = b2.getDegrees() < 90.0 || b2.getDegrees() > 270.0;
        return !(isB1TowardsNorth ^ isB2TowardsNorth);
    }

    public static boolean equals(Position first, Position second, double delta) {
        double latDiff = Math.abs(first.getLatDeg() - second.getLatDeg());
        double lngDiff = Math.abs(first.getLngDeg() - second.getLngDeg());
        return latDiff <= delta && lngDiff <= delta;
    }

    public static int getIndexOfClosest(List<TimedPositionWithSpeed> items, TimedPositionWithSpeed item) {
        int count = items.size();
        ArrayList<Double> diff_lat = new ArrayList<Double>();
        ArrayList<Double> diff_lng = new ArrayList<Double>();
        ArrayList<Long> diff_timepoint = new ArrayList<Long>();
        int index = 0;
        while (index < count) {
            diff_lat.add(Math.abs(items.get(index).getPosition().getLatDeg() - item.getPosition().getLatDeg()));
            diff_lng.add(Math.abs(items.get(index).getPosition().getLngDeg() - item.getPosition().getLngDeg()));
            diff_timepoint.add(Math.abs(items.get(index).getTimePoint().asMillis() - item.getTimePoint().asMillis()));
            ++index;
        }
        double min_diff_lat = (Double)Collections.min(diff_lat);
        double min_max_diff_lat = min_diff_lat + (Double)Collections.max(diff_lat);
        double min_diff_lng = (Double)Collections.min(diff_lng);
        double min_max_diff_lng = min_diff_lng + (Double)Collections.max(diff_lng);
        long min_diff_timepoint = (Long)Collections.min(diff_timepoint);
        double min_max_diff_timepoint = min_diff_timepoint + (Long)Collections.max(diff_timepoint);
        ArrayList<Double> norm_diff_lat = new ArrayList<Double>();
        ArrayList<Double> norm_diff_lng = new ArrayList<Double>();
        ArrayList<Double> norm_diff_timepoint = new ArrayList<Double>();
        int index2 = 0;
        while (index2 < count) {
            norm_diff_lat.add(((Double)diff_lat.get(index2) - min_diff_lat) / min_max_diff_lat);
            norm_diff_lng.add(((Double)diff_lng.get(index2) - min_diff_lng) / min_max_diff_lng);
            norm_diff_timepoint.add((double)((Long)diff_timepoint.get(index2) - min_diff_timepoint) / min_max_diff_timepoint);
            ++index2;
        }
        ArrayList<Double> deltas = new ArrayList<Double>();
        int index3 = 0;
        while (index3 < count) {
            deltas.add(Math.sqrt(Math.pow((Double)norm_diff_lat.get(index3), 2.0) + Math.pow((Double)norm_diff_lng.get(index3), 2.0) + Math.pow((Double)norm_diff_timepoint.get(index3), 2.0)));
            ++index3;
        }
        int result = 0;
        double min = (Double)deltas.get(0);
        int index4 = 0;
        while (index4 < count) {
            if ((Double)deltas.get(index4) < min) {
                result = index4;
                min = (Double)deltas.get(index4);
            }
            ++index4;
        }
        return result;
    }

    public static SpeedWithBearing getWindAtTimepoint(long timepointAsMillis, Path gpsTrack) {
        List pathPoints = gpsTrack.getPathPoints();
        int noOfPathPoints = pathPoints.size();
        ArrayList<Double> diffs = new ArrayList<Double>();
        int index = 0;
        while (index < noOfPathPoints) {
            diffs.add(Double.valueOf(Math.abs(((TimedPositionWithSpeed)pathPoints.get(index)).getTimePoint().asMillis() - timepointAsMillis)));
            ++index;
        }
        int indexOfMinDiff = diffs.indexOf(Collections.min(diffs));
        return ((TimedPositionWithSpeed)pathPoints.get(indexOfMinDiff)).getSpeed();
    }

    public static List<SimulatorWindDTO> toSimulatorWindDTOList(List<TimedPositionWithSpeed> points) {
        ArrayList<SimulatorWindDTO> result = new ArrayList<SimulatorWindDTO>();
        for (TimedPositionWithSpeed point : points) {
            result.add(SimulatorServiceUtils.toSimulatorWindDTO((TimedPositionWithSpeed)point));
        }
        return result;
    }

    public static SimulatorWindDTO toSimulatorWindDTO(TimedPositionWithSpeed point) {
        Position position = point.getPosition();
        SpeedWithBearing windSpeedWithBearing = point.getSpeed();
        TimePoint timePoint = point.getTimePoint();
        double latDeg = position.getLatDeg();
        double lngDeg = position.getLngDeg();
        double windSpeedKn = windSpeedWithBearing.getKnots();
        double windBearingDeg = windSpeedWithBearing.getBearing().getDegrees();
        return new SimulatorWindDTO(latDeg, lngDeg, windSpeedKn, windBearingDeg, timePoint);
    }

    public static SimulatorUISelection toSimulatorUISelection(SimulatorUISelectionDTO selection) {
        return new SimulatorUISelectionImpl(selection.boatClassIndex.intValue(), selection.raceIndex.intValue(), selection.competitorIndex.intValue(), selection.legIndex.intValue());
    }
}

