/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.client.MediaServiceWrite;
import com.sap.sailing.gwt.ui.server.MediaServiceImpl;
import com.sap.sse.security.Action;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;

public class MediaServiceWriteImpl
extends MediaServiceImpl
implements MediaServiceWrite {
    private static final long serialVersionUID = 7177987884609485859L;

    public MediaTrackWithSecurityDTO addMediaTrack(MediaTrack mediaTrack) {
        if (mediaTrack.dbId != null) {
            throw new IllegalStateException("Property dbId must not be null for newly created media track.");
        }
        this.racingEventService().mediaTrackAdded(mediaTrack);
        SecurityService securityService = this.racingEventService().getSecurityService();
        QualifiedObjectIdentifier identifier = mediaTrack.getIdentifier();
        securityService.setDefaultOwnershipIfNotSet(identifier);
        if (!SecurityUtils.getSubject().isPermitted(identifier.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CREATE))) {
            this.racingEventService().mediaTrackDeleted(mediaTrack);
            securityService.deleteOwnership(identifier);
            throw new UnauthenticatedException("Not authorized to create media track object");
        }
        MediaTrackWithSecurityDTO mediaTrackWithSecurity = new MediaTrackWithSecurityDTO(mediaTrack);
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.racingEventService().getSecurityService(), (SecuredDTO)mediaTrackWithSecurity);
        return mediaTrackWithSecurity;
    }

    public void deleteMediaTrack(MediaTrack mediaTrack) {
        this.racingEventService().getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)mediaTrack, (Action)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updateTitle(MediaTrack mediaTrack) {
        this.ensureUserCanUpdateMediaTrack(mediaTrack);
        this.racingEventService().mediaTrackTitleChanged(mediaTrack);
    }

    public void updateUrl(MediaTrack mediaTrack) {
        this.ensureUserCanUpdateMediaTrack(mediaTrack);
        this.racingEventService().mediaTrackUrlChanged(mediaTrack);
    }

    public void updateStartTime(MediaTrack mediaTrack) {
        this.ensureUserCanUpdateMediaTrack(mediaTrack);
        this.racingEventService().mediaTrackStartTimeChanged(mediaTrack);
    }

    public void updateDuration(MediaTrack mediaTrack) {
        this.ensureUserCanUpdateMediaTrack(mediaTrack);
        this.racingEventService().mediaTrackDurationChanged(mediaTrack);
    }

    public void updateRace(MediaTrack mediaTrack) {
        this.ensureUserCanUpdateMediaTrack(mediaTrack);
        this.racingEventService().mediaTrackAssignedRacesChanged(mediaTrack);
    }

    private void ensureUserCanUpdateMediaTrack(MediaTrack mediaTrack) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.MEDIA_TRACK.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)mediaTrack));
    }
}

