/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagCell;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagInputPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingPanelResources;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.List;

public class TagPreviewPanel
extends FlowPanel {
    private final TaggingPanelResources resources = TaggingPanelResources.INSTANCE;
    private final TaggingPanelResources.TagPanelStyle style = this.resources.style();
    private final TaggingComponent taggingComponent;
    private final UserService userService;
    private final CellList<TagDTO> tagPreviewCellList;
    private List<TagDTO> listContainingPreviewTag;

    protected TagPreviewPanel(TaggingComponent taggingComponent, TagInputPanel inputPanel, StringMessages stringMessages, UserService userService, RaceIdentifier raceIdentifier) {
        this.taggingComponent = taggingComponent;
        this.userService = userService;
        this.setStyleName(this.style.tagPreviewPanel());
        this.tagPreviewCellList = new CellList((Cell)new TagCell(taggingComponent, stringMessages, userService, true, raceIdentifier), (CellList.Resources)this.resources);
        this.listContainingPreviewTag = new ArrayList();
        this.add((Widget)new Label(stringMessages.tagPreview()));
        this.add((Widget)this.tagPreviewCellList);
        inputPanel.getTagTextBox().addValueChangeHandler(event -> this.renderPreview(inputPanel));
        inputPanel.getCommentTextArea().addValueChangeHandler(event -> this.renderPreview(inputPanel));
        inputPanel.getVisibleForPublicCheckBox().addValueChangeHandler(event -> this.renderPreview(inputPanel));
        this.renderPreview(inputPanel);
    }

    protected void renderPreview(TagInputPanel inputPanel) {
        this.listContainingPreviewTag.removeAll(this.listContainingPreviewTag);
        this.listContainingPreviewTag.add(new TagDTO(inputPanel.getTag(), inputPanel.getComment(), inputPanel.getHiddenInfo(), inputPanel.getImageURL(), "", inputPanel.isVisibleForPublic(), this.userService.getCurrentUser().getName(), (TimePoint)new MillisecondsTimePoint(this.taggingComponent.getTimerTime()), MillisecondsTimePoint.now()));
        this.tagPreviewCellList.setRowData(this.listContainingPreviewTag);
        this.setVisible(!inputPanel.getTag().isEmpty());
    }
}

