/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.TagFilterSets;
import com.sap.sailing.gwt.ui.client.shared.filter.TagFilterSetsDialog;
import com.sap.sailing.gwt.ui.client.shared.filter.TagFilterSetsJsonDeSerializer;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagFilterLabel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagListProvider;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingPanelResources;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.AbstractListFilter;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collections;

public class TagFilterPanel
extends FlowPanel
implements KeyUpHandler,
Filter<TagDTO> {
    private static final String LOCAL_STORAGE_TAGS_FILTER_SETS_KEY = "sailing.tags.filtersets";
    private final TaggingPanelResources.TagPanelStyle style = TaggingPanelResources.INSTANCE.style();
    private final TaggingComponent taggingComponent;
    private final StringMessages stringMessages;
    private final UserService userService;
    private final TagListProvider tagListProvider;
    private TagFilterSets tagFilterSets;
    private final TextBox searchTextBox;
    private final Button clearTextBoxButton;
    private final Button filterSettingsButton;
    private final Button refreshTagsButton;
    private final AbstractListFilter<TagDTO> filter;
    private FilterSet<TagDTO, FilterWithUI<TagDTO>> lastActiveTagFilterSet;
    private final TagFilterLabel currentFilter;

    protected TagFilterPanel(TaggingComponent taggingComponent, StringMessages stringMessages, UserService userService) {
        this.taggingComponent = taggingComponent;
        this.stringMessages = stringMessages;
        this.userService = userService;
        this.tagListProvider = taggingComponent.getTagListProvider();
        this.tagFilterSets = new TagFilterSets();
        this.setStyleName(this.style.tagFilterPanel());
        this.searchTextBox = new TextBox();
        this.clearTextBoxButton = new Button();
        this.filterSettingsButton = new Button();
        this.refreshTagsButton = new Button();
        this.currentFilter = new TagFilterLabel(taggingComponent, stringMessages);
        this.loadTagFilterSets();
        this.filter = new /* Unavailable Anonymous Inner Class!! */;
        this.initializeUI();
    }

    private void initializeUI() {
        this.setStyleName(this.style.tagFilterPanel());
        Button submitButton = new Button();
        submitButton.setStyleName(this.style.tagFilterButton());
        submitButton.addStyleName("gwt-Button");
        submitButton.addStyleName(this.style.tagFilterSearchButton());
        submitButton.addStyleName(this.style.imageSearch());
        this.searchTextBox.getElement().setAttribute("placeholder", this.stringMessages.tagSearchTags());
        this.searchTextBox.addKeyUpHandler((KeyUpHandler)this);
        this.searchTextBox.setStyleName(this.style.tagFilterSearchInput());
        this.clearTextBoxButton.setStyleName(this.style.tagFilterButton());
        this.clearTextBoxButton.addStyleName(this.style.tagFilterClearButton());
        this.clearTextBoxButton.addStyleName(this.style.imageClearSearch());
        this.clearTextBoxButton.addStyleName(this.style.tagFilterHiddenButton());
        this.clearTextBoxButton.addStyleName("gwt-Button");
        this.clearTextBoxButton.addClickHandler(event -> this.clearSearchbox());
        this.filterSettingsButton.setStyleName(this.style.tagFilterButton());
        this.filterSettingsButton.addStyleName(this.style.imageInactiveFilter());
        this.filterSettingsButton.addStyleName("gwt-Button");
        this.filterSettingsButton.setTitle(this.stringMessages.tagsFilter());
        this.filterSettingsButton.addClickHandler(event -> this.showFilterDialog());
        this.refreshTagsButton.setStyleName(this.style.tagReloadButton());
        this.refreshTagsButton.addStyleName(this.style.imageReload());
        this.refreshTagsButton.addStyleName("gwt-Button");
        this.refreshTagsButton.setTitle(this.stringMessages.refresh());
        this.refreshTagsButton.addClickHandler(event -> this.taggingComponent.clearCache());
        FlowPanel searchBoxPanel = new FlowPanel();
        searchBoxPanel.setStyleName(this.style.tagFilterSearchBox());
        searchBoxPanel.add((Widget)submitButton);
        searchBoxPanel.add((Widget)this.searchTextBox);
        searchBoxPanel.add((Widget)this.clearTextBoxButton);
        this.add((Widget)searchBoxPanel);
        this.add((Widget)this.filterSettingsButton);
        this.add((Widget)this.refreshTagsButton);
        this.add((Widget)this.currentFilter);
    }

    private void showFilterDialog() {
        TagFilterSetsDialog tagsFilterSetsDialog = new TagFilterSetsDialog(this.tagFilterSets, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, this.userService);
        tagsFilterSetsDialog.show();
    }

    private void updateTagFilterControlState(TagFilterSets filterSets) {
        String tagsFilterTitle = this.stringMessages.tagsFilter();
        FilterSet activeFilterSet = filterSets.getActiveFilterSet();
        if (activeFilterSet != null) {
            if (this.lastActiveTagFilterSet == null) {
                this.filterSettingsButton.removeStyleName(this.style.imageInactiveFilter());
                this.filterSettingsButton.addStyleName(this.style.imageActiveFilter());
            }
            this.lastActiveTagFilterSet = activeFilterSet;
        } else {
            if (this.lastActiveTagFilterSet != null) {
                this.filterSettingsButton.removeStyleName(this.style.imageActiveFilter());
                this.filterSettingsButton.addStyleName(this.style.imageInactiveFilter());
            }
            this.lastActiveTagFilterSet = null;
        }
        if (this.lastActiveTagFilterSet != null) {
            this.filterSettingsButton.setTitle(String.valueOf(tagsFilterTitle) + " (" + this.lastActiveTagFilterSet.getName() + ")");
        } else {
            this.filterSettingsButton.setTitle(tagsFilterTitle);
        }
    }

    protected void loadTagFilterSets() {
        if (this.userService.getCurrentUser() != null) {
            this.userService.getPreference(LOCAL_STORAGE_TAGS_FILTER_SETS_KEY, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.tagFilterSets.removeAllFilterSets();
            this.tagListProvider.setCurrentFilterSet(null);
        }
    }

    private void storeTagFilterSets(TagFilterSets newTagsFilterSets) {
        TagFilterSetsJsonDeSerializer serializer = new TagFilterSetsJsonDeSerializer();
        JSONObject jsonObject = serializer.serialize(newTagsFilterSets);
        this.userService.setPreference(LOCAL_STORAGE_TAGS_FILTER_SETS_KEY, jsonObject.toString(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void clearSearchbox() {
        this.searchTextBox.setText("");
        this.clearTextBoxButton.addStyleName(this.style.tagFilterHiddenButton());
        this.onKeyUp(null);
    }

    private void ensureSearchFilterIsSet() {
        FilterSet tagProviderFilterSet = this.tagListProvider.getTagFilterSet();
        if (tagProviderFilterSet == null || !Util.contains((Iterable)tagProviderFilterSet.getFilters(), (Object)this)) {
            FilterSet newFilterSetWithThis;
            if (tagProviderFilterSet != null) {
                newFilterSetWithThis = new FilterSet(tagProviderFilterSet.getName());
                for (Filter oldFilter : tagProviderFilterSet.getFilters()) {
                    newFilterSetWithThis.addFilter(oldFilter);
                }
            } else {
                newFilterSetWithThis = new FilterSet(null);
            }
            newFilterSetWithThis.addFilter((Filter)this);
            this.tagListProvider.setCurrentFilterSet(newFilterSetWithThis);
        }
    }

    private void removeSearchFilter() {
        if (this.tagListProvider.getTagFilterSet() != null && Util.contains((Iterable)this.tagListProvider.getTagFilterSet().getFilters(), (Object)this)) {
            FilterSet newFilterSetWithThis = new FilterSet(this.tagListProvider.getTagFilterSet().getName());
            for (Filter oldFilter : this.tagListProvider.getTagFilterSet().getFilters()) {
                if (oldFilter == this) continue;
                newFilterSetWithThis.addFilter(oldFilter);
            }
            this.tagListProvider.setCurrentFilterSet(newFilterSetWithThis);
        }
    }

    public boolean matches(TagDTO tag) {
        Iterable lowercaseKeywords = Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)this.searchTextBox.getText().toLowerCase());
        return !Util.isEmpty((Iterable)this.filter.applyFilter(lowercaseKeywords, Collections.singleton(tag)));
    }

    public String getName() {
        return null;
    }

    public void onKeyUp(KeyUpEvent event) {
        String newValue = this.searchTextBox.getValue();
        if (newValue.trim().isEmpty()) {
            this.removeSearchFilter();
            this.clearTextBoxButton.addStyleName(this.style.tagFilterHiddenButton());
        } else if (newValue.length() >= 2) {
            this.clearTextBoxButton.removeStyleName(this.style.tagFilterHiddenButton());
            this.ensureSearchFilterIsSet();
            this.tagListProvider.setCurrentFilterSet(this.tagListProvider.getTagFilterSet());
        }
    }

    static /* synthetic */ TagFilterSets access$1(TagFilterPanel tagFilterPanel) {
        return tagFilterPanel.tagFilterSets;
    }

    static /* synthetic */ TagListProvider access$2(TagFilterPanel tagFilterPanel) {
        return tagFilterPanel.tagListProvider;
    }

    static /* synthetic */ void access$3(TagFilterPanel tagFilterPanel, TagFilterSets tagFilterSets) {
        tagFilterPanel.updateTagFilterControlState(tagFilterSets);
    }

    static /* synthetic */ UserService access$4(TagFilterPanel tagFilterPanel) {
        return tagFilterPanel.userService;
    }

    static /* synthetic */ void access$5(TagFilterPanel tagFilterPanel, TagFilterSets tagFilterSets) {
        tagFilterPanel.storeTagFilterSets(tagFilterSets);
    }

    static /* synthetic */ TaggingComponent access$6(TagFilterPanel tagFilterPanel) {
        return tagFilterPanel.taggingComponent;
    }

    static /* synthetic */ void access$7(TagFilterPanel tagFilterPanel, TagFilterSets tagFilterSets) {
        tagFilterPanel.tagFilterSets = tagFilterSets;
    }

    static /* synthetic */ StringMessages access$8(TagFilterPanel tagFilterPanel) {
        return tagFilterPanel.stringMessages;
    }
}

