/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagButtonJsonDeSerializer;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagFooterPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingPanelResources;
import com.sap.sse.security.ui.client.UserService;

public class TagButtonPanel
extends FlowPanel {
    private static final String USER_STORAGE_TAG_BUTTONS_KEY = "sailing.tags.buttons";
    private final TaggingPanelResources.TagPanelStyle style = TaggingPanelResources.INSTANCE.style();
    private final TagFooterPanel footerPanel;
    private final TaggingComponent taggingComponent;
    private final StringMessages stringMessages;
    private final UserService userService;
    private final Label heading;
    private final Panel tagButtonsPanel;

    protected TagButtonPanel(TaggingComponent taggingComponent, TagFooterPanel footerPanel, StringMessages stringMessages, UserService userService) {
        this.footerPanel = footerPanel;
        this.taggingComponent = taggingComponent;
        this.stringMessages = stringMessages;
        this.userService = userService;
        this.heading = new Label(stringMessages.tagButtons());
        this.heading.setStyleName(this.style.tagButtonPanelHeader());
        this.add((Widget)this.heading);
        this.tagButtonsPanel = new FlowPanel();
        this.tagButtonsPanel.setStyleName(this.style.buttonsPanel());
        this.tagButtonsPanel.addStyleName(this.style.tagButtonPanel());
        this.add((Widget)this.tagButtonsPanel);
    }

    protected void loadAllTagButtons() {
        this.tagButtonsPanel.clear();
        if (this.userService.getCurrentUser() != null) {
            this.userService.getPreference(USER_STORAGE_TAG_BUTTONS_KEY, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.taggingComponent.getTagButtons().clear();
            this.recalculateHeight();
        }
    }

    protected void storeAllTagButtons() {
        TagButtonJsonDeSerializer serializer = new TagButtonJsonDeSerializer();
        JSONArray jsonArray = serializer.serialize(this.taggingComponent.getTagButtons());
        this.userService.setPreference(USER_STORAGE_TAG_BUTTONS_KEY, jsonArray.toString(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void recalculateHeight() {
        if (this.taggingComponent.getTagButtons().size() == 0) {
            this.tagButtonsPanel.clear();
            this.footerPanel.setTagButtonsVisibility(false);
        } else {
            this.footerPanel.setTagButtonsVisibility(true);
            int oldHeight = this.getOffsetHeight();
            this.tagButtonsPanel.clear();
            this.taggingComponent.getTagButtons().forEach(button -> this.tagButtonsPanel.add((Widget)button));
            if (this.getOffsetHeight() - oldHeight != 0) {
                this.taggingComponent.refreshContentPanel();
            }
        }
    }

    static /* synthetic */ TaggingComponent access$0(TagButtonPanel tagButtonPanel) {
        return tagButtonPanel.taggingComponent;
    }

    static /* synthetic */ StringMessages access$1(TagButtonPanel tagButtonPanel) {
        return tagButtonPanel.stringMessages;
    }
}

