/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardComponentContext;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardModeWithPerRaceCompetitors;
import com.sap.sailing.gwt.ui.shared.MarkPassingTimesDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.settings.ComponentContextWithSettingsStorageAndAdditionalSettingsLayers;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WinningLanesMode
extends RaceBoardModeWithPerRaceCompetitors {
    private Duration tailLength;
    private boolean adjustedLeaderboardSettings;
    private boolean adjustedCompetitorSelection;

    protected void updateCompetitorSelection() {
        int howManyCompetitorsToSelect = this.getHowManyCompetitorsToSelect(this.getLeaderboardPanel().getCompetitors((RaceIdentifier)this.getRaceIdentifier()));
        this.updateCompetitorSelection(howManyCompetitorsToSelect, this.getLeaderboardForSpecificTimePoint());
    }

    private void adjustLeaderboardSettings() {
        SingleRaceLeaderboardPanel leaderboardPanel = this.getLeaderboardPanel();
        ArrayList<DetailType> raceDetailsToShow = new ArrayList<DetailType>();
        raceDetailsToShow.add(DetailType.RACE_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS);
        raceDetailsToShow.add(DetailType.RACE_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS);
        raceDetailsToShow.add(DetailType.RACE_DISTANCE_TRAVELED);
        raceDetailsToShow.add(DetailType.RACE_TIME_TRAVELED);
        SecurityChildSettingsContext context = new SecurityChildSettingsContext((SecuredDTO)this.getLeaderboard(), leaderboardPanel.getPaywallResolver());
        SingleRaceLeaderboardSettings additiveSettings = SingleRaceLeaderboardSettings.createDefaultSettingsWithRaceDetailValues(raceDetailsToShow, (SecurityChildSettingsContext)context);
        ((RaceBoardComponentContext)leaderboardPanel.getComponentContext()).addModesPatching((Component)leaderboardPanel, (GenericSerializableSettings)additiveSettings, (ComponentContextWithSettingsStorageAndAdditionalSettingsLayers.OnSettingsReloadedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void adjustMapSettings() {
        RaceMap raceMap = this.getRaceBoardPanel().getMap();
        RaceMapSettings defaultSettings = raceMap.getLifecycle().createDefaultSettings();
        RaceMapSettings additiveSettings = new RaceMapSettings.RaceMapSettingsBuilder(defaultSettings, raceMap.getLifecycle().getRaceDTO(), raceMap.getLifecycle().getPaywallResolver()).withTailLengthInMilliseconds(Long.valueOf(this.tailLength.asMillis())).withWindUp(Boolean.valueOf(true)).withShowOnlySelectedCompetitors(Boolean.valueOf(true)).build();
        ((RaceBoardComponentContext)raceMap.getComponentContext()).addModesPatching((Component)raceMap, (GenericSerializableSettings)additiveSettings, (ComponentContextWithSettingsStorageAndAdditionalSettingsLayers.OnSettingsReloadedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private int getHowManyCompetitorsToSelect(Iterable<CompetitorDTO> competitors) {
        int numberOfCompetitors = Util.size(competitors);
        return numberOfCompetitors == 0 ? 0 : (numberOfCompetitors <= 4 ? 1 : (numberOfCompetitors <= 9 ? 2 : 3));
    }

    protected void trigger() {
        Date startOfRace;
        if (this.getRaceTimesInfoForRace() != null && (startOfRace = this.getRaceTimesInfoForRace().startOfRace) != null) {
            if (this.getTimer().getPlayMode() == Timer.PlayModes.Live) {
                this.tailLength = new MillisecondsTimePoint(startOfRace).until(this.getTimer().getLiveTimePoint());
            } else {
                Date end;
                List markPassingTimes = this.getRaceTimesInfoForRace().getMarkPassingTimes();
                Date firstPassingOfLastWaypointPassed = markPassingTimes == null || markPassingTimes.isEmpty() ? null : ((MarkPassingTimesDTO)markPassingTimes.get((int)(markPassingTimes.size() - 1))).firstPassingDate;
                Date endOfRace = this.getRaceTimesInfoForRace().endOfRace;
                Date date = firstPassingOfLastWaypointPassed != null ? firstPassingOfLastWaypointPassed : (end = endOfRace != null ? endOfRace : this.getRaceTimesInfoForRace().endOfTracking);
                if (end != null) {
                    this.tailLength = new MillisecondsTimePoint(startOfRace).until((TimePoint)new MillisecondsTimePoint(end));
                    this.getTimer().setTime(end.getTime());
                }
            }
            this.stopReceivingRaceTimesInfos();
        }
        if (!this.adjustedLeaderboardSettings && this.getLeaderboard() != null) {
            this.adjustedLeaderboardSettings = true;
            this.stopReceivingLeaderboard();
            this.adjustLeaderboardSettings();
        }
        if (this.getLeaderboardForSpecificTimePoint() == null && this.tailLength != null && this.getLeaderboard() != null && this.getRaceColumn() != null) {
            this.loadLeaderboardForSpecificTimePoint(this.getLeaderboard().getName(), this.getRaceColumn().getName(), this.getTimer().getTime());
        }
        if (!this.adjustedCompetitorSelection && this.getLeaderboardForSpecificTimePoint() != null && this.getCompetitorsInRace() != null) {
            this.stopReceivingCompetitorsInRace();
            this.adjustedCompetitorSelection = true;
            this.updateCompetitorSelection();
        }
        if (this.adjustedLeaderboardSettings && this.tailLength != null && this.adjustedCompetitorSelection) {
            this.adjustMapSettings();
        }
    }
}

