/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.ui.client.RaceTimePanelLifecycle;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerLifecycle;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChartLifecycle;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartLifecycle;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapLifecycle;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTableLifecycle;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPerspectiveSettingsDialogComponent;
import com.sap.sailing.gwt.ui.raceboard.SingleRaceLeaderboardPanelLifecycle;
import com.sap.sse.gwt.client.shared.components.ComponentLifecycle;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.AbstractPerspectiveLifecycle;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.premium.PaywallResolver;

public class RaceBoardPerspectiveLifecycle
extends AbstractPerspectiveLifecycle<RaceBoardPerspectiveOwnSettings> {
    private final StringMessages stringMessages;
    private final RaceMapLifecycle raceMapLifecycle;
    private final WindChartLifecycle windChartLifecycle;
    private final SingleRaceLeaderboardPanelLifecycle leaderboardPanelLifecycle;
    private final MultiCompetitorRaceChartLifecycle multiCompetitorRaceChartLifecycle;
    private final MediaPlayerLifecycle mediaPlayerLifecycle;
    private final RaceTimePanelLifecycle raceTimePanelLifecycle;
    private final ManeuverTableLifecycle maneuverTableLifecycle;
    public static final String ID = "rb";

    public RaceBoardPerspectiveLifecycle(AbstractLeaderboardDTO leaderboard, StringMessages stringMessages, Iterable<DetailType> competitorChartAllowedDetailTypes, UserService userService, PaywallResolver paywallResolver, Iterable<DetailType> availableDetailTypes, SecuredDTO raceDTO) {
        this.stringMessages = stringMessages;
        this.raceMapLifecycle = new RaceMapLifecycle(stringMessages, paywallResolver, raceDTO);
        this.windChartLifecycle = new WindChartLifecycle(stringMessages);
        this.maneuverTableLifecycle = new ManeuverTableLifecycle(stringMessages);
        this.leaderboardPanelLifecycle = new SingleRaceLeaderboardPanelLifecycle(stringMessages, availableDetailTypes, leaderboard.canBoatsOfCompetitorsChangePerRace, paywallResolver, leaderboard);
        this.multiCompetitorRaceChartLifecycle = new MultiCompetitorRaceChartLifecycle(stringMessages, competitorChartAllowedDetailTypes);
        this.mediaPlayerLifecycle = new MediaPlayerLifecycle(stringMessages);
        this.raceTimePanelLifecycle = new RaceTimePanelLifecycle(stringMessages, userService, raceDTO);
        this.addLifeCycle((ComponentLifecycle)this.raceMapLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.windChartLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.leaderboardPanelLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.multiCompetitorRaceChartLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.mediaPlayerLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.raceTimePanelLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.maneuverTableLifecycle);
    }

    public RaceBoardPerspectiveOwnSettings createPerspectiveOwnDefaultSettings() {
        return new RaceBoardPerspectiveOwnSettings();
    }

    public SettingsDialogComponent<RaceBoardPerspectiveOwnSettings> getPerspectiveOwnSettingsDialogComponent(RaceBoardPerspectiveOwnSettings perspectiveSettings) {
        return new RaceBoardPerspectiveSettingsDialogComponent(perspectiveSettings, this.stringMessages);
    }

    public String getLocalizedShortName() {
        return this.stringMessages.raceViewer();
    }

    public boolean hasSettings() {
        return true;
    }

    public ManeuverTableLifecycle getManeuverTable() {
        return this.maneuverTableLifecycle;
    }

    public RaceMapLifecycle getRaceMapLifecycle() {
        return this.raceMapLifecycle;
    }

    public WindChartLifecycle getWindChartLifecycle() {
        return this.windChartLifecycle;
    }

    public SingleRaceLeaderboardPanelLifecycle getLeaderboardPanelLifecycle() {
        return this.leaderboardPanelLifecycle;
    }

    public MultiCompetitorRaceChartLifecycle getMultiCompetitorRaceChartLifecycle() {
        return this.multiCompetitorRaceChartLifecycle;
    }

    public MediaPlayerLifecycle getMediaPlayerLifecycle() {
        return this.mediaPlayerLifecycle;
    }

    public RaceTimePanelLifecycle getRaceTimePanelLifecycle() {
        return this.raceTimePanelLifecycle;
    }

    public String getComponentId() {
        return ID;
    }

    protected RaceBoardPerspectiveOwnSettings extractOwnUserSettings(RaceBoardPerspectiveOwnSettings settings) {
        return settings;
    }

    protected RaceBoardPerspectiveOwnSettings extractOwnDocumentSettings(RaceBoardPerspectiveOwnSettings settings) {
        return settings;
    }
}

