/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceCompetitorSet;
import com.sap.sailing.gwt.ui.raceboard.AbstractRaceBoardMode;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPanel;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.List;

public abstract class RaceBoardModeWithPerRaceCompetitors
extends AbstractRaceBoardMode
implements RaceCompetitorSet.CompetitorsForRaceDefinedListener {
    private Iterable<CompetitorDTO> competitorsInRace;

    protected abstract void updateCompetitorSelection();

    public void applyTo(RaceBoardPanel raceBoardPanel) {
        super.applyTo(raceBoardPanel);
        raceBoardPanel.getMap().addCompetitorsForRaceDefinedListener((RaceCompetitorSet.CompetitorsForRaceDefinedListener)this);
    }

    protected void stopReceivingCompetitorsInRace() {
        this.getRaceBoardPanel().getMap().removeCompetitorsForRaceDefinedListener((RaceCompetitorSet.CompetitorsForRaceDefinedListener)this);
    }

    protected void updateCompetitorSelection(int howManyTopCompetitorsInRaceToSelect, LeaderboardDTO leaderboard) {
        if (leaderboard != null) {
            List competitorsFromBestToWorstInColumn = leaderboard.getCompetitorsFromBestToWorst(this.getRaceColumn());
            HashSet<CompetitorDTO> competitorsToSelect = new HashSet<CompetitorDTO>();
            int numberOfSelectedCompetitors = 0;
            int i = 0;
            while (numberOfSelectedCompetitors < howManyTopCompetitorsInRaceToSelect && i < competitorsFromBestToWorstInColumn.size()) {
                if (this.getCompetitorsInRace() == null || Util.contains((Iterable)this.getCompetitorsInRace(), competitorsFromBestToWorstInColumn.get(i))) {
                    competitorsToSelect.add((CompetitorDTO)competitorsFromBestToWorstInColumn.get(i));
                    ++numberOfSelectedCompetitors;
                }
                ++i;
            }
            this.getRaceBoardPanel().getCompetitorSelectionProvider().setSelection(competitorsToSelect, new CompetitorSelectionChangeListener[0]);
            super.onInitializationFinished();
        }
    }

    public void competitorsForRaceDefined(Iterable<CompetitorDTO> competitorsInRace) {
        this.competitorsInRace = competitorsInRace;
        this.checkIfTrigger();
    }

    protected Iterable<CompetitorDTO> getCompetitorsInRace() {
        return this.competitorsInRace;
    }
}

