/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.ui.actions.GetLeaderboardForRaceAction;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateListener;
import com.sap.sailing.gwt.ui.client.RaceTimePanel;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.raceboard.AbstractRaceBoardMode;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardMode;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPanel;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.player.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;

public abstract class AbstractRaceBoardMode
implements RaceBoardMode,
RaceTimesInfoProviderListener,
LeaderboardUpdateListener {
    private Timer timer;
    private RegattaAndRaceIdentifier raceIdentifier;
    private RaceTimePanel raceTimePanel;
    private SingleRaceLeaderboardPanel leaderboardPanel;
    private RaceBoardPanel raceBoardPanel;
    private Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfo;
    private RaceTimesInfoDTO raceTimesInfoForRace;
    private LeaderboardDTO leaderboard;
    private LeaderboardDTO leaderboardForSpecificTimePoint;
    private RaceColumnDTO raceColumn;
    private final Collection<Runnable> runnablesToRunAfterInitializationFinished = new LinkedList();

    public void applyTo(RaceBoardPanel raceBoardPanel) {
        this.raceBoardPanel = raceBoardPanel;
        this.raceTimePanel = raceBoardPanel.getRaceTimePanel();
        this.raceTimePanel.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)this);
        this.leaderboardPanel = raceBoardPanel.getLeaderboardPanel();
        this.leaderboardPanel.addLeaderboardUpdateListener((LeaderboardUpdateListener)this);
        this.leaderboardPanel.setAutoExpandPreSelected(true);
        this.timer = raceBoardPanel.getTimer();
        this.raceIdentifier = raceBoardPanel.getSelectedRaceIdentifier();
        raceBoardPanel.getMap().addMapInitializedListener((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void checkIfTrigger() {
        if (this.raceBoardPanel.getMap().isDataInitialized()) {
            this.trigger();
        }
    }

    public void addInitializationFinishedRunner(Runnable runnable) {
        this.runnablesToRunAfterInitializationFinished.add(runnable);
    }

    protected void onInitializationFinished() {
        this.runnablesToRunAfterInitializationFinished.forEach(r -> r.run());
    }

    protected abstract void trigger();

    protected Timer getTimer() {
        return this.timer;
    }

    protected RegattaAndRaceIdentifier getRaceIdentifier() {
        return this.raceIdentifier;
    }

    protected RaceTimePanel getRaceTimePanel() {
        return this.raceTimePanel;
    }

    protected SingleRaceLeaderboardPanel getLeaderboardPanel() {
        return this.leaderboardPanel;
    }

    protected RaceBoardPanel getRaceBoardPanel() {
        return this.raceBoardPanel;
    }

    public void raceTimesInfosReceived(Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfo, long clientTimeWhenRequestWasSent, Date serverTimeDuringRequest, long clientTimeWhenResponseWasReceived) {
        this.raceTimesInfo = raceTimesInfo;
        this.raceTimesInfoForRace = raceTimesInfo.get(this.getRaceIdentifier());
        this.checkIfTrigger();
    }

    protected void stopReceivingRaceTimesInfos() {
        this.raceTimePanel.removeRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)this);
    }

    public void updatedLeaderboard(LeaderboardDTO leaderboard) {
        this.leaderboard = leaderboard;
        this.checkIfTrigger();
    }

    protected void stopReceivingLeaderboard() {
        this.leaderboardPanel.removeLeaderboardUpdateListener((LeaderboardUpdateListener)this);
    }

    protected void loadLeaderboardForSpecificTimePoint(String leaderboardName, String raceColumnName, Date timePoint) {
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        ArrayList<String> raceColumnNameAsList = new ArrayList<String>();
        if (this.getRaceColumn() != null) {
            raceColumnNameAsList.add(this.getRaceColumn().getName());
        }
        GetLeaderboardForRaceAction getLeaderboardByNameAction = new GetLeaderboardForRaceAction(this.getLeaderboardPanel().getSailingService(), this.getLeaderboardPanel().getLeaderboard().getName(), this.raceIdentifier, this.getTimer().getTime(), raceColumnNameAsList, false, this.getLeaderboard(), false, this.getTimer(), null, StringMessages.INSTANCE);
        this.getLeaderboardPanel().getExecutor().execute((AsyncAction)getLeaderboardByNameAction, "loadLeaderboardData", (AsyncCallback)callback);
    }

    public void currentRaceSelected(RaceIdentifier raceIdentifier, RaceColumnDTO raceColumn) {
        this.raceColumn = raceColumn;
        this.checkIfTrigger();
    }

    protected Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> getRaceTimesInfo() {
        return this.raceTimesInfo;
    }

    protected RaceTimesInfoDTO getRaceTimesInfoForRace() {
        return this.raceTimesInfoForRace;
    }

    protected LeaderboardDTO getLeaderboard() {
        return this.leaderboard;
    }

    protected LeaderboardDTO getLeaderboardForSpecificTimePoint() {
        return this.leaderboardForSpecificTimePoint;
    }

    protected RaceColumnDTO getRaceColumn() {
        return this.raceColumn;
    }

    protected void setTimerOrUseCustomStart(TimePoint startPlayingAt) {
        Duration initialDurationAfterRaceStartInReplay;
        RaceBoardPerspectiveOwnSettings perspectiveOwnSettings;
        Timer.PlayModes playMode = this.getTimer().getPlayMode();
        MillisecondsTimePoint startPlayingAtOverride = null;
        if (playMode != Timer.PlayModes.Live && this.getRaceTimesInfoForRace() != null && (perspectiveOwnSettings = this.raceBoardPanel.getOriginalPerspectiveSettings()) != null && (initialDurationAfterRaceStartInReplay = perspectiveOwnSettings.getInitialDurationAfterRaceStartInReplay()) != null) {
            Date relativeTo = this.getRaceTimesInfoForRace().getStartOfRace() != null ? this.getRaceTimesInfoForRace().getStartOfRace() : this.getRaceTimesInfoForRace().getStartOfTracking();
            startPlayingAtOverride = new MillisecondsTimePoint(relativeTo.getTime() + initialDurationAfterRaceStartInReplay.asMillis());
        }
        this.getTimer().setTime(startPlayingAtOverride != null ? startPlayingAtOverride.asMillis() : startPlayingAt.asMillis());
    }

    static /* synthetic */ void access$0(AbstractRaceBoardMode abstractRaceBoardMode, LeaderboardDTO leaderboardDTO) {
        abstractRaceBoardMode.leaderboardForSpecificTimePoint = leaderboardDTO;
    }
}

