/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.polarmining;

import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class PolarDataMiningSettingsValidator
implements DataEntryDialog.Validator<PolarDataMiningSettings> {
    private final StringMessages stringMessages;

    public PolarDataMiningSettingsValidator(StringMessages stringMessages) {
        this.stringMessages = stringMessages;
    }

    public String getErrorMessage(PolarDataMiningSettings valueToValidate) {
        String errorMessage = null;
        if (this.oneOrMoreParametersAreNull(valueToValidate)) {
            errorMessage = this.stringMessages.oneOrMoreParametersAreEmpty();
        } else {
            errorMessage = this.validateConfidenceValues(valueToValidate, errorMessage);
            errorMessage = this.validateMinDataValues(valueToValidate, errorMessage);
            errorMessage = this.validateNumberOfColumns(valueToValidate.getNumberOfHistogramColumns(), errorMessage);
        }
        return errorMessage;
    }

    private boolean oneOrMoreParametersAreNull(PolarDataMiningSettings valueToValidate) {
        boolean oneOrMoreParametersAreNull = false;
        if (valueToValidate.getMinimumDataCountPerAngle() == null || valueToValidate.getMinimumDataCountPerGraph() == null) {
            oneOrMoreParametersAreNull = true;
        }
        return oneOrMoreParametersAreNull;
    }

    private String validateNumberOfColumns(int numberOfHistogramColumns, String errorMessage) {
        if (numberOfHistogramColumns < 2) {
            String numberOfColumnsAtLeast2 = this.stringMessages.numberOfColumnsAtLeast2();
            errorMessage = errorMessage == null ? numberOfColumnsAtLeast2 : String.valueOf(errorMessage) + "\n" + numberOfColumnsAtLeast2;
        }
        return errorMessage;
    }

    private String validateMinDataValues(PolarDataMiningSettings valueToValidate, String errorMessage) {
        Integer minDataPerAngle = valueToValidate.getMinimumDataCountPerAngle();
        Integer minDataPerGraph = valueToValidate.getMinimumDataCountPerGraph();
        if (minDataPerAngle < 0 || minDataPerGraph < 0) {
            String minDataValuesNeedToBeAtLeastZero = this.stringMessages.minDataValuesNeedToBeAtLeastZero();
            errorMessage = errorMessage == null ? minDataValuesNeedToBeAtLeastZero : String.valueOf(errorMessage) + "\n" + minDataValuesNeedToBeAtLeastZero;
        }
        return errorMessage;
    }

    private String validateConfidenceValues(PolarDataMiningSettings valueToValidate, String errorMessage) {
        double minimumWindConfidence = valueToValidate.getMinimumWindConfidence();
        if (minimumWindConfidence < 0.0 || minimumWindConfidence > 1.0) {
            errorMessage = this.stringMessages.confidenceShouldBeBetween();
        }
        return errorMessage;
    }
}

