/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.polarmining;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.polarmining.PolarDataMiningSettingsValidator;
import com.sap.sailing.gwt.ui.polarmining.WindSpeedSteppingConfiguratorPanel;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettingsImpl;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;

public class PolarDataMiningSettingsDialogComponent
implements SettingsDialogComponent<PolarDataMiningSettings> {
    private PolarDataMiningSettings settings;
    private StringMessages stringMessages;
    private IntegerBox minimumGraphDataSizeBox;
    private DoubleBox minimumWindConfidenceBox;
    private IntegerBox minimumDataCountPerAngleBox;
    private IntegerBox numberOfHistogramColumnsBox;
    private CheckBox useOnlyWindGaugesForWindSpeedBox;
    private CheckBox useOnlyEstimationForWindDirectionBox;
    private WindSpeedSteppingConfiguratorPanel windSteppingBox;
    private DoubleBox windSteppingMaxDistanceBox;
    private CheckBox applyMinimumWindConfidenceBox;

    public PolarDataMiningSettingsDialogComponent(PolarDataMiningSettings settings) {
        this.settings = settings;
        this.stringMessages = StringMessages.INSTANCE;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel vp = new VerticalPanel();
        Grid grid = new Grid(10, 2);
        grid.setCellPadding(5);
        vp.add((Widget)grid);
        this.setupGrid(grid, dialog);
        return vp;
    }

    private void setupGrid(Grid grid, DataEntryDialog<?> dialog) {
        Label minimumGraphDataSizeLabel = new Label(String.valueOf(this.stringMessages.polarSheetMinimumDataSizePerGraph()) + ":");
        minimumGraphDataSizeLabel.setTitle(this.stringMessages.polarSheetMinimumDataSizePerGraphTooltip());
        grid.setWidget(0, 0, (Widget)minimumGraphDataSizeLabel);
        this.minimumGraphDataSizeBox = dialog.createIntegerBox(this.settings.getMinimumDataCountPerGraph(), 6);
        grid.setWidget(0, 1, (Widget)this.minimumGraphDataSizeBox);
        Label minimumDataSizePerAngleLabel = new Label(String.valueOf(this.stringMessages.polarSheetMinimumDataSizePerAngle()) + ":");
        minimumDataSizePerAngleLabel.setTitle(this.stringMessages.polarSheetMinimumDataSizePerAngleTooltip());
        grid.setWidget(1, 0, (Widget)minimumDataSizePerAngleLabel);
        this.minimumDataCountPerAngleBox = dialog.createIntegerBox(this.settings.getMinimumDataCountPerAngle(), 6);
        grid.setWidget(1, 1, (Widget)this.minimumDataCountPerAngleBox);
        Label minimumWindConfidenceLabel = new Label(String.valueOf(this.stringMessages.polarSheetMinimumWindConfidence()) + ":");
        minimumWindConfidenceLabel.setTitle(this.stringMessages.polarSheetMinimumWindConfidenceTooltip());
        grid.setWidget(2, 0, (Widget)minimumWindConfidenceLabel);
        this.minimumWindConfidenceBox = dialog.createDoubleBox(Double.valueOf(this.settings.getMinimumWindConfidence()), 6);
        grid.setWidget(2, 1, (Widget)this.minimumWindConfidenceBox);
        Label applyMinimumWindConfidenceLabel = new Label(String.valueOf(this.stringMessages.applyMinimumWindConfidence()) + ":");
        applyMinimumWindConfidenceLabel.setTitle(this.stringMessages.applyMinimumWindConfidenceTooltip());
        grid.setWidget(3, 0, (Widget)applyMinimumWindConfidenceLabel);
        this.applyMinimumWindConfidenceBox = dialog.createCheckbox("");
        this.applyMinimumWindConfidenceBox.setValue(Boolean.valueOf(this.settings.applyMinimumWindConfidence()));
        grid.setWidget(3, 1, (Widget)this.applyMinimumWindConfidenceBox);
        Label useOnlyWindGaugesForWindSpeedLabel = new Label(String.valueOf(this.stringMessages.polarSheetUseOnlyWindGaugeData()) + ":");
        useOnlyWindGaugesForWindSpeedLabel.setTitle(this.stringMessages.polarSheetUseOnlyWindGaugeDataTooltip());
        grid.setWidget(4, 0, (Widget)useOnlyWindGaugesForWindSpeedLabel);
        this.useOnlyWindGaugesForWindSpeedBox = dialog.createCheckbox("");
        this.useOnlyWindGaugesForWindSpeedBox.setValue(Boolean.valueOf(this.settings.useOnlyWindGaugesForWindSpeed()));
        grid.setWidget(4, 1, (Widget)this.useOnlyWindGaugesForWindSpeedBox);
        Label useOnlyEstimationForWindDirectionLabel = new Label(String.valueOf(this.stringMessages.polarSheetUseOnlyEstimationData()) + ":");
        useOnlyEstimationForWindDirectionLabel.setTitle(this.stringMessages.polarSheetUseOnlyEstimationDataTooltip());
        grid.setWidget(5, 0, (Widget)useOnlyEstimationForWindDirectionLabel);
        this.useOnlyEstimationForWindDirectionBox = dialog.createCheckbox("");
        this.useOnlyEstimationForWindDirectionBox.setValue(Boolean.valueOf(this.settings.useOnlyEstimatedForWindDirection()));
        grid.setWidget(5, 1, (Widget)this.useOnlyEstimationForWindDirectionBox);
        grid.setWidget(6, 0, (Widget)new Label(String.valueOf(this.stringMessages.polarSheetNumberOfHistogramColumns()) + ":"));
        this.numberOfHistogramColumnsBox = dialog.createIntegerBox(Integer.valueOf(this.settings.getNumberOfHistogramColumns()), 3);
        grid.setWidget(6, 1, (Widget)this.numberOfHistogramColumnsBox);
        grid.setWidget(7, 0, (Widget)new Label(String.valueOf(this.stringMessages.polarSheetWindSteppingInKnots()) + ":"));
        this.windSteppingBox = new WindSpeedSteppingConfiguratorPanel(this.settings.getWindSpeedStepping());
        grid.setWidget(7, 1, (Widget)this.windSteppingBox);
        Label windSteppingMaxDistanceLabel = new Label(String.valueOf(this.stringMessages.polarSheetWindSteppingMaxDistance()) + ":");
        windSteppingMaxDistanceLabel.setTitle(this.stringMessages.polarSheetWindSteppingMaxDistanceTooltip());
        grid.setWidget(8, 0, (Widget)windSteppingMaxDistanceLabel);
        this.windSteppingMaxDistanceBox = dialog.createDoubleBox(Double.valueOf(this.settings.getWindSpeedStepping().getMaxDistance()), 6);
        grid.setWidget(8, 1, (Widget)this.windSteppingMaxDistanceBox);
        grid.setWidget(9, 0, (Widget)new Label(this.stringMessages.pleaseSeeToolTips()));
    }

    public PolarDataMiningSettings getResult() {
        return new PolarDataMiningSettingsImpl((Integer)this.minimumGraphDataSizeBox.getValue(), ((Double)this.minimumWindConfidenceBox.getValue()).doubleValue(), this.applyMinimumWindConfidenceBox.getValue().booleanValue(), (Integer)this.minimumDataCountPerAngleBox.getValue(), (Integer)this.numberOfHistogramColumnsBox.getValue(), this.useOnlyWindGaugesForWindSpeedBox.getValue().booleanValue(), this.useOnlyEstimationForWindDirectionBox.getValue().booleanValue(), this.windSteppingBox.getStepping(((Double)this.windSteppingMaxDistanceBox.getValue()).doubleValue()));
    }

    public FocusWidget getFocusWidget() {
        return this.minimumGraphDataSizeBox;
    }

    public DataEntryDialog.Validator<PolarDataMiningSettings> getValidator() {
        return new PolarDataMiningSettingsValidator(this.stringMessages);
    }
}

