/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.pairinglist;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.PairingListDTO;
import com.sap.sailing.gwt.common.authentication.FixedSailingAuthentication;
import com.sap.sailing.gwt.common.authentication.SailingHeaderWithAuthentication;
import com.sap.sailing.gwt.common.communication.routing.ProvidesLeaderboardRouting;
import com.sap.sailing.gwt.ui.adminconsole.PairingListPreviewDialog;
import com.sap.sailing.gwt.ui.client.AbstractSailingReadEntryPoint;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.pairinglist.PairingListContextDefinition;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.settings.SettingsToUrlSerializer;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.List;

public class PairingListEntryPoint
extends AbstractSailingReadEntryPoint
implements ProvidesLeaderboardRouting {
    private PairingListContextDefinition pairingListContextDefinition;
    private StringMessages stringMessages = StringMessages.INSTANCE;
    private StrippedLeaderboardDTO strippedLeaderboardDTO;
    private String leaderboardName;

    protected void doOnModuleLoad() {
        super.doOnModuleLoad();
        this.pairingListContextDefinition = (PairingListContextDefinition)new SettingsToUrlSerializer().deserializeFromCurrentLocation((GenericSerializableSettings)new PairingListContextDefinition());
        this.leaderboardName = this.pairingListContextDefinition.getLeaderboardName();
        this.getSailingService().getLeaderboard(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createUI() {
        DockLayoutPanel mainPanel = new DockLayoutPanel(Style.Unit.PX);
        ScrollPanel scrollPanel = new ScrollPanel();
        RootLayoutPanel.get().add((Widget)mainPanel);
        mainPanel.setWidth("100%");
        mainPanel.setHeight("100%");
        SailingHeaderWithAuthentication header = new SailingHeaderWithAuthentication(this.pairingListContextDefinition.getLeaderboardName());
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        new FixedSailingAuthentication(this.getUserService(), (PaywallResolver)paywallResolver, header.getAuthenticationMenuView());
        mainPanel.addNorth((Widget)header, 75.0);
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        contentPanel.setWidth("100%");
        contentPanel.getElement().getStyle().setProperty("marginTop", "15px");
        contentPanel.getElement().getStyle().setProperty("marginBottom", "15px");
        scrollPanel.add((Widget)contentPanel);
        this.getSailingService().getPairingListFromRaceLogs(this.pairingListContextDefinition.getLeaderboardName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        mainPanel.add((Widget)scrollPanel);
    }

    private Widget createPairingListPanel(PairingListDTO pairingListDTO, List<String> raceDisplayNames) {
        Widget pairingListPanel = new PairingListPreviewDialog(pairingListDTO, raceDisplayNames, this.stringMessages, this.pairingListContextDefinition.getLeaderboardName()).getPairingListGrid();
        pairingListPanel.getElement().getStyle().setProperty("marginTop", "15px");
        return pairingListPanel;
    }

    private native void printPairingListGrid(String var1);

    public String getLeaderboardName() {
        return this.leaderboardName;
    }

    static /* synthetic */ void access$0(PairingListEntryPoint pairingListEntryPoint, StrippedLeaderboardDTO strippedLeaderboardDTO) {
        pairingListEntryPoint.strippedLeaderboardDTO = strippedLeaderboardDTO;
    }

    static /* synthetic */ void access$1(PairingListEntryPoint pairingListEntryPoint) {
        pairingListEntryPoint.createUI();
    }

    static /* synthetic */ StrippedLeaderboardDTO access$2(PairingListEntryPoint pairingListEntryPoint) {
        return pairingListEntryPoint.strippedLeaderboardDTO;
    }

    static /* synthetic */ SailingServiceAsync access$3(PairingListEntryPoint pairingListEntryPoint) {
        return pairingListEntryPoint.getSailingService();
    }

    static /* synthetic */ StringMessages access$4(PairingListEntryPoint pairingListEntryPoint) {
        return pairingListEntryPoint.stringMessages;
    }

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$5(PairingListEntryPoint pairingListEntryPoint) {
        return pairingListEntryPoint.getStringMessages();
    }

    static /* synthetic */ Widget access$6(PairingListEntryPoint pairingListEntryPoint, PairingListDTO pairingListDTO, List list) {
        return pairingListEntryPoint.createPairingListPanel(pairingListDTO, list);
    }

    static /* synthetic */ PairingListContextDefinition access$7(PairingListEntryPoint pairingListEntryPoint) {
        return pairingListEntryPoint.pairingListContextDefinition;
    }

    static /* synthetic */ void access$8(PairingListEntryPoint pairingListEntryPoint, String string) {
        pairingListEntryPoint.printPairingListGrid(string);
    }
}

