/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboardedit;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboardedit.EditScoreDialog;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import java.util.Arrays;

public class EditScoreDialog
extends DataEntryDialog<ScoreCorrectionUpdate> {
    private final ListBox maxPointsBox;
    private final DoubleBox totalPointsBox;
    private final DoubleBox incrementalScoreOffsetInPointsBox;
    private final StringMessages stringMessages;

    public EditScoreDialog(StringMessages stringMessages, String competitorName, String raceColumnName, MaxPointsReason oldMaxPointsReason, Double oldTotalPoints, Double oldIncrementalScoreOffsetInPoints, DataEntryDialog.DialogCallback<ScoreCorrectionUpdate> callback) {
        super(stringMessages.correctScore(), stringMessages.correctScoreFor(competitorName, raceColumnName), stringMessages.ok(), stringMessages.cancel(), null, true, callback);
        this.stringMessages = stringMessages;
        this.maxPointsBox = this.createListBox(false);
        this.maxPointsBox.addItem("");
        MaxPointsReason[] maxPointsReasonArray = MaxPointsReason.getLexicographicalValues();
        int n = maxPointsReasonArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaxPointsReason maxPointsReason = maxPointsReasonArray[n2];
            this.maxPointsBox.addItem(maxPointsReason.name());
            ++n2;
        }
        if (oldMaxPointsReason == null) {
            this.maxPointsBox.setSelectedIndex(0);
        } else {
            this.maxPointsBox.setSelectedIndex(1 + Arrays.asList(MaxPointsReason.getLexicographicalValues()).indexOf(oldMaxPointsReason));
        }
        this.totalPointsBox = this.createDoubleBox(5);
        if (oldTotalPoints != null) {
            this.totalPointsBox.setValue((Object)oldTotalPoints);
        }
        this.incrementalScoreOffsetInPointsBox = this.createDoubleBox(5);
        if (oldIncrementalScoreOffsetInPoints != null) {
            this.incrementalScoreOffsetInPointsBox.setValue((Object)oldIncrementalScoreOffsetInPoints);
        }
    }

    protected ScoreCorrectionUpdate getResult() {
        MaxPointsReason maxPointsReason = "".equals(this.maxPointsBox.getItemText(this.maxPointsBox.getSelectedIndex())) ? null : MaxPointsReason.valueOf((String)this.maxPointsBox.getItemText(this.maxPointsBox.getSelectedIndex()));
        Double totalScore = (Double)this.totalPointsBox.getValue();
        Double incrementalScoreCorrectionInPoints = (Double)this.incrementalScoreOffsetInPointsBox.getValue();
        return new ScoreCorrectionUpdate(totalScore, incrementalScoreCorrectionInPoints, maxPointsReason);
    }

    protected Widget getAdditionalWidget() {
        Grid grid = new Grid(3, 2);
        grid.setWidget(0, 0, (Widget)new Label(this.stringMessages.penaltyOrRedress()));
        grid.setWidget(0, 1, (Widget)this.maxPointsBox);
        grid.setWidget(1, 0, (Widget)new Label(this.stringMessages.totalScore()));
        grid.setWidget(1, 1, (Widget)this.totalPointsBox);
        grid.setWidget(2, 0, (Widget)new Label(this.stringMessages.incrementalScoreCorrectionInPoints()));
        grid.setWidget(2, 1, (Widget)this.incrementalScoreOffsetInPointsBox);
        return grid;
    }

    protected Focusable getInitialFocusWidget() {
        return this.totalPointsBox;
    }

    public void show() {
        super.show();
        this.totalPointsBox.selectAll();
    }
}

