/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettingsDialogComponent;
import com.sap.sailing.gwt.ui.actions.GetLeaderboardForRaceAction;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorRaceRankFilter;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFetcher;
import com.sap.sailing.gwt.ui.leaderboard.CompetitorFilterPanel;
import com.sap.sailing.gwt.ui.leaderboard.ExpandableSortableColumn;
import com.sap.sailing.gwt.ui.leaderboard.ExplicitRaceColumnSelectionWithPreselectedRace;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.BinaryOperator;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterOperator;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.client.WithSecurity;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SingleRaceLeaderboardPanel
extends LeaderboardPanel<SingleRaceLeaderboardSettings> {
    private boolean autoExpandPreSelectedRace;
    private final RegattaAndRaceIdentifier preSelectedRace;
    private RaceRankColumn raceRankColumn;
    private boolean notSortedYet = true;
    private boolean showRaceRankColumn;

    public SingleRaceLeaderboardPanel(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, SingleRaceLeaderboardSettings settings, boolean isEmbedded, RegattaAndRaceIdentifier preSelectedRace, RaceCompetitorSelectionProvider competitorSelectionProvider, Timer timer, String leaderboardGroupName, String leaderboardName, ErrorReporter errorReporter, StringMessages stringMessages, boolean showRaceDetails, CompetitorFilterPanel competitorSearchTextBox, boolean showSelectionCheckbox, RaceTimesInfoProvider optionalRaceTimesInfoProvider, boolean autoExpandLastRaceColumn, boolean adjustTimerDelay, boolean autoApplyTopNFilter, boolean showCompetitorFilterStatus, boolean enableSyncScroller, LeaderboardPanel.LeaderBoardStyle style, FlagImageResolver flagImageResolver, Iterable<DetailType> availableDetailTypes, WithSecurity withSecurity) {
        super(parent, context, sailingService, asyncActionsExecutor, (LeaderboardSettings)settings, isEmbedded, (CompetitorSelectionProvider)competitorSelectionProvider, timer, leaderboardName, errorReporter, stringMessages, showRaceDetails, competitorSearchTextBox, showSelectionCheckbox, optionalRaceTimesInfoProvider, autoExpandLastRaceColumn, adjustTimerDelay, autoApplyTopNFilter, showCompetitorFilterStatus, enableSyncScroller, style, flagImageResolver, availableDetailTypes, withSecurity);
        assert (preSelectedRace != null);
        this.preSelectedRace = preSelectedRace;
        this.showRaceRankColumn = settings.isShowRaceRankColumn();
        this.initialize((LeaderboardSettings)settings);
    }

    protected int ensureRaceRankColumn(int rankColumnIndex) {
        int indexOfNextColumn;
        boolean required = this.isShowRaceRankColumn() && this.preSelectedRace != null;
        int n = indexOfNextColumn = required ? 1 : 0;
        if (this.getLeaderboardTable().getColumnCount() > rankColumnIndex) {
            if (required) {
                if (this.getLeaderboardTable().getColumn(rankColumnIndex) != this.getRaceRankColumn()) {
                    this.insertColumn(rankColumnIndex, this.getRaceRankColumn());
                }
            } else if (this.getLeaderboardTable().getColumn(rankColumnIndex) == this.getRaceRankColumn()) {
                this.removeColumn(rankColumnIndex);
            }
        } else if (required) {
            this.insertColumn(rankColumnIndex, this.getRaceRankColumn());
        }
        return indexOfNextColumn;
    }

    private AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?> getRaceRankColumn() {
        if (this.raceRankColumn == null) {
            this.raceRankColumn = new RaceRankColumn(this, this.preSelectedRace);
        }
        return this.raceRankColumn;
    }

    private boolean isShowRaceRankColumn() {
        return this.showRaceRankColumn;
    }

    protected boolean canShowCompetitorBoatInfo() {
        return true;
    }

    protected void setDefaultRaceColumnSelection(SingleRaceLeaderboardSettings settings) {
        this.raceColumnSelection = new ExplicitRaceColumnSelectionWithPreselectedRace((RaceIdentifier)this.preSelectedRace);
    }

    protected void updateCompetitors(LeaderboardDTO leaderboard) {
        RaceCompetitorSelectionProvider raceCompetitorSelection = (RaceCompetitorSelectionProvider)this.competitorSelectionProvider;
        RaceColumnDTO singleRaceColumn = null;
        for (RaceColumnDTO raceColumn : leaderboard.getRaceList()) {
            if (!leaderboard.raceIsTracked(raceColumn.getRaceColumnName()) || !raceColumn.hasTrackedRace((RaceIdentifier)this.preSelectedRace)) continue;
            singleRaceColumn = raceColumn;
            break;
        }
        if (singleRaceColumn != null) {
            for (CompetitorDTO competitor : leaderboard.competitors) {
                BoatDTO boatOfCompetitor = leaderboard.getBoatOfCompetitor(singleRaceColumn.getRaceColumnName(), competitor);
                raceCompetitorSelection.setBoat(competitor, boatOfCompetitor);
                LeaderboardRowDTO leaderboardRowDTO = (LeaderboardRowDTO)leaderboard.rows.get(competitor);
                leaderboardRowDTO.boat = boatOfCompetitor;
            }
        }
        super.updateCompetitors(leaderboard);
    }

    public SingleRaceLeaderboardSettings getSettings() {
        SingleRaceLeaderboardSettings leaderboardSettings = new SingleRaceLeaderboardSettings((Collection)this.selectedManeuverDetails, (Collection)this.selectedLegDetails, (Collection)this.selectedRaceDetails, (Collection)this.selectedOverallDetailColumns, Long.valueOf(this.timer.getRefreshInterval()), this.isShowAddedScores(), this.isShowCompetitorShortName(), this.isShowCompetitorFullName(), this.isShowCompetitorBoatInfo(), this.isShowCompetitorNationality, this.showRaceRankColumn, new SecurityChildSettingsContext((SecuredDTO)this.leaderboard, this.paywallResolver));
        return leaderboardSettings;
    }

    public boolean isAutoExpandPreSelectedRace() {
        return this.autoExpandPreSelectedRace;
    }

    private RaceCompetitorSelectionProvider getRaceCompetitorSelection() {
        return (RaceCompetitorSelectionProvider)this.competitorSelectionProvider;
    }

    public String getCompetitorColor(CompetitorDTO competitor) {
        return this.isEmbedded() ? this.getRaceCompetitorSelection().getColor(competitor, this.preSelectedRace).getAsHtml() : null;
    }

    public int getLegCount(LeaderboardDTO leaderboardDTO, String raceColumnName) {
        return leaderboardDTO.getLegCount(raceColumnName, (RaceIdentifier)this.preSelectedRace);
    }

    protected SingleRaceLeaderboardSettings overrideDefaultsForNamesOfRaceColumns(SingleRaceLeaderboardSettings currentSettings, LeaderboardDTO result) {
        return currentSettings;
    }

    protected void applyTop30FilterIfCompetitorSizeGreaterEqual40(LeaderboardDTO leaderboard) {
        int maxRaceRank = 30;
        if (leaderboard.competitors.size() >= 40) {
            CompetitorRaceRankFilter raceRankFilter = new CompetitorRaceRankFilter();
            raceRankFilter.setLeaderboardFetcher((LeaderboardFetcher)this);
            raceRankFilter.setSelectedRace((RaceIdentifier)this.preSelectedRace);
            raceRankFilter.setQuickRankProvider(this.competitorFilterPanel.getQuickRankProvider());
            raceRankFilter.setOperator((FilterOperator)new BinaryOperator(BinaryOperator.Operators.LessThanEquals));
            raceRankFilter.setValue((Number)maxRaceRank);
            FilterSet activeFilterSet = this.competitorSelectionProvider.getOrCreateCompetitorsFilterSet(this.stringMessages.topNCompetitorsByRaceRank(maxRaceRank));
            activeFilterSet.addFilter((Filter)raceRankFilter);
            this.competitorSelectionProvider.setCompetitorsFilterSet(activeFilterSet);
        }
    }

    protected void processAutoExpands(AbstractSortableColumnWithMinMax<?, ?> c, LeaderboardPanel.RaceColumn<?> lastRaceColumn) {
        ExpandableSortableColumn expandableSortableColumn;
        if ((!this.autoExpandPerformedOnce && this.isAutoExpandPreSelectedRace() && c instanceof LeaderboardPanel.RaceColumn && ((LeaderboardPanel.RaceColumn)c).getRace().hasTrackedRace((RaceIdentifier)this.preSelectedRace) || this.isAutoExpandLastRaceColumn() && c == lastRaceColumn) && !(expandableSortableColumn = (ExpandableSortableColumn)c).isExpanded()) {
            expandableSortableColumn.changeExpansionState(true);
            this.autoExpandPerformedOnce = true;
        }
        if (c instanceof LeaderboardPanel.RaceColumn && ((LeaderboardPanel.RaceColumn)c).getRace().hasTrackedRace((RaceIdentifier)this.preSelectedRace)) {
            RaceColumnDTO raceColumn = ((LeaderboardPanel.RaceColumn)c).getRace();
            this.informLeaderboardUpdateListenersAboutRaceSelected((RaceIdentifier)this.preSelectedRace, raceColumn);
        }
    }

    protected void postApplySettings(LeaderboardSettings newSettings, List<ExpandableSortableColumn<?>> columnsToExpandAgain) {
        LeaderboardPanel.RaceColumn raceColumnByRaceName;
        super.postApplySettings(newSettings, columnsToExpandAgain);
        if (this.notSortedYet && (raceColumnByRaceName = this.getRaceColumnByRaceName(this.preSelectedRace.getRaceName())) != null) {
            this.getLeaderboardTable().sortColumn((Column)raceColumnByRaceName, true);
            this.notSortedYet = false;
        }
    }

    public Map<CompetitorDTO, LeaderboardRowDTO> getRowsToDisplay() {
        Iterable allFilteredCompetitors = this.competitorSelectionProvider.getFilteredCompetitors();
        HashMap<CompetitorDTO, LeaderboardRowDTO> result = new HashMap<CompetitorDTO, LeaderboardRowDTO>();
        for (CompetitorDTO competitorInPreSelectedRace : this.getCompetitors((RaceIdentifier)this.preSelectedRace)) {
            if (!Util.contains((Iterable)allFilteredCompetitors, (Object)competitorInPreSelectedRace)) continue;
            result.put(competitorInPreSelectedRace, (LeaderboardRowDTO)this.leaderboard.rows.get(competitorInPreSelectedRace));
        }
        return result;
    }

    public SettingsDialogComponent<SingleRaceLeaderboardSettings> getSettingsDialogComponent(SingleRaceLeaderboardSettings useTheseSettings) {
        return new SingleRaceLeaderboardSettingsDialogComponent(useTheseSettings, this.stringMessages, this.availableDetailTypes, this.paywallResolver, (AbstractLeaderboardDTO)this.leaderboard);
    }

    protected void openSettingsDialog() {
        SettingsDialog settingsDialog = new SettingsDialog((Component)this, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
        settingsDialog.ensureDebugId("LeaderboardSettingsDialog");
        settingsDialog.show();
    }

    protected void applyRaceSelection(LeaderboardSettings newSettings) {
    }

    public void setAutoExpandPreSelected(boolean b) {
        this.autoExpandPreSelectedRace = b;
    }

    public void updateSettings(SingleRaceLeaderboardSettings newSettings) {
        super.updateSettings((LeaderboardSettings)newSettings);
        this.showRaceRankColumn = newSettings.isShowRaceRankColumn();
    }

    protected void updateLeaderboardAndRun(Runnable callWhenExpansionDataIsLoaded) {
        LeaderboardDTO previousLeaderboard = this.getLeaderboard();
        this.getSailingService().getLeaderboardForRace(this.preSelectedRace, this.getLeaderboardName(), this.timer.getPlayMode() == Timer.PlayModes.Live ? null : this.getLeaderboardDisplayDate(), this.getNamesOfExpandedRaceColumns(), this.shallAddOverallDetails(), previousLeaderboard.getId(), false, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected AsyncAction<LeaderboardDTO> getRetrieverAction() {
        Date date = this.getLeaderboardDisplayDate();
        return new GetLeaderboardForRaceAction(this.getSailingService(), this.getLeaderboardName(), this.preSelectedRace, this.useNullAsTimePoint() ? null : date, this.getNamesOfExpandedRaceColumns(), this.shallAddOverallDetails(), this.getLeaderboard(), this.isFillTotalPointsUncorrected(), this.timer, this.getErrorReporter(), this.stringMessages);
    }

    static /* synthetic */ RegattaAndRaceIdentifier access$5(SingleRaceLeaderboardPanel singleRaceLeaderboardPanel) {
        return singleRaceLeaderboardPanel.preSelectedRace;
    }
}

