/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sailing.gwt.ui.leaderboard.HasStringAndDoubleValue;
import com.sap.sailing.gwt.ui.leaderboard.MinMaxRenderer;
import java.util.Comparator;

public class MinMaxRenderer<T> {
    protected static final String BACKGROUND_BAR_STYLE_BAD = "minMaxBackgroundBarBad";
    protected static final String BACKGROUND_BAR_STYLE_OK = "minMaxBackgroundBar";
    protected static final String BACKGROUND_BAR_STYLE_GOOD = "minMaxBackgroundBarGood";
    private final HasStringAndDoubleValue<T> valueProvider;
    private final Comparator<T> comparator;
    private Double minimumValue;
    private Double maximumValue;
    public static final Templates TEMPLATES = (Templates)GWT.create(Templates.class);

    public MinMaxRenderer(HasStringAndDoubleValue<T> valueProvider, Comparator<T> comparator) {
        this.valueProvider = valueProvider;
        this.comparator = comparator;
    }

    public final void render(Cell.Context context, T row, String title, SafeHtmlBuilder sb) {
        String stringValue = this.valueProvider.getStringValueToRender(row);
        this.render(row, stringValue == null ? "" : stringValue, title == null ? "" : title, sb);
    }

    protected void render(T row, String nullSafeValue, String nullSafeTitle, SafeHtmlBuilder sb) {
        sb.append(TEMPLATES.render(nullSafeValue, BACKGROUND_BAR_STYLE_OK, nullSafeTitle, this.getPercentage(row)));
    }

    protected int getPercentage(T row) {
        int percentage = 0;
        Double value = this.valueProvider.getDoubleValue(row);
        if (value != null && value != null && this.getMinimumDouble() != null && this.getMaximumDouble() != null) {
            int minBarLength = Math.abs(this.getMinimumDouble()) < 0.01 ? 0 : 10;
            percentage = (int)((double)minBarLength + (100.0 - (double)minBarLength) * (value - this.getMinimumDouble()) / (this.getMaximumDouble() - this.getMinimumDouble()));
        }
        return percentage;
    }

    private Double getMinimumDouble() {
        return this.minimumValue;
    }

    private Double getMaximumDouble() {
        return this.maximumValue;
    }

    public void updateMinMax(Iterable<T> displayedLeaderboardRowsProvider) {
        Object minimumOrderRow = null;
        Object maximumOrderRow = null;
        for (T row : displayedLeaderboardRowsProvider) {
            if (this.valueProvider.getDoubleValue(row) != null && (minimumOrderRow == null || this.comparator.compare(minimumOrderRow, row) > 0)) {
                minimumOrderRow = row;
            }
            if (this.valueProvider.getDoubleValue(row) == null || maximumOrderRow != null && this.comparator.compare(maximumOrderRow, row) >= 0) continue;
            maximumOrderRow = row;
        }
        if (minimumOrderRow != null) {
            this.minimumValue = this.valueProvider.getDoubleValue(minimumOrderRow);
        }
        if (maximumOrderRow != null) {
            this.maximumValue = this.valueProvider.getDoubleValue(maximumOrderRow);
        }
    }

    protected HasStringAndDoubleValue<T> getValueProvider() {
        return this.valueProvider;
    }
}

