/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.RaceColumnSelectionStrategies;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateListener;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFetcher;
import com.sap.sailing.gwt.ui.leaderboard.BoatFetcher;
import com.sap.sailing.gwt.ui.leaderboard.CompetitorColumnBase;
import com.sap.sailing.gwt.ui.leaderboard.CompetitorFetcher;
import com.sap.sailing.gwt.ui.leaderboard.CompetitorFilterPanel;
import com.sap.sailing.gwt.ui.leaderboard.DetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.DisplayedLeaderboardRowsProvider;
import com.sap.sailing.gwt.ui.leaderboard.ExpandableSortableColumn;
import com.sap.sailing.gwt.ui.leaderboard.FormattedDoubleLeaderboardRowDTODetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.IntegerDetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.LastNRacesColumnSelection;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.ManeuverCountRaceColumn;
import com.sap.sailing.gwt.ui.leaderboard.MaxSpeedOverallColumn;
import com.sap.sailing.gwt.ui.leaderboard.OverallTimeTraveledColumn;
import com.sap.sailing.gwt.ui.leaderboard.RaceColumnSelection;
import com.sap.sailing.gwt.ui.leaderboard.TotalTimeColumn;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.SortingOrder;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import com.sap.sse.gwt.client.celltable.FlushableSortedCellTableWithStylableHeaders;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.celltable.SortedCellTable;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.BusyStateChangeListener;
import com.sap.sse.gwt.client.controls.busyindicator.BusyStateProvider;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.panels.OverlayAssistantScrollPanel;
import com.sap.sse.gwt.client.player.PlayStateListener;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.IsEmbeddableComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.WithSecurity;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public abstract class LeaderboardPanel<LS extends LeaderboardSettings>
extends AbstractCompositeComponent<LS>
implements TimeListener,
PlayStateListener,
DisplayedLeaderboardRowsProvider,
IsEmbeddableComponent,
CompetitorSelectionChangeListener,
LeaderboardFetcher,
BusyStateProvider,
LeaderboardUpdateProvider {
    public static final String LOAD_LEADERBOARD_DATA_CATEGORY = "loadLeaderboardData";
    protected static final NumberFormat scoreFormat = NumberFormat.getFormat((String)"0.##");
    private final SailingServiceAsync sailingService;
    private static String IS_LIVE_TEXT_COLOR = "#FF0000";
    private static String DEFAULT_TEXT_COLOR = "#000000";
    private static final String STYLE_LEADERBOARD_CONTENT = "leaderboardContent";
    private static final String STYLE_LEADERBOARD_INFO = "leaderboardInfo";
    private static final String STYLE_LEADERBOARD_TOOLBAR = "leaderboardContent-toolbar";
    private static final String STYLE_LEADERBOARD_LIVE_RACE = "leaderboardContent-liverace";
    private static RaceColumnTemplate raceColumnTemplate = new RaceColumnTemplate();
    protected LS currentSettings;
    private String leaderboardName;
    private final ErrorReporter errorReporter;
    public final StringMessages stringMessages;
    private final FlushableSortedCellTableWithStylableHeaders<LeaderboardRowDTO> leaderboardTable;
    private final MultiSelectionModel<LeaderboardRowDTO> leaderboardSelectionModel;
    protected LeaderboardDTO leaderboard;
    private final TotalRankColumn totalRankColumn;
    protected Iterable<DetailType> availableDetailTypes;
    private final SelectionCheckboxColumn<LeaderboardRowDTO> selectionCheckboxColumn;
    protected final List<DetailType> selectedManeuverDetails = new ArrayList();
    protected final List<DetailType> selectedLegDetails = new ArrayList();
    protected final List<DetailType> selectedRaceDetails = new ArrayList();
    protected final List<DetailType> selectedOverallDetailColumns = new ArrayList();
    private final Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> overallDetailColumnMap;
    protected RaceColumnSelection raceColumnSelection;
    protected final String RACE_COLUMN_HEADER_STYLE;
    protected final String LEG_DETAIL_COLUMN_HEADER_STYLE;
    protected final String LEG_DETAIL_COLUMN_STYLE;
    protected final String LEG_COLUMN_HEADER_STYLE;
    protected final String RACE_COLUMN_STYLE;
    protected final String LEG_COLUMN_STYLE;
    protected final String TOTAL_COLUMN_STYLE;
    protected final Timer timer;
    private final boolean adjustTimerDelay;
    private boolean autoExpandLastRaceColumn;
    private boolean showAddedScores;
    private boolean showCompetitorShortName;
    private boolean showCompetitorFullName;
    private boolean showCompetitorBoatInfo;
    protected boolean autoExpandPerformedOnce;
    Anchor playPause;
    protected final CompetitorSelectionProvider competitorSelectionProvider;
    private final HorizontalPanel filterControlPanel;
    private Label filterStatusLabel;
    private Button filterClearButton;
    private final SelectionChangeEvent.Handler selectionChangeHandler;
    private HandlerRegistration leaderboardAsTableSelectionModelRegistration;
    private final FlowPanel contentPanel = new FlowPanel();
    protected final PaywallResolver paywallResolver;
    private HorizontalPanel refreshAndSettingsPanel;
    private Label scoreCorrectionLastUpdateTimeLabel;
    private Label scoreCorrectionCommentLabel;
    private Label liveRaceLabel;
    private final boolean isEmbedded;
    private ImageResource pauseIcon;
    private ImageResource playIcon;
    private int busyTaskCounter;
    private final BusyIndicator busyIndicator;
    private final Set<BusyStateChangeListener> busyStateChangeListeners;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private String raceNameForDefaultSorting;
    private final boolean showRaceDetails;
    private RaceTimesInfoProvider raceTimesInfoProvider;
    private RaceTimesInfoProviderListener raceTimesInfoProviderListener;
    private int blurInOnSelectionChanged;
    private Element elementToBlur;
    private boolean showSelectionCheckbox;
    private final List<LeaderboardUpdateListener> leaderboardUpdateListener = new ArrayList();
    private boolean initialCompetitorFilterHasBeenApplied = false;
    private final boolean showCompetitorFilterStatus;
    protected CompetitorFilterPanel competitorFilterPanel;
    private final boolean enableSyncedScroller;
    public boolean isShowCompetitorNationality;
    protected LeaderBoardStyle style;
    private FlowPanel informationPanel;
    private FlagImageResolver flagImageResolver;
    private Widget toolbarPanel;

    public LeaderboardPanel(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, LS settings, CompetitorSelectionProvider competitorSelectionProvider, String leaderboardName, ErrorReporter errorReporter, StringMessages stringMessages, boolean showRaceDetails, LeaderBoardStyle style, FlagImageResolver flagImageResolver, Iterable<DetailType> availableDetailTypes, WithSecurity sailingCF) {
        this(parent, context, sailingService, asyncActionsExecutor, settings, false, competitorSelectionProvider, leaderboardName, errorReporter, stringMessages, showRaceDetails, style, flagImageResolver, availableDetailTypes, sailingCF);
    }

    public LeaderboardPanel(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, LS settings, boolean isEmbedded, CompetitorSelectionProvider competitorSelectionProvider, String leaderboardName, ErrorReporter errorReporter, StringMessages stringMessages, boolean showRaceDetails, LeaderBoardStyle style, FlagImageResolver flagImageResolver, Iterable<DetailType> availableDetailTypes, WithSecurity sailingCF) {
        this(parent, context, sailingService, asyncActionsExecutor, settings, isEmbedded, competitorSelectionProvider, new Timer(Timer.PlayModes.Live, Timer.PlayStates.Paused, 3000L), leaderboardName, errorReporter, stringMessages, showRaceDetails, null, true, null, false, true, false, false, false, style, flagImageResolver, availableDetailTypes, sailingCF);
    }

    public LeaderboardPanel(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, LS settings, boolean isEmbedded, CompetitorSelectionProvider competitorSelectionProvider, Timer timer, String leaderboardName, ErrorReporter errorReporter, StringMessages stringMessages, boolean showRaceDetails, CompetitorFilterPanel competitorSearchTextBox, boolean showSelectionCheckbox, RaceTimesInfoProvider optionalRaceTimesInfoProvider, boolean autoExpandLastRaceColumn, boolean adjustTimerDelay, boolean autoApplyTopNFilter, boolean showCompetitorFilterStatus, boolean enableSyncScroller, LeaderBoardStyle style, FlagImageResolver flagImageResolver, Iterable<DetailType> availableDetailTypes, WithSecurity sailingCF) {
        super(parent, context);
        this.style = style;
        this.showSelectionCheckbox = showSelectionCheckbox;
        this.showRaceDetails = showRaceDetails;
        this.sailingService = sailingService;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.isEmbedded = isEmbedded;
        this.competitorSelectionProvider = competitorSelectionProvider;
        this.competitorSelectionProvider.addCompetitorSelectionChangeListener((CompetitorSelectionChangeListener)this);
        this.setLeaderboardName(leaderboardName);
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.raceTimesInfoProvider = optionalRaceTimesInfoProvider;
        this.adjustTimerDelay = adjustTimerDelay;
        this.initialCompetitorFilterHasBeenApplied = !autoApplyTopNFilter;
        this.showCompetitorFilterStatus = showCompetitorFilterStatus;
        this.enableSyncedScroller = enableSyncScroller;
        this.autoExpandLastRaceColumn = autoExpandLastRaceColumn;
        this.flagImageResolver = flagImageResolver;
        this.timer = timer;
        this.RACE_COLUMN_HEADER_STYLE = style.getTableresources().cellTableStyle().cellTableRaceColumnHeader();
        this.LEG_COLUMN_HEADER_STYLE = style.getTableresources().cellTableStyle().cellTableLegColumnHeader();
        this.LEG_DETAIL_COLUMN_HEADER_STYLE = style.getTableresources().cellTableStyle().cellTableLegDetailColumnHeader();
        this.RACE_COLUMN_STYLE = style.getTableresources().cellTableStyle().cellTableRaceColumn();
        this.LEG_COLUMN_STYLE = style.getTableresources().cellTableStyle().cellTableLegColumn();
        this.LEG_DETAIL_COLUMN_STYLE = style.getTableresources().cellTableStyle().cellTableLegDetailColumn();
        this.TOTAL_COLUMN_STYLE = style.getTableresources().cellTableStyle().cellTableTotalColumn();
        this.paywallResolver = new PaywallResolverImpl(sailingCF.getUserService(), sailingCF.getSubscriptionServiceFactory());
        sailingCF.getUserService().addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.overallDetailColumnMap = this.createOverallDetailColumnMap();
        if (settings.getLegDetailsToShow() != null) {
            this.selectedLegDetails.addAll(settings.getLegDetailsToShow());
        }
        if (settings.getOverallDetailsToShow() != null) {
            this.selectedOverallDetailColumns.addAll(settings.getOverallDetailsToShow());
        }
        timer.addPlayStateListener((PlayStateListener)this);
        timer.addTimeListener((TimeListener)this);
        this.totalRankColumn = new TotalRankColumn(this);
        this.totalRankColumn.setCellStyleNames("totalRankColumn");
        this.leaderboardTable = new FlushableSortedCellTableWithStylableHeaders(10000, (CellTable.Resources)style.getTableresources());
        this.leaderboardTable.addCellPreviewHandler((CellPreviewEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardTable.ensureDebugId("LeaderboardCellTable");
        this.selectionCheckboxColumn = new LeaderboardSelectionCheckboxColumn(this, competitorSelectionProvider);
        this.leaderboardTable.setWidth("100%");
        this.leaderboardSelectionModel = new MultiSelectionModel();
        this.selectionChangeHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.leaderboardAsTableSelectionModelRegistration = this.leaderboardSelectionModel.addSelectionChangeHandler(this.selectionChangeHandler);
        this.leaderboardTable.setSelectionModel((SelectionModel)this.leaderboardSelectionModel, this.selectionCheckboxColumn.getSelectionManager());
        SimplePanel mainPanel = new SimplePanel();
        this.leaderboardTable.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        this.contentPanel.setStyleName(STYLE_LEADERBOARD_CONTENT);
        this.busyIndicator = new SimpleBusyIndicator(false, 0.8f);
        this.busyIndicator.ensureDebugId("BusyIndicator");
        this.busyStateChangeListeners = new HashSet();
        this.contentPanel.add((Widget)new Label());
        if (!isEmbedded) {
            this.toolbarPanel = this.createToolbarPanel();
            this.contentPanel.add(this.toolbarPanel);
        }
        if (competitorSearchTextBox != null) {
            competitorSearchTextBox.add((Widget)this.busyIndicator);
            this.contentPanel.add((Widget)competitorSearchTextBox);
            competitorSearchTextBox.getSettingsButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.competitorFilterPanel = competitorSearchTextBox;
        }
        this.filterControlPanel = new HorizontalPanel();
        this.filterControlPanel.setStyleName("LeaderboardPanel-FilterControl-Panel");
        if (this.enableSyncedScroller) {
            this.contentPanel.add((Widget)new OverlayAssistantScrollPanel((Widget)this.leaderboardTable));
        } else {
            style.hookLeaderBoardAttachment(this.contentPanel, this.leaderboardTable);
        }
        if (showCompetitorFilterStatus) {
            this.contentPanel.add(this.createFilterDeselectionControl());
        }
        this.initWidget((Widget)mainPanel);
        mainPanel.setWidget((Widget)this.contentPanel);
        this.setTitle(stringMessages.leaderboard());
        this.availableDetailTypes = availableDetailTypes;
    }

    protected abstract void openSettingsDialog();

    protected void initialize(LS settings) {
        this.setDefaultRaceColumnSelection(settings);
        if (this.timer.isInitialized()) {
            this.loadCompleteLeaderboard(false);
        }
        this.updateSettings(settings);
        this.style.afterConstructorHook(this);
        this.contentPanel.add((Widget)new Label());
    }

    public void scrollRowIntoView(int selected) {
        this.leaderboardTable.getRowElement(selected).scrollIntoView();
    }

    Widget createToolbarPanel() {
        this.informationPanel = new FlowPanel();
        this.informationPanel.setStyleName(STYLE_LEADERBOARD_INFO);
        this.scoreCorrectionLastUpdateTimeLabel = new Label("");
        this.scoreCorrectionCommentLabel = new Label("");
        this.informationPanel.add((Widget)this.scoreCorrectionCommentLabel);
        this.informationPanel.add((Widget)this.scoreCorrectionLastUpdateTimeLabel);
        this.liveRaceLabel = new Label(this.stringMessages.live());
        this.liveRaceLabel.setStyleName(STYLE_LEADERBOARD_LIVE_RACE);
        this.liveRaceLabel.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        this.liveRaceLabel.getElement().getStyle().setColor(IS_LIVE_TEXT_COLOR);
        this.liveRaceLabel.setVisible(false);
        this.informationPanel.add((Widget)this.liveRaceLabel);
        DockPanel toolbarPanel = new DockPanel();
        toolbarPanel.ensureDebugId("ToolbarPanel");
        toolbarPanel.setStyleName(STYLE_LEADERBOARD_TOOLBAR);
        if (!this.isEmbedded) {
            toolbarPanel.add((Widget)this.informationPanel, DockPanel.WEST);
            toolbarPanel.add((Widget)this.busyIndicator, DockPanel.WEST);
        }
        toolbarPanel.setWidth("100%");
        toolbarPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        5 playPauseHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.pauseIcon = this.style.getResources().autoRefreshEnabledIcon();
        this.playIcon = this.style.getResources().autoRefreshDisabledIcon();
        this.refreshAndSettingsPanel = new HorizontalPanel();
        this.refreshAndSettingsPanel.ensureDebugId("RefreshAndSettingsPanel");
        this.refreshAndSettingsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        FlowPanel refreshPanel = new FlowPanel();
        refreshPanel.addStyleName("refreshPanel");
        toolbarPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        toolbarPanel.addStyleName("refreshAndSettings");
        this.playPause = new Anchor(this.getPlayPauseImgHtml(this.timer.getPlayState()));
        this.playPause.ensureDebugId("PlayAndPauseAnchor");
        this.playPause.addClickHandler((ClickHandler)playPauseHandler);
        this.playStateChanged(this.timer.getPlayState(), this.timer.getPlayMode());
        refreshPanel.add((Widget)this.playPause);
        this.refreshAndSettingsPanel.add((Widget)refreshPanel);
        toolbarPanel.add((Widget)this.refreshAndSettingsPanel, DockPanel.EAST);
        return toolbarPanel;
    }

    public Widget getEntryWidget() {
        return this;
    }

    public Widget getHeaderWidget() {
        return null;
    }

    public Widget getContentWidget() {
        return this.contentPanel;
    }

    public Widget getToolbarWidget() {
        return this.informationPanel;
    }

    public Widget getLegendWidget() {
        return null;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public FlowPanel getContentPanel() {
        return this.contentPanel;
    }

    protected ImageResource getSettingsIcon() {
        return this.style.getComponentresources().settingsIcon();
    }

    public void setShowCompetitorNationality(boolean isShowCompetitorNationality) {
        this.isShowCompetitorNationality = isShowCompetitorNationality;
    }

    public void updateSettings(LS newSettings) {
        this.currentSettings = newSettings;
        boolean oldShallAddOverallDetails = this.shallAddOverallDetails();
        if (newSettings.getOverallDetailsToShow() != null) {
            this.setValuesWithReferenceOrder((Iterable)newSettings.getOverallDetailsToShow(), DetailType.getAvailableOverallDetailColumnTypes(), this.selectedOverallDetailColumns);
        }
        this.setShowCompetitorNationality(newSettings.isShowCompetitorNationality());
        this.setShowAddedScores(newSettings.isShowAddedScores());
        this.setShowCompetitorShortName(newSettings.isShowCompetitorShortNameColumn());
        this.setShowCompetitorFullName(newSettings.isShowCompetitorFullNameColumn());
        this.setShowCompetitorBoatInfo(newSettings.isShowCompetitorBoatInfoColumn());
        ArrayList<ExpandableSortableColumn> columnsToExpandAgain = new ArrayList<ExpandableSortableColumn>();
        int i = 0;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            ExpandableSortableColumn expandableSortableColumn;
            Column c = this.getLeaderboardTable().getColumn(i);
            if (c instanceof ExpandableSortableColumn && (expandableSortableColumn = (ExpandableSortableColumn)c).isExpanded()) {
                expandableSortableColumn.changeExpansionState(false);
                columnsToExpandAgain.add(expandableSortableColumn);
            }
            ++i;
        }
        this.applyDetailSettings(newSettings);
        this.addBusyTask();
        6 doWhenNecessaryDetailHasBeenLoaded = new /* Unavailable Anonymous Inner Class!! */;
        boolean newShallAddOverallDetails = this.shallAddOverallDetails();
        if (oldShallAddOverallDetails == newShallAddOverallDetails || oldShallAddOverallDetails || this.getLeaderboard().hasOverallDetails()) {
            doWhenNecessaryDetailHasBeenLoaded.run();
        } else {
            this.updateLeaderboardAndRun((Runnable)doWhenNecessaryDetailHasBeenLoaded);
        }
    }

    protected void postApplySettings(LeaderboardSettings newSettings, List<ExpandableSortableColumn<?>> columnsToExpandAgain) {
        if (newSettings.getDelayBetweenAutoAdvancesInMilliseconds() != null) {
            this.timer.setRefreshInterval(newSettings.getDelayBetweenAutoAdvancesInMilliseconds().longValue());
        }
        for (ExpandableSortableColumn<?> expandableSortableColumn : columnsToExpandAgain) {
            expandableSortableColumn.changeExpansionState(true);
        }
    }

    protected abstract void applyRaceSelection(LeaderboardSettings var1);

    private void applyDetailSettings(LeaderboardSettings newSettings) {
        if (newSettings.getOverallDetailsToShow() != null) {
            this.setValuesWithReferenceOrder(Util.retainCopy((Iterable)newSettings.getOverallDetailsToShow(), (Iterable)this.availableDetailTypes), DetailType.getAvailableOverallDetailColumnTypes(), this.selectedOverallDetailColumns);
        }
        this.setShowCompetitorNationality(newSettings.isShowCompetitorNationality());
        this.setShowAddedScores(newSettings.isShowAddedScores());
        this.setShowCompetitorShortName(newSettings.isShowCompetitorShortNameColumn());
        this.setShowCompetitorFullName(newSettings.isShowCompetitorFullNameColumn());
        this.setShowCompetitorBoatInfo(newSettings.isShowCompetitorBoatInfoColumn());
        if (newSettings.getManeuverDetailsToShow() != null) {
            this.setValuesWithReferenceOrder(Util.retainCopy((Iterable)newSettings.getManeuverDetailsToShow(), (Iterable)this.availableDetailTypes), (Collection)ManeuverCountRaceColumn.getAvailableManeuverDetailColumnTypes(), this.selectedManeuverDetails);
        }
        if (newSettings.getLegDetailsToShow() != null) {
            this.setValuesWithReferenceOrder(Util.retainCopy((Iterable)newSettings.getLegDetailsToShow(), (Iterable)this.availableDetailTypes), DetailType.getAllLegDetailColumnTypes(), this.selectedLegDetails);
        }
        if (newSettings.getRaceDetailsToShow() != null) {
            ArrayList allRaceDetailsTypes = new ArrayList();
            allRaceDetailsTypes.addAll(DetailType.getAllRaceDetailTypes());
            allRaceDetailsTypes.addAll(DetailType.getRaceStartAnalysisColumnTypes());
            this.setValuesWithReferenceOrder(Util.retainCopy((Iterable)newSettings.getRaceDetailsToShow(), (Iterable)this.availableDetailTypes), allRaceDetailsTypes, this.selectedRaceDetails);
        }
    }

    protected abstract void setDefaultRaceColumnSelection(LS var1);

    private void setValuesWithReferenceOrder(Iterable<DetailType> valuesToSet, Collection<DetailType> referenceOrder, List<DetailType> collectionToSetValuesTo) {
        collectionToSetValuesTo.clear();
        collectionToSetValuesTo.addAll(referenceOrder);
        collectionToSetValuesTo.retainAll(Util.asList(valuesToSet));
    }

    protected abstract void updateLeaderboardAndRun(Runnable var1);

    public void setRaceColumnSelectionToLastNStrategy(Integer numberOfLastRacesToShow) {
        this.raceColumnSelection = new LastNRacesColumnSelection(numberOfLastRacesToShow.intValue(), this.getRaceTimesInfoProvider());
        if (this.timer.getPlayState() != Timer.PlayStates.Playing) {
            this.raceTimesInfoProviderListener = new /* Unavailable Anonymous Inner Class!! */;
            this.getRaceTimesInfoProvider().addRaceTimesInfoProviderListener(this.raceTimesInfoProviderListener);
        }
    }

    private RaceTimesInfoProvider getRaceTimesInfoProvider() {
        if (this.raceTimesInfoProvider == null) {
            List trackedRacesIdentifiers = this.leaderboard != null && this.getTrackedRacesIdentifiers() != null ? this.getTrackedRacesIdentifiers() : Collections.emptyList();
            this.raceTimesInfoProvider = new RaceTimesInfoProvider(this.getSailingService(), this.asyncActionsExecutor, this.errorReporter, (Collection)trackedRacesIdentifiers, this.timer.getRefreshInterval());
        }
        return this.raceTimesInfoProvider;
    }

    public AsyncActionsExecutor getExecutor() {
        return this.asyncActionsExecutor;
    }

    protected void processStyleForRaceColumnWithReasonForMaxPoints(boolean isDiscarded, SafeStylesBuilder ssb) {
        ssb.opacity(0.5);
    }

    private Widget createFilterDeselectionControl() {
        this.filterStatusLabel = new Label();
        this.filterStatusLabel.setStyleName("LeaderboardPanel-FilterControl-StatusLabel");
        this.filterStatusLabel.setText("");
        this.filterControlPanel.add((Widget)this.filterStatusLabel);
        this.filterClearButton = new Button(this.stringMessages.showAll());
        this.filterClearButton.setStyleName("LeaderboardPanel-FilterClear-Button");
        this.filterClearButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.filterControlPanel.add((Widget)this.filterClearButton);
        this.filterControlPanel.setCellHorizontalAlignment((Widget)this.filterClearButton, HasHorizontalAlignment.ALIGN_RIGHT);
        this.setFilterControlStatus();
        return this.filterControlPanel;
    }

    public abstract int getLegCount(LeaderboardDTO var1, String var2);

    private void setFilterControlStatus() {
        if (this.showCompetitorFilterStatus) {
            boolean filtersActive = this.competitorSelectionProvider.hasActiveFilters();
            if (filtersActive) {
                String labelText = "";
                for (Filter filter : this.competitorSelectionProvider.getCompetitorsFilterSet().getFilters()) {
                    labelText = filter instanceof FilterWithUI ? String.valueOf(labelText) + ((FilterWithUI)filter).getLocalizedDescription(this.stringMessages) + ", " : String.valueOf(labelText) + filter.getName() + ", ";
                }
                this.filterStatusLabel.setText(this.stringMessages.activeFilters(labelText.substring(0, labelText.length() - 2)));
                this.filterClearButton.setVisible(true);
                this.filterControlPanel.setVisible(true);
            } else {
                this.filterStatusLabel.setText("");
                this.filterClearButton.setVisible(false);
                this.filterControlPanel.setVisible(false);
                if (this.competitorFilterPanel != null) {
                    this.competitorFilterPanel.clearSelection();
                }
            }
        }
    }

    private Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> createOverallDetailColumnMap() {
        HashMap result = new HashMap();
        result.put(DetailType.OVERALL_TOTAL_DISTANCE_TRAVELED, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.OVERALL_TOTAL_DISTANCE_TRAVELED, e -> e.totalDistanceTraveledInMeters, this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        result.put(DetailType.OVERALL_TOTAL_AVERAGE_SPEED_OVER_GROUND, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.OVERALL_TOTAL_AVERAGE_SPEED_OVER_GROUND, (DetailTypeColumn.DataExtractor)new TotalAverageSpeedOverGroundField(null), this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        result.put(DetailType.OVERALL_MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new MaxSpeedOverallColumn(this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        result.put(DetailType.OVERALL_TOTAL_TIME_SAILED_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)this.createOverallTimeTraveledColumn());
        result.put(DetailType.OVERALL_TOTAL_DURATION_FOILED_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.OVERALL_TOTAL_DURATION_FOILED_IN_SECONDS, e -> e.totalDurationFoiledInSeconds, this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        result.put(DetailType.OVERALL_TOTAL_DISTANCE_FOILED_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.OVERALL_TOTAL_DISTANCE_FOILED_IN_METERS, e -> e.totalDistanceFoiledInMeters, this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        result.put(DetailType.OVERALL_TIME_ON_TIME_FACTOR, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.OVERALL_TIME_ON_TIME_FACTOR, e -> e.effectiveTimeOnTimeFactor, this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        result.put(DetailType.OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE, (DetailTypeColumn.DataExtractor)new TimeOnDistanceAllowanceInSecondsPerNauticalMileColumn(null), this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        result.put(DetailType.OVERALL_TOTAL_SCORED_RACE_COUNT, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new IntegerDetailTypeColumn(DetailType.OVERALL_TOTAL_SCORED_RACE_COUNT, e -> e.totalScoredRaces, this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, (DisplayedLeaderboardRowsProvider)this));
        return result;
    }

    private OverallTimeTraveledColumn createOverallTimeTraveledColumn() {
        return new OverallTimeTraveledColumn(this, this.stringMessages, this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE, this.LEG_COLUMN_HEADER_STYLE, this.LEG_COLUMN_STYLE);
    }

    protected HorizontalPanel getRefreshAndSettingsPanel() {
        return this.refreshAndSettingsPanel;
    }

    protected RaceColumn<?> getRaceColumnByRaceName(String raceName) {
        int i = 0;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            Column column = this.getLeaderboardTable().getColumn(i);
            if (column instanceof RaceColumn) {
                RaceColumnDTO raceInLeaderboard = ((RaceColumn)column).getRace();
                for (FleetDTO fleet : raceInLeaderboard.getFleets()) {
                    RegattaAndRaceIdentifier raceIdentifier = raceInLeaderboard.getRaceIdentifier(fleet);
                    if (raceIdentifier == null || !raceIdentifier.getRaceName().equals(raceName)) continue;
                    return (RaceColumn)column;
                }
            }
            ++i;
        }
        return null;
    }

    private RaceColumn<?> getRaceColumnByRaceColumnName(String raceColumnName) {
        int i = 0;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            Column column = this.getLeaderboardTable().getColumn(i);
            if (column instanceof RaceColumn && ((RaceColumn)column).getRaceColumnName().equals(raceColumnName)) {
                return (RaceColumn)column;
            }
            ++i;
        }
        return null;
    }

    private SafeHtml getPlayPauseImgHtml(Timer.PlayStates playState) {
        if (playState == Timer.PlayStates.Playing) {
            return AbstractImagePrototype.create((ImageResource)this.pauseIcon).getSafeHtml();
        }
        return AbstractImagePrototype.create((ImageResource)this.playIcon).getSafeHtml();
    }

    private void setDelayInMilliseconds(long delayInMilliseconds) {
        if (this.useNullAsTimePoint()) {
            this.timer.removeTimeListener((TimeListener)this);
        }
        this.timer.setLivePlayDelayInMillis(delayInMilliseconds);
        if (this.useNullAsTimePoint()) {
            this.timer.addTimeListener((TimeListener)this);
        }
    }

    protected boolean isAutoExpandLastRaceColumn() {
        return this.autoExpandLastRaceColumn;
    }

    protected boolean isShowAddedScores() {
        return this.showAddedScores;
    }

    private void setShowAddedScores(boolean showAddedScores) {
        this.showAddedScores = showAddedScores;
    }

    protected boolean isShowCompetitorShortName() {
        return this.showCompetitorShortName;
    }

    private void setShowCompetitorShortName(boolean showCompetitorShortName) {
        this.showCompetitorShortName = showCompetitorShortName;
    }

    protected boolean isShowCompetitorFullName() {
        return this.showCompetitorFullName;
    }

    private void setShowCompetitorFullName(boolean showCompetitorFullName) {
        this.showCompetitorFullName = showCompetitorFullName;
    }

    protected boolean isShowCompetitorBoatInfo() {
        return this.showCompetitorBoatInfo;
    }

    protected abstract boolean canShowCompetitorBoatInfo();

    private void setShowCompetitorBoatInfo(boolean showCompetitorBoatInfo) {
        this.showCompetitorBoatInfo = showCompetitorBoatInfo;
    }

    protected Date getLeaderboardDisplayDate() {
        return this.timer.getTime();
    }

    protected void addColumn(AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?> column) {
        this.leaderboardTable.addColumn(column, column.getHeader(), column.getComparator(), column.getPreferredSortingOrder().isAscending());
        String columnStyle = column.getColumnStyle();
        if (columnStyle != null) {
            this.getLeaderboardTable().addColumnStyleName(this.getLeaderboardTable().getColumnCount() - 1, columnStyle);
        }
    }

    protected void insertColumn(int beforeIndex, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?> column) {
        this.removeColumnStyles(beforeIndex);
        this.getLeaderboardTable().insertColumn(beforeIndex, column, column.getHeader(), column.getComparator(), column.getPreferredSortingOrder().isAscending());
        this.addColumnStyles(beforeIndex);
    }

    private void addColumnStyles(int startColumn) {
        int i = startColumn;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            AbstractSortableColumnWithMinMax columnToRemoveStyleFor = (AbstractSortableColumnWithMinMax)this.getLeaderboardTable().getColumn(i);
            String columnStyle = columnToRemoveStyleFor.getColumnStyle();
            if (columnStyle != null) {
                this.getLeaderboardTable().addColumnStyleName(i, columnStyle);
            }
            ++i;
        }
    }

    private void removeColumnStyles(int startColumn) {
        int i = startColumn;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            AbstractSortableColumnWithMinMax columnToRemoveStyleFor = (AbstractSortableColumnWithMinMax)this.getLeaderboardTable().getColumn(i);
            String columnStyle = columnToRemoveStyleFor.getColumnStyle();
            if (columnStyle != null) {
                this.getLeaderboardTable().removeColumnStyleName(i, columnStyle);
            }
            ++i;
        }
    }

    protected void removeColumn(int columnIndex) {
        ExpandableSortableColumn expandableColumn;
        Column c = this.getLeaderboardTable().getColumn(columnIndex);
        if (c instanceof ExpandableSortableColumn && (expandableColumn = (ExpandableSortableColumn)c).isExpanded()) {
            expandableColumn.changeExpansionState(false);
            expandableColumn.setExpanded(true);
        }
        this.removeColumnStyles(columnIndex);
        this.getLeaderboardTable().removeColumn(columnIndex);
        this.addColumnStyles(columnIndex);
    }

    protected void removeColumn(Column<LeaderboardRowDTO, ?> c) {
        int columnIndex = this.getLeaderboardTable().getColumnIndex(c);
        if (columnIndex != -1) {
            this.removeColumn(columnIndex);
        }
    }

    protected abstract AsyncAction<LeaderboardDTO> getRetrieverAction();

    public void loadCompleteLeaderboard(boolean showProgress) {
        if (this.needsDataLoading()) {
            if (showProgress) {
                this.addBusyTask();
            }
            AsyncAction getLeaderboardByNameAction = this.getRetrieverAction();
            this.asyncActionsExecutor.execute(getLeaderboardByNameAction, LOAD_LEADERBOARD_DATA_CATEGORY, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected abstract LS overrideDefaultsForNamesOfRaceColumns(LS var1, LeaderboardDTO var2);

    protected boolean isFillTotalPointsUncorrected() {
        return false;
    }

    protected boolean useNullAsTimePoint() {
        return this.timer.getPlayMode() == Timer.PlayModes.Live;
    }

    private boolean needsDataLoading() {
        return this.isVisible();
    }

    protected Collection<String> getNamesOfExpandedRaceColumns() {
        ArrayList<String> namesOfExpandedRaceColumns = new ArrayList<String>();
        int i = 0;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            RaceColumn raceColumn;
            Column column = this.getLeaderboardTable().getColumn(i);
            if (column instanceof RaceColumn && (raceColumn = (RaceColumn)column).isExpanded()) {
                namesOfExpandedRaceColumns.add(raceColumn.getRaceColumnName());
            }
            ++i;
        }
        return namesOfExpandedRaceColumns;
    }

    protected boolean shallAddOverallDetails() {
        return !this.selectedOverallDetailColumns.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeaderboard(LeaderboardDTO leaderboard) {
        if (leaderboard != null) {
            Collection columnsToCollapseAndExpandAgain = this.getExpandedRaceColumnsWhoseDisplayedLegCountChanged(leaderboard);
            for (RaceColumn columnToCollapseAndExpandAgain : columnsToCollapseAndExpandAgain) {
                columnToCollapseAndExpandAgain.changeExpansionState(false);
            }
            this.updateCompetitors(leaderboard);
            if (!this.initialCompetitorFilterHasBeenApplied) {
                this.applyTop30FilterIfCompetitorSizeGreaterEqual40(leaderboard);
                this.initialCompetitorFilterHasBeenApplied = true;
            }
            this.raceColumnSelection.autoUpdateRaceColumnSelectionForUpdatedLeaderboard(this.getLeaderboard(), leaderboard);
            this.setLeaderboard(leaderboard);
            this.adjustColumnLayout(leaderboard);
            this.updateRaceColumnDTOsToRaceColumns(leaderboard);
            for (RaceColumn columnToCollapseAndExpandAgain : columnsToCollapseAndExpandAgain) {
                columnToCollapseAndExpandAgain.changeExpansionState(true);
            }
            this.adjustDelayToLive();
            Map rowsToDisplay = this.getRowsToDisplay();
            HashSet rowsToAdd = new HashSet(rowsToDisplay.values());
            HashMap<Integer, LeaderboardRowDTO> rowsToUpdate = new HashMap<Integer, LeaderboardRowDTO>();
            List list = this.getData().getList();
            synchronized (list) {
                int index = 0;
                Iterator i = this.getData().getList().iterator();
                while (i.hasNext()) {
                    LeaderboardRowDTO oldRow = (LeaderboardRowDTO)i.next();
                    LeaderboardRowDTO newRow = (LeaderboardRowDTO)rowsToDisplay.get(oldRow.competitor);
                    if (newRow != null) {
                        rowsToUpdate.put(index++, newRow);
                        rowsToAdd.remove(newRow);
                        continue;
                    }
                    i.remove();
                }
                for (Map.Entry updateEntry : rowsToUpdate.entrySet()) {
                    LeaderboardRowDTO oldElement = this.getData().getList().set((Integer)updateEntry.getKey(), (LeaderboardRowDTO)updateEntry.getValue());
                    this.leaderboardSelectionModel.setSelected((Object)oldElement, false);
                    this.updateSelection((LeaderboardRowDTO)updateEntry.getValue());
                }
                for (LeaderboardRowDTO rowToAdd : rowsToAdd) {
                    this.getData().getList().add(rowToAdd);
                    this.updateSelection(rowToAdd);
                }
            }
            RaceColumn lastRaceColumn = null;
            int i = this.getLeaderboardTable().getColumnCount() - 1;
            while (i >= 0) {
                if (this.getLeaderboardTable().getColumn(i) instanceof RaceColumn) {
                    lastRaceColumn = (RaceColumn)this.getLeaderboardTable().getColumn(i);
                    break;
                }
                --i;
            }
            i = 0;
            while (i < this.getLeaderboardTable().getColumnCount()) {
                AbstractSortableColumnWithMinMax c = (AbstractSortableColumnWithMinMax)this.getLeaderboardTable().getColumn(i);
                c.updateMinMax();
                this.processAutoExpands(c, lastRaceColumn);
                ++i;
            }
            if (this.leaderboardTable.getCurrentlySortedColumn() != null) {
                this.leaderboardTable.sort();
            } else {
                AbstractSortableColumnWithMinMax columnToSortFor = this.getDefaultSortColumn();
                this.leaderboardTable.sortColumn((Column)columnToSortFor, columnToSortFor.getPreferredSortingOrder().isAscending());
            }
            if (!this.isEmbedded) {
                this.updateToolbar(leaderboard);
            }
            this.informLeaderboardUpdateListenersAboutLeaderboardUpdated(leaderboard);
        }
    }

    protected void updateToolbar(LeaderboardDTO leaderboard) {
        this.scoreCorrectionCommentLabel.setText(leaderboard.getComment() != null ? leaderboard.getComment() : "");
        if (leaderboard.getTimePointOfLastCorrectionsValidity() != null) {
            Date lastCorrectionDate = leaderboard.getTimePointOfLastCorrectionsValidity();
            String lastUpdate = DateAndTimeFormatterUtil.formatLongDateAndTimeGMT((Date)lastCorrectionDate);
            this.scoreCorrectionLastUpdateTimeLabel.setText(String.valueOf(this.stringMessages.lastScoreUpdate()) + ": " + lastUpdate);
        } else {
            this.scoreCorrectionLastUpdateTimeLabel.setText("");
        }
        boolean hasLiveRace = !leaderboard.getLiveRaces(this.timer.getLiveTimePointInMillis()).isEmpty();
        this.liveRaceLabel.setText(hasLiveRace ? this.getLiveRacesText() : "");
        this.scoreCorrectionLastUpdateTimeLabel.setVisible(!hasLiveRace);
        this.liveRaceLabel.setVisible(hasLiveRace);
    }

    protected abstract void processAutoExpands(AbstractSortableColumnWithMinMax<?, ?> var1, RaceColumn<?> var2);

    protected abstract void applyTop30FilterIfCompetitorSizeGreaterEqual40(LeaderboardDTO var1);

    private void updateSelection(LeaderboardRowDTO row) {
        boolean shallBeSelected = this.competitorSelectionProvider.isSelected(row.competitor);
        if (this.leaderboardAsTableSelectionModelRegistration != null) {
            this.leaderboardAsTableSelectionModelRegistration.removeHandler();
            this.leaderboardAsTableSelectionModelRegistration = null;
        }
        if (this.leaderboardSelectionModel.isSelected((Object)row) != shallBeSelected) {
            this.leaderboardSelectionModel.setSelected((Object)row, shallBeSelected);
        }
        this.leaderboardAsTableSelectionModelRegistration = this.leaderboardTable.getSelectionModel().addSelectionChangeHandler(this.selectionChangeHandler);
    }

    private void updateRaceColumnDTOsToRaceColumns(LeaderboardDTO leaderboard) {
        for (RaceColumnDTO newRace : leaderboard.getRaceList()) {
            RaceColumn raceColumn = this.getRaceColumnByRaceColumnName(newRace.getName());
            if (raceColumn == null) continue;
            raceColumn.setRace(newRace);
        }
    }

    protected void updateCompetitors(LeaderboardDTO leaderboard) {
        this.competitorSelectionProvider.setCompetitors((Iterable)leaderboard.competitors, new CompetitorSelectionChangeListener[]{this});
    }

    public void setSelection(Iterable<CompetitorDTO> newSelection) {
        this.competitorSelectionProvider.setSelection(newSelection, new CompetitorSelectionChangeListener[0]);
    }

    private Collection<RaceColumn<?>> getExpandedRaceColumnsWhoseDisplayedLegCountChanged(LeaderboardDTO newLeaderboard) {
        HashSet result = new HashSet();
        if (this.selectedRaceDetails.contains(DetailType.RACE_DISPLAY_LEGS)) {
            int i = 0;
            while (i < this.getLeaderboardTable().getColumnCount()) {
                int newLegCount;
                int oldLegCount;
                RaceColumn rc;
                Column c = this.getLeaderboardTable().getColumn(i);
                if (c instanceof RaceColumn && !(rc = (RaceColumn)c).isTogglingInProcess() && rc.isExpanded() && (oldLegCount = this.getLegCount(this.getLeaderboard(), rc.getRaceColumnName())) != (newLegCount = this.getLegCount(newLeaderboard, rc.getRaceColumnName()))) {
                    result.add(rc);
                }
                ++i;
            }
        }
        return result;
    }

    private void adjustDelayToLive() {
        if (this.adjustTimerDelay && this.leaderboard.getDelayToLiveInMillisForLatestRace() != null) {
            this.setDelayInMilliseconds(this.leaderboard.getDelayToLiveInMillisForLatestRace().longValue());
        }
    }

    public abstract Map<CompetitorDTO, LeaderboardRowDTO> getRowsToDisplay();

    public Iterable<CompetitorDTO> getCompetitors(RaceIdentifier race) {
        HashSet<CompetitorDTO> result = new HashSet<CompetitorDTO>();
        if (this.getLeaderboard() != null) {
            for (RaceColumnDTO raceColumn : this.getLeaderboard().getRaceList()) {
                if (!raceColumn.hasTrackedRace(race)) continue;
                for (Map.Entry e : this.getLeaderboard().rows.entrySet()) {
                    LeaderboardEntryDTO entry = (LeaderboardEntryDTO)((LeaderboardRowDTO)e.getValue()).fieldsByRaceColumnName.get(raceColumn.getRaceColumnName());
                    if (entry == null || entry.race == null || !entry.race.equals(race)) continue;
                    result.add((CompetitorDTO)e.getKey());
                }
            }
        }
        return result;
    }

    private AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?> getDefaultSortColumn() {
        RaceColumn defaultSortColumn = null;
        if (this.raceNameForDefaultSorting != null) {
            defaultSortColumn = this.getRaceColumnByRaceName(this.raceNameForDefaultSorting);
        }
        if (defaultSortColumn == null) {
            defaultSortColumn = this.getRankColumn();
        }
        return defaultSortColumn;
    }

    private TotalRankColumn getRankColumn() {
        return this.totalRankColumn;
    }

    protected void setLeaderboard(LeaderboardDTO leaderboard) {
        this.leaderboard = leaderboard;
    }

    public LeaderboardDTO getLeaderboard() {
        return this.leaderboard;
    }

    private void adjustColumnLayout(LeaderboardDTO leaderboard) {
        int columnIndex = 0;
        columnIndex = this.ensureRaceRankColumn(columnIndex);
        columnIndex = this.ensureSelectionCheckboxColumn(columnIndex);
        columnIndex = this.ensureRankColumn(columnIndex);
        columnIndex = this.ensureCompetitorInfoWithFlagColumnAndCompetitorColumn(columnIndex);
        columnIndex = this.updateCarryColumn(leaderboard, columnIndex);
        this.adjustOverallDetailColumns(leaderboard, columnIndex);
        this.removeUnusedRaceColumns(leaderboard);
        if (leaderboard != null) {
            if (this.style.hasRaceColumns()) {
                this.createMissingAndAdjustExistingRaceColumns(leaderboard);
            }
            this.ensureTotalsColumn();
        }
    }

    protected int ensureRaceRankColumn(int columnIndex) {
        return 0;
    }

    private void adjustOverallDetailColumns(LeaderboardDTO leaderboard, int indexOfFirstOverallDetailsColumn) {
        ArrayList<AbstractSortableColumnWithMinMax> overallDetailColumnsToShow = new ArrayList<AbstractSortableColumnWithMinMax>();
        for (DetailType overallDetailType : DetailType.getAvailableOverallDetailColumnTypes()) {
            if (!this.selectedOverallDetailColumns.contains(overallDetailType) || !this.overallDetailColumnMap.containsKey(overallDetailType)) continue;
            overallDetailColumnsToShow.add((AbstractSortableColumnWithMinMax)this.overallDetailColumnMap.get(overallDetailType));
        }
        int currentColumnIndex = indexOfFirstOverallDetailsColumn;
        int i = 0;
        Column currentColumn = currentColumnIndex < this.getLeaderboardTable().getColumnCount() ? this.getLeaderboardTable().getColumn(currentColumnIndex) : null;
        while (i < overallDetailColumnsToShow.size() || this.overallDetailColumnMap.values().contains(currentColumn)) {
            if (i < overallDetailColumnsToShow.size() && currentColumn == overallDetailColumnsToShow.get(i)) {
                ++i;
                currentColumn = this.getLeaderboardTable().getColumn(++currentColumnIndex);
                continue;
            }
            if (i < overallDetailColumnsToShow.size()) {
                this.insertColumn(currentColumnIndex++, (AbstractSortableColumnWithMinMax)overallDetailColumnsToShow.get(i++));
                continue;
            }
            this.removeColumn(currentColumnIndex);
            currentColumn = this.getLeaderboardTable().getColumn(currentColumnIndex);
        }
    }

    private void correctColumnData(RaceColumn<?> raceColumn, RaceColumnDTO race) {
        int columnIndex = this.getRaceColumnPosition(raceColumn);
        if (raceColumn.isExpansionEnabled() != race.hasTrackedRaces() || race.isMedalRace() != raceColumn.isMedalRace()) {
            if (raceColumn.isExpanded()) {
                raceColumn.changeExpansionState(false);
            }
            this.removeColumn(columnIndex);
            this.insertColumn(columnIndex, (AbstractSortableColumnWithMinMax)this.createRaceColumn(race));
        }
    }

    private void removeRaceColumnFromRaceColumnStartIndexBeforeRace(int raceColumnStartIndex, RaceColumnDTO race) {
        int counter = 0;
        int leaderboardposition = 0;
        while (leaderboardposition < this.getLeaderboardTable().getColumnCount()) {
            Column c = this.getLeaderboardTable().getColumn(leaderboardposition);
            if (c instanceof RaceColumn) {
                RaceColumn raceColumn = (RaceColumn)c;
                if (!raceColumn.getRaceColumnName().equals(race.getRaceColumnName())) {
                    if (raceColumnStartIndex == counter) {
                        this.removeColumn((Column)raceColumn);
                    }
                } else {
                    return;
                }
                ++counter;
            }
            ++leaderboardposition;
        }
    }

    private int getRaceColumnPosition(RaceColumn<?> raceColumn) {
        int leaderboardposition = 0;
        while (leaderboardposition < this.getLeaderboardTable().getColumnCount()) {
            RaceColumn rc;
            Column c = this.getLeaderboardTable().getColumn(leaderboardposition);
            if (c instanceof RaceColumn && (rc = (RaceColumn)c).equals(raceColumn)) {
                return leaderboardposition;
            }
            ++leaderboardposition;
        }
        return -1;
    }

    private int getColumnPositionToInsert(RaceColumnDTO race, int listpos) {
        int raceColumnCounter = 0;
        int noRaceColumnCounter = 0;
        boolean raceColumnFound = false;
        int leaderboardPosition = 0;
        while (!raceColumnFound && leaderboardPosition < this.getLeaderboardTable().getColumnCount()) {
            Column c = this.getLeaderboardTable().getColumn(leaderboardPosition);
            if (c instanceof RaceColumn) {
                if (raceColumnCounter == listpos) {
                    raceColumnFound = true;
                } else {
                    ++raceColumnCounter;
                }
            } else {
                ++noRaceColumnCounter;
            }
            ++leaderboardPosition;
        }
        if (raceColumnFound) {
            return raceColumnCounter + noRaceColumnCounter;
        }
        return -1;
    }

    private void removeRaceColumnsNotSelected(Iterable<RaceColumnDTO> selectedRaceColumns) {
        HashSet<String> selectedRaceColumnNames = new HashSet<String>();
        for (RaceColumnDTO selectedRaceColumn : selectedRaceColumns) {
            selectedRaceColumnNames.add(selectedRaceColumn.getRaceColumnName());
        }
        ArrayList<Column> columnsToRemove = new ArrayList<Column>();
        int i = 0;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            Column c = this.getLeaderboardTable().getColumn(i);
            if (c instanceof RaceColumn && (this.leaderboard == null || !selectedRaceColumnNames.contains(((RaceColumn)c).getRaceColumnName()))) {
                columnsToRemove.add(c);
            }
            ++i;
        }
        for (Column c : columnsToRemove) {
            this.removeColumn(c);
        }
    }

    private void createMissingAndAdjustExistingRaceColumns(LeaderboardDTO leaderboard) {
        Iterable correctedOrderSelectedRaces = this.raceColumnSelection.getSelectedRaceColumnsOrderedAsInLeaderboard(leaderboard);
        this.removeRaceColumnsNotSelected(correctedOrderSelectedRaces);
        int selectedRaceCount = 0;
        while (selectedRaceCount < Util.size((Iterable)correctedOrderSelectedRaces)) {
            RaceColumn raceColumn;
            RaceColumnDTO selectedRaceColumn = (RaceColumnDTO)Util.get((Iterable)correctedOrderSelectedRaces, (int)selectedRaceCount);
            RaceColumn raceColumn2 = raceColumn = selectedRaceColumn == null ? null : this.getRaceColumnByRaceColumnName(selectedRaceColumn.getName());
            if (raceColumn != null) {
                this.removeRaceColumnFromRaceColumnStartIndexBeforeRace(selectedRaceCount, selectedRaceColumn);
                this.correctColumnData(raceColumn, selectedRaceColumn);
            } else {
                int positionToInsert = this.getColumnPositionToInsert(selectedRaceColumn, selectedRaceCount);
                if (positionToInsert != -1) {
                    this.insertColumn(positionToInsert, (AbstractSortableColumnWithMinMax)this.createRaceColumn(selectedRaceColumn));
                } else {
                    this.addRaceColumn(this.createRaceColumn(selectedRaceColumn));
                }
            }
            ++selectedRaceCount;
        }
    }

    protected RaceColumn<?> createRaceColumn(RaceColumnDTO raceInLeaderboard) {
        TextRaceColumn textRaceColumn = new TextRaceColumn(this, raceInLeaderboard, this.shallExpandRaceColumn(raceInLeaderboard), SortingOrder.ASCENDING, this.RACE_COLUMN_HEADER_STYLE, this.RACE_COLUMN_STYLE);
        return textRaceColumn;
    }

    private boolean shallExpandRaceColumn(RaceColumnDTO raceColumnDTO) {
        return this.showRaceDetails && raceColumnDTO.hasTrackedRaces();
    }

    private void removeUnusedRaceColumns(LeaderboardDTO leaderboard) {
        ArrayList<Column> columnsToRemove = new ArrayList<Column>();
        int i = 0;
        while (i < this.getLeaderboardTable().getColumnCount()) {
            Column c = this.getLeaderboardTable().getColumn(i);
            if (c instanceof RaceColumn && (leaderboard == null || !leaderboard.raceListContains(((RaceColumn)c).getRaceColumnName()))) {
                columnsToRemove.add(c);
            }
            ++i;
        }
        for (Column c : columnsToRemove) {
            this.removeColumn(c);
        }
    }

    private void addRaceColumn(RaceColumn<?> raceColumn) {
        if (this.getLeaderboardTable().getColumn(this.getLeaderboardTable().getColumnCount() - 1) instanceof TotalNetPointsColumn) {
            this.removeColumn(this.getLeaderboardTable().getColumnCount() - 1);
        }
        this.addColumn(raceColumn);
    }

    private boolean isShowRegattaRankColumn() {
        return this.selectedOverallDetailColumns.contains(DetailType.REGATTA_RANK);
    }

    private int ensureRankColumn(int rankColumnIndex) {
        int indexOfNextColumn = rankColumnIndex + (this.isShowRegattaRankColumn() ? 1 : 0);
        if (this.getLeaderboardTable().getColumnCount() > rankColumnIndex) {
            if (this.isShowRegattaRankColumn()) {
                if (this.getLeaderboardTable().getColumn(rankColumnIndex) != this.getRankColumn()) {
                    this.insertColumn(rankColumnIndex, (AbstractSortableColumnWithMinMax)this.getRankColumn());
                }
            } else if (this.getLeaderboardTable().getColumn(rankColumnIndex) == this.getRankColumn()) {
                this.removeColumn(rankColumnIndex);
            }
        } else if (this.isShowRegattaRankColumn()) {
            this.insertColumn(rankColumnIndex, (AbstractSortableColumnWithMinMax)this.getRankColumn());
        }
        return indexOfNextColumn;
    }

    private int ensureSelectionCheckboxColumn(int selectionCheckboxColumnIndex) {
        int indexOfNextColumn = selectionCheckboxColumnIndex + (this.showSelectionCheckbox ? 1 : 0);
        if (this.getLeaderboardTable().getColumnCount() > selectionCheckboxColumnIndex) {
            if (this.showSelectionCheckbox) {
                if (this.getLeaderboardTable().getColumn(selectionCheckboxColumnIndex) != this.selectionCheckboxColumn) {
                    this.insertColumn(selectionCheckboxColumnIndex, (AbstractSortableColumnWithMinMax)this.selectionCheckboxColumn);
                }
            } else if (this.getLeaderboardTable().getColumn(selectionCheckboxColumnIndex) == this.selectionCheckboxColumn) {
                this.removeColumn(selectionCheckboxColumnIndex);
            }
        } else if (this.showSelectionCheckbox) {
            this.insertColumn(selectionCheckboxColumnIndex, (AbstractSortableColumnWithMinMax)this.selectionCheckboxColumn);
        }
        return indexOfNextColumn;
    }

    private int ensureCompetitorInfoWithFlagColumnAndCompetitorColumn(int columnIndexWhereToInsertTheNextColumn) {
        if (this.isShowCompetitorShortName()) {
            CompetitorFetcher competitorFetcher = row -> row.competitor;
            CompetitorInfoWithFlagColumn competitorInfoWithFlagColumn = new CompetitorInfoWithFlagColumn(this, competitorFetcher, this.style);
            if (this.getLeaderboardTable().getColumnCount() <= columnIndexWhereToInsertTheNextColumn || !(this.getLeaderboardTable().getColumn(columnIndexWhereToInsertTheNextColumn) instanceof CompetitorInfoWithFlagColumn)) {
                this.insertColumn(columnIndexWhereToInsertTheNextColumn, (AbstractSortableColumnWithMinMax)competitorInfoWithFlagColumn);
            }
            ++columnIndexWhereToInsertTheNextColumn;
        } else if (this.getLeaderboardTable().getColumnCount() > columnIndexWhereToInsertTheNextColumn && this.getLeaderboardTable().getColumn(columnIndexWhereToInsertTheNextColumn) instanceof CompetitorInfoWithFlagColumn) {
            this.removeColumn(columnIndexWhereToInsertTheNextColumn);
        }
        if (this.isShowCompetitorFullName()) {
            if (this.getLeaderboardTable().getColumnCount() <= columnIndexWhereToInsertTheNextColumn || !(this.getLeaderboardTable().getColumn(columnIndexWhereToInsertTheNextColumn) instanceof CompetitorColumn)) {
                this.insertColumn(columnIndexWhereToInsertTheNextColumn, (AbstractSortableColumnWithMinMax)this.createCompetitorColumn());
            }
            ++columnIndexWhereToInsertTheNextColumn;
        } else if (this.getLeaderboardTable().getColumnCount() > columnIndexWhereToInsertTheNextColumn && this.getLeaderboardTable().getColumn(columnIndexWhereToInsertTheNextColumn) instanceof CompetitorColumn) {
            this.removeColumn(columnIndexWhereToInsertTheNextColumn);
        }
        if (this.canShowCompetitorBoatInfo() && this.isShowCompetitorBoatInfo()) {
            if (this.getLeaderboardTable().getColumnCount() <= columnIndexWhereToInsertTheNextColumn || !(this.getLeaderboardTable().getColumn(columnIndexWhereToInsertTheNextColumn) instanceof BoatInfoColumn)) {
                BoatFetcher boatFetcher = row -> row.boat;
                BoatInfoColumn boatInfoColumn = new BoatInfoColumn(this, boatFetcher, this.style);
                this.insertColumn(columnIndexWhereToInsertTheNextColumn, (AbstractSortableColumnWithMinMax)boatInfoColumn);
            }
            ++columnIndexWhereToInsertTheNextColumn;
        } else if (this.getLeaderboardTable().getColumnCount() > columnIndexWhereToInsertTheNextColumn && this.getLeaderboardTable().getColumn(columnIndexWhereToInsertTheNextColumn) instanceof BoatInfoColumn) {
            this.removeColumn(columnIndexWhereToInsertTheNextColumn);
        }
        return columnIndexWhereToInsertTheNextColumn;
    }

    protected CompetitorColumn createCompetitorColumn() {
        return new CompetitorColumn(this, new CompetitorColumnBase((LeaderboardFetcher)this, this.stringMessages, (CompetitorFetcher)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void ensureTotalsColumn() {
        if (this.getLeaderboardTable().getColumnCount() == 0 || !(this.getLeaderboardTable().getColumn(this.getLeaderboardTable().getColumnCount() - 1) instanceof TotalNetPointsColumn)) {
            this.addColumn((AbstractSortableColumnWithMinMax)new TotalNetPointsColumn(this, this.TOTAL_COLUMN_STYLE));
        }
    }

    protected int updateCarryColumn(LeaderboardDTO leaderboard, int zeroBasedIndexOfCarryColumn) {
        boolean needsCarryColumn;
        boolean bl = needsCarryColumn = leaderboard != null && leaderboard.hasCarriedPoints;
        if (needsCarryColumn) {
            this.ensureCarryColumn(zeroBasedIndexOfCarryColumn);
        } else {
            this.ensureNoCarryColumn(zeroBasedIndexOfCarryColumn);
        }
        return needsCarryColumn ? zeroBasedIndexOfCarryColumn + 1 : zeroBasedIndexOfCarryColumn;
    }

    protected void ensureNoCarryColumn(int zeroBasedIndexOfCarryColumn) {
        if (this.getLeaderboardTable().getColumnCount() > zeroBasedIndexOfCarryColumn && this.getLeaderboardTable().getColumn(zeroBasedIndexOfCarryColumn) instanceof CarryColumn) {
            this.removeColumn(zeroBasedIndexOfCarryColumn);
        }
    }

    protected void ensureCarryColumn(int zeroBasedIndexOfCarryColumn) {
        if (this.getLeaderboardTable().getColumnCount() <= zeroBasedIndexOfCarryColumn || !(this.getLeaderboardTable().getColumn(zeroBasedIndexOfCarryColumn) instanceof CarryColumn)) {
            while (this.getLeaderboardTable().getColumnCount() > zeroBasedIndexOfCarryColumn) {
                this.removeColumn(zeroBasedIndexOfCarryColumn);
            }
            this.addColumn((AbstractSortableColumnWithMinMax)this.createCarryColumn());
        }
    }

    protected CarryColumn createCarryColumn() {
        return new CarryColumn(this);
    }

    public SortedCellTable<LeaderboardRowDTO> getLeaderboardTable() {
        return this.leaderboardTable;
    }

    public SailingServiceAsync getSailingService() {
        return this.sailingService;
    }

    protected String getLeaderboardName() {
        return this.leaderboardName;
    }

    protected void setLeaderboardName(String leaderboardName) {
        this.leaderboardName = leaderboardName;
    }

    protected ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    protected ListDataProvider<LeaderboardRowDTO> getData() {
        return this.getLeaderboardTable().getDataProvider();
    }

    public void timeChanged(Date newTime, Date oldTime) {
        this.loadCompleteLeaderboard(false);
    }

    public void playStateChanged(Timer.PlayStates playState, Timer.PlayModes playMode) {
        if (!this.isEmbedded) {
            this.playPause.setHTML(this.getPlayPauseImgHtml(playState));
            this.playPause.setTitle(playState == Timer.PlayStates.Playing ? this.stringMessages.pauseAutomaticRefresh() : this.stringMessages.autoRefresh());
        }
    }

    public void playSpeedFactorChanged(double newPlaySpeedFactor) {
    }

    private List<RegattaAndRaceIdentifier> getTrackedRacesIdentifiers() {
        ArrayList<RegattaAndRaceIdentifier> result = new ArrayList<RegattaAndRaceIdentifier>();
        for (RaceColumnDTO raceColumn : this.getLeaderboard().getRaceList()) {
            for (FleetDTO fleet : raceColumn.getFleets()) {
                if (raceColumn.getRaceIdentifier(fleet) == null) continue;
                result.add(raceColumn.getRaceIdentifier(fleet));
            }
        }
        return result;
    }

    public boolean hasSettings() {
        return true;
    }

    public boolean hasToolbar() {
        return false;
    }

    public String getLocalizedShortName() {
        return this.stringMessages.leaderboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeaderboardRowDTO getRow(String competitorIdAsString) {
        List list = this.getData().getList();
        synchronized (list) {
            for (LeaderboardRowDTO row : this.getData().getList()) {
                if (!row.competitor.getIdAsString().equals(competitorIdAsString)) continue;
                return row;
            }
        }
        return null;
    }

    public void addedToSelection(CompetitorDTO competitor) {
        LeaderboardRowDTO row = this.getRow(competitor.getIdAsString());
        if (row != null) {
            this.leaderboardSelectionModel.setSelected((Object)row, true);
        }
    }

    public void removedFromSelection(CompetitorDTO competitor) {
        LeaderboardRowDTO row = this.getRow(competitor.getIdAsString());
        if (row != null) {
            this.leaderboardSelectionModel.setSelected((Object)row, false);
        }
    }

    private Iterable<LeaderboardRowDTO> getSelectedRows() {
        return this.leaderboardSelectionModel.getSelectedSet();
    }

    public void competitorsListChanged(Iterable<CompetitorDTO> competitors) {
        this.setFilterControlStatus();
        if (this.timer.isInitialized()) {
            this.timeChanged(this.timer.getTime(), null);
        }
    }

    public void filteredCompetitorsListChanged(Iterable<CompetitorDTO> filteredCompetitors) {
        this.setFilterControlStatus();
        this.updateLeaderboard(this.getLeaderboard());
    }

    public void filterChanged(FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> oldFilterSet, FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> newFilterSet) {
        this.setFilterControlStatus();
    }

    public RaceColumnSelection getRaceColumnSelection() {
        return this.raceColumnSelection;
    }

    public void removeAllListeners() {
        if (this.raceTimesInfoProviderListener != null) {
            this.getRaceTimesInfoProvider().removeRaceTimesInfoProviderListener(this.raceTimesInfoProviderListener);
        }
        if (this.raceColumnSelection != null && this.raceColumnSelection.getType() == RaceColumnSelectionStrategies.LAST_N) {
            this.getRaceTimesInfoProvider().removeRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)((LastNRacesColumnSelection)this.raceColumnSelection));
        }
        if (this.timer != null) {
            this.timer.removeTimeListener((TimeListener)this);
        }
        if (this.leaderboardUpdateListener != null) {
            this.leaderboardUpdateListener.clear();
        }
    }

    protected Timer getTimer() {
        return this.timer;
    }

    protected void blurFocusedElementAfterSelectionChange() {
        this.blur();
        11 blurCommand = new /* Unavailable Anonymous Inner Class!! */;
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)blurCommand);
    }

    private void blur() {
        if (this.elementToBlur != null) {
            this.elementToBlur.blur();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.timeChanged(this.getLeaderboardDisplayDate(), null);
        }
    }

    public void addLeaderboardUpdateListener(LeaderboardUpdateListener listener) {
        this.leaderboardUpdateListener.add(listener);
    }

    public void removeLeaderboardUpdateListener(LeaderboardUpdateListener listener) {
        this.leaderboardUpdateListener.remove(listener);
    }

    protected void informLeaderboardUpdateListenersAboutLeaderboardUpdated(LeaderboardDTO leaderboard) {
        for (LeaderboardUpdateListener listener : new ArrayList(this.leaderboardUpdateListener)) {
            listener.updatedLeaderboard(leaderboard);
        }
    }

    protected void informLeaderboardUpdateListenersAboutRaceSelected(RaceIdentifier raceIdentifier, RaceColumnDTO raceColumn) {
        for (LeaderboardUpdateListener listener : this.leaderboardUpdateListener) {
            listener.currentRaceSelected(raceIdentifier, raceColumn);
        }
    }

    public boolean hasLiveRace() {
        return this.getLeaderboard().hasLiveRace(this.timer.getLiveTimePointInMillis());
    }

    public String getLiveRacesText() {
        String result = "";
        List liveRaces = this.leaderboard.getLiveRaces(this.timer.getLiveTimePointInMillis());
        boolean isMeta = this.leaderboard.type.isMetaLeaderboard();
        if (!liveRaces.isEmpty()) {
            if (liveRaces.size() == 1) {
                String text = this.getLiveRaceText((Util.Pair)liveRaces.get(0), isMeta);
                result = isMeta ? this.stringMessages.regattaIsLive(text) : this.stringMessages.raceIsLive(text);
            } else {
                String names = "";
                for (Util.Pair liveRace : liveRaces) {
                    names = String.valueOf(names) + this.getLiveRaceText(liveRace, isMeta) + ", ";
                }
                names = names.substring(0, names.length() - 2);
                result = isMeta ? this.stringMessages.regattasAreLive(names) : this.stringMessages.racesAreLive(names);
            }
        }
        return result;
    }

    private String getLiveRaceText(Util.Pair<RaceColumnDTO, FleetDTO> liveRace, boolean isMeta) {
        String raceName = ((RaceColumnDTO)liveRace.getA()).getRaceColumnName();
        String fleetName = ((FleetDTO)liveRace.getB()).getName();
        boolean isDefaultFleet = "Default".equals(fleetName);
        return String.valueOf(raceName) + (isDefaultFleet || isMeta ? "" : " (" + ((FleetDTO)liveRace.getB()).getName() + ")");
    }

    public String getDependentCssClassName() {
        return "leaderboard";
    }

    public void addBusyStateChangeListener(BusyStateChangeListener listener) {
        this.busyStateChangeListeners.add(listener);
    }

    public void removeBusyStateChangeListener(BusyStateChangeListener listener) {
        this.busyStateChangeListeners.remove(listener);
    }

    public boolean isBusy() {
        return this.busyIndicator.isBusy();
    }

    private void setBusyState(boolean isBusy) {
        if (this.busyIndicator.isBusy() != isBusy) {
            this.busyIndicator.setBusy(isBusy);
            for (BusyStateChangeListener listener : this.busyStateChangeListeners) {
                listener.onBusyStateChange(isBusy);
            }
        }
    }

    public void addBusyTask() {
        ++this.busyTaskCounter;
        if (this.busyTaskCounter == 1) {
            this.setBusyState(true);
        }
    }

    public void removeBusyTask() {
        --this.busyTaskCounter;
        if (this.busyTaskCounter == 0) {
            this.setBusyState(false);
        }
    }

    public String getId() {
        return "lb";
    }

    protected abstract String getCompetitorColor(CompetitorDTO var1);

    private void renderCompetitorText(CompetitorDTO competitor, boolean withFlags, boolean withColor, SafeHtmlBuilder sb, Consumer<SafeHtmlBuilder> textRenderer) {
        String competitorColor = this.getCompetitorColor(competitor);
        boolean showColor = withColor && competitorColor != null;
        String divStyle = showColor ? this.style.determineBoatColorDivStyle(competitorColor) : "border: none;";
        sb.appendHtmlConstant("<div style=\"" + divStyle + "\">");
        if (withFlags) {
            String flagImageURL = competitor.getFlagImageURL();
            if (this.isShowCompetitorNationality || flagImageURL == null || flagImageURL.isEmpty()) {
                String twoLetterIsoCountryCode = competitor.getTwoLetterIsoCountryCode();
                CountryCode countryCode = CountryCodeFactory.INSTANCE.getFromTwoLetterISOName(twoLetterIsoCountryCode);
                ImageResource nationalityFlagImageResource = twoLetterIsoCountryCode == null || twoLetterIsoCountryCode.isEmpty() ? this.flagImageResolver.getEmptyFlagImageResource() : this.flagImageResolver.getFlagImageResource(twoLetterIsoCountryCode);
                if (nationalityFlagImageResource != null) {
                    this.style.renderNationalityFlag(nationalityFlagImageResource, countryCode, sb);
                    sb.appendHtmlConstant("&nbsp;");
                }
            }
            if (flagImageURL != null && !flagImageURL.isEmpty()) {
                this.style.renderFlagImage(flagImageURL, sb, competitor);
                sb.appendHtmlConstant("&nbsp;");
            }
        }
        textRenderer.accept(sb);
        sb.appendHtmlConstant("</div>");
    }

    public PaywallResolver getPaywallResolver() {
        return this.paywallResolver;
    }

    static /* synthetic */ void access$1(LeaderboardPanel leaderboardPanel, CompetitorDTO competitorDTO, boolean bl, boolean bl2, SafeHtmlBuilder safeHtmlBuilder, Consumer consumer) {
        leaderboardPanel.renderCompetitorText(competitorDTO, bl, bl2, safeHtmlBuilder, consumer);
    }

    static /* synthetic */ String access$2() {
        return IS_LIVE_TEXT_COLOR;
    }

    static /* synthetic */ String access$3() {
        return DEFAULT_TEXT_COLOR;
    }

    static /* synthetic */ RaceColumnTemplate access$4() {
        return raceColumnTemplate;
    }

    static /* synthetic */ FlushableSortedCellTableWithStylableHeaders access$5(LeaderboardPanel leaderboardPanel) {
        return leaderboardPanel.leaderboardTable;
    }

    static /* synthetic */ LeaderboardRowDTO access$6(LeaderboardPanel leaderboardPanel, String string) {
        return leaderboardPanel.getRow(string);
    }

    static /* synthetic */ void access$7(LeaderboardPanel leaderboardPanel, Element element) {
        leaderboardPanel.elementToBlur = element;
    }

    static /* synthetic */ Element access$8(LeaderboardPanel leaderboardPanel) {
        return leaderboardPanel.elementToBlur;
    }

    static /* synthetic */ void access$9(LeaderboardPanel leaderboardPanel, int n) {
        leaderboardPanel.blurInOnSelectionChanged = n;
    }

    static /* synthetic */ Iterable access$10(LeaderboardPanel leaderboardPanel) {
        return leaderboardPanel.getSelectedRows();
    }

    static /* synthetic */ int access$11(LeaderboardPanel leaderboardPanel) {
        return leaderboardPanel.blurInOnSelectionChanged;
    }

    static /* synthetic */ RaceTimesInfoProvider access$12(LeaderboardPanel leaderboardPanel) {
        return leaderboardPanel.getRaceTimesInfoProvider();
    }

    static /* synthetic */ RaceTimesInfoProviderListener access$13(LeaderboardPanel leaderboardPanel) {
        return leaderboardPanel.raceTimesInfoProviderListener;
    }

    static /* synthetic */ void access$14(LeaderboardPanel leaderboardPanel, RaceTimesInfoProviderListener raceTimesInfoProviderListener) {
        leaderboardPanel.raceTimesInfoProviderListener = raceTimesInfoProviderListener;
    }

    static /* synthetic */ void access$15(LeaderboardPanel leaderboardPanel) {
        leaderboardPanel.blur();
    }
}

