/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.RaceColumnSelectionStrategies;
import com.sap.sailing.gwt.ui.leaderboard.AbstractRaceColumnSelection;
import com.sap.sailing.gwt.ui.leaderboard.RaceColumnSelection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExplicitRaceColumnSelection
extends AbstractRaceColumnSelection
implements RaceColumnSelection {
    private final Map<String, RaceColumnDTO> selectedRaceColumns = new HashMap();

    public Iterable<RaceColumnDTO> getSelectedRaceColumns() {
        return this.selectedRaceColumns.values();
    }

    public void requestRaceColumnSelection(RaceColumnDTO column) {
        this.selectedRaceColumns.put(column.getName(), column);
    }

    public void requestClear() {
        this.selectedRaceColumns.clear();
    }

    private List<RaceColumnDTO> getRacesAddedNew(LeaderboardDTO oldLeaderboard, LeaderboardDTO newLeaderboard) {
        ArrayList<RaceColumnDTO> result = new ArrayList<RaceColumnDTO>();
        for (RaceColumnDTO s : newLeaderboard.getRaceList()) {
            if (oldLeaderboard != null && this.leaderboardContainsColumnNamed(oldLeaderboard, s.getRaceColumnName())) continue;
            result.add(s);
        }
        return result;
    }

    private boolean leaderboardContainsColumnNamed(LeaderboardDTO leaderboard, String raceColumnName) {
        for (RaceColumnDTO column : leaderboard.getRaceList()) {
            if (!column.getRaceColumnName().equals(raceColumnName)) continue;
            return true;
        }
        return false;
    }

    protected List<RaceColumnDTO> getRaceColumnsToAddImplicitly(LeaderboardDTO newLeaderboard, LeaderboardDTO oldLeaderboard) {
        List columnsToAddImplicitly = this.getRacesAddedNew(oldLeaderboard, newLeaderboard);
        return columnsToAddImplicitly;
    }

    public void autoUpdateRaceColumnSelectionForUpdatedLeaderboard(LeaderboardDTO oldLeaderboard, LeaderboardDTO newLeaderboard) {
        for (RaceColumnDTO selectedRaceColumn : this.getRaceColumnsToAddImplicitly(newLeaderboard, oldLeaderboard)) {
            this.requestRaceColumnSelection(selectedRaceColumn);
        }
    }

    public RaceColumnSelectionStrategies getType() {
        return RaceColumnSelectionStrategies.EXPLICIT;
    }

    public Integer getNumberOfLastRaceColumnsToShow() {
        return null;
    }
}

