/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.DisplayedLeaderboardRowsProvider;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardSortableColumnWithMinMax;
import com.sap.sailing.gwt.ui.leaderboard.SortableExpandableColumnHeader;
import com.sap.sse.common.SortingOrder;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import com.sap.sse.gwt.client.celltable.SortedCellTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ExpandableSortableColumn<C>
extends LeaderboardSortableColumnWithMinMax<LeaderboardRowDTO, C> {
    private boolean enableExpansion;
    private boolean togglingInProcess;
    private final LinkedList<Boolean> queuedToggleRequests = new LinkedList();
    private boolean suppressSortingOnce;
    private final LeaderboardPanel<?> leaderboardPanel;
    private final Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> detailColumnsMap;
    private final List<DetailType> detailSelection;
    protected List<AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> directChildren;
    private boolean expanded;

    public ExpandableSortableColumn(LeaderboardPanel<?> leaderboardPanel, boolean enableExpansion, Cell<C> cell, SortingOrder preferredSortingOrder, StringMessages stringConstants, String detailHeaderStyle, String detailColumnStyle, List<DetailType> detailSelection, DisplayedLeaderboardRowsProvider displayedLeaderboardRowsProvider) {
        super(cell, preferredSortingOrder, displayedLeaderboardRowsProvider);
        this.enableExpansion = enableExpansion;
        this.leaderboardPanel = leaderboardPanel;
        this.detailSelection = detailSelection;
        this.detailColumnsMap = this.getDetailColumnMap(leaderboardPanel, stringConstants, detailHeaderStyle, detailColumnStyle);
    }

    protected Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> getDetailColumnMap(LeaderboardPanel<?> leaderboardPanel, StringMessages stringConstants, String detailHeaderStyle, String detailColumnStyle) {
        return Collections.emptyMap();
    }

    protected LeaderboardPanel<?> getLeaderboardPanel() {
        return this.leaderboardPanel;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void suppressSortingOnce() {
        this.suppressSortingOnce = true;
    }

    protected Iterable<AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> getDirectChildren() {
        List<AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> result;
        if (this.isExpanded()) {
            result = new ArrayList();
            for (DetailType detailColumnType : this.detailSelection) {
                AbstractSortableColumnWithMinMax selectedColumn = (AbstractSortableColumnWithMinMax)this.detailColumnsMap.get(detailColumnType);
                if (selectedColumn == null) continue;
                result.add(selectedColumn);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    protected AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?> createExpansionColumn(DetailType detailColumnType) {
        throw new RuntimeException("Detail column type " + detailColumnType + " not supported by column of type " + this.getClass().getName());
    }

    protected List<DetailType> getSupportedDetails() {
        return Collections.emptyList();
    }

    private Collection<AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> getAllVisibleChildren() {
        ArrayList transitiveChildren = new ArrayList();
        if (this.isExpanded()) {
            for (AbstractSortableColumnWithMinMax childColumn : this.getDirectChildren()) {
                transitiveChildren.add(childColumn);
                if (!(childColumn instanceof ExpandableSortableColumn)) continue;
                ExpandableSortableColumn expandableChild = (ExpandableSortableColumn)childColumn;
                transitiveChildren.addAll(expandableChild.getAllVisibleChildren());
            }
        }
        return transitiveChildren;
    }

    public void changeExpansionState(boolean expand) {
        if (this.isExpansionEnabled()) {
            if (this.isTogglingInProcess()) {
                this.queuedToggleRequests.add(expand);
            } else {
                SortedCellTable table = this.getLeaderboardPanel().getLeaderboardTable();
                if (table == null) {
                    GWT.log((String)"WARNING: leaderboard table is null");
                } else {
                    this.getLeaderboardPanel().addBusyTask();
                    this.setTogglingInProcess(true);
                    if (!expand) {
                        if (this.isExpanded()) {
                            for (AbstractSortableColumnWithMinMax column : this.getAllVisibleChildren()) {
                                this.getLeaderboardPanel().removeColumn((Column)column);
                            }
                            this.setExpanded(!this.isExpanded());
                        }
                        this.finishCurrentToggling();
                    } else if (!this.isExpanded()) {
                        this.setExpanded(!this.isExpanded());
                        this.ensureExpansionDataIsLoaded((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    } else {
                        this.finishCurrentToggling();
                    }
                }
            }
        }
    }

    private void finishCurrentToggling() {
        this.getLeaderboardPanel().removeBusyTask();
        this.setTogglingInProcess(false);
        if (!this.queuedToggleRequests.isEmpty()) {
            this.changeExpansionState(((Boolean)this.queuedToggleRequests.remove(0)).booleanValue());
        }
    }

    protected void ensureExpansionDataIsLoaded(Runnable callWhenExpansionDataIsLoaded) {
        callWhenExpansionDataIsLoaded.run();
    }

    public boolean isSortable() {
        boolean result;
        if (this.suppressSortingOnce) {
            result = false;
            this.suppressSortingOnce = false;
        } else {
            result = super.isSortable();
        }
        return result;
    }

    public boolean isExpansionEnabled() {
        return this.enableExpansion;
    }

    public boolean isTogglingInProcess() {
        return this.togglingInProcess;
    }

    private void setTogglingInProcess(boolean togglingInProcess) {
        this.togglingInProcess = togglingInProcess;
    }

    public void setEnableExpansion(boolean enableExpansion) {
        this.enableExpansion = enableExpansion;
    }

    protected void defaultRender(Cell.Context context, LeaderboardRowDTO object, SafeHtmlBuilder html) {
        super.render(context, (Object)object, html);
    }

    public abstract SortableExpandableColumnHeader getHeader();

    static /* synthetic */ Collection access$1(ExpandableSortableColumn expandableSortableColumn) {
        return expandableSortableColumn.getAllVisibleChildren();
    }

    static /* synthetic */ void access$2(ExpandableSortableColumn expandableSortableColumn) {
        expandableSortableColumn.finishCurrentToggling();
    }
}

