/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorRaceRankFilter;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorSelectionProviderFilterContext;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorTotalRankFilter;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorsFilterSets;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorsFilterSetsDialog;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorsFilterSetsJsonDeSerializer;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFetcher;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFilterContext;
import com.sap.sailing.gwt.ui.client.shared.filter.QuickFlagDataValuesProvider;
import com.sap.sailing.gwt.ui.client.shared.filter.SelectedCompetitorsFilter;
import com.sap.sailing.gwt.ui.client.shared.filter.SelectedRaceFilterContext;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.leaderboard.CompetitorFilterResources;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.AbstractListFilter;
import com.sap.sse.common.filter.BinaryOperator;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterOperator;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import java.util.Collections;
import java.util.function.Consumer;

public class CompetitorFilterPanel
extends FlowPanel
implements KeyUpHandler,
FilterWithUI<CompetitorDTO>,
CompetitorSelectionChangeListener {
    private static final String LOCAL_STORAGE_COMPETITORS_FILTER_SETS_KEY = "sailingAnalytics.raceBoard.competitorsFilterSets";
    private static final CompetitorFilterResources.CompetitorFilterCss css = CompetitorFilterResources.INSTANCE.css();
    private final TextBox searchTextBox;
    private final Button clearTextBoxButton;
    private final Button filterSetSelectionButton;
    private final StringMessages stringMessages;
    private final AbstractListFilter<CompetitorDTO> filter;
    private final CompetitorSelectionProvider competitorSelectionProvider;
    private String lastFilterSetNameWithoutThis;
    private CompetitorsFilterSets competitorsFilterSets;
    private FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> lastActiveCompetitorFilterSet;
    private final LeaderboardFetcher leaderboardFetcher;
    private final RaceMap raceMap;
    private final RaceIdentifier selectedRaceIdentifier;
    private final Button settingsButton;
    private final FlowPanel searchBoxPanel;
    private final CrossDomainStorage storage;

    public CompetitorFilterPanel(CompetitorSelectionProvider competitorSelectionProvider, StringMessages stringMessages, RaceMap raceMap, LeaderboardFetcher leaderboardFetcher, RaceIdentifier selectedRaceIdentifier, CrossDomainStorage storage) {
        css.ensureInjected();
        this.storage = storage;
        this.stringMessages = stringMessages;
        this.raceMap = raceMap;
        this.leaderboardFetcher = leaderboardFetcher;
        this.selectedRaceIdentifier = selectedRaceIdentifier;
        this.competitorSelectionProvider = competitorSelectionProvider;
        this.setStyleName(css.competitorFilterContainer());
        this.filter = new /* Unavailable Anonymous Inner Class!! */;
        this.settingsButton = new Button();
        this.settingsButton.ensureDebugId("leaderboardSettingsButton");
        this.settingsButton.setTitle(stringMessages.settings());
        this.settingsButton.setStyleName(css.button());
        this.settingsButton.addStyleName(css.settingsButton());
        this.settingsButton.addStyleName(css.settingsButtonBackgroundImage());
        Button submitButton = new Button();
        submitButton.setStyleName(css.button());
        submitButton.addStyleName(css.searchButton());
        submitButton.addStyleName(css.searchButtonBackgroundImage());
        this.searchTextBox = new TextBox();
        this.searchTextBox.getElement().setAttribute("placeholder", stringMessages.searchCompetitorsBySailNumberOrName());
        this.searchTextBox.addKeyUpHandler((KeyUpHandler)this);
        this.searchTextBox.setStyleName(css.searchInput());
        this.clearTextBoxButton = new Button();
        this.clearTextBoxButton.setStyleName(css.button());
        this.clearTextBoxButton.addStyleName(css.clearButton());
        this.clearTextBoxButton.addStyleName(css.clearButtonBackgroundImage());
        this.clearTextBoxButton.addStyleName(css.hiddenButton());
        this.clearTextBoxButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.filterSetSelectionButton = new Button("");
        this.filterSetSelectionButton.setStyleName(css.button());
        this.filterSetSelectionButton.addStyleName(css.filterButton());
        this.filterSetSelectionButton.setTitle(stringMessages.competitorsFilter());
        this.filterSetSelectionButton.addStyleName(css.filterInactiveButtonBackgroundImage());
        this.filterSetSelectionButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.searchBoxPanel = new FlowPanel();
        this.searchBoxPanel.setStyleName(css.searchBox());
        this.searchBoxPanel.add((Widget)submitButton);
        this.searchBoxPanel.add((Widget)this.searchTextBox);
        this.searchBoxPanel.add((Widget)this.clearTextBoxButton);
        this.add((Widget)this.searchBoxPanel);
        this.add((Widget)this.settingsButton);
        this.add((Widget)this.filterSetSelectionButton);
        this.loadCompetitorsFilterSets(loadedCompetitorsFilterSets -> {
            if (loadedCompetitorsFilterSets != null) {
                this.competitorsFilterSets = loadedCompetitorsFilterSets;
                this.insertSelectedCompetitorsFilter(this.competitorsFilterSets);
                this.updateCompetitorFilterSetAndView(this.competitorsFilterSets.getActiveFilterSet());
            } else {
                this.competitorsFilterSets = this.createAndAddDefaultCompetitorsFilter();
                this.updateCompetitorFilterSetAndView(this.competitorsFilterSets.getActiveFilterSet());
                this.storeCompetitorsFilterSets(this.competitorsFilterSets);
            }
        });
    }

    public CompetitorsFilterSets getCompetitorsFilterSets() {
        return this.competitorsFilterSets;
    }

    public void onKeyUp(KeyUpEvent event) {
        String newValue = this.searchTextBox.getValue();
        if (newValue.trim().isEmpty()) {
            this.removeSearchFilter();
            this.clearTextBoxButton.addStyleName(css.hiddenButton());
        } else if (newValue.length() >= 2) {
            this.clearTextBoxButton.removeStyleName(css.hiddenButton());
            this.ensureSearchFilterIsSet();
            this.competitorSelectionProvider.setCompetitorsFilterSet(this.competitorSelectionProvider.getCompetitorsFilterSet());
        }
    }

    private void ensureSearchFilterIsSet() {
        if (this.competitorSelectionProvider.getCompetitorsFilterSet() == null || !Util.contains((Iterable)this.competitorSelectionProvider.getCompetitorsFilterSet().getFilters(), (Object)this)) {
            FilterSet newFilterSetWithThis = new FilterSet(this.getName());
            if (this.competitorSelectionProvider.getCompetitorsFilterSet() != null) {
                for (Filter oldFilter : this.competitorSelectionProvider.getCompetitorsFilterSet().getFilters()) {
                    newFilterSetWithThis.addFilter(oldFilter);
                }
            }
            newFilterSetWithThis.addFilter((Filter)this);
            this.competitorSelectionProvider.setCompetitorsFilterSet(newFilterSetWithThis);
        }
    }

    private void removeSearchFilter() {
        if (this.competitorSelectionProvider.getCompetitorsFilterSet() != null && Util.contains((Iterable)this.competitorSelectionProvider.getCompetitorsFilterSet().getFilters(), (Object)this)) {
            FilterSet newFilterSetWithThis = new FilterSet(this.lastFilterSetNameWithoutThis);
            for (Filter oldFilter : this.competitorSelectionProvider.getCompetitorsFilterSet().getFilters()) {
                if (oldFilter == this) continue;
                newFilterSetWithThis.addFilter(oldFilter);
            }
            this.competitorSelectionProvider.setCompetitorsFilterSet(newFilterSetWithThis);
        }
    }

    public void clearSelection() {
        this.searchTextBox.setText("");
        this.clearTextBoxButton.addStyleName(css.hiddenButton());
        this.onKeyUp(null);
    }

    public boolean matches(CompetitorDTO competitor) {
        Iterable lowercaseKeywords = Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)this.searchTextBox.getText().toLowerCase());
        return !Util.isEmpty((Iterable)this.filter.applyFilter(lowercaseKeywords, Collections.singleton(competitor)));
    }

    public String getName() {
        return this.stringMessages.competitorSearchFilter();
    }

    public void clearAllActiveFilters() {
        this.competitorsFilterSets.setActiveFilterSet(null);
        this.competitorSelectionProvider.clearAllFilters();
    }

    public void updateCompetitorFilterSetAndView(FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> activeFilterSet) {
        this.competitorsFilterSets.setActiveFilterSet(activeFilterSet);
        this.updateCompetitorsFilterContexts(this.competitorsFilterSets);
        this.competitorSelectionProvider.setCompetitorsFilterSet(this.competitorsFilterSets.getActiveFilterSetWithGeneralizedType());
        this.updateCompetitorsFilterControlState(this.competitorsFilterSets);
    }

    private void showEditCompetitorsFiltersDialog() {
        CompetitorsFilterSetsDialog competitorsFilterSetsDialog = new CompetitorsFilterSetsDialog(this.competitorsFilterSets, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        competitorsFilterSetsDialog.show();
    }

    private void insertSelectedCompetitorsFilter(CompetitorsFilterSets filterSet) {
        FilterSet selectedCompetitorsFilterSet = new FilterSet(this.stringMessages.selectedCompetitors());
        selectedCompetitorsFilterSet.setEditable(false);
        SelectedCompetitorsFilter selectedCompetitorsFilter = new SelectedCompetitorsFilter();
        selectedCompetitorsFilter.setCompetitorSelectionProvider(this.competitorSelectionProvider);
        selectedCompetitorsFilterSet.addFilter((Filter)selectedCompetitorsFilter);
        filterSet.addFilterSet(0, selectedCompetitorsFilterSet);
    }

    private void updateCompetitorsFilterContexts(CompetitorsFilterSets filterSets) {
        for (FilterSet filterSet : filterSets.getFilterSets()) {
            for (Filter filter : filterSet.getFilters()) {
                if (this.leaderboardFetcher != null && filter instanceof LeaderboardFilterContext) {
                    ((LeaderboardFilterContext)filter).setLeaderboardFetcher(this.leaderboardFetcher);
                }
                if (filter instanceof SelectedRaceFilterContext) {
                    if (this.selectedRaceIdentifier != null) {
                        ((SelectedRaceFilterContext)filter).setSelectedRace(this.selectedRaceIdentifier);
                    }
                    if (this.raceMap != null) {
                        ((SelectedRaceFilterContext)filter).setQuickRankProvider((QuickFlagDataValuesProvider)this.raceMap);
                    }
                }
                if (!(filter instanceof CompetitorSelectionProviderFilterContext)) continue;
                ((CompetitorSelectionProviderFilterContext)filter).setCompetitorSelectionProvider(this.competitorSelectionProvider);
            }
        }
    }

    private void updateCompetitorsFilterControlState(CompetitorsFilterSets filterSets) {
        String competitorsFilterTitle = this.stringMessages.competitorsFilter();
        FilterSet activeFilterSet = filterSets.getActiveFilterSet();
        if (activeFilterSet != null) {
            if (this.lastActiveCompetitorFilterSet == null) {
                this.filterSetSelectionButton.removeStyleName(css.filterInactiveButtonBackgroundImage());
                this.filterSetSelectionButton.addStyleName(css.filterActiveButtonBackgroundImage());
            }
            this.lastActiveCompetitorFilterSet = activeFilterSet;
        } else {
            if (this.lastActiveCompetitorFilterSet != null) {
                this.filterSetSelectionButton.removeStyleName(css.filterActiveButtonBackgroundImage());
                this.filterSetSelectionButton.addStyleName(css.filterInactiveButtonBackgroundImage());
            }
            this.lastActiveCompetitorFilterSet = null;
        }
        if (this.lastActiveCompetitorFilterSet != null) {
            this.filterSetSelectionButton.setTitle(String.valueOf(competitorsFilterTitle) + " (" + this.lastActiveCompetitorFilterSet.getName() + ")");
        } else {
            this.filterSetSelectionButton.setTitle(competitorsFilterTitle);
        }
    }

    private void loadCompetitorsFilterSets(Consumer<CompetitorsFilterSets> resultConsumer) {
        this.storage.getItem(LOCAL_STORAGE_COMPETITORS_FILTER_SETS_KEY, jsonAsLocalStore -> {
            if (jsonAsLocalStore != null && !jsonAsLocalStore.isEmpty()) {
                CompetitorsFilterSetsJsonDeSerializer deserializer = new CompetitorsFilterSetsJsonDeSerializer();
                JSONValue value = JSONParser.parseStrict((String)jsonAsLocalStore);
                if (value.isObject() != null) {
                    resultConsumer.accept(deserializer.deserialize((JSONObject)value));
                } else {
                    resultConsumer.accept(null);
                }
            } else {
                resultConsumer.accept(null);
            }
        });
    }

    private void storeCompetitorsFilterSets(CompetitorsFilterSets newCompetitorsFilterSets) {
        this.storage.removeItem(LOCAL_STORAGE_COMPETITORS_FILTER_SETS_KEY, e -> {
            CompetitorsFilterSetsJsonDeSerializer serializer = new CompetitorsFilterSetsJsonDeSerializer();
            JSONObject jsonObject = serializer.serialize(newCompetitorsFilterSets);
            this.storage.setItem(LOCAL_STORAGE_COMPETITORS_FILTER_SETS_KEY, jsonObject.toString(), null);
        });
    }

    private CompetitorsFilterSets createAndAddDefaultCompetitorsFilter() {
        CompetitorsFilterSets filterSets = new CompetitorsFilterSets();
        this.insertSelectedCompetitorsFilter(filterSets);
        int maxRaceRank = 30;
        FilterSet topNRaceRankCompetitorsFilterSet = new FilterSet(this.stringMessages.topNCompetitorsByRaceRank(maxRaceRank));
        CompetitorRaceRankFilter raceRankFilter = new CompetitorRaceRankFilter();
        raceRankFilter.setOperator((FilterOperator)new BinaryOperator(BinaryOperator.Operators.LessThanEquals));
        raceRankFilter.setValue((Number)maxRaceRank);
        topNRaceRankCompetitorsFilterSet.addFilter((Filter)raceRankFilter);
        filterSets.addFilterSet(topNRaceRankCompetitorsFilterSet);
        int maxTotalRank = 30;
        FilterSet topNTotalRankCompetitorsFilterSet = new FilterSet(this.stringMessages.topNCompetitorsByTotalRank(maxTotalRank));
        CompetitorTotalRankFilter totalRankFilter = new CompetitorTotalRankFilter();
        totalRankFilter.setOperator((FilterOperator)new BinaryOperator(BinaryOperator.Operators.LessThanEquals));
        totalRankFilter.setValue((Number)50);
        topNTotalRankCompetitorsFilterSet.addFilter((Filter)totalRankFilter);
        filterSets.addFilterSet(topNTotalRankCompetitorsFilterSet);
        return filterSets;
    }

    public Button getSettingsButton() {
        return this.settingsButton;
    }

    public QuickFlagDataValuesProvider getQuickRankProvider() {
        return this.raceMap;
    }

    public void filterChanged(FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> oldFilterSet, FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> newFilterSet) {
        if (newFilterSet != null && !Util.contains((Iterable)newFilterSet.getFilters(), (Object)this)) {
            this.lastFilterSetNameWithoutThis = newFilterSet.getName();
        }
        if (!Util.contains((Iterable)newFilterSet.getFilters(), (Object)this)) {
            this.onKeyUp(null);
        }
    }

    public void competitorsListChanged(Iterable<CompetitorDTO> competitors) {
    }

    public void filteredCompetitorsListChanged(Iterable<CompetitorDTO> filteredCompetitors) {
    }

    public void addedToSelection(CompetitorDTO competitor) {
    }

    public void removedFromSelection(CompetitorDTO competitor) {
    }

    public String validate(StringMessages stringMessages) {
        return null;
    }

    public String getLocalizedName(StringMessages stringMessages) {
        return this.getName();
    }

    public String getLocalizedDescription(StringMessages stringMessages) {
        return this.getName();
    }

    public FilterWithUI<CompetitorDTO> copy() {
        return null;
    }

    public FilterUIFactory<CompetitorDTO> createUIFactory() {
        return null;
    }

    static /* synthetic */ void access$1(CompetitorFilterPanel competitorFilterPanel) {
        competitorFilterPanel.showEditCompetitorsFiltersDialog();
    }

    static /* synthetic */ CompetitorsFilterSets access$2(CompetitorFilterPanel competitorFilterPanel) {
        return competitorFilterPanel.competitorsFilterSets;
    }

    static /* synthetic */ void access$3(CompetitorFilterPanel competitorFilterPanel, CompetitorsFilterSets competitorsFilterSets) {
        competitorFilterPanel.updateCompetitorsFilterContexts(competitorsFilterSets);
    }

    static /* synthetic */ CompetitorSelectionProvider access$4(CompetitorFilterPanel competitorFilterPanel) {
        return competitorFilterPanel.competitorSelectionProvider;
    }

    static /* synthetic */ void access$5(CompetitorFilterPanel competitorFilterPanel, CompetitorsFilterSets competitorsFilterSets) {
        competitorFilterPanel.updateCompetitorsFilterControlState(competitorsFilterSets);
    }

    static /* synthetic */ void access$6(CompetitorFilterPanel competitorFilterPanel, CompetitorsFilterSets competitorsFilterSets) {
        competitorFilterPanel.storeCompetitorsFilterSets(competitorsFilterSets);
    }
}

