/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap.windladder;

import com.google.gwt.maps.client.MapWidget;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.windladder.DoubleCanvasBuffer;
import com.sap.sailing.gwt.ui.client.shared.racemap.windladder.WindLadderOverlay;
import com.sap.sailing.gwt.ui.shared.WindDTO;

public class WindLadder
extends DoubleCanvasBuffer<WindLadderOverlay> {
    protected CoordinateSystem coordinateSystem;
    protected Double windBearingRadians;
    protected Position fixPosition;
    protected long transitionTime;
    protected Double previousWindBearingRadians;
    protected Position previousFixPosition;
    protected boolean forceSwap;
    protected boolean doSwap;

    public WindLadder(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        this.buffer = new WindLadderOverlay[2];
        ((WindLadderOverlay[])this.buffer)[0] = new WindLadderOverlay(this, map, zIndex, coordinateSystem, "buffer-0");
        ((WindLadderOverlay[])this.buffer)[1] = new WindLadderOverlay(this, map, zIndex, coordinateSystem, "buffer-1");
        this.apply(overlay -> overlay.setVisible(false));
        this.setVisible(true);
        this.addToMap();
    }

    protected void forceSwap() {
        this.forceSwap = true;
    }

    public void update(WindDTO windFix, Position fixPosition, long timeForPositionTransitionMillis) {
        boolean swapRequired;
        this.previousWindBearingRadians = this.windBearingRadians;
        this.previousFixPosition = this.fixPosition;
        if (windFix != null) {
            this.windBearingRadians = Math.toRadians(this.coordinateSystem.mapDegreeBearing(windFix.trueWindFromDeg.doubleValue()));
        }
        if (fixPosition != null) {
            this.fixPosition = fixPosition;
        }
        this.transitionTime = timeForPositionTransitionMillis;
        if (this.doSwap) {
            this.doSwap();
            this.doSwap = false;
        }
        boolean bl = swapRequired = !((WindLadderOverlay)this.getActiveCanvas()).update(this.windBearingRadians, fixPosition, timeForPositionTransitionMillis);
        if (this.forceSwap || swapRequired) {
            this.swap();
            this.forceSwap = false;
        }
    }

    public void swap() {
        WindLadderOverlay next = ((WindLadderOverlay[])this.buffer)[this.nextCanvasIndex()];
        next.update(this.previousWindBearingRadians, this.previousFixPosition, this.transitionTime, true);
        this.doSwap = true;
    }

    public void doSwap() {
        super.swap();
    }
}

