/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.ImageTransformer;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapImageManager;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapStyle;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.settings.DummyOnSettingsStoredCallback;
import com.sap.sse.gwt.client.shared.settings.OnSettingsStoredCallback;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.premium.PaywallResolver;

public class TrueNorthIndicatorPanel
extends FlowPanel {
    private final ImageTransformer transformer;
    private final StringMessages stringMessages;
    private final RaceMapImageManager raceMapResources;
    private final RaceMap map;
    private Canvas canvas;
    private RaceMapStyle raceMapStyle;
    private final CoordinateSystem coordinateSystem;
    private final SecuredDTO securedDTO;
    private final PaywallResolver paywallResolver;

    public TrueNorthIndicatorPanel(RaceMap map, RaceMapImageManager theRaceMapResources, RaceMapStyle raceMapStyle, StringMessages stringMessages, CoordinateSystem coordinateSystem, SecuredDTO securedDTO, PaywallResolver paywallResolver) {
        this.stringMessages = stringMessages;
        this.coordinateSystem = coordinateSystem;
        this.raceMapResources = theRaceMapResources;
        this.raceMapStyle = raceMapStyle;
        this.map = map;
        this.securedDTO = securedDTO;
        this.paywallResolver = paywallResolver;
        this.addStyleName(raceMapStyle.raceMapIndicatorPanel());
        this.addStyleName(raceMapStyle.trueNorthIndicatorPanel());
        this.transformer = this.raceMapResources.getTrueNorthIndicatorIconTransformer();
        this.canvas = this.transformer.getCanvas();
        this.canvas.addStyleName(this.raceMapStyle.raceMapIndicatorPanelCanvas());
        this.add((Widget)this.canvas);
        this.canvas.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void toggle() {
        RaceMapSettings oldRaceMapSettings = this.map.getSettings();
        boolean newWindUpSettings = !oldRaceMapSettings.isWindUp();
        RaceMapSettings newRaceMapSettings = new RaceMapSettings.RaceMapSettingsBuilder(oldRaceMapSettings, this.securedDTO, this.paywallResolver).withWindUp(Boolean.valueOf(newWindUpSettings)).withShowSatelliteLayer(Boolean.valueOf(oldRaceMapSettings.isShowSatelliteLayer() && !newWindUpSettings)).build();
        if (this.map.getComponentContext() != null && this.map.getComponentContext().isStorageSupported((Component)this.map)) {
            this.map.getComponentContext().storeSettingsForContext((Component)this.map, (Settings)newRaceMapSettings, (OnSettingsStoredCallback)new DummyOnSettingsStoredCallback());
        }
        this.map.updateSettings(newRaceMapSettings);
    }

    protected void redraw() {
        double mappedTrueNorthDeg = this.coordinateSystem.mapDegreeBearing(0.0);
        this.transformer.drawTransformedImage(mappedTrueNorthDeg, 1.0);
        String title = String.valueOf(this.stringMessages.rotatedFromTrueNorth((double)Math.round(mappedTrueNorthDeg))) + '\n' + this.stringMessages.clickToToggleWindUp();
        this.canvas.setTitle(title);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }
}

