/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.shared.filter.AbstractTagTextFilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.TagUsernameFilter;
import com.sap.sse.common.filter.FilterOperator;
import com.sap.sse.common.filter.TextFilter;
import com.sap.sse.common.filter.TextOperator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class TagUsernameFilterUIFactory
extends AbstractTagTextFilterUIFactory {
    private TextBox valueTextBox;
    private ListBox operatorSelectionListBox;

    public TagUsernameFilterUIFactory() {
        this(new TagUsernameFilter());
    }

    public TagUsernameFilterUIFactory(TagUsernameFilter tagUsernameFilter) {
        super((TextFilter)tagUsernameFilter, TextOperator.Operators.Equals);
        this.supportedOperators.add(TextOperator.Operators.Equals);
        this.supportedOperators.add(TextOperator.Operators.NotEqualTo);
        this.supportedOperators.add(TextOperator.Operators.Contains);
        this.supportedOperators.add(TextOperator.Operators.NotContains);
        this.supportedOperators.add(TextOperator.Operators.StartsWith);
        this.supportedOperators.add(TextOperator.Operators.EndsWith);
        this.valueTextBox = null;
        this.operatorSelectionListBox = null;
    }

    public Widget createFilterUIWidget(DataEntryDialog<?> dataEntryDialog) {
        Grid hpGrid = new Grid(1, 2);
        hpGrid.setWidget(0, 0, this.createOperatorSelectionWidget(dataEntryDialog));
        hpGrid.setWidget(0, 1, this.createValueInputWidget(dataEntryDialog));
        hpGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        hpGrid.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_MIDDLE);
        return hpGrid;
    }

    private Widget createValueInputWidget(DataEntryDialog<?> dataEntryDialog) {
        if (this.valueTextBox == null) {
            this.valueTextBox = dataEntryDialog.createTextBox((String)this.tagTextFilter.getValue());
            this.valueTextBox.setVisibleLength(20);
            this.valueTextBox.setFocus(true);
        }
        return this.valueTextBox;
    }

    private Widget createOperatorSelectionWidget(DataEntryDialog<?> dataEntryDialog) {
        if (this.operatorSelectionListBox == null) {
            this.operatorSelectionListBox = this.createOperatorSelectionListBox(dataEntryDialog);
        }
        return this.operatorSelectionListBox;
    }

    public FilterWithUI<TagDTO> createFilterFromUI() {
        TagUsernameFilter result = null;
        if (this.valueTextBox != null && this.operatorSelectionListBox != null) {
            result = new TagUsernameFilter();
            TextOperator.Operators op = TextOperator.Operators.valueOf((String)this.operatorSelectionListBox.getValue(this.operatorSelectionListBox.getSelectedIndex()));
            TextOperator textOperator = new TextOperator(op);
            result.setOperator((FilterOperator)textOperator);
            result.setValue(this.valueTextBox.getValue());
        }
        return result;
    }
}

