/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.AbstractTagsFilterSetDialog;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.TagFilterWithUIFactory;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTagsFilterSetDialog
extends DataEntryDialog<FilterSet<TagDTO, FilterWithUI<TagDTO>>> {
    private final FilterSet<TagDTO, FilterWithUI<TagDTO>> tagsFilterSet;
    private final StringMessages stringMessages;
    private final List<String> availableTagFilterNames;
    private ListBox filterListBox;
    private final Button addFilterButton;
    protected TextBox filterSetNameTextBox;
    private Grid tagsFiltersGrid;
    private Label tagsFiltersGridHeadline;
    private Label tagsFiltersGridFooter;
    private VerticalPanel mainPanel;
    private final List<Widget> filterEditWidgets;
    private final List<FilterUIFactory<TagDTO>> filterUIFactories;
    private final List<Label> filterNameLabels;
    private final List<String> filterNames;
    private final List<Button> filterDeleteButtons;

    public AbstractTagsFilterSetDialog(FilterSet<TagDTO, FilterWithUI<TagDTO>> tagsFilterSet, List<String> availableTagFilterNames, List<String> existingFilterSetNames, String dialogTitle, StringMessages stringMessages, DataEntryDialog.DialogCallback<FilterSet<TagDTO, FilterWithUI<TagDTO>>> callback) {
        super(dialogTitle, null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new TagsFilterSetValidator(existingFilterSetNames, stringMessages), callback);
        this.tagsFilterSet = tagsFilterSet;
        this.availableTagFilterNames = availableTagFilterNames;
        this.stringMessages = stringMessages;
        this.tagsFiltersGrid = new Grid(0, 0);
        this.tagsFiltersGridHeadline = new Label();
        this.tagsFiltersGridFooter = new Label();
        this.filterEditWidgets = new ArrayList();
        this.filterNameLabels = new ArrayList();
        this.filterNames = new ArrayList();
        this.filterUIFactories = new ArrayList();
        this.filterDeleteButtons = new ArrayList();
        this.addFilterButton = new Button(stringMessages.add());
        this.addFilterButton.addStyleName("inlineButton");
        this.addFilterButton.addStyleName("btn-secondary");
        this.filterListBox = this.createListBox(false);
    }

    protected Widget getAdditionalWidget() {
        this.mainPanel = new VerticalPanel();
        Grid hGrid = new Grid(1, 2);
        this.mainPanel.add((Widget)hGrid);
        hGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.filterName()) + ":"));
        Grid filterSetNameTextBoxWrapperGrid = new Grid(1, 1);
        filterSetNameTextBoxWrapperGrid.setWidget(0, 0, (Widget)this.filterSetNameTextBox);
        filterSetNameTextBoxWrapperGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        hGrid.setWidget(0, 1, (Widget)filterSetNameTextBoxWrapperGrid);
        hGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        hGrid.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_MIDDLE);
        this.filterListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.filterListBox.addItem(String.valueOf(this.stringMessages.selectAFilterCriteria()) + "...");
        for (String filterName : this.availableTagFilterNames) {
            FilterWithUI filter = TagFilterWithUIFactory.createFilter((String)filterName);
            this.filterListBox.addItem(filter.getLocalizedName(this.stringMessages));
        }
        this.updateSelectedFilterInfo();
        this.addFilterButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Grid tagsFiltersGridHeadlineGrid = new Grid(1, 1);
        tagsFiltersGridHeadlineGrid.setWidget(0, 0, (Widget)this.tagsFiltersGridHeadline);
        tagsFiltersGridHeadlineGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        this.mainPanel.add((Widget)tagsFiltersGridHeadlineGrid);
        this.mainPanel.add((Widget)this.tagsFiltersGrid);
        this.mainPanel.add((Widget)this.tagsFiltersGridFooter);
        for (FilterWithUI existingFilter : this.tagsFilterSet.getFilters()) {
            FilterWithUI filter = existingFilter.copy();
            FilterUIFactory filterUIFactory = filter.createUIFactory();
            this.filterUIFactories.add(filterUIFactory);
            this.createFilterNameAndLabel(filter);
            this.createFilterEditWidget(filterUIFactory);
            this.createFilterDeleteButton(filter);
        }
        this.updateTagsFiltersGrid(this.mainPanel);
        Grid addFilterPanel = new Grid(1, 3);
        this.mainPanel.add((Widget)addFilterPanel);
        addFilterPanel.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.filterCriteria()) + ":"));
        Grid filterListBoxWrapperGrid = new Grid(1, 1);
        filterListBoxWrapperGrid.setWidget(0, 0, (Widget)this.filterListBox);
        filterListBoxWrapperGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        addFilterPanel.setWidget(0, 1, (Widget)filterListBoxWrapperGrid);
        addFilterPanel.setWidget(0, 2, (Widget)this.addFilterButton);
        addFilterPanel.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        addFilterPanel.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_MIDDLE);
        addFilterPanel.getCellFormatter().setVerticalAlignment(0, 2, HasVerticalAlignment.ALIGN_MIDDLE);
        return this.mainPanel;
    }

    private Label createFilterNameAndLabel(FilterWithUI<TagDTO> filter) {
        Label filterNameLabel = new Label(String.valueOf(filter.getLocalizedName(this.stringMessages)) + ":");
        this.filterNameLabels.add(filterNameLabel);
        this.filterNames.add(filter.getName());
        return filterNameLabel;
    }

    private Widget createFilterEditWidget(FilterUIFactory<TagDTO> filterUIFactory) {
        Widget filterEditWidget = filterUIFactory.createFilterUIWidget((DataEntryDialog)this);
        this.filterEditWidgets.add(filterEditWidget);
        return filterEditWidget;
    }

    private Button createFilterDeleteButton(FilterWithUI<TagDTO> filter) {
        Button filterDeleteBtn = new Button(this.stringMessages.delete());
        filterDeleteBtn.addStyleName("inlineButton");
        filterDeleteBtn.addStyleName("btn-secondary");
        this.filterDeleteButtons.add(filterDeleteBtn);
        filterDeleteBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return filterDeleteBtn;
    }

    private void updateSelectedFilterInfo() {
        FilterWithUI selectedFilter = this.getFilterFromSelectedFilterName();
        if (selectedFilter != null) {
            this.addFilterButton.setEnabled(true);
        } else {
            this.addFilterButton.setEnabled(false);
        }
    }

    protected FilterSet<TagDTO, FilterWithUI<TagDTO>> getResult() {
        FilterSet result = new FilterSet(this.filterSetNameTextBox.getText());
        for (FilterUIFactory filterUIFactory : this.filterUIFactories) {
            result.addFilter((Filter)filterUIFactory.createFilterFromUI());
        }
        return result;
    }

    private FilterWithUI<TagDTO> getFilterFromSelectedFilterName() {
        FilterWithUI result = null;
        int selectedIndex = this.filterListBox.getSelectedIndex();
        if (selectedIndex > 0) {
            String selectedItemValue = this.filterListBox.getValue(selectedIndex);
            for (String filterName : this.availableTagFilterNames) {
                FilterWithUI filter = TagFilterWithUIFactory.createFilter((String)filterName);
                if (!selectedItemValue.equals(filter.getLocalizedName(this.stringMessages))) continue;
                result = filter;
                break;
            }
        }
        return result;
    }

    private void updateTagsFiltersGrid(VerticalPanel parentPanel) {
        boolean showGridFooter;
        int widgetIndex = parentPanel.getWidgetIndex((Widget)this.tagsFiltersGrid);
        parentPanel.remove((Widget)this.tagsFiltersGrid);
        int filterCount = this.filterNameLabels.size();
        boolean showGridHeadline = filterCount >= 1;
        boolean bl = showGridFooter = filterCount >= 1;
        if (filterCount > 0) {
            this.tagsFiltersGrid = new Grid(filterCount, 3);
            this.tagsFiltersGrid.setCellSpacing(4);
            this.tagsFiltersGridHeadline.setVisible(showGridHeadline);
            this.tagsFiltersGridFooter.setVisible(showGridFooter);
            if (showGridHeadline) {
                this.tagsFiltersGridHeadline.setText(this.stringMessages.tagFilterExplanation());
            }
            if (showGridFooter) {
                this.tagsFiltersGridFooter.setText("");
            }
            int i = 0;
            while (i < filterCount) {
                this.tagsFiltersGrid.setWidget(i, 0, (Widget)this.filterNameLabels.get(i));
                this.tagsFiltersGrid.setWidget(i, 1, (Widget)this.filterEditWidgets.get(i));
                this.tagsFiltersGrid.setWidget(i, 2, (Widget)this.filterDeleteButtons.get(i));
                this.tagsFiltersGrid.getCellFormatter().setVerticalAlignment(i, 0, HasVerticalAlignment.ALIGN_MIDDLE);
                this.tagsFiltersGrid.getCellFormatter().setVerticalAlignment(i, 1, HasVerticalAlignment.ALIGN_MIDDLE);
                this.tagsFiltersGrid.getCellFormatter().setVerticalAlignment(i, 2, HasVerticalAlignment.ALIGN_MIDDLE);
                ++i;
            }
        } else {
            this.tagsFiltersGrid = new Grid(0, 0);
        }
        parentPanel.insert((Widget)this.tagsFiltersGrid, widgetIndex);
    }

    protected Focusable getInitialFocusWidget() {
        return this.filterSetNameTextBox;
    }

    static /* synthetic */ void access$1(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        abstractTagsFilterSetDialog.updateSelectedFilterInfo();
    }

    static /* synthetic */ FilterWithUI access$2(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        return abstractTagsFilterSetDialog.getFilterFromSelectedFilterName();
    }

    static /* synthetic */ List access$3(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        return abstractTagsFilterSetDialog.filterUIFactories;
    }

    static /* synthetic */ Label access$4(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog, FilterWithUI filterWithUI) {
        return abstractTagsFilterSetDialog.createFilterNameAndLabel(filterWithUI);
    }

    static /* synthetic */ Widget access$5(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog, FilterUIFactory filterUIFactory) {
        return abstractTagsFilterSetDialog.createFilterEditWidget(filterUIFactory);
    }

    static /* synthetic */ Button access$6(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog, FilterWithUI filterWithUI) {
        return abstractTagsFilterSetDialog.createFilterDeleteButton(filterWithUI);
    }

    static /* synthetic */ VerticalPanel access$7(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        return abstractTagsFilterSetDialog.mainPanel;
    }

    static /* synthetic */ void access$8(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog, VerticalPanel verticalPanel) {
        abstractTagsFilterSetDialog.updateTagsFiltersGrid(verticalPanel);
    }

    static /* synthetic */ void access$9(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        abstractTagsFilterSetDialog.validateAndUpdate();
    }

    static /* synthetic */ List access$10(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        return abstractTagsFilterSetDialog.filterDeleteButtons;
    }

    static /* synthetic */ List access$11(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        return abstractTagsFilterSetDialog.filterNames;
    }

    static /* synthetic */ List access$12(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        return abstractTagsFilterSetDialog.filterNameLabels;
    }

    static /* synthetic */ List access$13(AbstractTagsFilterSetDialog abstractTagsFilterSetDialog) {
        return abstractTagsFilterSetDialog.filterEditWidgets;
    }
}

