/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.controls;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.UriUtils;
import com.sap.sailing.gwt.ui.client.shared.controls.MultipleLinkCell;
import java.util.List;

public class MultipleLinkCell
extends AbstractCell<List<CellLink>> {
    private ValueUpdater<String> onLinkClickHandler;
    private boolean isBlockLinkEvent = false;
    private static LinkTemplates linkTemplates = (LinkTemplates)GWT.create(LinkTemplates.class);

    public MultipleLinkCell() {
        super(new String[]{"click", "mousedown"});
    }

    public MultipleLinkCell(boolean isBlockLinkEvent) {
        super(new String[]{"click", "mousedown"});
        this.isBlockLinkEvent = isBlockLinkEvent;
    }

    public ValueUpdater<String> getOnLinkClickHandler() {
        return this.onLinkClickHandler;
    }

    public void setOnLinkClickHandler(ValueUpdater<String> handler) {
        this.onLinkClickHandler = handler;
    }

    public boolean isBlockLinkEvent() {
        return this.isBlockLinkEvent;
    }

    public void setBlockLinkEvent(boolean isBlockLinkEvent) {
        this.isBlockLinkEvent = isBlockLinkEvent;
    }

    public void onBrowserEvent(Cell.Context context, Element parent, List<CellLink> value, NativeEvent event, ValueUpdater<List<CellLink>> valueUpdater) {
        super.onBrowserEvent(context, parent, value, event, valueUpdater);
        if (this.isBlockLinkEvent) {
            Element el;
            event.preventDefault();
            EventTarget eventTarget = event.getEventTarget();
            if (parent.isOrHasChild((Node)Element.as((JavaScriptObject)eventTarget)) && (el = Element.as((JavaScriptObject)eventTarget)).getNodeName().equalsIgnoreCase("a")) {
                this.onLinkClickHandler.update((Object)el.getAttribute("target"));
            }
        }
    }

    public void render(Cell.Context context, List<CellLink> links, SafeHtmlBuilder sb) {
        if (!links.isEmpty()) {
            boolean isFirst = true;
            for (CellLink link : links) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.appendHtmlConstant("<br>");
                }
                SafeHtml rendered = linkTemplates.cell(link.getTarget(), UriUtils.fromString((String)link.getHref()), link.getText());
                sb.append(rendered);
            }
        }
    }
}

