/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.WindSourceTypeFormatter;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartSettings;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class WindChartSettingsDialogComponent
implements SettingsDialogComponent<WindChartSettings> {
    private final WindChartSettings initialSettings;
    private IntegerBox resolutionInSecondsBox;
    private final Map<WindSourceType, CheckBox> windDirectionsCheckboxes;
    private final Map<WindSourceType, CheckBox> windSpeedCheckboxes;
    private CheckBox showWindSpeedSeriesCheckbox;
    private CheckBox showWindDirectionsSeriesCheckbox;
    private final StringMessages stringMessages;

    public WindChartSettingsDialogComponent(WindChartSettings initialSettings, StringMessages stringMessages) {
        this.stringMessages = stringMessages;
        this.initialSettings = initialSettings;
        this.windDirectionsCheckboxes = new LinkedHashMap();
        this.windSpeedCheckboxes = new LinkedHashMap();
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        CheckBox checkbox;
        VerticalPanel vp = new VerticalPanel();
        this.resolutionInSecondsBox = dialog.createIntegerBox(Integer.valueOf((int)(this.initialSettings.getResolutionInMilliseconds() / 1000L)), 5);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new Label(String.valueOf(this.stringMessages.stepSizeInSeconds()) + ":"));
        hp.add((Widget)this.resolutionInSecondsBox);
        vp.add((Widget)hp);
        Label createHeadlineLabel = dialog.createHeadlineLabel(this.stringMessages.windSourcesUsed());
        vp.add((Widget)createHeadlineLabel);
        Grid grid = new Grid(1, 2);
        grid.setCellPadding(5);
        vp.add((Widget)grid);
        VerticalPanel windDirectionSourcesPanel = new VerticalPanel();
        grid.setWidget(0, 0, (Widget)windDirectionSourcesPanel);
        VerticalPanel windSpeedSourcesPanel = new VerticalPanel();
        grid.setWidget(0, 1, (Widget)windSpeedSourcesPanel);
        this.showWindSpeedSeriesCheckbox = dialog.createCheckbox(this.stringMessages.showWindSpeedSeries());
        this.showWindSpeedSeriesCheckbox.setTitle(this.stringMessages.showWindSpeedSeriesTooltip());
        this.showWindSpeedSeriesCheckbox.setValue(Boolean.valueOf(this.initialSettings.isShowWindSpeedSeries()));
        this.showWindSpeedSeriesCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        windSpeedSourcesPanel.add((Widget)this.showWindSpeedSeriesCheckbox);
        this.showWindDirectionsSeriesCheckbox = dialog.createCheckbox(this.stringMessages.showWindDirectionSeries());
        this.showWindDirectionsSeriesCheckbox.setTitle(this.stringMessages.showWindDirectionSeriesTooltip());
        this.showWindDirectionsSeriesCheckbox.setValue(Boolean.valueOf(this.initialSettings.isShowWindDirectionsSeries()));
        this.showWindDirectionsSeriesCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        windDirectionSourcesPanel.add((Widget)this.showWindDirectionsSeriesCheckbox);
        for (WindSourceType windSourceType : this.getWindSourceTypesToOffer()) {
            checkbox = dialog.createCheckbox(WindSourceTypeFormatter.format((WindSourceType)windSourceType, (StringMessages)this.stringMessages));
            checkbox.setTitle(WindSourceTypeFormatter.tooltipFor((WindSourceType)windSourceType, (StringMessages)this.stringMessages));
            checkbox.setEnabled(this.initialSettings.isShowWindDirectionsSeries());
            this.windDirectionsCheckboxes.put(windSourceType, checkbox);
            checkbox.setValue(Boolean.valueOf(this.initialSettings.getWindDirectionSourcesToDisplay().contains(windSourceType)));
            checkbox.getElement().getStyle().setMarginLeft(15.0, Style.Unit.PX);
            windDirectionSourcesPanel.add((Widget)checkbox);
        }
        for (WindSourceType windSourceType : this.getWindSourceTypesToOffer()) {
            checkbox = dialog.createCheckbox(WindSourceTypeFormatter.format((WindSourceType)windSourceType, (StringMessages)this.stringMessages));
            checkbox.setTitle(WindSourceTypeFormatter.tooltipFor((WindSourceType)windSourceType, (StringMessages)this.stringMessages));
            checkbox.setEnabled(this.initialSettings.isShowWindSpeedSeries() && windSourceType.useSpeed());
            this.windSpeedCheckboxes.put(windSourceType, checkbox);
            checkbox.setValue(Boolean.valueOf(this.initialSettings.getWindSpeedSourcesToDisplay().contains(windSourceType)));
            checkbox.getElement().getStyle().setMarginLeft(15.0, Style.Unit.PX);
            windSpeedSourcesPanel.add((Widget)checkbox);
        }
        return vp;
    }

    private Iterable<WindSourceType> getWindSourceTypesToOffer() {
        HashSet<WindSourceType> result = new HashSet<WindSourceType>();
        result.addAll(Arrays.asList(WindSourceType.values()));
        return result;
    }

    public WindChartSettings getResult() {
        HashSet<WindSourceType> windDirectionSourcesToDisplay = new HashSet<WindSourceType>();
        for (Map.Entry e : this.windDirectionsCheckboxes.entrySet()) {
            if (!((CheckBox)e.getValue()).getValue().booleanValue()) continue;
            windDirectionSourcesToDisplay.add((WindSourceType)e.getKey());
        }
        HashSet<WindSourceType> windSpeedSourcesToDisplay = new HashSet<WindSourceType>();
        for (Map.Entry e : this.windSpeedCheckboxes.entrySet()) {
            if (!((CheckBox)e.getValue()).getValue().booleanValue()) continue;
            windSpeedSourcesToDisplay.add((WindSourceType)e.getKey());
        }
        return new WindChartSettings(this.showWindSpeedSeriesCheckbox.getValue().booleanValue(), windSpeedSourcesToDisplay, this.showWindDirectionsSeriesCheckbox.getValue().booleanValue(), windDirectionSourcesToDisplay, (long)(this.resolutionInSecondsBox.getValue() == null ? -1 : (Integer)this.resolutionInSecondsBox.getValue() * 1000));
    }

    public DataEntryDialog.Validator<WindChartSettings> getValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public FocusWidget getFocusWidget() {
        return (FocusWidget)this.windDirectionsCheckboxes.values().iterator().next();
    }

    static /* synthetic */ Map access$1(WindChartSettingsDialogComponent windChartSettingsDialogComponent) {
        return windChartSettingsDialogComponent.windSpeedCheckboxes;
    }

    static /* synthetic */ Map access$2(WindChartSettingsDialogComponent windChartSettingsDialogComponent) {
        return windChartSettingsDialogComponent.windDirectionsCheckboxes;
    }

    static /* synthetic */ StringMessages access$3(WindChartSettingsDialogComponent windChartSettingsDialogComponent) {
        return windChartSettingsDialogComponent.stringMessages;
    }
}

