/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media.popup;

import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.media.VideoJSPlayer;
import com.sap.sailing.gwt.ui.client.media.popup.AbstractPopupWindow;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.resources.CommonControlsCSS;

public class VideoPopupWindow
extends AbstractPopupWindow
implements ContextMenuHandler {
    private boolean isDebug;
    private VideoJSPlayer videoJSDelegate;

    protected void initializePlayer() {
        RootLayoutPanel mainPanel = RootLayoutPanel.get();
        CommonControlsCSS.ensureInjected();
        String title = Window.Location.getParameter((String)"title");
        Window.setTitle((String)title);
        String videoUrl = Window.Location.getParameter((String)"url");
        String mimeType = Window.Location.getParameter((String)"mimetype");
        boolean bl = this.isDebug = Window.Location.getParameter((String)"gwt.codesvr") != null;
        if (videoUrl != null) {
            this.videoJSDelegate = new VideoJSPlayer(true, false, (TakedownNoticeService)this.getUserService(), "takedownRequestForRaceVideo");
            this.videoJSDelegate.setVideo(MimeType.valueOf((String)mimeType), videoUrl, Window.Location.getParameter((String)"eventName"));
            mainPanel.add((Widget)this.videoJSDelegate);
            this.initPlay();
        } else {
            mainPanel.add((Widget)new Label("Parameter 'url' not assigned."));
        }
    }

    native void initPlay();

    public void loadedmetadata() {
        this.adjustWindowSize();
    }

    public void play() {
        this.videoJSDelegate.play();
    }

    public void pause() {
        this.videoJSDelegate.pause();
    }

    public void setTime(double time) {
        this.videoJSDelegate.setCurrentTime((int)Math.min(time, (double)this.videoJSDelegate.getDuration()));
    }

    public void setMuted(boolean muted) {
        this.videoJSDelegate.setMuted(muted);
    }

    public boolean isPaused() {
        return this.videoJSDelegate.paused();
    }

    public double getDuration() {
        return this.videoJSDelegate.getDuration();
    }

    public double getTime() {
        return this.videoJSDelegate.getCurrentTime();
    }

    public void setPlaybackSpeed(double newPlaySpeedFactor) {
        this.videoJSDelegate.setPlaybackRate(newPlaySpeedFactor);
    }

    public void onContextMenu(ContextMenuEvent event) {
        if (!this.isDebug) {
            event.preventDefault();
            event.stopPropagation();
        }
    }

    protected boolean hasVideoSizes() {
        return this.videoJSDelegate != null;
    }

    protected int getVideoWidth() {
        return this.videoJSDelegate.getVideoWidth();
    }

    protected int getVideoHeight() {
        return this.videoJSDelegate.getVideoHeight();
    }

    protected void setVideoSize(int width, int height) {
        this.videoJSDelegate.setPixelSize(width, height);
    }
}

