/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.MediaElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.media.client.Audio;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.VideoMetadataDTO;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.client.MediaServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.NewMediaDialog;
import com.sap.sailing.gwt.ui.client.media.NewMediaDialogResources;
import com.sap.sailing.gwt.ui.client.media.TimeFormatUtil;
import com.sap.sailing.gwt.ui.common.client.YoutubeApi;
import com.sap.sse.common.Duration;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MediaSubType;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.adminconsole.EndUploadEvent;
import com.sap.sse.gwt.adminconsole.StartUploadEvent;
import com.sap.sse.gwt.adminconsole.URLFieldWithFileUpload;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.formfactor.DeviceDetector;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NewMediaDialog
extends DataEntryDialog<MediaTrack>
implements FileStorageServiceConnectionTestObservable.FileStorageServiceConnectionTestObserver {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final boolean DONT_FIRE_EVENTS = false;
    private static final Duration DEFAULT_DURATION = new MillisecondsDurationImpl(0L);
    private static final NewMediaDialogResources RESOURCES = NewMediaDialogResources.INSTANCE;
    private static final String PROGRESS_STATUS_URL = "/sailingserver/fileupload/progress";
    protected final StringMessages stringMessages;
    protected MediaTrack mediaTrack = new MediaTrack();
    private URLFieldWithFileUpload urlBox;
    private TextBox nameBox;
    protected DateAndTimeInput startTimeBox;
    private SimplePanel infoLabel;
    private TextBox durationBox;
    private TimePoint defaultStartTime;
    private ListBox mimeTypeListBox;
    private Label infoLabelLabel;
    private final RegattaAndRaceIdentifier raceIdentifier;
    private final Set<RegattaAndRaceIdentifier> assignedRaces;
    private final MediaServiceAsync mediaService;
    private boolean remoteMp4WasStarted;
    private boolean remoteMp4WasFinished;
    private Button defaultTimeButton;
    private Button resetNameButton;
    private SimpleBusyIndicator busyIndicator;
    private String lastCheckedUrl;
    private boolean manuallyEditedStartTime = false;

    public NewMediaDialog(MediaServiceAsync mediaService, TimePoint defaultStartTime, StringMessages stringMessages, RegattaAndRaceIdentifier raceIdentifier, FileStorageServiceConnectionTestObservable storageServiceConnection, DataEntryDialog.DialogCallback<MediaTrack> dialogCallback) {
        super(stringMessages.addMediaTrack(), "", stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new MediaTrackValidator(stringMessages), dialogCallback);
        RESOURCES.css().ensureInjected();
        this.defaultStartTime = defaultStartTime != null ? defaultStartTime : MillisecondsTimePoint.now();
        this.stringMessages = stringMessages;
        this.raceIdentifier = raceIdentifier;
        this.assignedRaces = new HashSet();
        this.assignedRaces.add(raceIdentifier);
        this.mediaService = mediaService;
        this.urlBox = new URLFieldWithFileUpload((com.sap.sse.gwt.adminconsole.StringMessages)stringMessages, false, true, false, "audio/*,video/*");
        this.urlBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.getCancelButton().addClickHandler(clickEvent -> this.urlBox.deleteCurrentFile());
        this.nameBox = this.createTextBox(null);
        this.nameBox.addStyleName(RESOURCES.css().nameBoxClass());
        this.nameBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.resetNameButton = new Button();
        this.resetNameButton.addStyleName("btn-primary");
        this.resetNameButton.addStyleName(RESOURCES.css().resetNameButtonClass());
        this.resetNameButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.startTimeBox = new DateAndTimeInput(DateTimeInput.Accuracy.MILLISECONDS);
        this.startTimeBox.addStyleName(RESOURCES.css().startTimeTextboxClass());
        this.startTimeBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.defaultTimeButton = new Button();
        this.defaultTimeButton.addStyleName("btn-primary");
        this.defaultTimeButton.setTitle(StringMessages.INSTANCE.resetStartTimeToDefault());
        this.defaultTimeButton.addStyleName(RESOURCES.css().resetButtonClass());
        this.defaultTimeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.durationBox = this.createTextBox(null);
        this.durationBox.setValue((Object)DEFAULT_DURATION.toString());
        this.durationBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        storageServiceConnection.registerObserver((FileStorageServiceConnectionTestObservable.FileStorageServiceConnectionTestObserver)this);
    }

    protected void validateAndUpdate() {
        super.validateAndUpdate();
        if (this.urlBox.getUri() == null || this.urlBox.getUri().isEmpty()) {
            this.getOkButton().setEnabled(false);
        }
    }

    protected MediaTrack getResult() {
        this.updateFromUrl();
        this.connectMediaWithRace();
        return this.mediaTrack;
    }

    protected void connectMediaWithRace() {
        this.mediaTrack.assignedRaces = this.assignedRaces;
    }

    private void updateBoxByMimeType() {
        if (this.mimeTypeListBox != null) {
            int i = 0;
            while (i < this.mimeTypeListBox.getItemCount()) {
                String value = this.mimeTypeListBox.getValue(i);
                if (value != null && !value.isEmpty() && this.mediaTrack.mimeType == MimeType.valueOf((String)value)) {
                    this.mimeTypeListBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (this.mimeTypeListBox.getSelectedIndex() < 1) {
            this.mediaTrack.mimeType = null;
        }
    }

    protected void updateFromUrl() {
        String url = this.urlBox.getUri();
        if (url != null && !url.isEmpty()) {
            boolean urlChanged = !url.equals(this.lastCheckedUrl);
            this.lastCheckedUrl = url;
            if (urlChanged) {
                this.remoteMp4WasStarted = false;
                this.remoteMp4WasFinished = false;
                this.manuallyEditedStartTime = false;
                if (this.mediaTrack.startTime == null) {
                    this.mediaTrack.startTime = this.defaultStartTime;
                }
                boolean isVimeoUrl = this.isVimeoUrl(url);
                String youtubeId = YoutubeApi.getIdByUrl((String)url);
                if (youtubeId != null) {
                    this.mediaTrack.url = youtubeId;
                    this.mediaTrack.mimeType = MimeType.youtube;
                    this.mediaService.checkYoutubeMetadata(youtubeId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                } else if (isVimeoUrl) {
                    this.mediaTrack.url = url;
                    this.mediaTrack.mimeType = MimeType.vimeo;
                } else {
                    this.mediaTrack.url = url;
                    AnchorElement anchor = Document.get().createAnchorElement();
                    anchor.setHref(url);
                    String lastPathSegment = anchor.getPropertyString("pathname").substring(1);
                    MimeType mimeType = MimeType.byExtension((String)lastPathSegment);
                    this.mediaTrack.mimeType = mimeType != MimeType.unknown ? mimeType : null;
                }
                this.refreshUI();
            }
        }
    }

    private boolean isVimeoUrl(String url) {
        try {
            RegExp urlPattern = RegExp.compile((String)"^(.*:)//([A-Za-z0-9\\-\\.]+)(:[0-9]+)?(.*)$");
            MatchResult matchResult = urlPattern.exec(url);
            String host = matchResult.getGroup(2);
            return host.contains("vimeo.com");
        }
        catch (Exception e) {
            return false;
        }
    }

    private void loadMediaDuration() {
        Audio mediaBase = Audio.createIfSupported();
        if (mediaBase != null) {
            this.addLoadMetadataHandler(mediaBase.getMediaElement());
            mediaBase.setPreload("metadata");
            mediaBase.setSrc(this.mediaTrack.url);
            mediaBase.load();
        }
    }

    native void addLoadMetadataHandler(MediaElement var1);

    public void loadedmetadata(MediaElement mediaElement) {
        double duration;
        if (!this.manuallyEditedStartTime) {
            this.mediaTrack.startTime = this.defaultStartTime;
        }
        this.mediaTrack.duration = (duration = mediaElement.getDuration()) > 0.0 ? new MillisecondsDurationImpl(Math.round(duration * 1000.0)) : DEFAULT_DURATION;
        this.refreshUI();
        this.validateAndUpdate();
    }

    protected Widget getAdditionalWidget() {
        NewMediaDialogResources.INSTANCE.css().ensureInjected();
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.addStyleName(NewMediaDialogResources.INSTANCE.css().textfieldSizeClass());
        mainPanel.addStyleName(NewMediaDialogResources.INSTANCE.css().datePickerClass());
        Grid formGrid = new Grid(6, 2);
        formGrid.setCellSpacing(3);
        formGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.fileUpload()) + ":"));
        formGrid.setWidget(0, 1, (Widget)this.urlBox);
        formGrid.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.name()) + ":"));
        FlowPanel namePanel = new FlowPanel();
        namePanel.addStyleName(NewMediaDialogResources.INSTANCE.css().fieldGroup());
        namePanel.add((Widget)this.nameBox);
        namePanel.add((Widget)this.resetNameButton);
        formGrid.setWidget(1, 1, (Widget)namePanel);
        this.infoLabelLabel = new Label();
        formGrid.setWidget(2, 0, (Widget)this.infoLabelLabel);
        this.infoLabel = new SimplePanel();
        this.infoLabel.setWidget((Widget)new Label(""));
        formGrid.setWidget(2, 1, (Widget)this.infoLabel);
        formGrid.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.startTime()) + ":"));
        FlowPanel startTimePanel = new FlowPanel();
        startTimePanel.addStyleName(NewMediaDialogResources.INSTANCE.css().fieldGroup());
        startTimePanel.add((Widget)this.startTimeBox);
        startTimePanel.add((Widget)this.defaultTimeButton);
        formGrid.setWidget(3, 1, (Widget)startTimePanel);
        formGrid.setWidget(4, 0, (Widget)new Label(String.valueOf(this.stringMessages.duration()) + ":"));
        formGrid.setWidget(4, 1, (Widget)this.durationBox);
        this.busyIndicator = new SimpleBusyIndicator();
        formGrid.setWidget(5, 0, (Widget)this.busyIndicator);
        mainPanel.add((Widget)formGrid);
        FlowPanel progressOverlay = new FlowPanel();
        progressOverlay.addStyleName(NewMediaDialogResources.INSTANCE.css().progressOverlay());
        FlowPanel progressSpinner = new FlowPanel();
        progressSpinner.addStyleName(NewMediaDialogResources.INSTANCE.css().progressSpinner());
        Label counter = new Label("0%");
        counter.addStyleName(NewMediaDialogResources.INSTANCE.css().progressCounter());
        progressOverlay.add((Widget)progressSpinner);
        progressOverlay.add((Widget)counter);
        progressOverlay.setVisible(false);
        8 t = new /* Unavailable Anonymous Inner Class!! */;
        this.urlBox.setStartUploadEvent((StartUploadEvent)new /* Unavailable Anonymous Inner Class!! */);
        this.urlBox.setEndUploadEvent((EndUploadEvent)new /* Unavailable Anonymous Inner Class!! */);
        mainPanel.add((Widget)progressOverlay);
        return mainPanel;
    }

    private void requestProgressPercentage(Timer t, Label counter) {
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, PROGRESS_STATUS_URL);
        builder.setHeader((String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER.getA(), (String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER.getB());
        try {
            builder.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.logger.log(Level.SEVERE, "Error occured while requesting upload status. (2)", e);
            t.cancel();
        }
    }

    private String sliceBefore(String lastPathSegment, String slicer) {
        int paramSegment = lastPathSegment.indexOf(slicer);
        if (paramSegment > 0) {
            return lastPathSegment.substring(0, paramSegment);
        }
        return lastPathSegment;
    }

    public void setBusy(boolean busy) {
        this.busyIndicator.setBusy(busy);
    }

    protected void refreshUI() {
        this.nameBox.setValue((Object)this.mediaTrack.title, false);
        if (this.mediaTrack.isYoutube()) {
            this.infoLabelLabel.setText(String.valueOf(this.stringMessages.youtubeId()) + ":");
            this.infoLabel.setWidget((Widget)new Label(this.mediaTrack.url));
        } else {
            this.infoLabelLabel.setText(String.valueOf(this.stringMessages.mimeType()) + ":");
            if (this.mediaTrack.mimeType != null && this.mediaTrack.mimeType.getMediaSubType() == MediaSubType.mp4) {
                if (!this.remoteMp4WasStarted) {
                    this.processMp4(this.mediaTrack);
                } else if (this.remoteMp4WasFinished) {
                    this.manualMimeTypeSelection(null, this.mediaTrack, MimeType.mp4MimeTypes());
                } else {
                    this.infoLabel.setWidget((Widget)new Label(this.stringMessages.processingMP4()));
                }
            } else if (this.mediaTrack.mimeType == MimeType.vimeo) {
                this.infoLabel.setWidget((Widget)new Label(this.mediaTrack.typeToString()));
            } else {
                this.manualMimeTypeSelection(null, this.mediaTrack, new MimeType[]{MimeType.mp4, MimeType.mp4panorama, MimeType.mp4panoramaflip, MimeType.youtube, MimeType.vimeo, MimeType.mov, MimeType.ogg, MimeType.aac, MimeType.mp3});
            }
        }
        this.startTimeBox.setValue(this.mediaTrack.startTime == null ? null : this.mediaTrack.startTime.asDate(), false);
        if (this.mediaTrack.duration != null) {
            this.durationBox.setValue((Object)TimeFormatUtil.durationToHrsMinSec((Duration)this.mediaTrack.duration), false);
        } else {
            this.durationBox.setValue((Object)DEFAULT_DURATION.toString(), false);
        }
        this.refreshPopupPosition();
    }

    public void show() {
        super.show();
        this.refreshPopupPosition();
    }

    private void refreshPopupPosition() {
        if (!DeviceDetector.isDesktop()) {
            DialogBox popup = super.getDialogBox();
            popup.setPopupPositionAndShow((width, height) -> {
                popup.getElement().getStyle().clearTop();
                popup.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            });
        }
    }

    public void onFileStorageServiceTestPassed() {
        this.urlBox.setUploadEnabled(true);
    }

    private void processMp4(MediaTrack mediaTrack) {
        this.busyIndicator.setBusy(true);
        this.remoteMp4WasStarted = true;
        this.remoteMp4WasFinished = false;
        Label infoLbl = new Label(this.stringMessages.processingMP4());
        this.infoLabel.setWidget((Widget)infoLbl);
        this.checkMetadata(mediaTrack.url, infoLbl, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void checkMetadata(String url, Label lbl, AsyncCallback<VideoMetadataDTO> asyncCallback) {
        this.mediaService.checkMetadata(this.mediaTrack.url, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void mp4MetadataResult(VideoMetadataDTO result) {
        if (!result.isDownloadable()) {
            Notification.notify((String)this.stringMessages.couldNotDownload(this.mediaTrack.url), (Notification.NotificationType)Notification.NotificationType.ERROR);
            this.manualMimeTypeSelection(result.getMessage(), this.mediaTrack, MimeType.mp4MimeTypes());
        } else {
            this.mediaTrack.duration = result.getDuration();
            if (this.mediaTrack.duration == null) {
                this.loadMediaDuration();
            } else {
                this.mediaTrack.duration = DEFAULT_DURATION;
            }
            MimeType mimeType = this.mediaTrack.mimeType = result.isSpherical() ? MimeType.mp4panorama : MimeType.mp4;
            if (result.getRecordStartedTime() != null && !this.manuallyEditedStartTime) {
                this.mediaTrack.startTime = new MillisecondsTimePoint(result.getRecordStartedTime());
            }
            this.refreshUI();
            this.validateAndUpdate();
        }
    }

    private void manualMimeTypeSelection(String message, MediaTrack mediaTrack, MimeType[] proposedMimeTypes) {
        FlowPanel fp = new FlowPanel();
        if (message != null) {
            fp.add((Widget)new Label(message));
        }
        this.mimeTypeListBox = this.createListBox(false);
        this.mimeTypeListBox.addItem(this.stringMessages.pleaseSelect(), "");
        int i = 0;
        while (i < proposedMimeTypes.length) {
            this.mimeTypeListBox.addItem(proposedMimeTypes[i].name());
            ++i;
        }
        this.mimeTypeListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        fp.add((Widget)this.mimeTypeListBox);
        this.infoLabel.setWidget((Widget)fp);
        this.updateBoxByMimeType();
    }

    protected Focusable getInitialFocusWidget() {
        return this.urlBox.getInitialFocusWidget();
    }

    public void openFileChooserDialog() {
        this.urlBox.fireClickToFileUploadField();
    }

    static /* synthetic */ TextBox access$1(NewMediaDialog newMediaDialog) {
        return newMediaDialog.nameBox;
    }

    static /* synthetic */ URLFieldWithFileUpload access$2(NewMediaDialog newMediaDialog) {
        return newMediaDialog.urlBox;
    }

    static /* synthetic */ void access$3(NewMediaDialog newMediaDialog, boolean bl) {
        newMediaDialog.manuallyEditedStartTime = bl;
    }

    static /* synthetic */ TextBox access$4(NewMediaDialog newMediaDialog) {
        return newMediaDialog.durationBox;
    }

    static /* synthetic */ Duration access$5() {
        return DEFAULT_DURATION;
    }

    static /* synthetic */ SimplePanel access$6(NewMediaDialog newMediaDialog) {
        return newMediaDialog.infoLabel;
    }

    static /* synthetic */ void access$7(NewMediaDialog newMediaDialog, Timer timer, Label label) {
        newMediaDialog.requestProgressPercentage(timer, label);
    }

    static /* synthetic */ Logger access$8(NewMediaDialog newMediaDialog) {
        return newMediaDialog.logger;
    }

    static /* synthetic */ SimpleBusyIndicator access$9(NewMediaDialog newMediaDialog) {
        return newMediaDialog.busyIndicator;
    }

    static /* synthetic */ void access$10(NewMediaDialog newMediaDialog, boolean bl) {
        newMediaDialog.remoteMp4WasFinished = bl;
    }

    static /* synthetic */ void access$11(NewMediaDialog newMediaDialog, String string, MediaTrack mediaTrack, MimeType[] mimeTypeArray) {
        newMediaDialog.manualMimeTypeSelection(string, mediaTrack, mimeTypeArray);
    }

    static /* synthetic */ MediaServiceAsync access$12(NewMediaDialog newMediaDialog) {
        return newMediaDialog.mediaService;
    }

    static /* synthetic */ ListBox access$13(NewMediaDialog newMediaDialog) {
        return newMediaDialog.mimeTypeListBox;
    }
}

