/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.media.MediaSynchAdapter;
import com.sap.sailing.gwt.ui.client.media.MediaSynchControl;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;

public class MediaSynchControl
implements MediaSynchAdapter.EditFlag {
    private static final int FAST = 1000;
    private static final int SLOW = 100;
    private final MediaServiceWriteAsync mediaServiceWrite;
    private final MediaSynchAdapter mediaSynchAdapter;
    private final ErrorReporter errorReporter;
    private final MediaTrack backupVideoTrack;
    private final FlowPanel mainPanel;
    private final FlowPanel editPanel;
    private final FlowPanel commitPanel;
    private final FlowPanel fineTuningPanel;
    private final TextBox titleEdit;
    private final EditButtonProxy editButton;
    private final Button previewButton;
    private final Button saveButton;
    private final Button discardButton;
    private boolean isEditing = false;
    private UserService userservice;

    public MediaSynchControl(MediaSynchAdapter mediaSynchAdapter, MediaServiceWriteAsync mediaServiceWrite, ErrorReporter errorReporter, EditButtonProxy editButtonProxy, UserService userservice) {
        this.mediaServiceWrite = mediaServiceWrite;
        this.mediaSynchAdapter = mediaSynchAdapter;
        this.errorReporter = errorReporter;
        this.userservice = userservice;
        MediaTrackWithSecurityDTO videoTrack = this.mediaSynchAdapter.getMediaTrack();
        this.backupVideoTrack = new MediaTrack(videoTrack.title, videoTrack.url, videoTrack.startTime, videoTrack.duration, videoTrack.mimeType, videoTrack.assignedRaces);
        this.mainPanel = new FlowPanel();
        this.mainPanel.addStyleName("main-panel");
        this.editPanel = new FlowPanel();
        this.fineTuningPanel = new FlowPanel();
        this.fineTuningPanel.addStyleName("finetuning-panel");
        this.commitPanel = new FlowPanel();
        this.commitPanel.addStyleName("button-panel");
        this.editButton = editButtonProxy;
        this.titleEdit = new TextBox();
        this.titleEdit.setText(videoTrack.title);
        this.titleEdit.addStyleName("title-edit");
        this.titleEdit.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button fastRewindButton = new Button("-1s &#171;", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button slowRewindButton = new Button("-0.1s &#8249;", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button slowForwardButton = new Button("&#8250; +0.1s", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button fastForwardButton = new Button("&#187; + 1s", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton.addAction((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton.setTitle("Pauses race and decouples race from video playback. Use video controls, race time slider or fine tuning buttons for time alignment, then press Preview to re-couple race and video playback.");
        this.previewButton = new Button("Preview", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.previewButton.setTitle("Re-couples race and video playback. If ok, press Save to write changes back to database. Press Cancel to reset the changes.");
        this.saveButton = new Button("Save", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.saveButton.addStyleName("confirm-button");
        this.discardButton = new Button("Cancel", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.fineTuningPanel.add((Widget)fastRewindButton);
        this.fineTuningPanel.add((Widget)slowRewindButton);
        this.fineTuningPanel.add((Widget)slowForwardButton);
        this.fineTuningPanel.add((Widget)fastForwardButton);
        this.mainPanel.add((Widget)this.titleEdit);
        this.editPanel.add((Widget)this.previewButton);
        this.mainPanel.add((Widget)this.editPanel);
        this.mainPanel.add((Widget)this.fineTuningPanel);
        this.commitPanel.add((Widget)this.saveButton);
        this.commitPanel.add((Widget)this.discardButton);
        this.mainPanel.add((Widget)this.commitPanel);
        10 userHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.mainPanel.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.updateUiState();
    }

    protected void preview() {
        this.isEditing = false;
        this.pausePlayback();
        this.mediaSynchAdapter.updateOffset();
        this.updateUiState();
    }

    protected void edit() {
        this.pausePlayback();
        this.isEditing = true;
        this.updateUiState();
    }

    private void pausePlayback() {
        this.mediaSynchAdapter.pauseMedia();
        this.mediaSynchAdapter.pauseRace();
    }

    private void discard() {
        this.mediaSynchAdapter.getMediaTrack().title = this.backupVideoTrack.title;
        this.titleEdit.setText(this.mediaSynchAdapter.getMediaTrack().title);
        this.mediaSynchAdapter.getMediaTrack().startTime = this.backupVideoTrack.startTime;
        this.isEditing = false;
        this.pausePlayback();
        this.mediaSynchAdapter.forceAlign();
        this.updateUiState();
    }

    private void save() {
        if (!this.backupVideoTrack.startTime.equals(this.mediaSynchAdapter.getMediaTrack().startTime)) {
            this.mediaServiceWrite.updateStartTime((MediaTrack)this.mediaSynchAdapter.getMediaTrack(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!this.backupVideoTrack.title.equals(this.mediaSynchAdapter.getMediaTrack().title)) {
            this.mediaServiceWrite.updateTitle((MediaTrack)this.mediaSynchAdapter.getMediaTrack(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateUiState() {
        boolean showEditUI = this.isEditing || this.isDirty();
        int i = 0;
        while (i < this.fineTuningPanel.getWidgetCount()) {
            Widget widget = this.fineTuningPanel.getWidget(i);
            if (widget instanceof FocusWidget) {
                ((FocusWidget)widget).setEnabled(showEditUI);
            }
            ++i;
        }
        this.mediaSynchAdapter.setControlsVisible(showEditUI);
        this.previewButton.setEnabled(showEditUI);
        MediaTrackWithSecurityDTO videoTrack = this.mediaSynchAdapter.getMediaTrack();
        this.editButton.setEnabled(this.hasRightToEdit(videoTrack) && !showEditUI);
        this.mainPanel.getElement().getStyle().setDisplay(showEditUI && this.hasRightToEdit(videoTrack) ? Style.Display.BLOCK : Style.Display.NONE);
        boolean isDirty = this.isDirty();
        this.saveButton.setEnabled(showEditUI || isDirty);
        this.discardButton.setEnabled(showEditUI || isDirty);
    }

    private boolean hasRightToEdit(MediaTrackWithSecurityDTO video) {
        return this.userservice.hasPermission((SecuredDTO)video, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
    }

    private boolean isDirty() {
        return !this.backupVideoTrack.startTime.equals(this.mediaSynchAdapter.getMediaTrack().startTime) || !this.backupVideoTrack.title.equals(this.titleEdit.getText());
    }

    private void fastForward() {
        this.changeOffsetBy(-1000);
    }

    private void slowForward() {
        this.changeOffsetBy(-100);
    }

    private void slowRewind() {
        this.changeOffsetBy(100);
    }

    private void fastRewind() {
        this.changeOffsetBy(1000);
    }

    private void changeOffsetBy(int delta) {
        this.mediaSynchAdapter.changeOffsetBy((long)delta);
        this.updateUiState();
    }

    public Widget widget() {
        return this.mainPanel;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    static /* synthetic */ TextBox access$0(MediaSynchControl mediaSynchControl) {
        return mediaSynchControl.titleEdit;
    }

    static /* synthetic */ MediaSynchAdapter access$1(MediaSynchControl mediaSynchControl) {
        return mediaSynchControl.mediaSynchAdapter;
    }

    static /* synthetic */ void access$2(MediaSynchControl mediaSynchControl) {
        mediaSynchControl.updateUiState();
    }

    static /* synthetic */ void access$3(MediaSynchControl mediaSynchControl) {
        mediaSynchControl.fastRewind();
    }

    static /* synthetic */ void access$4(MediaSynchControl mediaSynchControl) {
        mediaSynchControl.slowRewind();
    }

    static /* synthetic */ void access$5(MediaSynchControl mediaSynchControl) {
        mediaSynchControl.slowForward();
    }

    static /* synthetic */ void access$6(MediaSynchControl mediaSynchControl) {
        mediaSynchControl.fastForward();
    }

    static /* synthetic */ void access$7(MediaSynchControl mediaSynchControl) {
        mediaSynchControl.save();
    }

    static /* synthetic */ void access$8(MediaSynchControl mediaSynchControl) {
        mediaSynchControl.discard();
    }

    static /* synthetic */ MediaTrack access$9(MediaSynchControl mediaSynchControl) {
        return mediaSynchControl.backupVideoTrack;
    }

    static /* synthetic */ ErrorReporter access$10(MediaSynchControl mediaSynchControl) {
        return mediaSynchControl.errorReporter;
    }
}

