/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.AbstractMediaSelectionControl;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManager;
import com.sap.sse.common.media.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MediaManagementControl
extends AbstractMediaSelectionControl
implements CloseHandler<PopupPanel> {
    private final DialogBox dialogControl;
    private final Map<MediaTrack, CheckBox> videoCheckBoxes = new HashMap();
    private final UIObject popupLocation;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$common$media$MediaType;

    public MediaManagementControl(MediaPlayerManager mediaPlayerManager, UIObject popupLocation, StringMessages stringMessages) {
        super(mediaPlayerManager, stringMessages);
        this.popupLocation = popupLocation;
        this.dialogControl = new DialogBox(true, false);
        this.dialogControl.setText(stringMessages.managePlaybackMedia());
        this.dialogControl.addCloseHandler((CloseHandler)this);
    }

    public void show() {
        ArrayList videoTracks = new ArrayList();
        ArrayList audioTracks = new ArrayList();
        this.filterGivenMediaTracksTo(videoTracks, audioTracks, (Iterable)this.mediaPlayerManager.getAssignedMediaTracks());
        this.filterGivenMediaTracksTo(videoTracks, audioTracks, (Iterable)this.mediaPlayerManager.getOverlappingMediaTracks());
        VerticalPanel grid = new VerticalPanel();
        this.addAudioTracksToGridPanel(audioTracks, (Panel)grid);
        this.addVideoTracksToGridPanel(videoTracks, (Panel)grid);
        this.addNewMediaButtonsTo((Panel)grid);
        this.dialogControl.add((Widget)grid);
        this.dialogControl.showRelativeTo(this.popupLocation);
    }

    private void addNewMediaButtonsTo(Panel grid) {
        HorizontalPanel controlButtons = new HorizontalPanel();
        controlButtons.setWidth("100%");
        if (this.mediaPlayerManager.allowsCreating()) {
            Button addButton = new Button(this.stringMessages.add(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            addButton.addStyleName("btn-secondary");
            controlButtons.add((Widget)addButton);
        }
        Button closeButton = new Button(this.stringMessages.close(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        closeButton.addStyleName("btn-secondary");
        controlButtons.add((Widget)closeButton);
        controlButtons.setCellHorizontalAlignment((Widget)closeButton, HasHorizontalAlignment.ALIGN_RIGHT);
        grid.add((Widget)controlButtons);
    }

    private void addVideoTracksToGridPanel(Collection<MediaTrackWithSecurityDTO> videoTracks, Panel grid) {
        if (!videoTracks.isEmpty()) {
            grid.add((Widget)new Label(this.stringMessages.videos()));
            for (MediaTrackWithSecurityDTO videoTrack : videoTracks) {
                grid.add(this.createVideoOptions(videoTrack, this.mediaPlayerManager.getPlayingVideoTracks()));
            }
        }
    }

    private void addAudioTracksToGridPanel(Collection<MediaTrackWithSecurityDTO> audioTracks, Panel grid) {
        if (!audioTracks.isEmpty()) {
            grid.add((Widget)new Label(this.stringMessages.audioFiles()));
            grid.add(this.createAudioButton(null));
            for (MediaTrackWithSecurityDTO audioTrack : audioTracks) {
                grid.add(this.createAudioButton(audioTrack));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void filterGivenMediaTracksTo(Collection<MediaTrackWithSecurityDTO> videoTracks, Collection<MediaTrackWithSecurityDTO> audioTracks, Iterable<MediaTrackWithSecurityDTO> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Widget createVideoOptions(MediaTrackWithSecurityDTO videoTrack, Set<MediaTrack> selectedVideos) {
        CheckBox videoCheckBox = new CheckBox(videoTrack.title);
        this.videoCheckBoxes.put(videoTrack, videoCheckBox);
        videoCheckBox.setTitle(videoTrack.toString());
        videoCheckBox.setValue(Boolean.valueOf(selectedVideos.contains(videoTrack)));
        videoCheckBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.mediaPlayerManager.allowsEditing(videoTrack)) {
            HorizontalPanel panel = new HorizontalPanel();
            panel.setWidth("100%");
            panel.add((Widget)videoCheckBox);
            Button deleteButton = this.createDeleteButton(videoTrack);
            panel.add((Widget)deleteButton);
            ToggleButton connectButton = this.createConnectButton(videoTrack);
            panel.setCellHorizontalAlignment((Widget)deleteButton, HasHorizontalAlignment.ALIGN_RIGHT);
            panel.add((Widget)connectButton);
            panel.setCellHorizontalAlignment((Widget)connectButton, HasHorizontalAlignment.ALIGN_RIGHT);
            panel.setCellWidth((Widget)connectButton, "13");
            this.setVideoPlayCheckboxEnabled((MediaTrack)videoTrack, connectButton.getValue().booleanValue());
            return panel;
        }
        return videoCheckBox;
    }

    private ToggleButton createConnectButton(MediaTrackWithSecurityDTO videoTrack) {
        ToggleButton connectButton = new ToggleButton();
        connectButton.setValue(Boolean.valueOf(videoTrack.assignedRaces.contains(this.mediaPlayerManager.getCurrentRace())));
        connectButton.setTitle("Connect video to this race");
        connectButton.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return connectButton;
    }

    private void setVideoPlayCheckboxEnabled(MediaTrack videoTrack, boolean enable) {
        CheckBox videoCheckBox = (CheckBox)this.videoCheckBoxes.get(videoTrack);
        videoCheckBox.setEnabled(enable);
    }

    private void disconnectVideoFromRace(MediaTrackWithSecurityDTO videoTrack, ToggleButton connectButton) {
        videoTrack.assignedRaces.remove(this.mediaPlayerManager.getCurrentRace());
        this.mediaPlayerManager.getMediaServiceWrite().updateRace((MediaTrack)videoTrack, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void connectVideoToRace(MediaTrack videoTrack, ToggleButton connectButton) {
        videoTrack.assignedRaces.add(this.mediaPlayerManager.getCurrentRace());
        this.mediaPlayerManager.getMediaServiceWrite().updateRace(videoTrack, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Button createDeleteButton(MediaTrackWithSecurityDTO videoTrack) {
        Button deleteButton = new Button("X", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return deleteButton;
    }

    private Widget createAudioButton(MediaTrackWithSecurityDTO audioTrack) {
        String label = audioTrack != null ? audioTrack.title : this.stringMessages.soundOff();
        String title = audioTrack != null ? audioTrack.toString() : this.stringMessages.turnOffAllSoundChannels();
        RadioButton audioButton = new RadioButton("group-name", label);
        audioButton.setTitle(title);
        audioButton.setValue(Boolean.valueOf(audioTrack == this.mediaPlayerManager.getPlayingAudioTrack()));
        audioButton.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.mediaPlayerManager.allowsEditing(audioTrack) && audioTrack != null) {
            HorizontalPanel panel = new HorizontalPanel();
            panel.setWidth("100%");
            panel.add((Widget)audioButton);
            Button deleteButton = this.createDeleteButton(audioTrack);
            panel.add((Widget)deleteButton);
            panel.setCellHorizontalAlignment((Widget)deleteButton, HasHorizontalAlignment.ALIGN_RIGHT);
            return panel;
        }
        return audioButton;
    }

    public void onClose(CloseEvent<PopupPanel> arg0) {
        this.dialogControl.clear();
        this.videoCheckBoxes.clear();
    }

    public boolean isShowing() {
        return this.dialogControl.isShowing();
    }

    public void hide() {
        this.dialogControl.hide(false);
    }

    protected void updateUi() {
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$common$media$MediaType() {
        if ($SWITCH_TABLE$com$sap$sse$common$media$MediaType != null) {
            return $SWITCH_TABLE$com$sap$sse$common$media$MediaType;
        }
        int[] nArray = new int[MediaType.values().length];
        try {
            nArray[MediaType.audio.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MediaType.image.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MediaType.unknown.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MediaType.video.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sse$common$media$MediaType = nArray;
        return nArray;
    }

    static /* synthetic */ void access$1(MediaManagementControl mediaManagementControl, MediaTrack mediaTrack, ToggleButton toggleButton) {
        mediaManagementControl.connectVideoToRace(mediaTrack, toggleButton);
    }

    static /* synthetic */ void access$2(MediaManagementControl mediaManagementControl, MediaTrackWithSecurityDTO mediaTrackWithSecurityDTO, ToggleButton toggleButton) {
        mediaManagementControl.disconnectVideoFromRace(mediaTrackWithSecurityDTO, toggleButton);
    }

    static /* synthetic */ void access$3(MediaManagementControl mediaManagementControl, MediaTrack mediaTrack, boolean bl) {
        mediaManagementControl.setVideoPlayCheckboxEnabled(mediaTrack, bl);
    }
}

