/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.dom.client.MediaElement;
import com.google.gwt.media.client.MediaBase;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.media.shared.AbstractMediaPlayer;

public abstract class AbstractHtmlMediaPlayer
extends AbstractMediaPlayer {
    private boolean isReady = false;
    private double deferredMediaTime;
    private double deferredPlaybackSpeed = 1.0;
    private boolean deferredIsPlaying;
    private boolean deferredIsMuted;
    protected final MediaBase mediaElement = this.createMediaElement();

    public AbstractHtmlMediaPlayer(MediaTrackWithSecurityDTO mediaTrack) {
        super(mediaTrack);
        if (this.mediaElement != null) {
            this.mediaElement.setControls(false);
            this.mediaElement.setAutoplay(false);
            this.mediaElement.setLoop(false);
            this.mediaElement.setMuted(false);
            this.mediaElement.setPreload("auto");
            this.addNativeEventHandlers(this.mediaElement.getMediaElement());
            this.mediaElement.setSrc(mediaTrack.url);
            this.mediaElement.setTitle(mediaTrack.title);
        }
    }

    protected abstract MediaBase createMediaElement();

    native void addNativeEventHandlers(MediaElement var1);

    private void initPlayState() {
        if (!this.isReady && this.mediaElement != null) {
            this.mediaElement.setCurrentTime(Math.min(this.deferredMediaTime, this.mediaElement.getDuration()));
            this.mediaElement.setMuted(this.deferredIsMuted);
            this.mediaElement.setPlaybackRate(this.deferredPlaybackSpeed);
            if (this.deferredIsPlaying) {
                this.mediaElement.play();
            } else {
                this.mediaElement.pause();
            }
        }
        this.isReady = true;
    }

    public boolean isMediaPaused() {
        if (this.isReady) {
            return this.mediaElement.isPaused();
        }
        return !this.deferredIsPlaying;
    }

    public void pauseMedia() {
        this.deferredIsPlaying = false;
        if (this.isReady && this.mediaElement != null) {
            this.mediaElement.pause();
        }
    }

    public void playMedia() {
        this.deferredIsPlaying = true;
        if (this.isReady && this.mediaElement != null) {
            this.mediaElement.play();
        }
    }

    public void setPlaybackSpeed(double playbackSpeed) {
        this.deferredPlaybackSpeed = playbackSpeed;
        if (this.isReady && this.mediaElement != null) {
            this.mediaElement.setPlaybackRate(playbackSpeed);
        }
    }

    public void setMuted(boolean isToBeMuted) {
        this.deferredIsMuted = isToBeMuted;
        if (this.isReady && this.mediaElement != null) {
            this.mediaElement.setMuted(isToBeMuted);
        }
    }

    public double getDuration() {
        if (this.isReady) {
            return this.mediaElement.getDuration();
        }
        return Double.NaN;
    }

    public double getCurrentMediaTime() {
        if (this.isReady) {
            return this.mediaElement.getCurrentTime();
        }
        return Double.NaN;
    }

    public void setCurrentMediaTime(double mediaTime) {
        this.deferredMediaTime = mediaTime;
        if (this.isReady && this.mediaElement != null) {
            this.mediaElement.setCurrentTime(Math.min(mediaTime, this.mediaElement.getDuration()));
        }
    }

    public void shutDown() {
        this.mediaElement.pause();
        this.mediaElement.setSrc(null);
    }
}

