/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IntegerBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.ClientResources;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.TimePanelCssResources;
import com.sap.sailing.gwt.ui.client.TimePanelSettings;
import com.sap.sailing.gwt.ui.client.TimePanelSettingsDialogComponent;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.controls.slider.SliderBar;
import com.sap.sse.gwt.client.controls.slider.TimeSlider;
import com.sap.sse.gwt.client.player.PlayStateListener;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.TimeRangeChangeListener;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.TimeZoomChangeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.Date;
import java.util.Optional;

public class TimePanel<T extends TimePanelSettings>
extends AbstractCompositeComponent<T>
implements TimeListener,
TimeZoomChangeListener,
TimeRangeChangeListener,
PlayStateListener,
RequiresResize {
    protected final Timer timer;
    protected final TimeRangeWithZoomProvider timeRangeProvider;
    private final boolean canReplayWhileLiveIsPossible;
    private final IntegerBox playSpeedBox;
    private final Label timeDelayLabel;
    private final Label timeLabel;
    private final Label dateLabel;
    private final Label timeToStartLabel;
    private final FlowPanel timeToStartControlPanel;
    private final Label playModeLabel;
    protected final TimeSlider timeSlider;
    private final Button backToLivePlayButton;
    protected final StringMessages stringMessages;
    protected final DateTimeFormat dateFormatter = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_FULL);
    protected final DateTimeFormat timeFormatter = DateTimeFormat.getFormat((String)"HH:mm:ss");
    protected final DateTimeFormat timeFormatterDetailed = DateTimeFormat.getFormat((String)"HH:mm:ss:SS");
    private final ImageResource playSpeedImg;
    private final ImageResource playModeLiveActiveImg;
    private final ImageResource playModeReplayActiveImg;
    private final ImageResource playModeInactiveImg;
    private final Button playPauseButton;
    private final Image playModeImage;
    protected Date lastReceivedDataTimepoint;
    private final Button slowDownButton;
    private final Button speedUpButton;
    private final Button toggleAdvancedModeButton;
    private final Button resetZoomButton;
    private final FlowPanel controlsPanel;
    private final SimplePanel timePanelSlider;
    private final FlowPanel timePanelSliderFlowWrapper;
    private final FlowPanel playControlPanel;
    private final FlowPanel timePanelInnerWrapper;
    private final SecuredDTO raceDTO;
    private long MINIMUM_AUTO_ADVANCE_TIME_IN_MS = 300000L;
    private boolean advancedModeShown;
    private static ClientResources resources = (ClientResources)GWT.create(ClientResources.class);
    protected static TimePanelCssResources.TimePanelCss timePanelCss = TimePanelCssResources.INSTANCE.css();
    private final boolean forcePaddingRightToAlignToCharts;
    private UserService userService;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates;

    public TimePanel(Component<?> parent, ComponentContext<?> context, Timer timer, TimeRangeWithZoomProvider timeRangeProvider, StringMessages stringMessages, boolean canReplayWhileLiveIsPossible, boolean forcePaddingRightToAlignToCharts, UserService userService, SecuredDTO raceDTO) {
        super(parent, context);
        this.raceDTO = raceDTO;
        this.userService = userService;
        this.timer = timer;
        this.timeRangeProvider = timeRangeProvider;
        this.stringMessages = stringMessages;
        this.canReplayWhileLiveIsPossible = canReplayWhileLiveIsPossible;
        this.forcePaddingRightToAlignToCharts = forcePaddingRightToAlignToCharts;
        timer.addTimeListener((TimeListener)this);
        timer.addPlayStateListener((PlayStateListener)this);
        timeRangeProvider.addTimeRangeChangeListener((TimeRangeChangeListener)this);
        this.timePanelInnerWrapper = new FlowPanel();
        this.timePanelInnerWrapper.setStyleName("timePanelInnerWrapper");
        this.timePanelInnerWrapper.setSize("100%", "100%");
        this.timePanelSlider = new SimplePanel();
        this.timePanelSliderFlowWrapper = new FlowPanel();
        this.timePanelSlider.setStyleName("timePanelSlider");
        this.timePanelSlider.getElement().getStyle().setPaddingLeft(66.0, Style.Unit.PX);
        this.timePanelSliderFlowWrapper.add((Widget)this.timePanelSlider);
        this.playSpeedImg = resources.timesliderPlaySpeedIcon();
        this.playPauseButton = new Button("");
        this.playModeLiveActiveImg = resources.timesliderPlayStateLiveActiveIcon();
        this.playModeReplayActiveImg = resources.timesliderPlayStateReplayActiveIcon();
        this.playModeInactiveImg = resources.timesliderPlayStateLiveInactiveIcon();
        this.playModeImage = new Image(this.playModeInactiveImg);
        this.timeSlider = new TimeSlider();
        this.timeSlider.setEnabled(true);
        this.timeSlider.setLabelFormatter((SliderBar.LabelFormatter)new /* Unavailable Anonymous Inner Class!! */);
        this.timeSlider.ensureDebugId("timeSlider");
        this.timeSlider.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.timePanelInnerWrapper.add((Widget)this.timePanelSliderFlowWrapper);
        this.timePanelSlider.add((Widget)this.timeSlider);
        this.controlsPanel = new FlowPanel();
        this.controlsPanel.setStyleName("timePanel-controls");
        this.timePanelInnerWrapper.add((Widget)this.controlsPanel);
        this.playControlPanel = new FlowPanel();
        this.playControlPanel.setStyleName("timePanel-controls-play");
        this.controlsPanel.add((Widget)this.playControlPanel);
        this.toggleAdvancedModeButton = this.createToggleAdvancedModeButton();
        this.playControlPanel.add((Widget)this.toggleAdvancedModeButton);
        this.playPauseButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.playPauseButton.setTitle(stringMessages.startStopPlaying());
        this.playPauseButton.setStyleName("playPauseButton");
        this.playControlPanel.add((Widget)this.playPauseButton);
        this.backToLivePlayButton = new Button(stringMessages.raceIsInLiveTimePanelMode());
        this.backToLivePlayButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.backToLivePlayButton.setStyleName("backToLivePlayButton");
        this.backToLivePlayButton.setTitle(stringMessages.backToLive());
        this.playControlPanel.add((Widget)this.backToLivePlayButton);
        FlowPanel timeControlPanel = new FlowPanel();
        timeControlPanel.setStyleName("timePanel-controls-time");
        this.dateLabel = new Label();
        this.timeLabel = new Label();
        timeControlPanel.add((Widget)this.dateLabel);
        timeControlPanel.add((Widget)this.timeLabel);
        this.dateLabel.getElement().setClassName("dateLabel");
        this.timeLabel.getElement().setClassName("timeLabel");
        this.timeToStartControlPanel = new FlowPanel();
        this.timeToStartControlPanel.setStyleName("timePanel-controls-timeToStart");
        this.timeToStartLabel = new Label();
        this.timeToStartControlPanel.add((Widget)this.timeToStartLabel);
        this.timeToStartLabel.getElement().setClassName("timeToStartLabel");
        FlowPanel playModeControlPanel = new FlowPanel();
        playModeControlPanel.setStyleName("timePanel-controls-playmode");
        playModeControlPanel.add((Widget)this.playModeImage);
        this.playModeImage.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.playModeLabel = new Label();
        playModeControlPanel.add((Widget)this.playModeLabel);
        this.playModeLabel.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.playModeLabel.getElement().setClassName("playModeLabel");
        FlowPanel playSpeedControlPanel = new FlowPanel();
        playSpeedControlPanel.setStyleName("timePanel-controls-playSpeed");
        this.playSpeedBox = new IntegerBox();
        this.playSpeedBox.setVisibleLength(3);
        this.playSpeedBox.setValue((Object)((int)timer.getPlaySpeedFactor()));
        this.playSpeedBox.setTitle(stringMessages.playSpeedHelp());
        this.playSpeedBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Image playSpeedImage = new Image(this.playSpeedImg);
        playSpeedControlPanel.add((Widget)playSpeedImage);
        playSpeedControlPanel.add((Widget)this.playSpeedBox);
        this.slowDownButton = new Button("-1");
        this.slowDownButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.slowDownButton.setTitle(stringMessages.slowPlaySpeedDown());
        this.slowDownButton.addStyleName("timePanelButton-SlowDown");
        playSpeedControlPanel.add((Widget)this.slowDownButton);
        this.speedUpButton = new Button("+1");
        this.speedUpButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.speedUpButton.setTitle(stringMessages.speedPlaySpeedUp());
        this.speedUpButton.addStyleName("timePanelButton-SpeedUp");
        playSpeedControlPanel.add((Widget)this.speedUpButton);
        playSpeedImage.getElement().getStyle().setFloat(Style.Float.LEFT);
        playSpeedImage.getElement().getStyle().setPadding(3.0, Style.Unit.PX);
        playSpeedImage.getElement().getStyle().setMarginRight(3.0, Style.Unit.PX);
        this.playSpeedBox.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.playSpeedBox.getElement().getStyle().setPadding(2.0, Style.Unit.PX);
        this.speedUpButton.addStyleName("timePanelButton");
        this.slowDownButton.addStyleName("timePanelButton");
        FlowPanel timeDelayPanel = new FlowPanel();
        timeDelayPanel.setStyleName("timePanel-controls-timeDelay");
        this.timeDelayLabel = new Label();
        timeDelayPanel.add((Widget)this.timeDelayLabel);
        this.timeDelayLabel.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.timeDelayLabel.getElement().getStyle().setPadding(3.0, Style.Unit.PX);
        timePanelCss.ensureInjected();
        this.controlsPanel.add((Widget)this.createSettingsButton());
        this.initWidget((Widget)this.timePanelInnerWrapper);
        this.playStateChanged(timer.getPlayState(), timer.getPlayMode());
        this.controlsPanel.add((Widget)playSpeedControlPanel);
        this.controlsPanel.add((Widget)playModeControlPanel);
        this.controlsPanel.add((Widget)timeDelayPanel);
        this.controlsPanel.add((Widget)timeControlPanel);
        this.controlsPanel.add((Widget)this.timeToStartControlPanel);
        this.resetZoomButton = new Button(stringMessages.resetZoom());
        this.resetZoomButton.setEnabled(false);
        this.resetZoomButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.controlsPanel.add((Widget)this.resetZoomButton);
        this.hideControlsPanel();
    }

    public TimeRangeWithZoomProvider getTimeRangeProvider() {
        return this.timeRangeProvider;
    }

    private Button createSettingsButton() {
        Button settingsButton = SettingsDialog.createSettingsButton((Component)this, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
        settingsButton.setStyleName(timePanelCss.settingsButtonStyle());
        settingsButton.addStyleName(timePanelCss.settingsButtonBackgroundImage());
        return settingsButton;
    }

    private Button createToggleAdvancedModeButton() {
        Button toggleAdvancedModeButton = new Button();
        toggleAdvancedModeButton.setStyleName("TimePanel-ShowExtended-Button");
        toggleAdvancedModeButton.addStyleDependentName("Closed");
        return toggleAdvancedModeButton;
    }

    public boolean toggleAdvancedMode() {
        if (this.advancedModeShown) {
            this.hideControlsPanel();
        } else {
            this.showControlsPanel();
        }
        this.advancedModeShown = !this.advancedModeShown;
        return this.advancedModeShown;
    }

    protected void hideControlsPanel() {
        this.controlsPanel.remove((Widget)this.playControlPanel);
        this.timePanelInnerWrapper.remove((Widget)this.controlsPanel);
        this.timePanelSliderFlowWrapper.insert((Widget)this.playControlPanel, 0);
        this.playControlPanel.setStyleName("timePanel-timeslider-play");
    }

    protected void showControlsPanel() {
        this.timePanelInnerWrapper.add((Widget)this.controlsPanel);
    }

    /*
     * Exception decompiling
     */
    public void timeChanged(Date newTime, Date oldTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeTimeRange(Date oldTime, Date newTime) {
        TimePoint from = Util.getEarliestOfTimePoints((TimePoint)(this.getFromTime() == null ? null : new MillisecondsTimePoint(this.getFromTime())), (TimePoint)(oldTime == null ? null : new MillisecondsTimePoint(oldTime)));
        from = Util.getEarliestOfTimePoints((TimePoint)from, (TimePoint)(newTime == null ? null : new MillisecondsTimePoint(newTime)));
        TimePoint to = Util.getEarliestOfTimePoints((TimePoint)(this.getToTime() == null ? null : new MillisecondsTimePoint(this.getToTime())), (TimePoint)(oldTime == null ? null : new MillisecondsTimePoint(oldTime)));
        from = Util.getEarliestOfTimePoints((TimePoint)to, (TimePoint)(newTime == null ? null : new MillisecondsTimePoint(newTime)));
        this.timeRangeProvider.setTimeRange(from == null ? null : from.asDate(), to == null ? null : to.asDate(), new TimeRangeChangeListener[0]);
    }

    protected String getTimeToStartLabelText(Date time) {
        return null;
    }

    protected String getTimeLabelText(Date time) {
        DateTimeFormat formatter = this.timeFormatter;
        if (this.timer.getRefreshInterval() < 1000L) {
            formatter = this.timeFormatterDetailed;
        }
        String timeLabelText = this.lastReceivedDataTimepoint == null ? formatter.format(time) : String.valueOf(formatter.format(time)) + " (" + formatter.format(this.lastReceivedDataTimepoint) + ")";
        return timeLabelText;
    }

    protected String getDateLabelText(Date time) {
        return this.dateFormatter.format(time);
    }

    protected Date getFromTime() {
        return this.timeRangeProvider.getFromTime();
    }

    protected Date getToTime() {
        return this.timeRangeProvider.getToTime();
    }

    public void setMinMax(Date min, Date max, boolean fireEvent) {
        assert (min != null && max != null);
        Optional changed = this.timeSlider.setMinAndMaxValue(Double.valueOf(min.getTime()), Double.valueOf(max.getTime()), fireEvent);
        if (changed.isPresent()) {
            int numSteps;
            Double changedMin = (Double)((Util.Pair)changed.get()).getA();
            Double changedMax = (Double)((Util.Pair)changed.get()).getB();
            if (!this.timeRangeProvider.isZoomed()) {
                this.timeRangeProvider.setTimeRange(new Date(changedMin.longValue()), new Date(changedMax.longValue()), new TimeRangeChangeListener[]{this});
            }
            if ((numSteps = this.timeSlider.getElement().getClientWidth()) > 0) {
                this.timeSlider.setStepSize((double)numSteps, fireEvent);
            } else {
                this.timeSlider.setStepSize(1000.0, fireEvent);
            }
            if (this.timeSlider.getCurrentValue() == null) {
                this.timeSlider.setCurrentValue(changedMin, fireEvent);
            }
        }
    }

    public void resetTimeSlider() {
        this.timeSlider.clearMarkers();
        this.timeSlider.redraw();
    }

    /*
     * Exception decompiling
     */
    public void playStateChanged(Timer.PlayStates playState, Timer.PlayModes playMode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updatePlayPauseButtonsVisibility(Timer.PlayModes playMode) {
        this.playPauseButton.setVisible(playMode == Timer.PlayModes.Live || this.canReplayWhileLiveIsPossible() || !this.isLiveModeToBeMadePossible());
    }

    public void playSpeedFactorChanged(double newPlaySpeedFactor) {
    }

    public void onTimeZoomChanged(Date zoomStartTimepoint, Date zoomEndTimepoint) {
        this.resetZoomButton.setEnabled(true);
    }

    public void onTimeZoomReset() {
        this.resetZoomButton.setEnabled(false);
    }

    public void onTimeRangeChanged(Date fromTime, Date toTime) {
        this.setMinMax(fromTime, toTime, true);
    }

    protected boolean isLiveModeToBeMadePossible() {
        return false;
    }

    protected void setJumpToLiveEnablement(boolean enabled) {
        this.backToLivePlayButton.setEnabled(enabled);
        if (enabled) {
            this.backToLivePlayButton.setText(this.stringMessages.backToLiveTimePanelMode());
            this.backToLivePlayButton.removeStyleDependentName("Inactive");
            this.backToLivePlayButton.addStyleDependentName("Active");
        } else {
            this.backToLivePlayButton.setText(this.stringMessages.raceIsInLiveTimePanelMode());
            this.backToLivePlayButton.removeStyleDependentName("Active");
            this.backToLivePlayButton.addStyleDependentName("Inactive");
        }
    }

    protected void setLiveGenerallyPossible(boolean possible) {
        this.backToLivePlayButton.setVisible(possible);
        this.updateTimeSliderPadding(possible);
        this.updatePlayPauseButtonsVisibility(this.timer.getPlayMode());
    }

    private void updateTimeSliderPadding(boolean backToLivePlayButtonVisible) {
        Style timePanelStyle = this.timePanelSlider.getElement().getStyle();
        if (backToLivePlayButtonVisible || this.forcePaddingRightToAlignToCharts) {
            timePanelStyle.setPaddingRight(66.0, Style.Unit.PX);
        } else {
            timePanelStyle.clearPaddingRight();
        }
        this.timeSlider.onResize();
    }

    public T getSettings() {
        TimePanelSettings result = new TimePanelSettings(this.timer.getRefreshInterval());
        return (T)result;
    }

    public Widget getEntryWidget() {
        return this;
    }

    public boolean hasSettings() {
        return true;
    }

    public SettingsDialogComponent<T> getSettingsDialogComponent(T settings) {
        return new TimePanelSettingsDialogComponent(settings, this.stringMessages, this.userService, this.raceDTO);
    }

    public void updateSettings(T newSettings) {
        this.timer.setRefreshInterval(newSettings.getRefreshInterval());
    }

    public String getLocalizedShortName() {
        return this.stringMessages.timePanelName();
    }

    public void onResize() {
        Widget child = this.getWidget();
        if (child instanceof RequiresResize) {
            ((RequiresResize)child).onResize();
        }
        this.timeSlider.onResize();
    }

    public Date getLastReceivedDataTimepoint() {
        return this.lastReceivedDataTimepoint;
    }

    public void setLastReceivedDataTimepoint(Date lastReceivedDataTimepoint) {
        this.lastReceivedDataTimepoint = lastReceivedDataTimepoint;
    }

    protected boolean canReplayWhileLiveIsPossible() {
        return this.canReplayWhileLiveIsPossible;
    }

    public Button getAdvancedToggleButton() {
        return this.toggleAdvancedModeButton;
    }

    public String getDependentCssClassName() {
        return "timePanel";
    }

    public Button getBackToLiveButton() {
        return this.backToLivePlayButton;
    }

    public String getId() {
        return "TimePanel";
    }

    public void setBarOverlays(Iterable<TimeSlider.BarOverlay> overlays) {
        this.timeSlider.setBarOverlays(overlays);
    }

    static /* synthetic */ IntegerBox access$3(TimePanel timePanel) {
        return timePanel.playSpeedBox;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes() {
        if ($SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes != null) {
            return $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;
        }
        int[] nArray = new int[Timer.PlayModes.values().length];
        try {
            nArray[Timer.PlayModes.Live.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Timer.PlayModes.Replay.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates() {
        if ($SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates != null) {
            return $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates;
        }
        int[] nArray = new int[Timer.PlayStates.values().length];
        try {
            nArray[Timer.PlayStates.Paused.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Timer.PlayStates.Playing.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayStates = nArray;
        return nArray;
    }
}

