/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.tractrac;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.TracTracConfigurationWithSecurityDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;

public class TracTracConnectionDialog
extends DataEntryDialog<TracTracConfigurationWithSecurityDTO> {
    private static final StringMessages stringMessages = StringMessages.INSTANCE;
    private Grid grid;
    protected TextBox storedURITextBox;
    protected TextBox liveURITextBox;
    protected TextBox jsonURLTextBox;
    protected TextBox tracTracUpdateURITextBox;
    protected TextBox tracTracApiTokenTextBox;
    protected boolean tracTracApiTokenAvailable;
    protected PasswordTextBox tractracPasswordTextBox;
    private final ErrorReporter errorReporter;
    protected String creatorName;
    protected String name;

    public TracTracConnectionDialog(DataEntryDialog.DialogCallback<TracTracConfigurationWithSecurityDTO> callback, UserService userService, ErrorReporter errorReporter) {
        super(stringMessages.tracTracConnection(), null, stringMessages.ok(), stringMessages.cancel(), null, true, callback);
        this.errorReporter = errorReporter;
        this.ensureDebugId("TracTracConnectionDialog");
        this.createUi();
    }

    private void createUi() {
        this.grid = new Grid(6, 3);
        this.grid.setWidget(0, 0, (Widget)new Label(String.valueOf(stringMessages.details()) + ":"));
        Label liveURILabel = new Label(String.valueOf(stringMessages.liveUri()) + ":");
        liveURILabel.setTitle(stringMessages.leaveEmptyForDefault());
        this.liveURITextBox = this.createTextBox("");
        this.liveURITextBox.ensureDebugId("LiveURITextBox");
        this.liveURITextBox.setVisibleLength(40);
        this.liveURITextBox.setTitle(stringMessages.leaveEmptyForDefault());
        this.grid.setWidget(1, 0, (Widget)liveURILabel);
        this.grid.setWidget(1, 1, (Widget)this.liveURITextBox);
        Label storedURILabel = new Label(String.valueOf(stringMessages.storedUri()) + ":");
        storedURILabel.setTitle(stringMessages.leaveEmptyForDefault());
        this.storedURITextBox = this.createTextBox("");
        this.storedURITextBox.ensureDebugId("StoredURITextBox");
        this.storedURITextBox.setVisibleLength(40);
        this.storedURITextBox.setTitle(stringMessages.leaveEmptyForDefault());
        this.grid.setWidget(2, 0, (Widget)storedURILabel);
        this.grid.setWidget(2, 1, (Widget)this.storedURITextBox);
        Label jsonURLLabel = new Label(String.valueOf(stringMessages.jsonUrl()) + ":");
        this.jsonURLTextBox = this.createTextBox("");
        this.jsonURLTextBox.ensureDebugId("JsonURLTextBox");
        this.jsonURLTextBox.setVisibleLength(100);
        this.jsonURLTextBox.addKeyUpHandler(e -> super.getOkButton().setEnabled(!this.jsonURLTextBox.getText().isEmpty()));
        this.grid.setWidget(3, 0, (Widget)jsonURLLabel);
        this.grid.setWidget(3, 1, (Widget)this.jsonURLTextBox);
        Label tracTracUpdateURLLabel = new Label(String.valueOf(stringMessages.tracTracUpdateUrl()) + ":");
        this.tracTracUpdateURITextBox = this.createTextBox("");
        this.tracTracUpdateURITextBox.ensureDebugId("TracTracUpdateURITextBox");
        this.tracTracUpdateURITextBox.setVisibleLength(100);
        this.tracTracUpdateURITextBox.setTitle(stringMessages.leaveEmptyForDefault());
        this.grid.setWidget(4, 0, (Widget)tracTracUpdateURLLabel);
        this.grid.setWidget(4, 1, (Widget)this.tracTracUpdateURITextBox);
        this.tracTracApiTokenTextBox = this.createTextBox("");
        this.tracTracApiTokenTextBox.ensureDebugId("TracTracApiTokenTextBox");
        this.tracTracApiTokenTextBox.setVisibleLength(40);
        this.grid.setWidget(5, 0, (Widget)new Label(String.valueOf(stringMessages.tractracApiToken()) + ":"));
        this.grid.setWidget(5, 1, (Widget)this.tracTracApiTokenTextBox);
        Button testConnectionButton = new Button(stringMessages.testConnection());
        testConnectionButton.addClickHandler(e -> this.testTracTracConnection());
        testConnectionButton.setEnabled(false);
        this.tracTracApiTokenTextBox.addKeyUpHandler(e -> testConnectionButton.setEnabled(Util.hasLength((String)this.tracTracApiTokenTextBox.getValue())));
        this.grid.setWidget(5, 2, (Widget)testConnectionButton);
    }

    private void testTracTracConnection() {
        RequestBuilder rbJsonUrl = new RequestBuilder(RequestBuilder.GET, this.jsonURLTextBox.getValue());
        try {
            rbJsonUrl.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.errorReporter.reportError(stringMessages.tracTracConnectionTestFailed(e.getMessage()));
        }
    }

    private void testTracTracConnectionWithUpdateURI(String serverUpdateURI, String eventId) {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, String.valueOf(serverUpdateURI) + "/api/v3/valid?eventId=" + eventId);
        rb.setHeader("Authorization", "Bearer " + this.tracTracApiTokenTextBox.getValue());
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            this.errorReporter.reportError(stringMessages.tracTracConnectionTestFailed(e.getMessage()));
        }
    }

    protected Focusable getInitialFocusWidget() {
        return this.jsonURLTextBox;
    }

    protected TracTracConfigurationWithSecurityDTO getResult() {
        String jsonURL = this.jsonURLTextBox.getValue();
        String liveDataURI = this.liveURITextBox.getValue();
        String storedDataURI = this.storedURITextBox.getValue();
        String courseDesignUpdateURI = this.tracTracUpdateURITextBox.getValue();
        String tracTracApiToken = this.tracTracApiTokenTextBox.getValue();
        return new TracTracConfigurationWithSecurityDTO(this.name, jsonURL, liveDataURI, storedDataURI, courseDesignUpdateURI, tracTracApiToken, this.tracTracApiTokenAvailable || Util.hasLength((String)tracTracApiToken), this.creatorName);
    }

    protected Widget getAdditionalWidget() {
        return this.grid;
    }

    static /* synthetic */ ErrorReporter access$1(TracTracConnectionDialog tracTracConnectionDialog) {
        return tracTracConnectionDialog.errorReporter;
    }

    static /* synthetic */ StringMessages access$2() {
        return stringMessages;
    }

    static /* synthetic */ void access$3(TracTracConnectionDialog tracTracConnectionDialog, String string, String string2) {
        tracTracConnectionDialog.testTracTracConnectionWithUpdateURI(string, string2);
    }
}

