/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.multivideo;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.adminconsole.multivideo.MultiURLChangeDialog;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.TimeFormatUtil;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiURLChangeDialog
extends DialogBox {
    private static final String EMPTY_TEXT = "";
    private static final int TITLE_COLUMN = 0;
    private static final int URL_COLUMN = 1;
    private static final int URL_COLUMN_NEW = 2;
    private static final int DURATION_COLUMN = 3;
    private static final int STARTTIME_COLUMN = 4;
    private static final int MIMETYPE_COLUMN = 5;
    private static final Style STYLE = ((StyleHolder)GWT.create(StyleHolder.class)).style();
    private StringMessages stringMessages;
    private List<MediaTrack> mediaTrackRenameMap = new ArrayList();
    private FlexTable dataTable;
    private Button doSaveButton;
    private TextBox replacePartIn;
    private TextBox replacePartOut;

    public MultiURLChangeDialog(MediaServiceWriteAsync mediaServiceWrite, StringMessages stringMessages, Set<MediaTrackWithSecurityDTO> selected, ErrorReporter errorReporter, Runnable afterLinking) {
        this.stringMessages = stringMessages;
        this.setGlassEnabled(true);
        FlowPanel mainContent = new FlowPanel();
        Label descriptionLabel = new Label(this.stringMessages.multiUrlChangeExplain());
        mainContent.add((Widget)descriptionLabel);
        mainContent.add((Widget)new Label(stringMessages.multiUrlChangeFind()));
        this.replacePartIn = new TextBox();
        this.replacePartIn.getElement().getStyle().setWidth(25.0, Style.Unit.PCT);
        mainContent.add((Widget)this.replacePartIn);
        mainContent.add((Widget)new Label(stringMessages.multiUrlChangeReplace()));
        this.replacePartOut = new TextBox();
        this.replacePartOut.getElement().getStyle().setWidth(25.0, Style.Unit.PCT);
        this.replacePartOut.setText("http://replace_me_with_baseurl/");
        mainContent.add((Widget)this.replacePartOut);
        this.replacePartOut.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.replacePartOut.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.replacePartOut.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        FlowPanel buttonPanel = new FlowPanel();
        DockPanel dockPanel = new DockPanel();
        this.add((Widget)dockPanel);
        dockPanel.add((Widget)new ScrollPanel((Widget)mainContent), DockPanel.CENTER);
        this.dataTable = new FlexTable();
        STYLE.ensureInjected();
        this.dataTable.addStyleName(STYLE.tableStyle());
        mainContent.add((Widget)this.dataTable);
        Button cancelButton = new Button(stringMessages.close());
        cancelButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        cancelButton.ensureDebugId("CancelButton");
        cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.doSaveButton = new Button(stringMessages.multiUrlChangeSave());
        this.doSaveButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)this.doSaveButton);
        buttonPanel.add((Widget)cancelButton);
        dockPanel.add((Widget)buttonPanel, DockPanel.SOUTH);
        this.mediaTrackRenameMap = new ArrayList<MediaTrackWithSecurityDTO>(selected);
        String maxPrefixForAll = this.maxPrefixForAll();
        if (maxPrefixForAll.length() == 0) {
            Notification.notify((String)this.stringMessages.multiUrlNoPrefixWarning(), (Notification.NotificationType)Notification.NotificationType.WARNING);
        }
        this.replacePartIn.setText(maxPrefixForAll);
        this.updateUI();
    }

    private String maxPrefixForAll() {
        List allUrls = this.mediaTrackRenameMap.stream().map(f -> f.url).collect(Collectors.toList());
        int length = Integer.MAX_VALUE;
        for (String url : allUrls) {
            int urlLength = url.length();
            if (urlLength >= length) continue;
            length = urlLength;
        }
        int i = 0;
        while (i < length) {
            Character charTest = null;
            for (String url : allUrls) {
                char cur = url.charAt(i);
                if (charTest == null) {
                    charTest = Character.valueOf(cur);
                    continue;
                }
                if (charTest.charValue() == cur) continue;
                return url.substring(0, i);
            }
            ++i;
        }
        return (String)allUrls.get(0);
    }

    protected void updateUI() {
        int y = 0;
        this.dataTable.removeAllRows();
        this.dataTable.clear();
        this.dataTable.setWidget(y, 0, (Widget)new Label(this.stringMessages.title()));
        this.dataTable.setWidget(y, 1, (Widget)new Label(this.stringMessages.url()));
        this.dataTable.setWidget(y, 2, (Widget)new Label(this.stringMessages.multiUrlChangeNewURL()));
        this.dataTable.setWidget(y, 3, (Widget)new Label(this.stringMessages.duration()));
        this.dataTable.setWidget(y, 4, (Widget)new Label(this.stringMessages.startTime()));
        this.dataTable.setWidget(y, 5, (Widget)new Label(this.stringMessages.mimeType()));
        int row = 0;
        while (row < this.dataTable.getCellCount(0)) {
            this.dataTable.getFlexCellFormatter().addStyleName(y, row, STYLE.tableHeader());
            ++row;
        }
        ++y;
        for (MediaTrack remoteFile : this.mediaTrackRenameMap) {
            Label name = new Label(remoteFile.title);
            this.dataTable.setWidget(y, 0, (Widget)name);
            Anchor link = new Anchor(remoteFile.url);
            link.setHref(remoteFile.url);
            link.setTarget("_blank");
            this.dataTable.setWidget(y, 1, (Widget)link);
            String newUrl = this.getPatchedUrl(remoteFile);
            Anchor linknew = new Anchor(newUrl);
            linknew.setHref(newUrl);
            linknew.setTarget("_blank");
            this.dataTable.setWidget(y, 2, (Widget)linknew);
            String durationtext = EMPTY_TEXT;
            if (remoteFile.duration != null) {
                durationtext = TimeFormatUtil.durationToHrsMinSec((Duration)remoteFile.duration);
            }
            this.dataTable.setWidget(y, 3, (Widget)new Label(durationtext));
            String startTimeText = EMPTY_TEXT;
            if (remoteFile.startTime != null) {
                startTimeText = TimeFormatUtil.DATETIME_FORMAT.format(new Date(remoteFile.startTime.asMillis()));
            }
            this.dataTable.setWidget(y, 4, (Widget)new Label(startTimeText));
            this.dataTable.setWidget(y, 5, (Widget)new Label(remoteFile.mimeType.name()));
            ++y;
        }
        if (this.isShowing()) {
            this.center();
        }
    }

    private String getPatchedUrl(MediaTrack remoteFile) {
        String newUrl = remoteFile.url;
        newUrl = newUrl.substring(this.replacePartIn.getText().length());
        newUrl = String.valueOf(this.replacePartOut.getText()) + newUrl;
        return newUrl;
    }

    static /* synthetic */ List access$0(MultiURLChangeDialog multiURLChangeDialog) {
        return multiURLChangeDialog.mediaTrackRenameMap;
    }

    static /* synthetic */ String access$1(MultiURLChangeDialog multiURLChangeDialog, MediaTrack mediaTrack) {
        return multiURLChangeDialog.getPatchedUrl(mediaTrack);
    }
}

