/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.adminconsole.VideoDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.adminconsole.URLFieldWithFileUpload;
import com.sap.sse.gwt.client.GWTLocaleUtil;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.listedit.GenericStringListInlineEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;
import com.sap.sse.gwt.client.controls.listedit.StringListInlineEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.media.VideoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class VideoDialog
extends DataEntryDialog<List<VideoDTO>>
implements FileStorageServiceConnectionTestObservable.FileStorageServiceConnectionTestObserver {
    protected final StringMessages stringMessages;
    protected final URLFieldWithFileUpload videoURLAndUploadComposite;
    protected final Date creationDate;
    protected Label createdAtLabel;
    protected TextBox subtitleTextBox;
    protected TextBox copyrightTextBox;
    private Grid multiVideoGrid;
    private final TextBox titleTextBox = new TextBox();
    private final ListBox mimeTypeListBox = this.createMimeTextSelection();
    protected final ListBox localeListBox;
    protected final URLFieldWithFileUpload thumbnailURLAndUploadComposite;
    protected StringListInlineEditorComposite tagsListEditor;
    private final List<VideoTmpData> videoTmpDatas;
    private FlexTable formFlexTable;

    protected void initVideoTmpDatas(String uri, String title, Integer lengthInSeconds, MimeType mimeType) {
        VideoTmpData videoTmpData = new VideoTmpData(null);
        this.videoTmpDatas.add(videoTmpData);
        videoTmpData.uri = uri;
        videoTmpData.fileName = this.extractFileName(uri);
        videoTmpData.title = title;
        videoTmpData.lengthInSeconds = lengthInSeconds;
        videoTmpData.mimeType = mimeType;
        this.renderMultiFileTable(false);
        this.setFieldsEnabled(true);
    }

    private String extractFileName(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public VideoDialog(Date createdAtDate, VideoParameterValidator validator, StringMessages stringMessages, FileStorageServiceConnectionTestObservable storageServiceAvailable, DataEntryDialog.DialogCallback<List<VideoDTO>> callback) {
        super(stringMessages.video(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)validator, callback);
        this.stringMessages = stringMessages;
        this.creationDate = createdAtDate;
        this.videoTmpDatas = new ArrayList();
        this.getDialogBox().getWidget().setWidth("730px");
        this.localeListBox = this.createListBox(false);
        for (String locale : GWTLocaleUtil.getAvailableLocalesAndDefault()) {
            this.localeListBox.addItem(GWTLocaleUtil.getDecoratedLanguageDisplayNameWithDefaultLocaleSupport((String)locale), locale == null ? "" : locale);
        }
        this.videoURLAndUploadComposite = new URLFieldWithFileUpload((com.sap.sse.gwt.adminconsole.StringMessages)stringMessages, true, true, true, "audio/*,video/*");
        this.videoURLAndUploadComposite.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.thumbnailURLAndUploadComposite = new URLFieldWithFileUpload((com.sap.sse.gwt.adminconsole.StringMessages)stringMessages, false, true, true, "image/*");
        this.tagsListEditor = new StringListInlineEditorComposite(Collections.emptyList(), (ListEditorUiStrategy)new GenericStringListInlineEditorComposite.ExpandedUi((com.sap.sse.gwt.client.StringMessages)stringMessages, IconResources.INSTANCE.removeIcon(), MediaTagConstants.videoTagSuggestions, stringMessages.enterTagsForTheVideo(), 50));
        storageServiceAvailable.registerObserver((FileStorageServiceConnectionTestObservable.FileStorageServiceConnectionTestObserver)this);
        this.getCancelButton().addClickHandler(clickEvent -> {
            this.videoURLAndUploadComposite.deleteCurrentFile();
            this.thumbnailURLAndUploadComposite.deleteCurrentFile();
        });
    }

    private void renderMultiFileTable(boolean updateMediaInfo) {
        GWT.log((String)("video tmp data size = " + this.videoTmpDatas.size()));
        GWT.log((String)("video tmp data = " + this.videoTmpDatas));
        if (this.formFlexTable == null && this.videoTmpDatas.size() > 0) {
            this.initFormFlexTable();
        }
        if (this.formFlexTable != null && this.videoTmpDatas.size() > 0) {
            if (this.videoTmpDatas.size() == 1) {
                this.formFlexTable.getRowFormatter().setVisible(2, true);
                this.formFlexTable.getRowFormatter().setVisible(3, true);
                this.formFlexTable.getRowFormatter().setVisible(4, true);
                this.formFlexTable.getRowFormatter().setVisible(5, false);
                VideoTmpData videoTmpData = (VideoTmpData)this.videoTmpDatas.get(0);
                this.titleTextBox.setText(videoTmpData.title);
                GWT.log((String)("video tmp data = " + videoTmpData));
                this.titleTextBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.mimeTypeListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.setSelectedMimeType(this.mimeTypeListBox, videoTmpData.mimeType);
            } else {
                this.formFlexTable.getRowFormatter().setVisible(2, false);
                this.formFlexTable.getRowFormatter().setVisible(3, false);
                this.formFlexTable.getRowFormatter().setVisible(4, false);
                this.formFlexTable.getRowFormatter().setVisible(5, true);
                Grid multiVideoGrid = new Grid(this.videoTmpDatas.size() + 1, 3);
                multiVideoGrid.setWidth("100%");
                this.formFlexTable.setWidget(5, 0, (Widget)multiVideoGrid);
                multiVideoGrid.setWidget(0, 0, (Widget)new Label(this.stringMessages.name()));
                multiVideoGrid.setWidget(0, 1, (Widget)new Label(this.stringMessages.title()));
                multiVideoGrid.setWidget(0, 2, (Widget)new Label(this.stringMessages.mimeType()));
                int i = 0;
                while (i < this.videoTmpDatas.size()) {
                    VideoTmpData videoTmpData = (VideoTmpData)this.videoTmpDatas.get(i);
                    TextBox titleTextBox = new TextBox();
                    titleTextBox.setText(videoTmpData.title);
                    titleTextBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                    Label nameLabel = new Label(videoTmpData.fileName);
                    ListBox mimeTypeListBox = this.createMimeTextSelection();
                    mimeTypeListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                    this.setSelectedMimeType(mimeTypeListBox, videoTmpData.mimeType);
                    multiVideoGrid.setWidget(i + 1, 0, (Widget)nameLabel);
                    multiVideoGrid.setWidget(i + 1, 1, (Widget)titleTextBox);
                    multiVideoGrid.setWidget(i + 1, 2, (Widget)mimeTypeListBox);
                    ++i;
                }
            }
        }
    }

    protected List<VideoDTO> getResult() {
        ArrayList<VideoDTO> results = new ArrayList<VideoDTO>(this.videoURLAndUploadComposite.getUris().size());
        for (VideoTmpData videoData : this.videoTmpDatas) {
            VideoDTO videoDTO = new VideoDTO(videoData.uri, videoData.mimeType, this.creationDate);
            videoDTO.setTitle(videoData.title);
            videoDTO.setSubtitle(this.subtitleTextBox.getValue());
            videoDTO.setCopyright(this.copyrightTextBox.getValue());
            videoDTO.setLocale(this.getSelectedLocale());
            ArrayList<String> tags = new ArrayList<String>();
            for (String tag : this.tagsListEditor.getValue()) {
                tags.add(tag);
            }
            videoDTO.setTags(tags);
            videoDTO.setThumbnailRef(this.thumbnailURLAndUploadComposite.getUri());
            videoDTO.setLengthInSeconds(videoData.lengthInSeconds);
            results.add(videoDTO);
        }
        return results;
    }

    private ListBox createMimeTextSelection() {
        ListBox mimeTypeListBox = this.createListBox(false);
        mimeTypeListBox.ensureDebugId("mimeTypeListBox");
        mimeTypeListBox.addItem(MimeType.unknown.name());
        mimeTypeListBox.addItem(MimeType.mp4.name());
        mimeTypeListBox.addItem(MimeType.mov.name());
        mimeTypeListBox.addItem(MimeType.mp4panorama.name());
        mimeTypeListBox.addItem(MimeType.mp4panoramaflip.name());
        mimeTypeListBox.addItem(MimeType.ogv.name());
        mimeTypeListBox.addItem(MimeType.qt.name());
        mimeTypeListBox.addItem(MimeType.webm.name());
        mimeTypeListBox.addItem(MimeType.youtube.name());
        mimeTypeListBox.addItem(MimeType.vimeo.name());
        return mimeTypeListBox;
    }

    protected void setSelectedMimeType(ListBox mimeTypeListBox, MimeType mimeType) {
        int i = 0;
        while (i < mimeTypeListBox.getItemCount()) {
            if (mimeTypeListBox.getItemText(i).equals(mimeType.name())) {
                mimeTypeListBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    private MimeType getSelectedMimeType(ListBox mimeTypeListBox) {
        MimeType result = null;
        int selectedIndex = mimeTypeListBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            result = MimeType.valueOf((String)mimeTypeListBox.getSelectedValue());
        }
        return result;
    }

    protected void setSelectedLocale(String locale) {
        int i = 0;
        while (i < this.localeListBox.getItemCount()) {
            if (Util.equalsWithNull((Object)this.localeListBox.getValue(i), (Object)locale)) {
                this.localeListBox.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        this.localeListBox.setSelectedIndex(0);
    }

    private String getSelectedLocale() {
        return this.localeListBox.getSelectedValue();
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        panel.setWidth("100%");
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        this.initFormFlexTable();
        panel.add((Widget)this.formFlexTable);
        return panel;
    }

    private void initFormFlexTable() {
        this.formFlexTable = new FlexTable();
        this.formFlexTable.ensureDebugId("videoDialogFormTable");
        this.formFlexTable.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.createdAt()) + ":"));
        this.formFlexTable.setWidget(0, 1, (Widget)this.createdAtLabel);
        this.formFlexTable.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.videoUrl()) + ":"));
        this.formFlexTable.setWidget(1, 1, (Widget)this.videoURLAndUploadComposite);
        this.formFlexTable.setWidget(2, 0, (Widget)new Label(String.valueOf(this.stringMessages.title()) + ":"));
        this.formFlexTable.setWidget(2, 1, (Widget)this.titleTextBox);
        this.formFlexTable.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.mimeType()) + ":"));
        this.formFlexTable.setWidget(3, 1, (Widget)this.mimeTypeListBox);
        this.formFlexTable.setWidget(5, 0, (Widget)this.multiVideoGrid);
        this.formFlexTable.getFlexCellFormatter().setColSpan(5, 0, 2);
        this.formFlexTable.getRowFormatter().setVisible(5, false);
        this.formFlexTable.setWidget(6, 0, (Widget)new Label(String.valueOf(this.stringMessages.subtitle()) + ":"));
        this.formFlexTable.setWidget(6, 1, (Widget)this.subtitleTextBox);
        this.formFlexTable.setWidget(7, 0, (Widget)new Label(String.valueOf(this.stringMessages.copyright()) + ":"));
        this.formFlexTable.setWidget(7, 1, (Widget)this.copyrightTextBox);
        this.formFlexTable.setWidget(8, 0, (Widget)new Label(String.valueOf(this.stringMessages.language()) + ":"));
        this.formFlexTable.setWidget(8, 1, (Widget)this.localeListBox);
        this.formFlexTable.setWidget(9, 0, (Widget)new Label(String.valueOf(this.stringMessages.tags()) + ":"));
        this.formFlexTable.setWidget(9, 1, (Widget)this.tagsListEditor);
        this.formFlexTable.setWidget(10, 0, (Widget)new Label(String.valueOf(this.stringMessages.thumbnailUrl()) + ":"));
        this.formFlexTable.setWidget(10, 1, (Widget)this.thumbnailURLAndUploadComposite);
        this.setFieldsEnabled(this.videoTmpDatas.size() > 0);
    }

    private void setFieldsEnabled(boolean enabled) {
        this.formFlexTable.getRowFormatter().setVisible(2, enabled);
        this.formFlexTable.getRowFormatter().setVisible(3, enabled);
        this.formFlexTable.getRowFormatter().setVisible(6, enabled);
        this.formFlexTable.getRowFormatter().setVisible(7, enabled);
        this.formFlexTable.getRowFormatter().setVisible(8, enabled);
        this.formFlexTable.getRowFormatter().setVisible(9, enabled);
        this.formFlexTable.getRowFormatter().setVisible(10, enabled);
    }

    protected Focusable getInitialFocusWidget() {
        return this.videoURLAndUploadComposite.getInitialFocusWidget();
    }

    public void onFileStorageServiceTestPassed() {
        this.videoURLAndUploadComposite.setUploadEnabled(true);
        this.thumbnailURLAndUploadComposite.setUploadEnabled(true);
    }

    static /* synthetic */ void access$1(VideoDialog videoDialog) {
        videoDialog.validateAndUpdate();
    }

    static /* synthetic */ List access$2(VideoDialog videoDialog) {
        return videoDialog.videoTmpDatas;
    }

    static /* synthetic */ void access$3(VideoDialog videoDialog, boolean bl) {
        videoDialog.setFieldsEnabled(bl);
    }

    static /* synthetic */ FlexTable access$4(VideoDialog videoDialog) {
        return videoDialog.formFlexTable;
    }

    static /* synthetic */ void access$5(VideoDialog videoDialog, boolean bl) {
        videoDialog.renderMultiFileTable(bl);
    }

    static /* synthetic */ TextBox access$6(VideoDialog videoDialog) {
        return videoDialog.titleTextBox;
    }

    static /* synthetic */ ListBox access$7(VideoDialog videoDialog) {
        return videoDialog.mimeTypeListBox;
    }

    static /* synthetic */ MimeType access$8(VideoDialog videoDialog, ListBox listBox) {
        return videoDialog.getSelectedMimeType(listBox);
    }
}

