/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.text.client.DateTimeFormatRenderer;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractEventManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.SimulationPanel;
import com.sap.sailing.gwt.ui.adminconsole.TracTracEventManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.adminconsole.tractrac.TracTracConnectionDialog;
import com.sap.sailing.gwt.ui.adminconsole.tractrac.TracTracConnectionTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.TracTracConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.TracTracRaceRecordDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class TracTracEventManagementPanel
extends AbstractEventManagementPanel
implements FilterablePanelProvider<TracTracConfigurationWithSecurityDTO> {
    private final ErrorReporter errorReporter;
    private final List<TracTracRaceRecordDTO> availableTracTracRaces;
    private final ListDataProvider<TracTracRaceRecordDTO> raceList;
    private TracTracConnectionTableWrapper connectionsTable;
    private Label loadingMessageLabel;
    private LabeledAbstractFilterablePanel<TracTracRaceRecordDTO> racesFilterablePanel;
    private FlushableCellTable<TracTracRaceRecordDTO> racesTable;
    private final UserService userService;
    private final CellTableWithCheckboxResources tableResources;
    private final SailingServiceWriteAsync sailingServiceWrite;

    public TracTracEventManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages, CellTableWithCheckboxResources tableResources) {
        super(presenter, true, stringMessages);
        this.userService = presenter.getUserService();
        this.errorReporter = presenter.getErrorReporter();
        this.sailingServiceWrite = presenter.getSailingService();
        this.tableResources = tableResources;
        this.availableTracTracRaces = new ArrayList();
        this.raceList = new ListDataProvider();
        this.setWidget(this.createContent());
    }

    protected Widget createContent() {
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        CaptionPanel connectionsPanel = this.createConnectionsPanel();
        mainPanel.add((Widget)connectionsPanel);
        HorizontalPanel racesPanel = this.createRacesPanel();
        racesPanel.setWidth("100%");
        mainPanel.add((Widget)racesPanel);
        return mainPanel;
    }

    protected CaptionPanel createConnectionsPanel() {
        CaptionPanel connectionsPanel = new CaptionPanel("TracTrac " + this.stringMessages.connections());
        connectionsPanel.ensureDebugId("ConnectionsSection");
        connectionsPanel.setStyleName("bold");
        VerticalPanel tableAndConfigurationPanel = new VerticalPanel();
        this.connectionsTable = new TracTracConnectionTableWrapper(this.userService, this.sailingServiceWrite, this.stringMessages, this.errorReporter, true, this.tableResources, () -> {});
        this.connectionsTable.refreshTracTracConnectionList();
        Grid grid = new Grid(1, 2);
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.racesWithHiddenState()) + ":"));
        CheckBox showHiddenRacesCheckbox = new CheckBox(this.stringMessages.show());
        showHiddenRacesCheckbox.ensureDebugId("ShowHiddenRacesCheckBox");
        grid.setWidget(0, 1, (Widget)showHiddenRacesCheckbox);
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.TRACKED_RACE);
        buttonPanel.addUnsecuredAction(this.stringMessages.refresh(), () -> this.connectionsTable.refreshTracTracConnectionList());
        Button addCreateAction = buttonPanel.addCreateAction(this.stringMessages.addTracTracConnection(), () -> new TracTracConnectionDialog((DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, this.userService, this.errorReporter).show());
        addCreateAction.ensureDebugId("AddConnectionButton");
        buttonPanel.addRemoveAction(this.stringMessages.remove(), (SetSelectionModel)this.connectionsTable.getSelectionModel(), false, () -> this.sailingServiceWrite.deleteTracTracConfigurations((Collection)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        this.loadingMessageLabel = new Label();
        Button listRacesButton = buttonPanel.addUnsecuredAction(this.stringMessages.listRaces(), () -> {
            this.loadingMessageLabel.setText(this.stringMessages.loading());
            this.fillRaces((SailingServiceAsync)this.sailingServiceWrite, showHiddenRacesCheckbox.getValue().booleanValue());
        });
        listRacesButton.ensureDebugId("ListRacesButton");
        listRacesButton.setEnabled(false);
        buttonPanel.addUnsecuredWidget((Widget)this.loadingMessageLabel);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> {
            boolean objectSelected = ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1;
            listRacesButton.setEnabled(objectSelected);
        });
        tableAndConfigurationPanel.add((Widget)buttonPanel);
        tableAndConfigurationPanel.add((Widget)grid);
        tableAndConfigurationPanel.add((IsWidget)this.connectionsTable);
        connectionsPanel.setContentWidget((Widget)tableAndConfigurationPanel);
        return connectionsPanel;
    }

    protected HorizontalPanel createRacesPanel() {
        HorizontalPanel racesPanel = new HorizontalPanel();
        CaptionPanel trackableRacesPanel = this.createTrackableRacesPanel();
        racesPanel.add((Widget)trackableRacesPanel);
        racesPanel.setCellWidth((Widget)trackableRacesPanel, "50%");
        CaptionPanel trackedRacesPanel = this.createTrackedRacesPanel();
        racesPanel.add((Widget)trackedRacesPanel);
        racesPanel.setCellWidth((Widget)trackedRacesPanel, "50%");
        return racesPanel;
    }

    protected CaptionPanel createTrackableRacesPanel() {
        CaptionPanel trackableRacesPanel = new CaptionPanel(this.stringMessages.trackableRaces());
        trackableRacesPanel.ensureDebugId("TrackableRacesSection");
        trackableRacesPanel.setStyleName("bold");
        FlexTable layoutTable = new FlexTable();
        layoutTable.setWidth("100%");
        HTMLTable.ColumnFormatter columnFormatter = layoutTable.getColumnFormatter();
        FlexTable.FlexCellFormatter cellFormatter = layoutTable.getFlexCellFormatter();
        columnFormatter.setWidth(0, "130px");
        Label regattaForTrackingLabel = new Label(this.stringMessages.regattaUsedForTheTrackedRace());
        regattaForTrackingLabel.setWordWrap(false);
        int row = 0;
        layoutTable.setWidget(row, 0, (Widget)regattaForTrackingLabel);
        layoutTable.setWidget(row, 1, (Widget)this.getAvailableRegattasListBox());
        Label trackSettingsLabel = new Label(String.valueOf(this.stringMessages.trackSettings()) + ":");
        CheckBox trackWindCheckBox = new CheckBox(this.stringMessages.trackWind());
        trackWindCheckBox.ensureDebugId("TrackWindCheckBox");
        trackWindCheckBox.setWordWrap(false);
        trackWindCheckBox.setValue(Boolean.TRUE);
        CheckBox correctWindCheckBox = new CheckBox(this.stringMessages.declinationCheckbox());
        correctWindCheckBox.ensureDebugId("CorrectWindCheckBox");
        correctWindCheckBox.setWordWrap(false);
        correctWindCheckBox.setValue(Boolean.TRUE);
        SimulationPanel simulationPanel = new SimulationPanel(this.stringMessages);
        CheckBox ignoreTracTracMarkPassingsCheckbox = new CheckBox(this.stringMessages.useInternalAlgorithm());
        ignoreTracTracMarkPassingsCheckbox.setWordWrap(false);
        ignoreTracTracMarkPassingsCheckbox.setValue(Boolean.FALSE);
        CheckBox useOfficialResultsToUpdateRaceLogsCheckbox = new CheckBox(this.stringMessages.useOfficialResultsForAutomaticUpdates());
        ignoreTracTracMarkPassingsCheckbox.setWordWrap(false);
        ignoreTracTracMarkPassingsCheckbox.setValue(Boolean.FALSE);
        layoutTable.setWidget(++row, 0, (Widget)trackSettingsLabel);
        layoutTable.setWidget(row, 1, (Widget)trackWindCheckBox);
        layoutTable.setWidget(++row, 1, (Widget)correctWindCheckBox);
        layoutTable.setWidget(++row, 1, (Widget)simulationPanel);
        layoutTable.setWidget(++row, 1, (Widget)ignoreTracTracMarkPassingsCheckbox);
        layoutTable.setWidget(++row, 1, (Widget)useOfficialResultsToUpdateRaceLogsCheckbox);
        Label racesFilterLabel = new Label(String.valueOf(this.stringMessages.filterRaces()) + ":");
        AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        this.racesTable = new FlushableCellTable(10000, (CellTable.Resources)tableResources);
        this.racesTable.ensureDebugId("TrackableRacesCellTable");
        this.racesFilterablePanel = new /* Unavailable Anonymous Inner Class!! */;
        this.racesFilterablePanel.getTextBox().ensureDebugId("TrackableRacesFilterTextBox");
        layoutTable.setWidget(++row, 0, (Widget)racesFilterLabel);
        layoutTable.setWidget(row, 1, (Widget)this.racesFilterablePanel);
        5 regattaNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        regattaNameColumn.setSortable(false);
        6 boatClassColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatClassColumn.setSortable(true);
        7 raceNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceNameColumn.setSortable(true);
        8 raceStartTrackingColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceStartTrackingColumn.setSortable(true);
        9 raceStatusColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceStatusColumn.setSortable(true);
        10 raceVisibilityColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceVisibilityColumn.setSortable(true);
        SelectionCheckboxColumn selectionCheckboxColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.racesFilterablePanel.getAllListDataProvider(), (Flushable)this.racesTable);
        this.racesTable.addColumn((Column)selectionCheckboxColumn, selectionCheckboxColumn.getHeader());
        this.racesTable.addColumn((Column)regattaNameColumn, this.stringMessages.event());
        this.racesTable.addColumn((Column)raceNameColumn, this.stringMessages.race());
        this.racesTable.addColumn((Column)boatClassColumn, this.stringMessages.boatClass());
        this.racesTable.addColumn((Column)raceStartTrackingColumn, this.stringMessages.startTime());
        this.racesTable.addColumn((Column)raceStatusColumn, this.stringMessages.raceStatusColumn());
        this.racesTable.addColumn((Column)raceVisibilityColumn, this.stringMessages.raceVisibilityColumn());
        this.racesTable.addColumnSortHandler((ColumnSortEvent.Handler)this.getRaceTableColumnSortHandler(selectionCheckboxColumn, this.raceList.getList(), (Column)raceNameColumn, (Column)boatClassColumn, (Column)raceStartTrackingColumn, (Column)raceStatusColumn, (Column)raceVisibilityColumn));
        this.racesTable.setSelectionModel((SelectionModel)selectionCheckboxColumn.getSelectionModel(), selectionCheckboxColumn.getSelectionManager());
        this.racesTable.setWidth("100%");
        this.raceList.addDataDisplay((HasData)this.racesTable);
        layoutTable.setWidget(++row, 0, (Widget)this.racesTable);
        cellFormatter.setColSpan(row, 0, 2);
        Button startTrackingButton = new Button(this.stringMessages.startTracking());
        startTrackingButton.setEnabled(false);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> startTrackingButton.setEnabled(((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1));
        startTrackingButton.ensureDebugId("StartTrackingButton");
        startTrackingButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        layoutTable.setWidget(++row, 1, (Widget)startTrackingButton);
        trackableRacesPanel.setContentWidget((Widget)layoutTable);
        return trackableRacesPanel;
    }

    protected CaptionPanel createTrackedRacesPanel() {
        CaptionPanel trackedRacesPanel = new CaptionPanel(this.stringMessages.trackedRaces());
        trackedRacesPanel.ensureDebugId("TrackedRacesSection");
        trackedRacesPanel.setStyleName("bold");
        trackedRacesPanel.setContentWidget((Widget)this.trackedRacesListComposite);
        return trackedRacesPanel;
    }

    protected void reportError(String message) {
        this.errorReporter.reportError(message);
    }

    private ColumnSortEvent.ListHandler<TracTracRaceRecordDTO> getRaceTableColumnSortHandler(SelectionCheckboxColumn<TracTracRaceRecordDTO> selectionCheckboxColumn, List<TracTracRaceRecordDTO> raceRecords, Column<TracTracRaceRecordDTO, ?> nameColumn, Column<TracTracRaceRecordDTO, ?> boatClassColumn, Column<TracTracRaceRecordDTO, ?> trackingStartColumn, Column<TracTracRaceRecordDTO, ?> raceStatusColumn, Column<TracTracRaceRecordDTO, ?> raceVisibilityColumn) {
        ColumnSortEvent.ListHandler result = new ColumnSortEvent.ListHandler(raceRecords);
        result.setComparator(selectionCheckboxColumn, (Comparator)selectionCheckboxColumn.getComparator());
        result.setComparator(nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(boatClassColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(trackingStartColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(raceStatusColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(raceVisibilityColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private String getBoatClassNamesAsString(TracTracRaceRecordDTO object) {
        StringBuilder boatClassNames = new StringBuilder();
        for (String boatClassName : object.boatClassNames) {
            boatClassNames.append(boatClassName);
            boatClassNames.append(", ");
        }
        return boatClassNames.substring(0, boatClassNames.length() - 2);
    }

    private Duration getMillisecondsDurationFromMinutesAsString(String minutesAsString) {
        Double minutesAsDouble;
        Duration result = null;
        if (minutesAsString != null && (minutesAsDouble = Double.valueOf(Double.parseDouble(minutesAsString))) != null) {
            result = Duration.ONE_MINUTE.times(minutesAsDouble.longValue());
        }
        return result;
    }

    private void fillRaces(SailingServiceAsync sailingService, boolean listHiddenRaces) {
        Set selectedConnections = ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet();
        if (selectedConnections.size() == 1) {
            TracTracConfigurationWithSecurityDTO selectedConnection = (TracTracConfigurationWithSecurityDTO)selectedConnections.iterator().next();
            sailingService.listTracTracRacesInEvent(selectedConnection.getJsonUrl(), listHiddenRaces, selectedConnection.getTracTracApiToken(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private void trackSelectedRaces(boolean trackWind, boolean correctWind, Duration offsetToStartTimeOfSimulatedRace, boolean ignoreTracTracMarkPassings, boolean useOfficialResultsToUpdateRaceLogs) {
        TracTracConfigurationWithSecurityDTO selectedConnection = (TracTracConfigurationWithSecurityDTO)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().iterator().next();
        String liveURI = selectedConnection.getLiveDataURI();
        String storedURI = selectedConnection.getStoredDataURI();
        String updateURI = selectedConnection.getUpdateURI();
        String jsonUrlAsKey = selectedConnection.getJsonUrl();
        RegattaDTO selectedRegatta = this.getSelectedRegatta();
        RegattaName regattaIdentifier = null;
        if (selectedRegatta != null) {
            regattaIdentifier = new RegattaName(selectedRegatta.getName());
        }
        List allRaces = this.raceList.getList();
        SelectionModel selectionModel = this.racesTable.getSelectionModel();
        ArrayList<TracTracRaceRecordDTO> selectedRaces = new ArrayList<TracTracRaceRecordDTO>();
        for (TracTracRaceRecordDTO race : allRaces) {
            if (!selectionModel.isSelected((Object)race)) continue;
            selectedRaces.add(race);
        }
        if (this.checkBoatClassOK(selectedRegatta, selectedRaces)) {
            this.sailingServiceWrite.trackWithTracTrac((RegattaIdentifier)regattaIdentifier, selectedRaces, liveURI, storedURI, updateURI, trackWind, correctWind, offsetToStartTimeOfSimulatedRace, ignoreTracTracMarkPassings, useOfficialResultsToUpdateRaceLogs, jsonUrlAsKey, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    public void refreshTracTracConnectors() {
        this.connectionsTable.refreshTracTracConnectionList();
    }

    public AbstractFilterablePanel<TracTracConfigurationWithSecurityDTO> getFilterablePanel() {
        return this.connectionsTable.getFilterField();
    }

    static /* synthetic */ ErrorReporter access$0(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.errorReporter;
    }

    static /* synthetic */ TracTracConnectionTableWrapper access$1(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.connectionsTable;
    }

    static /* synthetic */ SailingServiceWriteAsync access$2(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.sailingServiceWrite;
    }

    static /* synthetic */ FlushableCellTable access$3(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.racesTable;
    }

    static /* synthetic */ String access$4(TracTracEventManagementPanel tracTracEventManagementPanel, TracTracRaceRecordDTO tracTracRaceRecordDTO) {
        return tracTracEventManagementPanel.getBoatClassNamesAsString(tracTracRaceRecordDTO);
    }

    static /* synthetic */ DateTimeFormatRenderer access$5(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.dateFormatter;
    }

    static /* synthetic */ DateTimeFormatRenderer access$6(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.timeFormatter;
    }

    static /* synthetic */ Duration access$7(TracTracEventManagementPanel tracTracEventManagementPanel, String string) {
        return tracTracEventManagementPanel.getMillisecondsDurationFromMinutesAsString(string);
    }

    static /* synthetic */ void access$8(TracTracEventManagementPanel tracTracEventManagementPanel, boolean bl, boolean bl2, Duration duration, boolean bl3, boolean bl4) {
        tracTracEventManagementPanel.trackSelectedRaces(bl, bl2, duration, bl3, bl4);
    }

    static /* synthetic */ Label access$9(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.loadingMessageLabel;
    }

    static /* synthetic */ List access$10(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.availableTracTracRaces;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$11(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.racesFilterablePanel;
    }

    static /* synthetic */ ListDataProvider access$12(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.raceList;
    }

    static /* synthetic */ StringMessages access$13(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.stringMessages;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$14(TracTracEventManagementPanel tracTracEventManagementPanel) {
        return tracTracEventManagementPanel.presenter;
    }
}

