/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.gwt.ui.adminconsole.DefaultRegattaCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.EventCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaStructure;
import com.sap.sailing.gwt.ui.adminconsole.StructureImportListComposite;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.adminconsole.swisstiming.SwissTimingEventIdUrlUtil;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StructureImportManagementPanel
extends SimplePanel
implements StructureImportListComposite.RegattaStructureProvider {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final AdminConsoleView.Presenter presenter;
    private final StructureImportListComposite regattaListComposite;
    private final BusyIndicator busyIndicator;
    private TextBox jsonURLTextBox;
    private TextBox eventIDTextBox;
    private CaptionPanel regattaImportPanel;
    private Button listRegattasButton;
    private Button importDetailsButton;
    private VerticalPanel editSeriesPanel;
    private final FlexTable regattaStructureGrid;
    private List<EventDTO> existingEvents;
    private ListBox sailingEventsListBox;
    private final Displayer<EventDTO> eventsDisplayer;
    private final Map<RegattaStructure, RegattaDTO> regattaDefaultsPerStructure = new HashMap();
    private final Map<RegattaDTO, RegattaStructure> regattaStructures = new HashMap();

    public StructureImportManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.busyIndicator = new SimpleBusyIndicator();
        this.sailingServiceWrite = presenter.getSailingService();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        this.presenter = presenter;
        this.regattaListComposite = new StructureImportListComposite(presenter, (StructureImportListComposite.RegattaStructureProvider)this, this.errorReporter, stringMessages);
        this.eventsDisplayer = result -> this.fillEvents(result);
        this.regattaListComposite.ensureDebugId("RegattaListComposite");
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        this.createUI(mainPanel);
        this.regattaListComposite.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.regattaStructureGrid = new FlexTable();
    }

    private void createUI(VerticalPanel mainPanel) {
        FlowPanel progressPanel = new FlowPanel();
        progressPanel.add((Widget)this.busyIndicator);
        this.eventIDTextBox = new TextBox();
        this.eventIDTextBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventIDTextBox.ensureDebugId("eventIDTextBox");
        this.eventIDTextBox.setVisibleLength(50);
        this.jsonURLTextBox = new TextBox();
        this.jsonURLTextBox.ensureDebugId("JsonURLTextBox");
        this.jsonURLTextBox.setVisibleLength(100);
        this.jsonURLTextBox.getElement().setPropertyString("placeholder", SwissTimingEventIdUrlUtil.getUrlFromEventId((String)"d30883d3-2876-4d7e-af49-891af6cbae1b"));
        this.listRegattasButton = new Button(this.stringMessages.listRegattas());
        this.importDetailsButton = new Button(this.stringMessages.importRegattas());
        this.importDetailsButton.setEnabled(false);
        this.importDetailsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.listRegattasButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Grid eventURLGrid = new Grid(3, 2);
        eventURLGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.manage2SailEvent()) + this.stringMessages.id() + ":"));
        eventURLGrid.setWidget(0, 1, (Widget)this.eventIDTextBox);
        eventURLGrid.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.jsonUrl()) + ":"));
        eventURLGrid.setWidget(1, 1, (Widget)this.jsonURLTextBox);
        eventURLGrid.setWidget(2, 1, (Widget)this.listRegattasButton);
        mainPanel.add((Widget)progressPanel);
        mainPanel.add((Widget)eventURLGrid);
        this.regattaImportPanel = new CaptionPanel(this.stringMessages.manage2SailEvent());
        mainPanel.add((Widget)this.regattaImportPanel);
        VerticalPanel regattaImportContentPanel = new VerticalPanel();
        this.regattaImportPanel.setContentWidget((Widget)regattaImportContentPanel);
        this.editSeriesPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.setSpacing(10);
        hPanel.add((Widget)this.regattaListComposite);
        hPanel.setCellWidth((Widget)this.regattaListComposite, "50%");
        hPanel.add((Widget)this.editSeriesPanel);
        hPanel.setCellWidth((Widget)this.editSeriesPanel, "50%");
        regattaImportContentPanel.add((Widget)hPanel);
        regattaImportContentPanel.add((Widget)this.importDetailsButton);
    }

    private Widget createEventSelectionAndCreateEventButtonUI() {
        Grid grid = new Grid(1, 2);
        this.sailingEventsListBox = new ListBox();
        this.sailingEventsListBox.setMultipleSelect(false);
        this.sailingEventsListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.presenter.getEventsRefresher().callFillAndReloadInitially(this.getEventsDisplayer());
        this.sailingEventsListBox.ensureDebugId("EventListBox");
        grid.setWidget(0, 0, (Widget)this.sailingEventsListBox);
        Button newEventBtn = new Button(this.stringMessages.createNewEvent());
        newEventBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        grid.setWidget(0, 1, (Widget)newEventBtn);
        this.editSeriesPanel.add((Widget)grid);
        return grid;
    }

    private void openEventCreateDialog() {
        EventCreateDialog dialog = new EventCreateDialog((Collection)this.existingEvents, Collections.emptyList(), this.sailingServiceWrite, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void createEvent(EventDTO newEvent) {
        this.sailingServiceWrite.createEvent(newEvent.getName(), newEvent.getDescription(), newEvent.startDate, newEvent.endDate, newEvent.getVenue().getName(), newEvent.isPublic, newEvent.getVenue().getCourseAreas(), newEvent.getOfficialWebsiteURL(), newEvent.getBaseURL(), newEvent.getSailorsInfoWebsiteURLs(), newEvent.getImages(), newEvent.getVideos(), newEvent.getLeaderboardGroupIds(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void listRegattasAndTheirStructures() {
        String jsonURL = this.eventIDTextBox.getValue() == null || this.eventIDTextBox.getValue().length() == 0 ? this.jsonURLTextBox.getValue() : SwissTimingEventIdUrlUtil.getUrlFromEventId((String)this.eventIDTextBox.getValue());
        if (jsonURL == null || jsonURL.length() == 0) {
            this.errorReporter.reportError(this.stringMessages.pleaseEnterNonEmptyUrl());
        } else {
            this.busyIndicator.setBusy(true);
            this.sailingServiceWrite.getManage2SailRegattas(jsonURL, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateImportRegattasButtonEnabledness() {
        this.importDetailsButton.setEnabled(!this.regattaListComposite.getSelectedRegattas().isEmpty() && this.getSelectedEvent() != null);
    }

    private void fillRegattas(Iterable<RegattaDTO> regattasFromXRR) {
        this.regattaStructures.clear();
        this.regattaDefaultsPerStructure.clear();
        for (RegattaDTO regattaFromXRR : regattasFromXRR) {
            RegattaStructure regattaStructure = new RegattaStructure(regattaFromXRR);
            if (!this.regattaDefaultsPerStructure.containsKey(regattaStructure)) {
                RegattaDTO defaultsForRegattasWithStructure = this.createRegattaDefaults(regattaFromXRR);
                this.regattaDefaultsPerStructure.put(regattaStructure, defaultsForRegattasWithStructure);
            }
            this.regattaStructures.put(regattaFromXRR, regattaStructure);
        }
        this.regattaListComposite.fillRegattas((Iterable)((List)regattasFromXRR));
    }

    private RegattaDTO createRegattaDefaults(RegattaDTO regatta) {
        RegattaDTO result = new RegattaDTO("Default", ScoringSchemeType.LOW_POINT);
        result.boatClass = new BoatClassDTO("Default", (Distance)new MeterDistance(5.0), (Distance)new MeterDistance(1.8));
        result.series = regatta.series;
        result.rankingMetricType = RankingMetrics.ONE_DESIGN;
        return result;
    }

    private void updateRegattaStructureGrid() {
        while (this.regattaStructureGrid.getRowCount() > 0) {
            this.regattaStructureGrid.removeRow(0);
        }
        List originalXRRImportedRegattasToConsider = this.regattaListComposite.getSelectedRegattas().isEmpty() ? this.regattaListComposite.getAllRegattas() : this.regattaListComposite.getSelectedRegattas();
        HashSet<RegattaStructure> structures = new HashSet<RegattaStructure>();
        for (RegattaDTO originalXRRImportedRegatta : originalXRRImportedRegattasToConsider) {
            structures.add((RegattaStructure)this.regattaStructures.get(originalXRRImportedRegatta));
        }
        int i = 0;
        for (RegattaStructure regattaStructure : structures) {
            int row = i++;
            this.updateRegattaStructureGridRow(row, regattaStructure);
        }
    }

    private void updateRegattaStructureGridRow(int row, RegattaStructure regattaStructure) {
        Button editBtn = new Button(this.stringMessages.editSeries());
        editBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.regattaStructureGrid.setWidget(row, 0, (Widget)new Label(regattaStructure.toString()));
        this.regattaStructureGrid.setWidget(row, 1, (Widget)editBtn);
    }

    private void editRegattaDefaults(int row, RegattaStructure regattaStructure) {
        ArrayList<EventDTO> existingEvents = new ArrayList<EventDTO>();
        EventDTO selectedEvent = this.getSelectedEvent();
        if (selectedEvent != null) {
            existingEvents.add(this.getSelectedEvent());
        }
        DefaultRegattaCreateDialog dialog = new DefaultRegattaCreateDialog(existingEvents, (RegattaDTO)this.regattaDefaultsPerStructure.get(regattaStructure), (SailingServiceAsync)this.sailingServiceWrite, this.presenter.getUserService(), this.errorReporter, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("DefaultRegattaCreateDialog");
        dialog.show();
    }

    private EventDTO getSelectedEvent() {
        EventDTO result = null;
        int selIndex = this.sailingEventsListBox.getSelectedIndex();
        if (selIndex > 0) {
            String itemValue = this.sailingEventsListBox.getValue(selIndex);
            for (EventDTO eventDTO : this.existingEvents) {
                if (!eventDTO.getName().equals(itemValue)) continue;
                result = eventDTO;
                break;
            }
        }
        return result;
    }

    private void createRegattas(Iterable<RegattaDTO> selectedOriginalRegattasFromXRR, EventDTO newEvent) {
        ArrayList<RegattaDTO> regattaConfigurationsToCreate = new ArrayList<RegattaDTO>();
        for (RegattaDTO originalRegattaFromXRR : selectedOriginalRegattasFromXRR) {
            RegattaDTO cloneFromDefaults = new RegattaDTO((RegattaDTO)this.regattaDefaultsPerStructure.get(this.regattaStructures.get(originalRegattaFromXRR)));
            cloneFromDefaults.setName(originalRegattaFromXRR.getName());
            cloneFromDefaults.boatClass = originalRegattaFromXRR.boatClass;
            Iterator originalSeriesIter = originalRegattaFromXRR.series.iterator();
            Iterator cloneFromDefaultsSeriesIter = cloneFromDefaults.series.iterator();
            while (originalSeriesIter.hasNext() && cloneFromDefaultsSeriesIter.hasNext()) {
                SeriesDTO originalSeries = (SeriesDTO)originalSeriesIter.next();
                SeriesDTO cloneFromDefaultsSeries = (SeriesDTO)cloneFromDefaultsSeriesIter.next();
                cloneFromDefaultsSeries.setRaceColumns(originalSeries.getRaceColumns());
            }
            regattaConfigurationsToCreate.add(cloneFromDefaults);
        }
        this.sailingServiceWrite.createRegattaStructure(regattaConfigurationsToCreate, newEvent, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public RegattaStructure getRegattaStructure(RegattaDTO regatta) {
        return (RegattaStructure)this.regattaStructures.get(regatta);
    }

    public Displayer<EventDTO> getEventsDisplayer() {
        return this.eventsDisplayer;
    }

    private void fillEvents(Iterable<EventDTO> result) {
        if (this.sailingEventsListBox != null) {
            this.sailingEventsListBox.clear();
            this.existingEvents = new ArrayList();
            Util.filter(result, e -> this.presenter.getUserService().hasPermission((SecuredDTO)e, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)).forEach(this.existingEvents::add);
            Collections.sort(this.existingEvents, new /* Unavailable Anonymous Inner Class!! */);
            this.sailingEventsListBox.addItem(this.stringMessages.selectSailingEvent());
            for (EventDTO event : this.existingEvents) {
                this.sailingEventsListBox.addItem(event.getName());
            }
        }
    }

    static /* synthetic */ void access$0(StructureImportManagementPanel structureImportManagementPanel) {
        structureImportManagementPanel.updateRegattaStructureGrid();
    }

    static /* synthetic */ void access$1(StructureImportManagementPanel structureImportManagementPanel) {
        structureImportManagementPanel.updateImportRegattasButtonEnabledness();
    }

    static /* synthetic */ TextBox access$2(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.eventIDTextBox;
    }

    static /* synthetic */ TextBox access$3(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.jsonURLTextBox;
    }

    static /* synthetic */ EventDTO access$4(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.getSelectedEvent();
    }

    static /* synthetic */ StructureImportListComposite access$5(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.regattaListComposite;
    }

    static /* synthetic */ void access$6(StructureImportManagementPanel structureImportManagementPanel, Iterable iterable, EventDTO eventDTO) {
        structureImportManagementPanel.createRegattas(iterable, eventDTO);
    }

    static /* synthetic */ ErrorReporter access$7(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$8(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.stringMessages;
    }

    static /* synthetic */ void access$9(StructureImportManagementPanel structureImportManagementPanel) {
        structureImportManagementPanel.listRegattasAndTheirStructures();
    }

    static /* synthetic */ void access$10(StructureImportManagementPanel structureImportManagementPanel) {
        structureImportManagementPanel.openEventCreateDialog();
    }

    static /* synthetic */ void access$11(StructureImportManagementPanel structureImportManagementPanel, EventDTO eventDTO) {
        structureImportManagementPanel.createEvent(eventDTO);
    }

    static /* synthetic */ List access$12(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.existingEvents;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$13(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.presenter;
    }

    static /* synthetic */ ListBox access$14(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.sailingEventsListBox;
    }

    static /* synthetic */ BusyIndicator access$15(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.busyIndicator;
    }

    static /* synthetic */ VerticalPanel access$16(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.editSeriesPanel;
    }

    static /* synthetic */ void access$17(StructureImportManagementPanel structureImportManagementPanel, Iterable iterable) {
        structureImportManagementPanel.fillRegattas(iterable);
    }

    static /* synthetic */ Widget access$18(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.createEventSelectionAndCreateEventButtonUI();
    }

    static /* synthetic */ FlexTable access$19(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.regattaStructureGrid;
    }

    static /* synthetic */ void access$20(StructureImportManagementPanel structureImportManagementPanel, int n, RegattaStructure regattaStructure) {
        structureImportManagementPanel.editRegattaDefaults(n, regattaStructure);
    }

    static /* synthetic */ Map access$21(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.regattaDefaultsPerStructure;
    }

    static /* synthetic */ Map access$22(StructureImportManagementPanel structureImportManagementPanel) {
        return structureImportManagementPanel.regattaStructures;
    }

    static /* synthetic */ void access$23(StructureImportManagementPanel structureImportManagementPanel, int n, RegattaStructure regattaStructure) {
        structureImportManagementPanel.updateRegattaStructureGridRow(n, regattaStructure);
    }
}

