/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.racelog.tracking.RaceLogTrackingState;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.ChooseNameDenoteEventDialog;
import com.sap.sailing.gwt.ui.adminconsole.CopyCourseAndCompetitorsDialog;
import com.sap.sailing.gwt.ui.adminconsole.InviteBuoyTenderDialog;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogCompetitorRegistrationDialog;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogTrackingCourseDefinitionDialog;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogTrackingEventManagementImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogTrackingEventManagementRaceImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLogBoatRegistrationDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLogCompetitorRegistrationDialog;
import com.sap.sailing.gwt.ui.adminconsole.SetFinishingAndFinishedTimeDialog;
import com.sap.sailing.gwt.ui.adminconsole.SetStartTimeDialog;
import com.sap.sailing.gwt.ui.adminconsole.SetTrackingTimesDialog;
import com.sap.sailing.gwt.ui.adminconsole.ShowCompetitorToBoatMappingsDialog;
import com.sap.sailing.gwt.ui.adminconsole.SmartphoneTrackingEventManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.TrackFileImportDeviceIdentifierTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.TrackFileImportWidget;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRaceChangedListener;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SmartphoneTrackingEventManagementPanel
extends AbstractLeaderboardConfigPanel {
    private ToggleButton startStopTrackingButton;
    private TrackFileImportDeviceIdentifierTableWrapper deviceIdentifierTable;
    private CheckBox correctWindDirectionForDeclination;
    private CheckBox trackWind;
    protected boolean regattaHasCompetitors = false;
    private Map<Util.Triple<String, String, String>, Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog>> raceWithStartAndEndOfTrackingTime = new HashMap();
    private CaptionPanel importPanel;
    private final Refresher<CompetitorDTO> competitorsRefresher;
    private final Refresher<BoatDTO> boatsRefresher;

    public SmartphoneTrackingEventManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        super(presenter, stringMessages, true);
        this.competitorsRefresher = presenter.getCompetitorsRefresher();
        this.boatsRefresher = presenter.getBoatsRefresher();
        this.importPanel = new CaptionPanel(stringMessages.importFixes());
        this.importPanel.setVisible(false);
        VerticalPanel importContent = new VerticalPanel();
        this.mainPanel.add((Widget)this.importPanel);
        this.deviceIdentifierTable = new TrackFileImportDeviceIdentifierTableWrapper(this.sailingServiceWrite, stringMessages, this.errorReporter);
        TrackFileImportWidget importWidget = new TrackFileImportWidget(this.deviceIdentifierTable, stringMessages, this.sailingServiceWrite, this.errorReporter);
        this.importPanel.add((Widget)importContent);
        importContent.add((Widget)importWidget);
        importContent.add((IsWidget)this.deviceIdentifierTable);
        this.trackedRacesListComposite.addTrackedRaceChangeListener((TrackedRaceChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.userService.addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */, true);
    }

    protected boolean isActionButtonsEnabled() {
        return true;
    }

    protected void addColumnsToLeaderboardTableAndSetSelectionModel(UserService userService, FlushableCellTable<StrippedLeaderboardDTO> leaderboardTable, AdminConsoleTableResources tableResources, ListDataProvider<StrippedLeaderboardDTO> listDataProvider) {
        ColumnSortEvent.ListHandler leaderboardColumnListHandler = new ColumnSortEvent.ListHandler(this.filteredLeaderboardList.getList());
        SelectionCheckboxColumn selectionCheckboxColumn = this.createSortableSelectionCheckboxColumn(leaderboardTable, tableResources, leaderboardColumnListHandler, listDataProvider);
        3 leaderboardNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardNameColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        5 leaderboardDisplayNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardDisplayNameColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardDisplayNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        7 leaderboardCanBoatsOfCompetitorsChangePerRaceColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardCanBoatsOfCompetitorsChangePerRaceColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardCanBoatsOfCompetitorsChangePerRaceColumn, (l1, l2) -> Boolean.valueOf(l1.canBoatsOfCompetitorsChangePerRace).compareTo(l2.canBoatsOfCompetitorsChangePerRace));
        HasPermissions type = SecuredDomainType.EVENT;
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, leaderboard -> listDataProvider.refresh(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, leaderboard -> {
            AccessControlListDTO accessControlListDTO = leaderboard.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        AccessControlledActionsColumn leaderboardActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new RaceLogTrackingEventManagementImagesBarCell(this.stringMessages), (UserService)userService);
        leaderboardActionColumn.addAction("ACTION_DENOTE_FOR_RACELOG_TRACKING", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.denoteForRaceLogTracking(arg_0));
        leaderboardActionColumn.addAction("ACTION_COMPETITOR_REGISTRATIONS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.handleCompetitorRegistration(arg_0));
        leaderboardActionColumn.addAction("ACTION_BOAT_REGISTRATIONS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.handleBoatRegistration(arg_0));
        leaderboardActionColumn.addAction("ACTION_MAP_DEVICES", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.handleDeviceMappings(arg_0));
        leaderboardActionColumn.addAction("ACTION_INVITE_BUOY_TENDERS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, t -> this.openChooseEventDialogAndSendMails(t.getName()));
        leaderboardActionColumn.addAction("ACTION_SHOW_REGATTA_LOG", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, t -> this.showRegattaLog());
        leaderboardActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        leaderboardActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        leaderboardTable.addColumn((Column)selectionCheckboxColumn, selectionCheckboxColumn.getHeader());
        leaderboardTable.addColumn((Column)leaderboardNameColumn, this.stringMessages.name());
        leaderboardTable.addColumn((Column)leaderboardDisplayNameColumn, this.stringMessages.displayName());
        leaderboardTable.addColumn((Column)leaderboardCanBoatsOfCompetitorsChangePerRaceColumn, this.stringMessages.canBoatsChange());
        SecuredDTOOwnerColumn.configureOwnerColumns(leaderboardTable, (ColumnSortEvent.ListHandler)leaderboardColumnListHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        leaderboardTable.addColumn((Column)leaderboardActionColumn, this.stringMessages.actions());
        leaderboardTable.addColumnSortHandler((ColumnSortEvent.Handler)leaderboardColumnListHandler);
        leaderboardTable.setSelectionModel((SelectionModel)selectionCheckboxColumn.getSelectionModel(), selectionCheckboxColumn.getSelectionManager());
    }

    private RaceLogTrackingState getTrackingState(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race) {
        return ((RaceColumnDTO)race.getA()).getRaceLogTrackingInfo((FleetDTO)((FleetDTO)race.getB())).raceLogTrackingState;
    }

    private boolean trackerExists(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race) {
        return ((RaceColumnDTO)race.getA()).getRaceLogTrackingInfo((FleetDTO)((FleetDTO)race.getB())).raceLogTrackerExists;
    }

    private boolean isFinished(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race) {
        RaceDTO raceDTO = ((RaceColumnDTO)race.getA()).getRace((FleetDTO)race.getB());
        boolean raceFinished = false;
        if (raceDTO != null) {
            raceFinished = raceDTO.status.status.equals((Object)TrackedRaceStatusEnum.FINISHED);
        }
        return raceFinished;
    }

    private boolean doesTrackerExist(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race) {
        return ((RaceColumnDTO)race.getA()).getRaceLogTrackingInfo((FleetDTO)((FleetDTO)race.getB())).raceLogTrackerExists;
    }

    private boolean doesCourseExist(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race) {
        return ((RaceColumnDTO)race.getA()).getRaceLogTrackingInfo((FleetDTO)((FleetDTO)race.getB())).courseExists;
    }

    private boolean doCompetitorRegistrationsExist(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race) {
        return ((RaceColumnDTO)race.getA()).getRaceLogTrackingInfo((FleetDTO)((FleetDTO)race.getB())).competitorRegistrationsExists;
    }

    protected void addColumnsToRacesTable(CellTable<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> racesTable) {
        8 raceLogTrackingStateColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 trackerStateColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 courseStateColumn = new /* Unavailable Anonymous Inner Class!! */;
        AccessControlledActionsColumn raceActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new RaceLogTrackingEventManagementRaceImagesBarCell(this.stringMessages, this), (UserService)this.userService, t -> (SecuredDTO)t.getC());
        raceActionColumn.addAction("ACTION_DENOTE_FOR_RACELOG_TRACKING", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.denoteForRaceLogTracking(arg_0));
        raceActionColumn.addAction("ACTION_REMOVE_DENOTATION", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.removeDenotation(arg_0));
        raceActionColumn.addAction("ACTION_COMPETITOR_REGISTRATIONS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.handleCompetitorRegistration(arg_0));
        raceActionColumn.addAction("ACTION_DEFINE_COURSE", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.handleDefineCourse(arg_0));
        raceActionColumn.addAction("ACTION_COPY", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.handleCopy(arg_0));
        raceActionColumn.addAction("ACTION_EDIT", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> ((SmartphoneTrackingEventManagementPanel)this).editRaceColumnOfLeaderboard(arg_0));
        raceActionColumn.addAction("ACTION_UNLINK", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, t -> this.unlinkRaceColumnFromTrackedRace(((RaceColumnDTO)t.getA()).getRaceColumnName(), (FleetDTO)t.getB()));
        raceActionColumn.addAction("ACTION_REFRESH_RACE_LOG", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, t -> this.refreshRaceLog((RaceColumnDTO)t.getA(), (FleetDTO)t.getB(), true));
        raceActionColumn.addAction("ACTION_SET_STARTTIME", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.setStartTime(arg_0));
        raceActionColumn.addAction("ACTION_SET_FINISHING_AND_FINISH_TIME", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.setEndTime(arg_0));
        raceActionColumn.addAction("ACTION_SHOW_RACELOG", (HasPermissions.Action)HasPermissions.DefaultActions.READ, t -> this.showRaceLog((RaceColumnDTO)t.getA(), (FleetDTO)t.getB()));
        raceActionColumn.addAction("ACTION_SET_TRACKING_TIMES", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.showSetTrackingTimesDialog(arg_0));
        raceActionColumn.addAction("ACTION_START_TRACKING", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, t -> this.startTracking(Collections.singleton(t), this.trackWind.getValue().booleanValue(), this.correctWindDirectionForDeclination.getValue().booleanValue()));
        raceActionColumn.addAction("ACTION_STOP_TRACKING", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, t -> this.stopTracking(Collections.singleton(t)));
        raceActionColumn.addAction("ACTION_EDIT_COMPETITOR_TO_BOAT_MAPPINGS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.showCompetitorToBoatMappings(arg_0));
        raceActionColumn.addAction("ACTION_CERTIFICATE_ASSIGNMENT", (HasPermissions.Action)HasPermissions.DefaultActions.READ, t -> this.assignCertificates(t));
        raceActionColumn.addAction("ACTION_SCRATCH_BOAT_SELECTION", (HasPermissions.Action)HasPermissions.DefaultActions.READ, t -> this.selectScratchBoat(t));
        raceActionColumn.addAction("ACTION_SET_IMPLIED_WIND", (HasPermissions.Action)HasPermissions.DefaultActions.READ, t -> this.setImpliedWind(t));
        racesTable.addColumn((Column)raceLogTrackingStateColumn, this.stringMessages.raceStatusColumn());
        racesTable.addColumn((Column)trackerStateColumn, this.stringMessages.trackerStatus());
        racesTable.addColumn((Column)courseStateColumn, this.stringMessages.courseStatus());
        racesTable.addColumn((Column)raceActionColumn, this.stringMessages.actions());
    }

    private void handleCopy(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        String leaderboardName = ((StrippedLeaderboardDTO)t.getC()).getName();
        ArrayList races = new ArrayList(this.raceColumnTable.getDataProvider().getList());
        races.remove(t);
        Distance buoyZoneRadius = this.getSelectedRegatta() == null ? RaceMapSettings.DEFAULT_BUOY_ZONE_RADIUS : this.getSelectedRegatta().getCalculatedBuoyZoneRadius();
        new CopyCourseAndCompetitorsDialog(this.sailingServiceWrite, this.errorReporter, this.stringMessages, races, t, this.availableLeaderboardList, leaderboardName, buoyZoneRadius, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void handleDefineCourse(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        String leaderboardName = ((StrippedLeaderboardDTO)t.getC()).getName();
        String raceColumnName = ((RaceColumnDTO)t.getA()).getName();
        String fleetName = ((FleetDTO)t.getB()).getName();
        new RaceLogTrackingCourseDefinitionDialog(this.presenter, this.stringMessages, leaderboardName, raceColumnName, fleetName, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void handleCompetitorRegistration(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        String leaderboardName = ((StrippedLeaderboardDTO)t.getC()).getName();
        boolean canBoatsOfCompetitorsChangePerRace = this.canBoatsOfCompetitorsChangePerRace();
        String raceColumnName = ((RaceColumnDTO)t.getA()).getName();
        String fleetName = ((FleetDTO)t.getB()).getName();
        boolean editable = !this.doesTrackerExist(t) || this.getTrackingState(t) != RaceLogTrackingState.TRACKING;
        this.registerCompetitorsInRaceLog(this.getSelectedRegatta(), editable, leaderboardName, canBoatsOfCompetitorsChangePerRace, raceColumnName, fleetName, t);
    }

    private void registerCompetitorsInRaceLog(RegattaDTO selectedRegatta, boolean editable, String leaderboardName, boolean canBoatsOfCompetitorsChangePerRace, String raceColumnName, String fleetName, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleetDTO) {
        RegattaDTO regatta = this.getSelectedRegatta();
        String boatClassName = regatta.boatClass.getName();
        RaceLogCompetitorRegistrationDialog dialog = new RaceLogCompetitorRegistrationDialog(boatClassName, this.sailingServiceWrite, this.userService, this.competitorsRefresher, this.boatsRefresher, this.stringMessages, this.errorReporter, editable, leaderboardName, canBoatsOfCompetitorsChangePerRace, raceColumnName, fleetName, ((RaceColumnDTO)raceColumnDTOAndFleetDTO.getA()).getFleets(), (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    protected void addLeaderboardControls(AccessControlledButtonPanel buttonPanel) {
    }

    protected void addSelectedLeaderboardRacesControls(Panel racesPanel) {
        this.trackWind = new CheckBox(this.stringMessages.trackWind());
        this.trackWind.setValue(Boolean.valueOf(true));
        this.correctWindDirectionForDeclination = new CheckBox(this.stringMessages.declinationCheckbox());
        this.correctWindDirectionForDeclination.setValue(Boolean.valueOf(true));
        this.startStopTrackingButton = new ToggleButton(this.stringMessages.startTracking(), this.stringMessages.stopTracking());
        this.startStopTrackingButton.ensureDebugId("StartTrackingButton");
        this.startStopTrackingButton.setEnabled(false);
        racesPanel.add((Widget)this.trackWind);
        racesPanel.add((Widget)this.correctWindDirectionForDeclination);
        racesPanel.add((Widget)this.startStopTrackingButton);
        this.startStopTrackingButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.raceColumnTableSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void stopTracking(Set<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> selectedSet) {
        ArrayList<RegattaAndRaceIdentifier> racesToStopTracking = new ArrayList<RegattaAndRaceIdentifier>();
        for (AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleetDTOWithNameBasedEquality : selectedSet) {
            RaceDTO race = ((RaceColumnDTO)raceColumnDTOAndFleetDTOWithNameBasedEquality.getA()).getRace((FleetDTO)raceColumnDTOAndFleetDTOWithNameBasedEquality.getB());
            if (race == null || !race.isTracked) continue;
            racesToStopTracking.add(race.getRaceIdentifier());
        }
        this.sailingServiceWrite.stopTrackingRaces(racesToStopTracking, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void enableStartTrackingButtonIfAppropriateRacesSelected() {
        boolean hasPermissionToChange;
        boolean onlyUntrackedRacesPresent = this.raceColumnTableSelectionModel.getSelectedSet().size() > 0;
        boolean onlyTrackedRacesPresent = this.raceColumnTableSelectionModel.getSelectedSet().size() > 0;
        boolean onlyRacesWithNonExistentTracker = this.raceColumnTableSelectionModel.getSelectedSet().size() > 0;
        for (AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race : this.raceColumnTableSelectionModel.getSelectedSet()) {
            if (this.getTrackingState(race).isForTracking() && this.isFinished(race)) {
                onlyUntrackedRacesPresent = false;
                onlyTrackedRacesPresent = false;
            }
            if (!this.getTrackingState(race).isForTracking() || this.doesTrackerExist(race) || this.isFinished(race)) {
                onlyUntrackedRacesPresent = false;
            } else {
                onlyTrackedRacesPresent = false;
            }
            if (!this.trackerExists(race)) continue;
            onlyRacesWithNonExistentTracker = false;
        }
        boolean bl = hasPermissionToChange = this.leaderboardSelectionModel.getSelectedSet().stream().filter(new /* Unavailable Anonymous Inner Class!! */).count() > 0L;
        if (!onlyTrackedRacesPresent && !onlyUntrackedRacesPresent) {
            this.startStopTrackingButton.setEnabled(false);
        }
        if (onlyTrackedRacesPresent) {
            this.startStopTrackingButton.setDown(true);
            this.startStopTrackingButton.setEnabled(hasPermissionToChange);
        }
        if (onlyUntrackedRacesPresent || onlyRacesWithNonExistentTracker) {
            this.startStopTrackingButton.setDown(false);
            this.startStopTrackingButton.setEnabled(hasPermissionToChange);
        }
    }

    protected void leaderboardRaceColumnSelectionChanged() {
        AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality selectedRaceInLeaderboard = this.getSelectedRaceColumnWithFleet();
        if (selectedRaceInLeaderboard != null) {
            this.selectTrackedRaceInRaceList();
        } else {
            this.trackedRacesListComposite.clearSelection();
        }
        this.enableStartTrackingButtonIfAppropriateRacesSelected();
    }

    protected void leaderboardSelectionChanged() {
        StrippedLeaderboardDTO selectedLeaderboard = this.getSelectedLeaderboard();
        this.regattaHasCompetitors = false;
        if (this.leaderboardSelectionModel.getSelectedSet().size() == 1 && selectedLeaderboard != null) {
            ArrayList<Util.Triple> raceColumnsAndFleets = new ArrayList<Util.Triple>();
            for (RaceColumnDTO raceColumn : selectedLeaderboard.getRaceList()) {
                for (FleetDTO fleet : raceColumn.getFleets()) {
                    raceColumnsAndFleets.add(new Util.Triple((Object)selectedLeaderboard.getName(), (Object)raceColumn.getName(), (Object)fleet.getName()));
                }
            }
            this.sailingServiceWrite.getTrackingTimes(raceColumnsAndFleets, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.selectedLeaderBoardPanel.setVisible(true);
            this.selectedLeaderBoardPanel.setCaptionText("Details of leaderboard '" + selectedLeaderboard.getName() + "'");
            if (!selectedLeaderboard.type.isMetaLeaderboard()) {
                this.trackedRacesListComposite.setRegattaFilterValue(selectedLeaderboard.regattaName);
                this.trackedRacesCaptionPanel.setVisible(true);
            }
            this.sailingServiceWrite.doesRegattaLogContainCompetitors(((StrippedLeaderboardDTO)this.leaderboardSelectionModel.getSelectedSet().toArray()[0]).getName(), (AsyncCallback)new RegattaLogCallBack(this, null));
        } else {
            this.selectedLeaderBoardPanel.setVisible(false);
            this.trackedRacesCaptionPanel.setVisible(false);
        }
    }

    public Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog> getTrackingTimesFor(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleet) {
        return (Util.Pair)this.raceWithStartAndEndOfTrackingTime.get(new Util.Triple((Object)this.getSelectedLeaderboard().getName(), (Object)((RaceColumnDTO)raceColumnDTOAndFleet.getA()).getName(), (Object)((FleetDTO)raceColumnDTOAndFleet.getB()).getName()));
    }

    private void denoteForRaceLogTracking(StrippedLeaderboardDTO leaderboard) {
        ChooseNameDenoteEventDialog dialog = new ChooseNameDenoteEventDialog(this.stringMessages, leaderboard, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void denoteRacesWithMultipleFleetsToDefineTheirOwnCompetitors(String leaderboardName, Iterable<RaceColumnDTO> raceColumns) {
        HashSet<Util.Pair> raceCoordinatesUsingOwnCompetitors = new HashSet<Util.Pair>();
        for (RaceColumnDTO raceColumn : raceColumns) {
            if (raceColumn.getFleets().size() <= 1) continue;
            for (FleetDTO fleet : raceColumn.getFleets()) {
                this.sailingServiceWrite.enableCompetitorRegistrationsForRace(leaderboardName, raceColumn.getName(), fleet.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                raceCoordinatesUsingOwnCompetitors.add(new Util.Pair((Object)raceColumn, (Object)fleet));
            }
        }
    }

    private void updateRegattaConfigDesignerModeToByMarks(String regattaName) {
        RegattaDTO regatta = this.getRegattaByName(regattaName);
        if (regatta != null) {
            DeviceConfigurationDTO.RegattaConfigurationDTO configuration = regatta.configuration;
            if (configuration == null) {
                configuration = new DeviceConfigurationDTO.RegattaConfigurationDTO();
                configuration.defaultCourseDesignerMode = CourseDesignerMode.BY_MARKS;
                this.updateRegattaConfiguration(regatta, configuration);
            } else if (configuration.defaultCourseDesignerMode != CourseDesignerMode.BY_MARKS) {
                DialogBox dialogBox = this.createOverrideConfigurationDialog(regatta, configuration);
                dialogBox.center();
            }
        }
    }

    private DialogBox createOverrideConfigurationDialog(RegattaDTO regatta, DeviceConfigurationDTO.RegattaConfigurationDTO configuration) {
        DialogBox dialogBox = new DialogBox(true, true);
        dialogBox.setText(this.stringMessages.allRacesHaveBeenDenoted());
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.add((Widget)new HTML(new SafeHtmlBuilder().appendEscapedLines(this.stringMessages.warningOverrideRegattaConfigurationCourseDesignerToByMarks()).toSafeHtml()));
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setSpacing(5);
        contentPanel.add((Widget)buttonPanel);
        Button yesButton = new Button(this.stringMessages.yes());
        yesButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)yesButton);
        Button noButton = new Button(this.stringMessages.no(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)noButton);
        dialogBox.setWidget((Widget)contentPanel);
        return dialogBox;
    }

    private void updateRegattaConfiguration(RegattaDTO regatta, DeviceConfigurationDTO.RegattaConfigurationDTO configuration) {
        RegattaName regattaIdentifier = new RegattaName(regatta.getName());
        this.sailingServiceWrite.updateRegatta((RegattaIdentifier)regattaIdentifier, regatta.startDate, regatta.endDate, (List)Util.mapToArrayList((Iterable)regatta.courseAreas, CourseAreaDTO::getId), configuration, regatta.buoyZoneRadiusInHullLengths, regatta.useStartTimeInference, regatta.controlTrackingFromStartAndFinishTimes, regatta.autoRestartTrackingUponCompetitorSetChange, regatta.registrationLinkSecret, regatta.competitorRegistrationType, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void denoteForRaceLogTracking(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        this.sailingServiceWrite.denoteForRaceLogTracking(((StrippedLeaderboardDTO)t.getC()).getName(), ((RaceColumnDTO)t.getA()).getName(), ((FleetDTO)t.getB()).getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void removeDenotation(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        this.sailingServiceWrite.removeDenotationForRaceLogTracking(((StrippedLeaderboardDTO)t.getC()).getName(), ((RaceColumnDTO)t.getA()).getName(), ((FleetDTO)t.getB()).getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void startTracking(Set<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> races, boolean trackWind, boolean correctWindByDeclination) {
        boolean proceed;
        StrippedLeaderboardDTO leaderboard = this.getSelectedLeaderboard();
        String namesOfRacesMissingRegistrations = "";
        if (!this.regattaHasCompetitors) {
            for (AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race : races) {
                if (this.doCompetitorRegistrationsExist(race)) continue;
                namesOfRacesMissingRegistrations = String.valueOf(namesOfRacesMissingRegistrations) + ((RaceColumnDTO)race.getA()).getName() + "/" + ((FleetDTO)race.getB()).getName() + " ";
            }
        }
        if (!namesOfRacesMissingRegistrations.isEmpty() && !(proceed = Window.confirm((String)this.stringMessages.competitorRegistrationsMissingProceed(namesOfRacesMissingRegistrations)))) {
            return;
        }
        ArrayList<Util.Triple> leaderboardRaceColumnFleetNames = new ArrayList<Util.Triple>();
        for (AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race : races) {
            RaceColumnDTO raceColumn = (RaceColumnDTO)race.getA();
            FleetDTO fleet = (FleetDTO)race.getB();
            leaderboardRaceColumnFleetNames.add(new Util.Triple((Object)leaderboard.getName(), (Object)raceColumn.getName(), (Object)fleet.getName()));
        }
        this.sailingServiceWrite.startRaceLogTracking(leaderboardRaceColumnFleetNames, trackWind, correctWindByDeclination, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setStartTime(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        new SetStartTimeDialog((SailingServiceAsync)this.sailingServiceWrite, this.errorReporter, ((StrippedLeaderboardDTO)t.getC()).getName(), ((RaceColumnDTO)t.getA()).getName(), ((FleetDTO)t.getB()).getName(), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void setEndTime(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        new SetFinishingAndFinishedTimeDialog((SailingServiceAsync)this.sailingServiceWrite, this.errorReporter, ((StrippedLeaderboardDTO)t.getC()).getName(), ((RaceColumnDTO)t.getA()).getName(), ((FleetDTO)t.getB()).getName(), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void refreshTrackingActionButtons() {
        this.leaderboardSelectionChanged();
    }

    private void showSetTrackingTimesDialog(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        new SetTrackingTimesDialog((SailingServiceAsync)this.sailingServiceWrite, this.errorReporter, ((StrippedLeaderboardDTO)t.getC()).getName(), ((RaceColumnDTO)t.getA()).getName(), ((FleetDTO)t.getB()).getName(), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void showCompetitorToBoatMappings(AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality t) {
        String selectedLeaderboardName = ((StrippedLeaderboardDTO)t.getC()).getName();
        String raceColumnName = ((RaceColumnDTO)t.getA()).getName();
        String fleetName = ((FleetDTO)t.getB()).getName();
        String raceName = "Default".equals(fleetName) ? raceColumnName : String.valueOf(raceColumnName) + ", " + fleetName;
        ShowCompetitorToBoatMappingsDialog dialog = new ShowCompetitorToBoatMappingsDialog(this.sailingServiceWrite, this.stringMessages, this.errorReporter, selectedLeaderboardName, raceColumnName, fleetName, raceName, this.userService);
        dialog.center();
    }

    private String getLocaleInfo() {
        return LocaleInfo.getCurrentLocale().getLocaleName();
    }

    private void openChooseEventDialogAndSendMails(String leaderboardName) {
        new InviteBuoyTenderDialog(this.stringMessages, (SailingServiceAsync)this.sailingServiceWrite, leaderboardName, this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void handleCompetitorRegistration(StrippedLeaderboardDTO t) {
        RegattaDTO regatta = this.getSelectedRegatta();
        String boatClassName = regatta.boatClass.getName();
        new RegattaLogCompetitorRegistrationDialog(boatClassName, this.sailingServiceWrite, this.userService, this.competitorsRefresher, this.boatsRefresher, this.stringMessages, this.errorReporter, true, t.getName(), t.canBoatsOfCompetitorsChangePerRace, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void handleBoatRegistration(StrippedLeaderboardDTO t) {
        if (t.canBoatsOfCompetitorsChangePerRace) {
            RegattaDTO regatta = this.getSelectedRegatta();
            String boatClassName = regatta.boatClass.getName();
            new RegattaLogBoatRegistrationDialog(boatClassName, this.sailingServiceWrite, this.userService, this.boatsRefresher, this.competitorsRefresher, this.stringMessages, this.errorReporter, true, t.getName(), t.canBoatsOfCompetitorsChangePerRace, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
        } else {
            Notification.notify((String)this.stringMessages.canNotRegisterBoats(), (Notification.NotificationType)Notification.NotificationType.ERROR);
        }
    }

    private void handleDeviceMappings(StrippedLeaderboardDTO t) {
        this.sailingServiceWrite.getSecretForRegattaByName(t.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ CaptionPanel access$0(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel) {
        return smartphoneTrackingEventManagementPanel.importPanel;
    }

    static /* synthetic */ RaceLogTrackingState access$1(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleetDTOWithNameBasedEquality) {
        return smartphoneTrackingEventManagementPanel.getTrackingState(raceColumnDTOAndFleetDTOWithNameBasedEquality);
    }

    static /* synthetic */ boolean access$2(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleetDTOWithNameBasedEquality) {
        return smartphoneTrackingEventManagementPanel.doesTrackerExist(raceColumnDTOAndFleetDTOWithNameBasedEquality);
    }

    static /* synthetic */ boolean access$3(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleetDTOWithNameBasedEquality) {
        return smartphoneTrackingEventManagementPanel.doesCourseExist(raceColumnDTOAndFleetDTOWithNameBasedEquality);
    }

    static /* synthetic */ ToggleButton access$4(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel) {
        return smartphoneTrackingEventManagementPanel.startStopTrackingButton;
    }

    static /* synthetic */ CheckBox access$5(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel) {
        return smartphoneTrackingEventManagementPanel.trackWind;
    }

    static /* synthetic */ CheckBox access$6(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel) {
        return smartphoneTrackingEventManagementPanel.correctWindDirectionForDeclination;
    }

    static /* synthetic */ void access$7(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, Set set, boolean bl, boolean bl2) {
        smartphoneTrackingEventManagementPanel.startTracking(set, bl, bl2);
    }

    static /* synthetic */ void access$8(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, Set set) {
        smartphoneTrackingEventManagementPanel.stopTracking(set);
    }

    static /* synthetic */ void access$9(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel) {
        smartphoneTrackingEventManagementPanel.refreshTrackingActionButtons();
    }

    static /* synthetic */ void access$10(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel) {
        smartphoneTrackingEventManagementPanel.enableStartTrackingButtonIfAppropriateRacesSelected();
    }

    static /* synthetic */ void access$11(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, Map map) {
        smartphoneTrackingEventManagementPanel.raceWithStartAndEndOfTrackingTime = map;
    }

    static /* synthetic */ void access$12(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, String string) {
        smartphoneTrackingEventManagementPanel.updateRegattaConfigDesignerModeToByMarks(string);
    }

    static /* synthetic */ void access$13(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, String string, Iterable iterable) {
        smartphoneTrackingEventManagementPanel.denoteRacesWithMultipleFleetsToDefineTheirOwnCompetitors(string, iterable);
    }

    static /* synthetic */ void access$14(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel, RegattaDTO regattaDTO, DeviceConfigurationDTO.RegattaConfigurationDTO regattaConfigurationDTO) {
        smartphoneTrackingEventManagementPanel.updateRegattaConfiguration(regattaDTO, regattaConfigurationDTO);
    }

    static /* synthetic */ String access$15(SmartphoneTrackingEventManagementPanel smartphoneTrackingEventManagementPanel) {
        return smartphoneTrackingEventManagementPanel.getLocaleInfo();
    }
}

