/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLogImpl;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogSetTrackingTimesDTO;
import com.sap.sailing.gwt.ui.adminconsole.SetTrackingTimesDialog;
import com.sap.sailing.gwt.ui.client.DataEntryDialogWithDateTimeBox;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Date;

public class SetTrackingTimesDialog
extends DataEntryDialogWithDateTimeBox<RaceLogSetTrackingTimesDTO> {
    private static AdminConsoleResources resources = (AdminConsoleResources)GWT.create(AdminConsoleResources.class);
    private final SailingServiceAsync service;
    private final ErrorReporter errorReporter;
    private final String leaderboardName;
    private final String raceColumnName;
    private final String fleetName;
    private final StringMessages stringMessages;
    private final DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_LONG);
    private Label currentStartLabel;
    private TimePointSpecificationFoundInLog currentStart;
    private Label currentEndLabel;
    private TimePointSpecificationFoundInLog currentEnd;
    private DateAndTimeInput startTimeBox;
    private CheckBox startTimeSetCheckbox;
    private DateAndTimeInput endTimeBox;
    private CheckBox endTimeSetCheckbox;
    private TextBox authorNameBox;
    private IntegerBox authorPriorityBox;

    protected SetTrackingTimesDialog(SailingServiceAsync service, ErrorReporter errorReporter, String leaderboardName, String raceColumnName, String fleetName, StringMessages stringMessages, DataEntryDialog.DialogCallback<RaceLogSetTrackingTimesDTO> callback) {
        super(stringMessages.setTrackingTimes(), stringMessages.setTrackingTimesDescription(), stringMessages.setTrackingTimes(), stringMessages.cancel(), (DataEntryDialog.Validator)new TrackingTimesValidator(stringMessages), callback);
        this.service = service;
        this.errorReporter = errorReporter;
        this.leaderboardName = leaderboardName;
        this.raceColumnName = raceColumnName;
        this.fleetName = fleetName;
        this.stringMessages = stringMessages;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel content = new VerticalPanel();
        content.add(this.createCurrentPanel());
        content.add(this.createInputPanel());
        this.refreshTimes();
        return content;
    }

    private void refreshTimes() {
        this.service.getTrackingTimes(this.leaderboardName, this.raceColumnName, this.fleetName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateDateTimeLabelAndTimeBoxFromDate(TimePointSpecificationFoundInLog timePoint, Label label, HasValue<Date> dateTimeBox, CheckBox setCheckBox) {
        if (timePoint == null) {
            label.setText(this.stringMessages.notAvailable());
            dateTimeBox.setValue(null);
            setCheckBox.setValue(Boolean.valueOf(false));
        } else {
            label.setText(timePoint.getTimePoint() == null ? "null" : this.dateTimeFormat.format(timePoint.getTimePoint().asDate()));
            dateTimeBox.setValue(timePoint.getTimePoint() == null ? null : timePoint.getTimePoint().asDate());
            setCheckBox.setValue(Boolean.valueOf(true));
        }
    }

    private Widget createInputPanel() {
        Grid content = new Grid(4, 4);
        Button startNow = new Button(this.stringMessages.now());
        startNow.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button endNow = new Button(this.stringMessages.now());
        endNow.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.startTimeBox = this.createDateTimeBox(null, DateTimeInput.Accuracy.SECONDS);
        this.startTimeBox.addValueChangeHandler(e -> this.startTimeSetCheckbox.setValue(Boolean.valueOf(true)));
        content.setWidget(0, 0, (Widget)this.createLabel(this.stringMessages.startOfTracking()));
        content.setWidget(0, 1, (Widget)this.startTimeBox);
        this.startTimeSetCheckbox = this.createCheckbox(this.stringMessages.set());
        content.setWidget(0, 2, (Widget)this.startTimeSetCheckbox);
        content.setWidget(0, 3, (Widget)startNow);
        this.endTimeBox = this.createDateTimeBox(null, DateTimeInput.Accuracy.SECONDS);
        this.endTimeBox.addValueChangeHandler(e -> this.endTimeSetCheckbox.setValue(Boolean.valueOf(true)));
        content.setWidget(1, 0, (Widget)this.createLabel(this.stringMessages.endOfTracking()));
        content.setWidget(1, 1, (Widget)this.endTimeBox);
        this.endTimeSetCheckbox = this.createCheckbox(this.stringMessages.set());
        content.setWidget(1, 2, (Widget)this.endTimeSetCheckbox);
        content.setWidget(1, 3, (Widget)endNow);
        this.authorNameBox = this.createTextBox("Shore");
        content.setWidget(2, 0, (Widget)this.createLabel(this.stringMessages.authorName()));
        content.setWidget(2, 1, (Widget)this.authorNameBox);
        this.authorPriorityBox = this.createIntegerBox(Integer.valueOf(0), 2);
        content.setWidget(3, 0, (Widget)this.createLabel(this.stringMessages.authorPriority()));
        content.setWidget(3, 1, (Widget)this.authorPriorityBox);
        return content;
    }

    private Widget createCurrentPanel() {
        CaptionPanel current = new CaptionPanel(this.stringMessages.liveData());
        HorizontalPanel currentPanel = new HorizontalPanel();
        currentPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Grid grid = new Grid(2, 2);
        this.currentStartLabel = new Label("");
        grid.setWidget(0, 0, (Widget)this.createLabel(this.stringMessages.startOfTracking()));
        grid.setWidget(0, 1, (Widget)this.currentStartLabel);
        this.currentEndLabel = new Label("");
        grid.setWidget(1, 0, (Widget)this.createLabel(this.stringMessages.endOfTracking()));
        grid.setWidget(1, 1, (Widget)this.currentEndLabel);
        currentPanel.add((Widget)grid);
        PushButton refreshButton = new PushButton(new Image(resources.reloadIcon()));
        refreshButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        currentPanel.add((Widget)refreshButton);
        current.add((Widget)currentPanel);
        return current;
    }

    protected RaceLogSetTrackingTimesDTO getResult() {
        Date startTime = this.startTimeBox.getValue();
        Date endTime = this.endTimeBox.getValue();
        RaceLogSetTrackingTimesDTO dto = new RaceLogSetTrackingTimesDTO();
        dto.leaderboardName = this.leaderboardName;
        dto.raceColumnName = this.raceColumnName;
        dto.fleetName = this.fleetName;
        dto.authorName = this.authorNameBox.getValue();
        dto.authorPriority = (Integer)this.authorPriorityBox.getValue();
        dto.logicalTimePoint = MillisecondsTimePoint.now();
        Object object = this.startTimeSetCheckbox.getValue().booleanValue() ? (startTime == null ? new TimePointSpecificationFoundInLogImpl(null) : new TimePointSpecificationFoundInLogImpl((TimePoint)new MillisecondsTimePoint(startTime))) : (dto.newStartOfTracking = null);
        dto.newEndOfTracking = this.endTimeSetCheckbox.getValue().booleanValue() ? (endTime == null ? new TimePointSpecificationFoundInLogImpl(null) : new TimePointSpecificationFoundInLogImpl((TimePoint)new MillisecondsTimePoint(endTime))) : null;
        dto.currentStartOfTracking = this.currentStart;
        dto.currentEndOfTracking = this.currentEnd;
        return dto;
    }

    static /* synthetic */ ErrorReporter access$1(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.errorReporter;
    }

    static /* synthetic */ void access$2(SetTrackingTimesDialog setTrackingTimesDialog, TimePointSpecificationFoundInLog timePointSpecificationFoundInLog) {
        setTrackingTimesDialog.currentStart = timePointSpecificationFoundInLog;
    }

    static /* synthetic */ void access$3(SetTrackingTimesDialog setTrackingTimesDialog, TimePointSpecificationFoundInLog timePointSpecificationFoundInLog) {
        setTrackingTimesDialog.currentEnd = timePointSpecificationFoundInLog;
    }

    static /* synthetic */ TimePointSpecificationFoundInLog access$4(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.currentStart;
    }

    static /* synthetic */ Label access$5(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.currentStartLabel;
    }

    static /* synthetic */ DateAndTimeInput access$6(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.startTimeBox;
    }

    static /* synthetic */ CheckBox access$7(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.startTimeSetCheckbox;
    }

    static /* synthetic */ void access$8(SetTrackingTimesDialog setTrackingTimesDialog, TimePointSpecificationFoundInLog timePointSpecificationFoundInLog, Label label, HasValue hasValue, CheckBox checkBox) {
        setTrackingTimesDialog.updateDateTimeLabelAndTimeBoxFromDate(timePointSpecificationFoundInLog, label, hasValue, checkBox);
    }

    static /* synthetic */ TimePointSpecificationFoundInLog access$9(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.currentEnd;
    }

    static /* synthetic */ Label access$10(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.currentEndLabel;
    }

    static /* synthetic */ DateAndTimeInput access$11(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.endTimeBox;
    }

    static /* synthetic */ CheckBox access$12(SetTrackingTimesDialog setTrackingTimesDialog) {
        return setTrackingTimesDialog.endTimeSetCheckbox;
    }

    static /* synthetic */ void access$13(SetTrackingTimesDialog setTrackingTimesDialog) {
        setTrackingTimesDialog.refreshTimes();
    }
}

