/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.adminconsole.DiscardThresholdBoxes;
import com.sap.sailing.gwt.ui.adminconsole.FleetListEditorComposite;
import com.sap.sailing.gwt.ui.adminconsole.SeriesWithFleetsCreateDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.controls.listedit.ListEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Arrays;
import java.util.Collection;

public class SeriesWithFleetsCreateDialog
extends DataEntryDialog<SeriesDTO> {
    protected static AdminConsoleResources resources = (AdminConsoleResources)GWT.create(AdminConsoleResources.class);
    private StringMessages stringMessages;
    private SeriesDTO series;
    protected final TextBox nameEntryField;
    protected CheckBox isMedalSeriesCheckbox;
    protected CheckBox fleetsCanRunInParallelCheckbox;
    protected CheckBox startsWithZeroScoreCheckbox;
    protected CheckBox hasSplitFleetContiguousScoringCheckbox;
    protected CheckBox hasCrossFleetMergedRankingCheckbox;
    protected CheckBox firstColumnIsNonDiscardableCarryForwardCheckbox;
    protected CheckBox useSeriesResultDiscardingThresholdsCheckbox;
    protected CheckBox oneAlwaysStaysOneCheckbox;
    protected IntegerBox maximumNumberOfDiscardsBox;
    protected final DiscardThresholdBoxes discardThresholdBoxes;
    protected ListEditorComposite<FleetDTO> fleetListComposite;

    public SeriesWithFleetsCreateDialog(Collection<SeriesDTO> existingSeries, StringMessages stringMessages, DataEntryDialog.DialogCallback<SeriesDTO> callback) {
        this(existingSeries, stringMessages, null, callback);
    }

    protected SeriesWithFleetsCreateDialog(Collection<SeriesDTO> existingSeries, StringMessages stringMessages, int[] discardThresholds, DataEntryDialog.DialogCallback<SeriesDTO> callback) {
        super(stringMessages.series(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new SeriesParameterValidator(stringMessages, existingSeries), callback);
        this.stringMessages = stringMessages;
        this.series = new SeriesDTO();
        this.discardThresholdBoxes = discardThresholds == null ? new DiscardThresholdBoxes((DataEntryDialog)this, stringMessages) : new DiscardThresholdBoxes((DataEntryDialog)this, discardThresholds, stringMessages);
        this.nameEntryField = this.createTextBox(null);
        this.nameEntryField.ensureDebugId("NameTextBox");
        this.nameEntryField.setVisibleLength(40);
        this.isMedalSeriesCheckbox = this.createCheckbox(stringMessages.medalSeries());
        this.isMedalSeriesCheckbox.ensureDebugId("MedalSeriesCheckbox");
        this.fleetsCanRunInParallelCheckbox = this.createCheckbox(stringMessages.canFleetsRunInParallel());
        this.fleetsCanRunInParallelCheckbox.setValue(Boolean.valueOf(true));
        this.fleetsCanRunInParallelCheckbox.ensureDebugId("FleetsCanRaceInParallelSeriesCheckbox");
        this.startsWithZeroScoreCheckbox = this.createCheckbox(stringMessages.startsWithZeroScore());
        this.startsWithZeroScoreCheckbox.ensureDebugId("StartsWithZeroScoreCheckbox");
        this.hasSplitFleetContiguousScoringCheckbox = this.createCheckbox(stringMessages.hasSplitFleetContiguousScoring());
        this.hasSplitFleetContiguousScoringCheckbox.ensureDebugId("HasSplitFleetContiguousScoringCheckbox");
        this.hasCrossFleetMergedRankingCheckbox = this.createCheckbox(stringMessages.hasCrossFleetMergedRanking());
        this.hasCrossFleetMergedRankingCheckbox.ensureDebugId("HasCrossFleetMergedRankingCheckbox");
        this.maximumNumberOfDiscardsBox = this.createIntegerBox(null, 3);
        this.maximumNumberOfDiscardsBox.ensureDebugId("maximumNumberOfDiscardsBox");
        this.firstColumnIsNonDiscardableCarryForwardCheckbox = this.createCheckbox(stringMessages.firstRaceIsNonDiscardableCarryForward());
        this.firstColumnIsNonDiscardableCarryForwardCheckbox.ensureDebugId("StartsWithNonDiscardableCarryForwardCheckbox");
        this.useSeriesResultDiscardingThresholdsCheckbox = this.createCheckbox(stringMessages.seriesDefinesResultDiscardingRule());
        this.useSeriesResultDiscardingThresholdsCheckbox.ensureDebugId("DefinesResultDiscardingRulesCheckbox");
        this.useSeriesResultDiscardingThresholdsCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.oneAlwaysStaysOneCheckbox = this.createCheckbox(stringMessages.oneAlwaysStaysOne());
        this.oneAlwaysStaysOneCheckbox.ensureDebugId("OneAlwaysStaysOneCheckbox");
        Widget widget = this.discardThresholdBoxes.getWidget();
        widget.ensureDebugId("DiscardThresholdBoxes");
        widget.setVisible(false);
        this.initializeFleetListComposite(stringMessages);
    }

    protected void initializeFleetListComposite(StringMessages stringMessages) {
        this.fleetListComposite = new FleetListEditorComposite(Arrays.asList(new FleetDTO("Default", 0, null)), stringMessages, IconResources.INSTANCE.removeIcon());
        this.fleetListComposite.ensureDebugId("FleetListEditorComposite");
        this.fleetListComposite.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected SeriesDTO getResult() {
        this.series.setName(this.nameEntryField.getText());
        this.series.setMedal(this.isMedalSeriesCheckbox.getValue().booleanValue());
        this.series.setFleetsCanRunInParallel(this.fleetsCanRunInParallelCheckbox.getValue().booleanValue());
        this.series.setStartsWithZeroScore(this.startsWithZeroScoreCheckbox.getValue());
        this.series.setSplitFleetContiguousScoring(this.hasSplitFleetContiguousScoringCheckbox.getValue());
        this.series.setCrossFleetMergedRanking(this.hasCrossFleetMergedRankingCheckbox.getValue());
        this.series.setFirstColumnIsNonDiscardableCarryForward(this.firstColumnIsNonDiscardableCarryForwardCheckbox.getValue().booleanValue());
        this.series.setMaximumNumberOfDiscards((Integer)this.maximumNumberOfDiscardsBox.getValue());
        this.series.setOneAlwaysStaysOne(this.oneAlwaysStaysOneCheckbox.getValue().booleanValue());
        this.series.setFleets(this.fleetListComposite.getValue());
        this.series.setDiscardThresholds(this.useSeriesResultDiscardingThresholdsCheckbox.getValue() != false ? this.discardThresholdBoxes.getDiscardThresholds() : null);
        return this.series;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        Grid formGrid = new Grid(11, 2);
        panel.add((Widget)formGrid);
        int row = 0;
        formGrid.setWidget(row, 0, (Widget)new Label(String.valueOf(this.stringMessages.name()) + ":"));
        formGrid.setWidget(row++, 1, (Widget)this.nameEntryField);
        formGrid.setWidget(row++, 1, (Widget)this.isMedalSeriesCheckbox);
        formGrid.setWidget(row++, 1, (Widget)this.fleetsCanRunInParallelCheckbox);
        formGrid.setWidget(row++, 1, (Widget)this.startsWithZeroScoreCheckbox);
        formGrid.setWidget(row++, 1, (Widget)this.hasSplitFleetContiguousScoringCheckbox);
        formGrid.setWidget(row++, 1, (Widget)this.hasCrossFleetMergedRankingCheckbox);
        formGrid.setWidget(row++, 1, (Widget)this.firstColumnIsNonDiscardableCarryForwardCheckbox);
        formGrid.setWidget(row++, 1, (Widget)this.oneAlwaysStaysOneCheckbox);
        formGrid.setWidget(row, 0, (Widget)new Label(this.stringMessages.maximumNumberOfDiscards()));
        formGrid.setWidget(row++, 1, (Widget)this.maximumNumberOfDiscardsBox);
        formGrid.setWidget(row++, 1, (Widget)this.useSeriesResultDiscardingThresholdsCheckbox);
        formGrid.setWidget(row++, 1, this.discardThresholdBoxes.getWidget());
        TabPanel tabPanel = new TabPanel();
        tabPanel.setWidth("100%");
        tabPanel.add((Widget)this.fleetListComposite, this.stringMessages.fleets());
        tabPanel.selectTab(0);
        panel.add((Widget)tabPanel);
        return panel;
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameEntryField;
    }

    static /* synthetic */ void access$1(SeriesWithFleetsCreateDialog seriesWithFleetsCreateDialog) {
        seriesWithFleetsCreateDialog.validateAndUpdate();
    }
}

