/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.ResultImportUrlAddDialog;
import com.sap.sailing.gwt.ui.adminconsole.ResultImportUrlsTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.UrlDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.Set;

public class ResultImportUrlsListComposite
extends Composite {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final ListBox urlProviderListBox;
    private final ResultImportUrlsTableWrapper<RefreshableMultiSelectionModel<UrlDTO>> table;

    public ResultImportUrlsListComposite(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        CaptionPanel captionPanel = new CaptionPanel(stringMessages.resultImportUrls());
        VerticalPanel panel = new VerticalPanel();
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(presenter.getUserService(), SecuredDomainType.RESULT_IMPORT_URL);
        this.table = new ResultImportUrlsTableWrapper(presenter.getSailingService(), presenter.getUserService(), stringMessages, this.errorReporter);
        Button add = buttonPanel.addCreateAction(stringMessages.add(), () -> this.addUrl());
        add.ensureDebugId("AddUrlButton");
        add.setEnabled(false);
        Button remove = buttonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.table.getSelectionModel(), true, () -> this.removeUrls(((RefreshableMultiSelectionModel)this.table.getSelectionModel()).getSelectedSet()));
        remove.ensureDebugId("RemoveUrlButton");
        Button refresh = buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.updateTable());
        refresh.ensureDebugId("RefreshUrlButton");
        refresh.setEnabled(false);
        Grid urlSample = new Grid(1, 2);
        urlSample.setWidget(0, 0, (Widget)new Label(stringMessages.sampleURL("")));
        Label urlSampleLabel = new Label();
        urlSample.setWidget(0, 1, (Widget)urlSampleLabel);
        this.urlProviderListBox = new ListBox();
        this.urlProviderListBox.ensureDebugId("urlProviderListBox");
        this.urlProviderListBox.setMultipleSelect(false);
        this.urlProviderListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.sailingServiceWrite.getUrlResultProviderNamesAndOptionalSampleURL((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        Grid providerGrid = new Grid(1, 2);
        providerGrid.setWidget(0, 0, (Widget)new Label(stringMessages.urlProviders()));
        providerGrid.setWidget(0, 1, (Widget)this.urlProviderListBox);
        panel.add((Widget)providerGrid);
        panel.add((Widget)buttonPanel);
        panel.add((Widget)urlSample);
        panel.add((IsWidget)this.table);
        captionPanel.setContentWidget((Widget)panel);
        this.initWidget((Widget)captionPanel);
    }

    private void addUrl() {
        new ResultImportUrlAddDialog(this.getSelectedProviderName(), (SailingServiceAsync)this.sailingServiceWrite, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void removeUrls(Set<UrlDTO> set) {
        if (set != null && set.size() > 0) {
            String providerName = this.getSelectedProviderName();
            this.sailingServiceWrite.removeResultImportURLs(providerName, set, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateTable() {
        this.table.update(this.getSelectedProviderName());
    }

    private String getSelectedProviderName() {
        String result = null;
        int selectedIndex = this.urlProviderListBox.getSelectedIndex();
        if (selectedIndex > 0) {
            result = this.urlProviderListBox.getItemText(selectedIndex);
        }
        return result;
    }

    static /* synthetic */ ListBox access$0(ResultImportUrlsListComposite resultImportUrlsListComposite) {
        return resultImportUrlsListComposite.urlProviderListBox;
    }

    static /* synthetic */ ResultImportUrlsTableWrapper access$1(ResultImportUrlsListComposite resultImportUrlsListComposite) {
        return resultImportUrlsListComposite.table;
    }

    static /* synthetic */ String access$2(ResultImportUrlsListComposite resultImportUrlsListComposite) {
        return resultImportUrlsListComposite.getSelectedProviderName();
    }

    static /* synthetic */ SailingServiceWriteAsync access$3(ResultImportUrlsListComposite resultImportUrlsListComposite) {
        return resultImportUrlsListComposite.sailingServiceWrite;
    }

    static /* synthetic */ StringMessages access$4(ResultImportUrlsListComposite resultImportUrlsListComposite) {
        return resultImportUrlsListComposite.stringMessages;
    }

    static /* synthetic */ void access$5(ResultImportUrlsListComposite resultImportUrlsListComposite) {
        resultImportUrlsListComposite.updateTable();
    }

    static /* synthetic */ ErrorReporter access$6(ResultImportUrlsListComposite resultImportUrlsListComposite) {
        return resultImportUrlsListComposite.errorReporter;
    }
}

