/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.client.help.HelpButton;
import com.sap.sailing.gwt.common.client.help.HelpButtonResources;
import com.sap.sailing.gwt.ui.adminconsole.CreateRegattaCallback;
import com.sap.sailing.gwt.ui.adminconsole.RegattaDetailsComposite;
import com.sap.sailing.gwt.ui.adminconsole.RegattaListComposite;
import com.sap.sailing.gwt.ui.adminconsole.RegattaWithSeriesAndFleetsCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class RegattaManagementPanel
extends SimplePanel
implements FilterablePanelProvider<RegattaDTO> {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final AdminConsoleView.Presenter presenter;
    private final RefreshableMultiSelectionModel<RegattaDTO> refreshableRegattaMultiSelectionModel;
    private final RegattaListComposite regattaListComposite;
    private final RegattaDetailsComposite regattaDetailsComposite;
    private final UserService userService;
    private final Displayer<RegattaDTO> regattasDisplayer;

    public RegattaManagementPanel(StringMessages stringMessages, AdminConsoleView.Presenter presenter) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.stringMessages = stringMessages;
        this.errorReporter = presenter.getErrorReporter();
        this.presenter = presenter;
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        CaptionPanel regattasPanel = new CaptionPanel(stringMessages.regattas());
        mainPanel.add((Widget)regattasPanel);
        VerticalPanel regattasContentPanel = new VerticalPanel();
        regattasPanel.setContentWidget((Widget)regattasContentPanel);
        this.regattaListComposite = new RegattaListComposite(presenter, stringMessages);
        this.regattaListComposite.ensureDebugId("RegattaListComposite");
        this.regattasDisplayer = result -> this.regattaListComposite.fillRegattas(result);
        this.refreshableRegattaMultiSelectionModel = this.regattaListComposite.getRefreshableMultiSelectionModel();
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.REGATTA);
        Button update = buttonPanel.addCreateAction(stringMessages.refresh(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        update.ensureDebugId("UpdateRegattaButton");
        Button create = buttonPanel.addCreateAction(stringMessages.addRegatta(), () -> this.openCreateRegattaDialog());
        create.ensureDebugId("AddRegattaButton");
        Button remove = buttonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.refreshableRegattaMultiSelectionModel, true, () -> {
            Collection regattas = this.createModifiableCollection();
            this.removeRegattas(regattas);
        });
        buttonPanel.addUnsecuredWidget((Widget)new HelpButton(HelpButtonResources.INSTANCE, stringMessages.videoGuide(), "https://sapsailing-documentation.s3-eu-west-1.amazonaws.com/adminconsole/Advanced+Topics/Setting+up+Events+with+multiple+Regattas+or+Classes.mp4"));
        regattasContentPanel.add((Widget)buttonPanel);
        this.refreshableRegattaMultiSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        regattasContentPanel.add((Widget)this.regattaListComposite);
        this.regattaDetailsComposite = new RegattaDetailsComposite(presenter, stringMessages);
        this.regattaDetailsComposite.ensureDebugId("RegattaDetailsComposite");
        this.regattaDetailsComposite.setVisible(false);
        mainPanel.add((Widget)this.regattaDetailsComposite);
    }

    public Displayer<RegattaDTO> getRegattasDisplayer() {
        return this.regattasDisplayer;
    }

    protected void removeRegattas(Collection<RegattaIdentifier> regattas) {
        if (!regattas.isEmpty()) {
            this.sailingServiceWrite.removeRegattas(regattas, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void openCreateRegattaDialog() {
        Displayer[] eventDisplayer;
        Collection existingRegattas = Collections.unmodifiableCollection(this.regattaListComposite.getAllRegattas());
        eventDisplayer = new Displayer[]{new /* Unavailable Anonymous Inner Class!! */};
        this.presenter.getEventsRefresher().addDisplayerAndCallFillOnInit(eventDisplayer[0]);
    }

    private void openCreateRegattaDialog(Collection<RegattaDTO> existingRegattas, Iterable<EventDTO> existingEvents) {
        RegattaWithSeriesAndFleetsCreateDialog dialog = new RegattaWithSeriesAndFleetsCreateDialog(existingRegattas, existingEvents, null, (SailingServiceAsync)this.sailingServiceWrite, this.userService, this.stringMessages, (DataEntryDialog.DialogCallback)new CreateRegattaCallback(this.stringMessages, this.presenter, existingEvents));
        dialog.ensureDebugId("RegattaCreateDialog");
        dialog.show();
    }

    private Collection<RegattaIdentifier> createModifiableCollection() {
        HashSet<RegattaIdentifier> regattas = new HashSet<RegattaIdentifier>();
        for (RegattaDTO regatta : this.refreshableRegattaMultiSelectionModel.getSelectedSet()) {
            regattas.add(regatta.getRegattaIdentifier());
        }
        return regattas;
    }

    public AbstractFilterablePanel<RegattaDTO> getFilterablePanel() {
        return this.regattaListComposite.filterablePanelRegattas;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$0(RegattaManagementPanel regattaManagementPanel) {
        return regattaManagementPanel.refreshableRegattaMultiSelectionModel;
    }

    static /* synthetic */ RegattaListComposite access$1(RegattaManagementPanel regattaManagementPanel) {
        return regattaManagementPanel.regattaListComposite;
    }

    static /* synthetic */ RegattaDetailsComposite access$2(RegattaManagementPanel regattaManagementPanel) {
        return regattaManagementPanel.regattaDetailsComposite;
    }

    static /* synthetic */ UserService access$3(RegattaManagementPanel regattaManagementPanel) {
        return regattaManagementPanel.userService;
    }

    static /* synthetic */ ErrorReporter access$4(RegattaManagementPanel regattaManagementPanel) {
        return regattaManagementPanel.errorReporter;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$5(RegattaManagementPanel regattaManagementPanel) {
        return regattaManagementPanel.presenter;
    }

    static /* synthetic */ void access$6(RegattaManagementPanel regattaManagementPanel, Collection collection, Iterable iterable) {
        regattaManagementPanel.openCreateRegattaDialog(collection, iterable);
    }
}

